insert into Q_ENTITY(ID, CREATED_ON, UPDATED_ON, CREATED_BY, UPDATED_BY, ENTITY_STATE, ROW_VERSION, Q_NUMBER, ALIAS,
                     PROJECT_EXECUTION_START_DATE, PROJECT_EXECUTION_END_DATE, Q_ENTITY_STAGE, Q_ENTITY_STATE,
                     COMMISSION_TYPE,
                     CUSTOMER_ID, RESPONSIBLE_USER_ID, PARENT_QENTITY_ID, REFERENCE_QENTITY_ID, PROJECT_ID,
                     PRIMARY_STAGE_ID)
    (select Q_ENTITY_SEQ.nextval as ID,
            sysdate as CREATED_ON,
            sysdate as UPDATED_ON,
            'import' as CREATED_BY,
            'import' as UPDATED_BY,
            'VALID' as ENTITY_STATE,
            0 as ROW_VERSION,
            b.Q_NUMBER, b.ALIAS,
            b.PROJECT_EXECUTION_START_DATE, b.PROJECT_EXECUTION_END_DATE, b.Q_ENTITY_STAGE, b.Q_ENTITY_STATE,
            b.COMMISSION_TYPE,
            b.CUSTOMER_ID, b.RESPONSIBLE_USER_ID, b.PARENT_QENTITY_ID, b.REFERENCE_QENTITY_ID, b.PROJECT_ID,
            b.PRIMARY_STAGE_ID
     from (select distinct 'Q230001' as Q_NUMBER,
                           q.commission_number as alias,
                           null as PROJECT_EXECUTION_START_DATE,
                           null as PROJECT_EXECUTION_END_DATE,
                           '' as Q_ENTITY_STAGE,
                           '' as Q_ENTITY_STATE,
                           '' as COMMISSION_TYPE,
                           q.customer_id as CUSTOMER_ID,
                           null as RESPONSIBLE_USER_ID,
                           null as PARENT_QENTITY_ID,
                           null as REFERENCE_QENTITY_ID,
                           null as PROJECT_ID,
                           q.id as PRIMARY_STAGE_ID
           from QUOTATION q
           where q.COMMISSION_NUMBER IS NOT NULL
             AND length(trim(q.COMMISSION_NUMBER)) > 0
             and q.ADDENDUM_NUMBER = 0
             and q.QUOTATION_NUMBER in (
                                        '43/160/600'
               )) b);

select * from Q_ENTITY order by id desc;

update quotation q set q.q_entity_id = (select qe.id from q_entity qe where qe.q_number = q.commission_number and q.ADDENDUM_NUMBER = 0)
where q.q_entity_id IS NULL and q.QUOTATION_NUMBER in (
                                                       '43/160/600',
                                                       '43/160/722', '43/160/284','43/160/824'
    )
;

update quotation q
set
    q.stage_type = 'COMMISSION',
    q.stage_state = 'ACTIVE',
    q.stage_state_on = sysdate
where q.q_entity_id IS NOT NULL AND q.addendum_number = 0
  and q.QUOTATION_NUMBER in (
    '43/160/600'
    );

update quotation q
set
    q.stage_type = 'COMMISSION__COST_UNIT',
    q.stage_state = 'ACTIVE',
    q.stage_state_on = sysdate
where q.q_entity_id IS NOT NULL AND q.addendum_number = 0
  and q.QUOTATION_NUMBER in (
                             '43/160/722', '43/160/284','43/160/824'
    );


update quotation q
set
    q.stage_type = 'COMMISSION__ADDENDUM',
    q.stage_state = 'ACTIVE',
    q.stage_state_on = sysdate
where q.q_entity_id IS NOT NULL AND q.addendum_number != 0
  and q.QUOTATION_NUMBER in (
    '43/160/600'
    );


update quotation q
set
    q.stage_type = 'COMMISSION__ADDENDUM',
    q.stage_state = 'ACTIVE',
    q.stage_state_on = sysdate
where q.q_entity_id IS NOT NULL AND q.addendum_number != 0
  and q.QUOTATION_NUMBER in (
                             '43/160/722', '43/160/284','43/160/824'
    );



-- set primary stage
update q_entity qe
set qe.primary_stage_id = (select max(id) from quotation where q_entity_id IS NOT NULL AND stage_type = 'COMMISSION')
where qe.primary_stage_id is null;

