-- db/changelog/db.changelog-view-1.sql::view-1::xoo was: 8:1ce153a46ea0ff9ebbadbaac08569734 but is now: 8:bc88999a53bd26a2745f9b89ec10a3fc

CREATE OR REPLACE VIEW "ELAN_AUFMASS_LESEN" as

select m.measurement_number                                              as "aufmass_nummer",
       m.CREATED_ON                                                      as "erstellt_am_um",
       decode(m.measurement_type, 'PARTIAL', 'TA', 'MAIN', 'SA', 'NONE') as "aufmass_art",
       decode(m.measurement_state,
              'TEMPORARY', 'vorläufig',
              'WAITING_FOR_APPROVAL', 'warten',
              'APPROVED', 'geprüft',
              'WAITING_FOR_INVOICE', 'in Rechnungslegung',
              'INVOICED', 'fakturiert')                                  as "aufmass_status",
       m.value_overall                                                   as "rechnung_summe",
       pss.pss_id                                                        as "pss_abruf_id",
       ucc.cost_center                                                   as "kostenstelle"
From measurement m
         left join release_order r on r.measurement_id = m.id
         left join pss_release_order pss on r.pss_release_order_id = pss.id
         left join USER_COST_CENTER ucc on ucc.user_id = m.assigned_user_id AND
                                           ucc.VALID_BEGIN <= m.PROJECT_EXECUTION_START_DATE AND
                                           ucc.VALID_END >= m.PROJECT_EXECUTION_START_DATE
order by m.id desc
/


update DATABASECHANGELOG
set MD5SUM = '8:bc88999a53bd26a2745f9b89ec10a3fc'
where MD5SUM = '8:1ce153a46ea0ff9ebbadbaac08569734';

commit;
