select 'insert into PAYROLL_MONTH_ITEM(ID, CREATED_ON, UPDATED_ON, CREATED_BY, UPDATED_BY, ENTITY_STATE, ROW_VERSION, REFERENCE_ID, PAYROLL_ITEM_TYPE_ID, PAYROLL_ITEM_CLAZZ, PAYROLL_MONTH_ID, QUOTATION_NUMBER, VALUE, REMARKS, COST_CENTER_SQUAD, SENDER_USER_ID, RECIPIENT_USER_ID)
 values (PAYROLL_MONTH_ITEM_SEQ.NEXTVAL, sysdate, sysdate, ''system'', ''system'', ''VALID'', 1, ''' || id || ''',
 null, ''INCENTIVE_PAYMENT'',
 (select id from PAYROLL_MONTH ' ||
       'where USER_ID = (select nvl((select id from sys_user where personal_number = ' || trupp_kz ||
       '), 324) from dual) ' ||
       'AND ACCOUNTING_MONTH = to_date( ''' || to_char(monat, 'dd.MM.yyyy') || ''', ''dd.MM.yyyy'')),
 ''' || angebotsnummer || ''', ' ||
       to_char(leistungsverdienst, 'FM9999999.90') || ' , ''' || replace(replace(bemerkung, '&', '+'), '''', '') ||
       ' [' || trupp_kz ||
       '/' || monat || ']' || ''', ''' || trupp_kostenstelle || ''',' ||
       '(select nvl((select id from sys_user where personal_number = ' || trupp_kz || '), 324) from dual),
       (select nvl((select id from sys_user where personal_number = ' || personalnummer || '), 324) from dual)
 );'
from fr_monatsbericht
where leistungsverdienst IS NOT NULL
-- and angebotsnummer in ('41/140/710')
-- AND trupp_kz = 1008
;

insert into PAYROLL_MONTH_ITEM(ID, CREATED_ON, UPDATED_ON, CREATED_BY, UPDATED_BY, ENTITY_STATE, ROW_VERSION,
                               REFERENCE_ID, PAYROLL_ITEM_TYPE_ID, PAYROLL_ITEM_CLAZZ, PAYROLL_MONTH_ID,
                               QUOTATION_NUMBER, VALUE, REMARKS, COST_CENTER_SQUAD, SENDER_USER_ID, RECIPIENT_USER_ID)
    (
        select PAYROLL_MONTH_ITEM_SEQ.NEXTVAL                                                                as ID,
               sysdate                                                                                       as CREATED_ON,
               sysdate                                                                                       as UPDATED_ON,
               'system'                                                                                      as CREATED_BY,
               'system'                                                                                      as UPDATED_BY,
               'VALID'                                                                                       as ENTITY_STATE,
               1                                                                                             as ROW_VERSION,
               a.id                                                                                          as REFERENCE_ID,
               null                                                                                          as PAYROLL_ITEM_TYPE_ID,
               'INCENTIVE_PAYMENT'                                                                           as PAYROLL_ITEM_CLAZZ,
               (select b.id
                from PAYROLL_MONTH b
                where b.USER_ID = nvl((select b.id
                                       from sys_user b
                                       where b.personal_number = decode(a.trupp_kz, 1077, 12143, a.trupp_kz)), 324)
                  AND b.ACCOUNTING_MONTH = monat)                                                            AS PAYROLL_MONTH_ID,
               a.angebotsnummer                                                                              as QUOTATION_NUMBER,
               a.leistungsverdienst                                                                          as VALUE,
               replace(replace(a.bemerkung, '&', '+'), '', '') || a.trupp_kz || '/' || a.monat || ']'        AS REMARKS,
               a.trupp_kostenstelle                                                                          as COST_CENTER_SQUAD,
               nvl((select b.id from sys_user b where b.personal_number = decode(a.trupp_kz, 1077, 12143, a.trupp_kz)),
                   324)                                                                                      AS SENDER_USER_ID,
               nvl((select b.id
                    from sys_user b
                    where b.personal_number = decode(a.personalnummer, 1077, 12143, a.personalnummer)),
                   324)                                                                                      AS RECIPIENT_USER_ID
        from qfm.fr_monatsbericht a
        where a.leistungsverdienst IS NOT NULL
          and (
                    a.trupp_kz in (1077, 12143) OR
                    a.personalnummer in (1077, 12143)
            )
    );


-- user fallback
select nvl((select id from sys_user where personal_number = '100000'), 324)
from dual;

-- example
insert into PAYROLL_MONTH_ITEM(ID, CREATED_ON, UPDATED_ON, CREATED_BY, UPDATED_BY, ENTITY_STATE, ROW_VERSION,
                               REFERENCE_ID, PAYROLL_ITEM_TYPE_ID, PAYROLL_ITEM_CLAZZ, PAYROLL_MONTH_ID,
                               QUOTATION_NUMBER, VALUE, REMARKS, COST_CENTER_SQUAD, SENDER_USER_ID, RECIPIENT_USER_ID)
values (PAYROLL_MONTH_ITEM_SEQ.NEXTVAL, sysdate, sysdate, 'system', 'system', 'VALID', 1, '1509865',
        null, 'INCENTIVE_PAYMENT',
        (select id
         from PAYROLL_MONTH
         where USER_ID = (select nvl((select id from sys_user where personal_number = 1067), 324) from dual)
           AND ACCOUNTING_MONTH = to_date('01.03.2008', 'dd.MM.yyyy')),
        '28/160/614', 833.58, ' [1067/01.03.08]', '160',
        (select nvl((select id from sys_user where personal_number = 1067), 324) from dual),
        (select nvl((select id from sys_user where personal_number = 1067), 324) from dual));



insert into PAYROLL_MONTH_ITEM(ID, CREATED_ON, UPDATED_ON, CREATED_BY, UPDATED_BY, ENTITY_STATE, ROW_VERSION,
                               REFERENCE_ID, PAYROLL_ITEM_TYPE_ID, PAYROLL_ITEM_CLAZZ, PAYROLL_MONTH_ID,
                               QUOTATION_NUMBER, VALUE, REMARKS, COST_CENTER_SQUAD, SENDER_USER_ID, RECIPIENT_USER_ID)
values (PAYROLL_MONTH_ITEM_SEQ.NEXTVAL, sysdate, sysdate, 'system', 'system', 'VALID', 1, '3116649',
        null, 'INCENTIVE_PAYMENT',
        (select id
         from PAYROLL_MONTH
         where USER_ID = (select nvl((select id from sys_user where personal_number = 1008), 324) from dual)
           AND ACCOUNTING_MONTH = to_date('01.07.2021', 'dd.MM.yyyy')),
        '41/140/710', 584.75, 'BKA Wartungen A [1008/01.07.21]', '140',
        (select nvl((select id from sys_user where personal_number = 1008), 324) from dual),
        (select nvl((select id from sys_user where personal_number = 1008), 324) from dual));
insert into PAYROLL_MONTH_ITEM(ID, CREATED_ON, UPDATED_ON, CREATED_BY, UPDATED_BY, ENTITY_STATE, ROW_VERSION,
                               REFERENCE_ID, PAYROLL_ITEM_TYPE_ID, PAYROLL_ITEM_CLAZZ, PAYROLL_MONTH_ID,
                               QUOTATION_NUMBER, VALUE, REMARKS, COST_CENTER_SQUAD, SENDER_USER_ID, RECIPIENT_USER_ID)
values (PAYROLL_MONTH_ITEM_SEQ.NEXTVAL, sysdate, sysdate, 'system', 'system', 'VALID', 1, '3112643',
        null, 'INCENTIVE_PAYMENT',
        (select id
         from PAYROLL_MONTH
         where USER_ID = (select nvl((select id from sys_user where personal_number = 1008), 324) from dual)
           AND ACCOUNTING_MONTH = to_date('01.03.2021', 'dd.MM.yyyy')),
        '41/140/710', 584.75, 'BKA Wartungen [1008/01.03.21]', '140',
        (select nvl((select id from sys_user where personal_number = 1008), 324) from dual),
        (select nvl((select id from sys_user where personal_number = 1754), 324) from dual));
insert into PAYROLL_MONTH_ITEM(ID, CREATED_ON, UPDATED_ON, CREATED_BY, UPDATED_BY, ENTITY_STATE, ROW_VERSION,
                               REFERENCE_ID, PAYROLL_ITEM_TYPE_ID, PAYROLL_ITEM_CLAZZ, PAYROLL_MONTH_ID,
                               QUOTATION_NUMBER, VALUE, REMARKS, COST_CENTER_SQUAD, SENDER_USER_ID, RECIPIENT_USER_ID)
values (PAYROLL_MONTH_ITEM_SEQ.NEXTVAL, sysdate, sysdate, 'system', 'system', 'VALID', 1, '3115393',
        null, 'INCENTIVE_PAYMENT',
        (select id
         from PAYROLL_MONTH
         where USER_ID = (select nvl((select id from sys_user where personal_number = 1008), 324) from dual)
           AND ACCOUNTING_MONTH = to_date('01.06.2021', 'dd.MM.yyyy')),
        '41/140/710', 584.75, 'BKA Wartungen [1008/01.06.21]', '140',
        (select nvl((select id from sys_user where personal_number = 1008), 324) from dual),
        (select nvl((select id from sys_user where personal_number = 1777), 324) from dual));