-- name / pwd
CREATE USER qfm_erp_staging IDENTIFIED BY oSGVzPIFLOmDhDP8 DEFAULT TABLESPACE users;

-- permissions
GRANT CONNECT, RESOURCE, DBA TO qfm_erp_staging;

GRANT CREATE SESSION TO qfm_erp_staging;

-- name / pwd (client system)
create tablespace qfm_erp_client Datafile 'qfm_erp_client.DBF' SIZE 1000 M autoextend on next 5 M;
create temporary tablespace temp_qfm_erp_client
    tempfile 'temp_qfm_erp_client.dbf' size 100 M REUSE AUTOEXTEND ON NEXT 10 M MAXSIZE unlimited EXTENT MANAGEMENT LOCAL UNIFORM SIZE 1 M;


create user qfm_erp_client identified by Bg3QFEJ8aV7DraJw default tablespace qfm_erp_client temporary tablespace temp_qfm_erp_client;

GRANT CONNECT, RESOURCE, QUERY REWRITE, UNLIMITED TABLESPACE, CREATE SESSION, ALTER SESSION TO qfm_erp_client;


--
create tablespace qfmerp Datafile 'qfmerp.DBF' SIZE 1000 M autoextend on next 5 M;

create temporary tablespace tempqfmerp
    tempfile 'tempqfmerp.dbf' size 100 M REUSE AUTOEXTEND ON NEXT 10 M MAXSIZE unlimited EXTENT MANAGEMENT LOCAL UNIFORM SIZE 1 M;

create user usrqfmerp identified by sommer default tablespace qfmerp temporary tablespace tempqfmerp;


GRANT CONNECT, RESOURCE, QUERY REWRITE, UNLIMITED TABLESPACE, CREATE SESSION TO qfmerp;


-- ADMIN --
insert into sys_user (ID, CREATED_ON, UPDATED_ON, CREATED_BY, UPDATED_BY, ENTITY_STATE,
                      ROW_VERSION, USERNAME, FIRST_NAME, LAST_NAME, ROLE, PASSWORD)
values (SYS_USER_SEQ.NEXTVAL, CURRENT_DATE, CURRENT_DATE, 'example', 'example', 'VALID', 0,
        'Admin', 'Admin', 'Admin',
        'ROLE_ADMIN', '{bcrypt_12}$2a$12$CiNZT2ijnejeRQtUyIuwouM5PWxQ9kffXnAGTQKy7KAaP00fCcwha');

commit;

-- admin -> $2a$12$CiNZT2ijnejeRQtUyIuwouM5PWxQ9kffXnAGTQKy7KAaP00fCcwha
-- sommer -> $2a$12$LoLRHwo4.WX4C5JGBi.BW.kfxNCMmImEV.JSsbE/.DnaZ4kAdxtre
-- world -> $2a$12$S2BaVv3wD2vd/NaIzUI8Oetyf4nMAkY.H3YShfcNtIiiIuMMUla3O
-- wagner -> $2a$12$LJl6BbdRVe2KYdWcMLZSQ.vguD/MJ7CW2OxKIs2EMaSqK.po.ZupC
-- götz -> $2a$12$MZ5Caxf.tyjeC/QOt4Va2.RDiOnUUvw/sYIMeqjcxsVn1K6Fb2ahS
-- wesel -> $2a$12$fgBPB5aVOCy/O//C882d1eC.uRi/2geSnvg/uM45jVQ31Yi24xlN6

-- ROLE_NONE("role_none", of()),
-- ROLE_ADMIN("role_admin", copyOf(EPrivilege.values())),
-- ROLE_TECHNICIAN("role_technician", of(VIS_MEASUREMENT_POS_SQUAD_WAGE, VIS_MEASUREMENT_HEAD_AGG_SQUAD_WAGE, VIS_QUOTATION_HEAD_WAGE, VIS_QUOTATION_POS_SQUAD_WAGE)),
-- ROLE_SITE_MANAGER("role_site_manager", copyOf(EPrivilege.values())),
-- ROLE_PROJECT_MANAGER("role_project_manager", copyOf(EPrivilege.values())),
-- ROLE_BUSINESS_UNIT_MANAGER("role_business_unit_manager", copyOf(EPrivilege.values())),
-- ROLE_ACCOUNTING("role_accounting", copyOf(EPrivilege.values())),


-- SQUAD 1 --
insert into sys_user (ID, CREATED_ON, UPDATED_ON, CREATED_BY, UPDATED_BY, ENTITY_STATE, ROW_VERSION,
                      USERNAME, FIRST_NAME, LAST_NAME, FULL_NAME, ROLE, PASSWORD, REFERENCE_ID,
                      SQUAD_REFERENCE_ID, SQUAD_NAME, SQUAD_NUMBER, FLAG_SQUAD_LEADER, ALLOWED_TO_LOGIN,
                      VISIBLE_IN_MEASUREMENT_EDIT)
values (SYS_USER_SEQ.NEXTVAL, CURRENT_DATE, CURRENT_DATE, 'example', 'example', 'VALID', 0,
        'Ralf', 'Ralf', 'Heyde', 'Ralf Heyde', 'ROLE_ADMIN',
        '{bcrypt_12}$2a$12$LoLRHwo4.WX4C5JGBi.BW.kfxNCMmImEV.JSsbE/.DnaZ4kAdxtre',
        'user-1', 'squad-1', 'Bautrupp LC', '100', 1, 1, 1);

insert into sys_user (ID, CREATED_ON, UPDATED_ON, CREATED_BY, UPDATED_BY, ENTITY_STATE, ROW_VERSION,
                      USERNAME, FIRST_NAME, LAST_NAME, FULL_NAME, ROLE, PASSWORD, REFERENCE_ID,
                      SQUAD_REFERENCE_ID, SQUAD_NAME, SQUAD_NUMBER, FLAG_SQUAD_LEADER, ALLOWED_TO_LOGIN,
                      VISIBLE_IN_MEASUREMENT_EDIT)
values (SYS_USER_SEQ.NEXTVAL, CURRENT_DATE, CURRENT_DATE, 'example', 'example', 'VALID', 0,
        'Adam', 'Adam', 'Cienskowski', 'Adam Cienskowski', 'ROLE_PROJECT_MANAGER',
        '{bcrypt_12}$2a$12$LoLRHwo4.WX4C5JGBi.BW.kfxNCMmImEV.JSsbE/.DnaZ4kAdxtre',
        'user-2', 'squad-2', 'Bautrupp LC', '200', 0, 1, 1);

insert into sys_user (ID, CREATED_ON, UPDATED_ON, CREATED_BY, UPDATED_BY, ENTITY_STATE, ROW_VERSION,
                      USERNAME, FIRST_NAME, LAST_NAME, FULL_NAME, ROLE, PASSWORD, REFERENCE_ID,
                      SQUAD_REFERENCE_ID, SQUAD_NAME, SQUAD_NUMBER, FLAG_SQUAD_LEADER, ALLOWED_TO_LOGIN,
                      VISIBLE_IN_MEASUREMENT_EDIT)
values (SYS_USER_SEQ.NEXTVAL, CURRENT_DATE, CURRENT_DATE, 'example', 'example', 'VALID', 0,
        'Alex', 'Alex', 'P.', 'Alex P.', 'ROLE_PROJECT_MANAGER',
        '{bcrypt_12}$2a$12$LoLRHwo4.WX4C5JGBi.BW.kfxNCMmImEV.JSsbE/.DnaZ4kAdxtre',
        'user-3', 'squad-3', 'Bautrupp LC', '300', 0, 1, 1);


-- SQUAD 2 / Bereich Matthias --
insert into squad (ID, CREATED_ON, UPDATED_ON, CREATED_BY, UPDATED_BY, ENTITY_STATE, ROW_VERSION, NAME, SQUAD_NUMBER,
                   REFERENCE_ID)
values (SQUAD_SEQ.NEXTVAL, CURRENT_DATE, CURRENT_DATE, 'example', 'example', 'VALID', 0, 'Bereich Matthias (QFM)', 201,
        '201');

insert into sys_user (ID, CREATED_ON, UPDATED_ON, CREATED_BY, UPDATED_BY, ENTITY_STATE, ROW_VERSION,
                      USERNAME, FIRST_NAME, LAST_NAME, FULL_NAME, ROLE, PASSWORD, SQUAD_ID)
values (SYS_USER_SEQ.NEXTVAL, CURRENT_DATE, CURRENT_DATE, 'example', 'example', 'VALID', 0,
        'Matthias', 'Matthias', 'Wesel', 'Matthias Wesel', 'ROLE_PROJECT_MANAGER',
        '$2a$12$fgBPB5aVOCy/O//C882d1eC.uRi/2geSnvg/uM45jVQ31Yi24xlN6',
        SQUAD_SEQ.currval);

-- Monteur Matthias
insert into sys_user (ID, CREATED_ON, UPDATED_ON, CREATED_BY, UPDATED_BY, ENTITY_STATE, ROW_VERSION,
                      USERNAME, FIRST_NAME, LAST_NAME, FULL_NAME, ROLE, PASSWORD, SQUAD_ID)
values (SYS_USER_SEQ.NEXTVAL, CURRENT_DATE, CURRENT_DATE, 'example', 'example', 'VALID', 0,
        'Matthias1', 'Monteur-1', 'Matthias', 'Monteur-1 Matthias', 'ROLE_TECHNICIAN',
        '$2a$12$LoLRHwo4.WX4C5JGBi.BW.kfxNCMmImEV.JSsbE/.DnaZ4kAdxtre',
        SQUAD_SEQ.currval);

insert into sys_user (ID, CREATED_ON, UPDATED_ON, CREATED_BY, UPDATED_BY, ENTITY_STATE, ROW_VERSION,
                      USERNAME, FIRST_NAME, LAST_NAME, FULL_NAME, ROLE, PASSWORD, SQUAD_ID)
values (SYS_USER_SEQ.NEXTVAL, CURRENT_DATE, CURRENT_DATE, 'example', 'example', 'VALID', 0,
        'Matthias2', 'Monteur-2', 'Matthias', 'Monteur-2 Matthias', 'ROLE_TECHNICIAN',
        '$2a$12$LoLRHwo4.WX4C5JGBi.BW.kfxNCMmImEV.JSsbE/.DnaZ4kAdxtre',
        SQUAD_SEQ.currval);

insert into sys_user (ID, CREATED_ON, UPDATED_ON, CREATED_BY, UPDATED_BY, ENTITY_STATE, ROW_VERSION,
                      USERNAME, FIRST_NAME, LAST_NAME, FULL_NAME, ROLE, PASSWORD, SQUAD_ID)
values (SYS_USER_SEQ.NEXTVAL, CURRENT_DATE, CURRENT_DATE, 'example', 'example', 'VALID', 0,
        'Matthias3', 'Monteur-3', 'Matthias', 'Monteur-3 Matthias', 'ROLE_TECHNICIAN',
        '$2a$12$LoLRHwo4.WX4C5JGBi.BW.kfxNCMmImEV.JSsbE/.DnaZ4kAdxtre',
        SQUAD_SEQ.currval);


-- SQUAD 3 / Bereich Adriana --
insert into squad (ID, CREATED_ON, UPDATED_ON, CREATED_BY, UPDATED_BY, ENTITY_STATE, ROW_VERSION, NAME, SQUAD_NUMBER)
values (SQUAD_SEQ.NEXTVAL, CURRENT_DATE, CURRENT_DATE, 'example', 'example', 'VALID', 0, 'Bereich Adriana (QFM)', 301);

insert into sys_user (ID, CREATED_ON, UPDATED_ON, CREATED_BY, UPDATED_BY, ENTITY_STATE, ROW_VERSION,
                      USERNAME, FIRST_NAME, LAST_NAME, FULL_NAME, ROLE, PASSWORD, SQUAD_ID)

values (SYS_USER_SEQ.NEXTVAL, CURRENT_DATE, CURRENT_DATE, 'example', 'example', 'VALID', 0,
        'Adriana', 'Adriana', 'Götz', 'Adriana Götz', 'ROLE_ACCOUNTING',
        '$2a$12$MZ5Caxf.tyjeC/QOt4Va2.RDiOnUUvw/sYIMeqjcxsVn1K6Fb2ahS',
        SQUAD_SEQ.currval);


-- SQUAD 4 / Bereich Dennis --
insert into squad (ID, CREATED_ON, UPDATED_ON, CREATED_BY, UPDATED_BY, ENTITY_STATE, ROW_VERSION, NAME, SQUAD_NUMBER)
values (SQUAD_SEQ.NEXTVAL, CURRENT_DATE, CURRENT_DATE, 'example', 'example', 'VALID', 0, 'Bereich Dennis (QFM)', 401);

insert into sys_user (ID, CREATED_ON, UPDATED_ON, CREATED_BY, UPDATED_BY, ENTITY_STATE, ROW_VERSION,
                      USERNAME, FIRST_NAME, LAST_NAME, FULL_NAME, ROLE, PASSWORD, SQUAD_ID)
values (SYS_USER_SEQ.NEXTVAL, CURRENT_DATE, CURRENT_DATE, 'example', 'example', 'VALID', 0,
        'Dennis', 'Dennis', 'Wagner', 'Dennis Wagner', 'ROLE_PROJECT_MANAGER',
        '$2a$12$LJl6BbdRVe2KYdWcMLZSQ.vguD/MJ7CW2OxKIs2EMaSqK.po.ZupC',
        SQUAD_SEQ.currval);


-- Monteur Dennis
insert into sys_user (ID, CREATED_ON, UPDATED_ON, CREATED_BY, UPDATED_BY, ENTITY_STATE, ROW_VERSION,
                      USERNAME, FIRST_NAME, LAST_NAME, FULL_NAME, ROLE, PASSWORD, SQUAD_ID)

values (SYS_USER_SEQ.NEXTVAL, CURRENT_DATE, CURRENT_DATE, 'example', 'example', 'VALID', 0,
        'Dennis1', 'Monteur-1', 'Dennis', 'Monteur-1 Dennis', 'ROLE_TECHNICIAN',
        '$2a$12$LoLRHwo4.WX4C5JGBi.BW.kfxNCMmImEV.JSsbE/.DnaZ4kAdxtre',
        SQUAD_SEQ.currval);

insert into sys_user (ID, CREATED_ON, UPDATED_ON, CREATED_BY, UPDATED_BY, ENTITY_STATE, ROW_VERSION,
                      USERNAME, FIRST_NAME, LAST_NAME, FULL_NAME, ROLE, PASSWORD, SQUAD_ID)

values (SYS_USER_SEQ.NEXTVAL, CURRENT_DATE, CURRENT_DATE, 'example', 'example', 'VALID', 0,
        'Dennis2', 'Monteur-2', 'Dennis', 'Monteur-2 Dennis', 'ROLE_TECHNICIAN',
        '$2a$12$LoLRHwo4.WX4C5JGBi.BW.kfxNCMmImEV.JSsbE/.DnaZ4kAdxtre',
        SQUAD_SEQ.currval);

insert into sys_user (ID, CREATED_ON, UPDATED_ON, CREATED_BY, UPDATED_BY, ENTITY_STATE, ROW_VERSION,
                      USERNAME, FIRST_NAME, LAST_NAME, FULL_NAME, ROLE, PASSWORD, SQUAD_ID)

values (SYS_USER_SEQ.NEXTVAL, CURRENT_DATE, CURRENT_DATE, 'example', 'example', 'VALID', 0,
        'Dennis3', 'Monteur-3', 'Dennis', 'Monteur-3 Dennis', 'ROLE_TECHNICIAN',
        '$2a$12$LoLRHwo4.WX4C5JGBi.BW.kfxNCMmImEV.JSsbE/.DnaZ4kAdxtre',
        SQUAD_SEQ.currval);



insert into sys_user (ID, CREATED_ON, UPDATED_ON, CREATED_BY, UPDATED_BY, ENTITY_STATE, ROW_VERSION,
                      USERNAME, FIRST_NAME, LAST_NAME, FULL_NAME, ROLE, PASSWORD,
                      ALLOWED_TO_LOGIN, VISIBLE_IN_MEASUREMENT_EDIT, FLAG_SYNC_DEFAULT)

values (SYS_USER_SEQ.NEXTVAL, CURRENT_DATE, CURRENT_DATE, 'example', 'example', 'VALID', 0,
        'Monteur', 'Monteur-1', 'MonteurVN', 'MonteurNN', 'ROLE_TECHNICIAN',
        '$2a$12$LoLRHwo4.WX4C5JGBi.BW.kfxNCMmImEV.JSsbE/.DnaZ4kAdxtre',
        1, 1, 0);

commit;

select *
from SYS_USER;