--liquibase formatted sql

--changeset xoo:view-1
--comment: changing pss view definition
CREATE OR REPLACE VIEW "ELAN_AUFMASS_LESEN" as

select m.measurement_number                                              as "aufmass_nummer",
       m.CREATED_ON                                                      as "erstellt_am_um",
       decode(m.measurement_type, 'PARTIAL', 'TA', 'MAIN', 'SA', 'NONE') as "aufmass_art",
       decode(ms.measurement_state,
              'UNKNOWN', 'unbekannt',
              'TEMPORARY', 'Vorläufig',
              'IN_REVIEW', 'Prüfen',
              'APPROVED', 'Geprüft',
              'RELEASED', 'Freigegeben',
              'SUBMITTED', 'Versendet',
              'CONFIRMED', 'Bestätigt',
              'REJECTED', 'Abgelehnt',
              'IN_ACCOUNTING', 'In Faktura',
              'ACCOUNTED', 'Fakturiert',
              'CLOSED', 'Abgeschlossen',
              'DELETED', 'Gelöscht'
           )                                  as "aufmass_status",
       m.value_overall                                                   as "rechnung_summe",
       pss.pss_id                                                        as "pss_abruf_id",
       ucc.cost_center                                                   as "kostenstelle"
From measurement m
         left join release_order r on r.measurement_id = m.id
         left join pss_release_order pss on r.pss_release_order_id = pss.id
         left join USER_COST_CENTER ucc on ucc.user_id = m.assigned_user_id AND
                                           ucc.VALID_BEGIN <= m.PROJECT_EXECUTION_START_DATE AND
                                           ucc.VALID_END >= m.PROJECT_EXECUTION_START_DATE
         left join MEASUREMENT_STATE ms on m.MEASUREMENT_STATE_ID = ms.id
order by m.id desc
/