--liquibase formatted sql

--changeset xoo:trigger-1 endDelimiter:/
--comment: changing External PSS Release Order Data
CREATE or REPLACE TRIGGER TRIGGER_EXT_PSS_RO_CHANGE
    AFTER INSERT OR UPDATE OR DELETE
    ON EXT__PSS_RELEASE_ORDER
    FOR EACH ROW

DECLARE
    queue_item_type          varchar2(50 char);
    ext_pss_release_order_id varchar2(50 char);
    change_event_id          NUMBER;
BEGIN
    select QUEUE_SEQ.nextval into change_event_id from dual;

    IF DELETING THEN
        queue_item_type := 'DELETED';
        ext_pss_release_order_id := to_char(:OLD.PSS_ID);
    END IF;

    IF INSERTING THEN
        queue_item_type := 'CREATED';
        ext_pss_release_order_id := to_char(:NEW.PSS_ID);
    END IF;

    IF UPDATING THEN
        queue_item_type := 'UPDATED';
        ext_pss_release_order_id := to_char(:NEW.PSS_ID);
    END IF;

    --     ID              NUMBER(19)        not null
    --     CREATED_ON      DATE              not null,
    --     CREATED_BY      VARCHAR2(50 char) not null,
    --     UPDATED_ON      DATE              not null,
    --     UPDATED_BY      VARCHAR2(50 char) not null,
    --     ENTITY_STATE    VARCHAR2(50 char) not null,
    --     QUEUE_ITEM_TYPE VARCHAR2(50 char),
    --     REFERENCE_TYPE  VARCHAR2(50 char),
    --     REFERENCE_ID    NUMBER(19),
    --     ROW_VERSION     NUMBER(10, 2)     not null,

    insert into QUEUE_ITEM(ID, CREATED_ON, CREATED_BY, UPDATED_ON, UPDATED_BY, ENTITY_STATE, QUEUE_ITEM_TYPE,
                           REFERENCE_TYPE,
                           REFERENCE_ID, ROW_VERSION)
    values (change_event_id, sysdate, 'TRIGGER_EXT_PSS_RO_CHANGE', sysdate, 'TRIGGER_EXT_PSS_RO_CHANGE', 'VALID',
            queue_item_type, 'EXT_PSS_RELEASE_ORDER', ext_pss_release_order_id, 0);

END;
/
