/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.service.validator.quotation;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import de.qfm.erp.common.request.quotation.StagePositionModificationItem;
import de.qfm.erp.common.request.quotation.StagePositionUpdateItem;
import de.qfm.erp.common.request.quotation.StageUpdateRequest;
import de.qfm.erp.service.helper.MapsHelper;
import de.qfm.erp.service.model.exception.request.BusinessRuleValidationException;
import de.qfm.erp.service.model.internal.message.Translatable;
import de.qfm.erp.service.model.internal.quotation.StageUpdateBucket;
import de.qfm.erp.service.model.internal.validation.ValidationResult;
import de.qfm.erp.service.model.jpa.quotation.EQStageType;
import de.qfm.erp.service.model.jpa.quotation.Quotation;
import de.qfm.erp.service.model.jpa.shared.EPositionType;
import de.qfm.erp.service.service.calculator.SurrogatePositionNumberHelper;
import de.qfm.erp.service.service.service.MessageService;
import de.qfm.erp.service.service.validator.quotation.QStageBeforeUpdateValidator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class QStageMultiplePositionNumberValidator
extends QStageBeforeUpdateValidator {
    private final MessageService messageService;

    @Autowired
    public QStageMultiplePositionNumberValidator(MessageService messageService) {
        this.messageService = messageService;
    }

    public Iterable<ValidationResult> validate(@NonNull StageUpdateBucket stageUpdateBucket) {
        if (stageUpdateBucket == null) {
            throw new NullPointerException("stageUpdateBucket is marked non-null but is null");
        }
        ImmutableList.Builder validationResultBuilder = ImmutableList.builder();
        StageUpdateRequest request = (StageUpdateRequest)stageUpdateBucket.getRequest();
        Quotation stage = (Quotation)stageUpdateBucket.getEntity();
        EQStageType stageType = stage.getStageType();
        if (!Iterables.contains((Iterable)EQStageType.STAGE_DUPLICATE_POSITIONS_ALLOWED_TYPES, (Object)stageType)) {
            List positions = (List)MoreObjects.firstNonNull((Object)request.getPositions(), (Object)ImmutableList.of());
            for (StagePositionUpdateItem updateItem : positions) {
                String spn = SurrogatePositionNumberHelper.surrogatePositionNumber((StagePositionModificationItem)updateItem);
                updateItem.setSurrogatePositionNumber(spn);
            }
            Set positionsWithSPN = (Set)positions.stream().filter(item -> StringUtils.isNotBlank((CharSequence)item.getSurrogatePositionNumber())).filter(item -> StringUtils.equalsIgnoreCase((CharSequence)EPositionType.STANDARD.name(), (CharSequence)item.getPositionType())).collect(ImmutableSet.toImmutableSet());
            Map bySPN = MapsHelper.mapFirst((Iterable)positionsWithSPN, StagePositionModificationItem::getSurrogatePositionNumber);
            HashSet items = Sets.newHashSet();
            Set duplicateSPN = positions.stream().filter(item -> StringUtils.equalsIgnoreCase((CharSequence)EPositionType.STANDARD.name(), (CharSequence)item.getPositionType())).map(StagePositionModificationItem::getSurrogatePositionNumber).filter(StringUtils::isNotBlank).filter(n -> !items.add(n)).collect(Collectors.toSet());
            String stageTypeName = this.messageService.get((Translatable)stageType, new Object[0]);
            if (!duplicateSPN.isEmpty()) {
                String collect = duplicateSPN.stream().map(bySPN::get).map(StagePositionModificationItem::getSurrogatePositionNumber).collect(Collectors.joining(","));
                String message = String.format("%s enth\u00e4lt bereits die Position/en: %s. Ein Speichern ist nicht m\u00f6glich, Duplikate sind nicht erlaubt", stageTypeName, collect);
                throw new BusinessRuleValidationException(message, (List)ImmutableList.of());
            }
        }
        return validationResultBuilder.build();
    }
}

