/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.service.validator.payroll;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import de.qfm.erp.common.request.employee.payroll.PayrollItemUpdateItem;
import de.qfm.erp.service.model.exception.request.UpdateRejectException;
import de.qfm.erp.service.model.internal.employee.payroll.PayrollMonthItemUpdateBucket;
import de.qfm.erp.service.model.internal.employee.payroll.PayrollMonthUpdateBucket;
import de.qfm.erp.service.model.internal.fieldname.EField;
import de.qfm.erp.service.model.internal.fieldname.FieldName;
import de.qfm.erp.service.model.internal.fieldname.FieldNamesFactory;
import de.qfm.erp.service.model.internal.message.EMessageKey;
import de.qfm.erp.service.model.internal.message.Message;
import de.qfm.erp.service.model.jpa.employee.payroll.PayrollItemType;
import de.qfm.erp.service.service.validator.payroll.PayrollBeforeMergeValidator;
import java.util.List;
import java.util.Objects;
import lombok.NonNull;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Service;

@Service
@Order(value=2)
public class PayrollMonthAuxiliaryWageProjectMandatoryValidator
extends PayrollBeforeMergeValidator {
    public static final Joiner MESSAGE_JOINER = Joiner.on((char)',').skipNulls();

    public boolean validate(@NonNull PayrollMonthUpdateBucket updateBucket) {
        if (updateBucket == null) {
            throw new NullPointerException("updateBucket is marked non-null but is null");
        }
        Iterable auxiliaryWagePayrollItemsBuckets = updateBucket.getAuxiliaryWagePayrollItemsBuckets();
        ImmutableList.Builder payrollItemProjectNotSetBuilder = ImmutableList.builder();
        for (PayrollMonthItemUpdateBucket auxiliaryWagePayrollItemsBucket : auxiliaryWagePayrollItemsBuckets) {
            boolean projectMandatory;
            PayrollItemType payrollItemType = auxiliaryWagePayrollItemsBucket.getPayrollItemType();
            PayrollItemUpdateItem payrollItemUpdateItem = auxiliaryWagePayrollItemsBucket.getPayrollItemUpdateItem();
            Long projectId = payrollItemUpdateItem.getProjectId();
            if (null == payrollItemType || !(projectMandatory = Objects.equals(payrollItemType.getFlagProjectMandatory(), true)) || null != projectId) continue;
            payrollItemProjectNotSetBuilder.add((Object)payrollItemType);
        }
        ImmutableList payrollItemTypesMissingProject = payrollItemProjectNotSetBuilder.build();
        if (!payrollItemTypesMissingProject.isEmpty()) {
            ImmutableSet payrollItemTypesMissingNames = (ImmutableSet)payrollItemTypesMissingProject.stream().map(PayrollItemType::getName).collect(ImmutableSet.toImmutableSet());
            String payrollItemTypesMissingNamesJoined = MESSAGE_JOINER.join((Iterable)payrollItemTypesMissingNames);
            throw new UpdateRejectException((FieldName)FieldNamesFactory.simpleFieldName((EField)EField.PAYROLL_MONTH_ITEM__AUXILIARY_WAGE__PROJECT), (Object)payrollItemTypesMissingNamesJoined, String.format("Payroll Month cannot be updated, auxiliary wages require a project set for: %s", payrollItemTypesMissingNamesJoined), Message.of((EMessageKey)EMessageKey.RULE_PAYROLL_MONTH_AUXILIARY_WAGE_MISSING_PROJECT, (List)ImmutableList.of((Object)payrollItemTypesMissingNamesJoined)));
        }
        return true;
    }
}

