/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.service.validator.measurement;

import com.google.common.collect.ImmutableList;
import de.qfm.erp.service.model.exception.request.UpdateRejectException;
import de.qfm.erp.service.model.internal.fieldname.EField;
import de.qfm.erp.service.model.internal.fieldname.FieldName;
import de.qfm.erp.service.model.internal.fieldname.FieldNamesFactory;
import de.qfm.erp.service.model.internal.measurement.MeasurementUpdateBucket;
import de.qfm.erp.service.model.internal.message.EMessageKey;
import de.qfm.erp.service.model.internal.message.Message;
import de.qfm.erp.service.model.internal.message.Translatable;
import de.qfm.erp.service.model.jpa.measurement.Measurement;
import de.qfm.erp.service.model.jpa.measurement.MeasurementState;
import de.qfm.erp.service.model.jpa.measurement.type.EMeasurementState;
import de.qfm.erp.service.model.jpa.quotation.Quotation;
import de.qfm.erp.service.service.service.MessageService;
import de.qfm.erp.service.service.validator.measurement.MeasurementBeforeUpdateValidator;
import java.util.List;
import java.util.Objects;
import lombok.NonNull;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Service;

@Service
@Order(value=0)
public class MeasurementUpdateInStatePrivilegedValidator
extends MeasurementBeforeUpdateValidator {
    private final MessageService messageService;

    public boolean validate(@NonNull MeasurementUpdateBucket updateBucket) {
        boolean isB2BBlocking;
        if (updateBucket == null) {
            throw new NullPointerException("updateBucket is marked non-null but is null");
        }
        Measurement measurement = (Measurement)updateBucket.getEntity();
        MeasurementState measurementState = measurement.getMeasurementState();
        EMeasurementState eMeasurementState = measurementState.getMeasurementState();
        Quotation quotation = measurement.getQuotation();
        boolean flagB2B = Objects.equals(quotation.getFlagB2B(), true);
        boolean bl = isB2BBlocking = flagB2B && EMeasurementState.B2B_BLOCKING_STATES.contains(eMeasurementState);
        if (isB2BBlocking) {
            String stateTranslated = this.messageService.getDE((Translatable)eMeasurementState, new Object[0]);
            throw new UpdateRejectException((FieldName)FieldNamesFactory.simpleFieldName((EField)EField.MEASUREMENT_STATE), (Object)eMeasurementState, String.format("Measurement cannot be updated, its in state: %s and you are not privileged", eMeasurementState), Message.of((EMessageKey)EMessageKey.RULE_MEASUREMENT_STATE_UPDATE_NOT_ALLOWED, (List)ImmutableList.of((Object)stateTranslated)));
        }
        return true;
    }

    public MeasurementUpdateInStatePrivilegedValidator(MessageService messageService) {
        this.messageService = messageService;
    }
}

