/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.service.validator.measurement;

import com.google.common.collect.ImmutableList;
import de.qfm.erp.service.model.exception.request.UpdateRejectException;
import de.qfm.erp.service.model.internal.fieldname.EField;
import de.qfm.erp.service.model.internal.fieldname.FieldName;
import de.qfm.erp.service.model.internal.fieldname.FieldNamesFactory;
import de.qfm.erp.service.model.internal.measurement.MeasurementUpdateBucket;
import de.qfm.erp.service.model.internal.message.EMessageKey;
import de.qfm.erp.service.model.internal.message.Message;
import de.qfm.erp.service.model.internal.message.Translatable;
import de.qfm.erp.service.model.jpa.measurement.Measurement;
import de.qfm.erp.service.model.jpa.measurement.MeasurementState;
import de.qfm.erp.service.model.jpa.measurement.type.EMeasurementState;
import de.qfm.erp.service.model.jpa.user.EPrivilege;
import de.qfm.erp.service.service.security.UserService;
import de.qfm.erp.service.service.service.MessageService;
import de.qfm.erp.service.service.validator.measurement.MeasurementBeforeMergeValidator;
import java.util.List;
import lombok.NonNull;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Service;

@Service
@Order(value=-200)
public class MeasurementStateBeforeMergeValidator
extends MeasurementBeforeMergeValidator {
    private final MessageService messageService;
    private final UserService userService;

    public boolean validate(@NonNull MeasurementUpdateBucket measurementUpdateBucket) {
        boolean hasPrivilege;
        if (measurementUpdateBucket == null) {
            throw new NullPointerException("measurementUpdateBucket is marked non-null but is null");
        }
        Measurement measurement = (Measurement)measurementUpdateBucket.getEntity();
        MeasurementState currentMeasurementState = measurement.getMeasurementState();
        EMeasurementState eCurrentMeasurementState = currentMeasurementState.getMeasurementState();
        if (EMeasurementState.MEASUREMENT_EDITING_NOT_ALLOWED.contains(eCurrentMeasurementState)) {
            throw new UpdateRejectException((FieldName)FieldNamesFactory.simpleFieldName((EField)EField.MEASUREMENT_STATE), (Object)eCurrentMeasurementState, String.format("Measurement cannot be Updated as its in State: %s", eCurrentMeasurementState), Message.of((EMessageKey)EMessageKey.RULE_MEASUREMENT_STATE_UPDATE_NOT_ALLOWED, (List)ImmutableList.of((Object)eCurrentMeasurementState)));
        }
        EPrivilege privilegeNeeded = (EPrivilege)EMeasurementState.MEASUREMENT_STATE__PRIVILEGE.get((Object)eCurrentMeasurementState);
        boolean bl = hasPrivilege = null != privilegeNeeded && this.userService.hasPrivilege(privilegeNeeded);
        if (!hasPrivilege) {
            String privilegeName = null != privilegeNeeded ? this.messageService.get((Translatable)privilegeNeeded, new Object[0]) : "n/a";
            throw new UpdateRejectException((FieldName)FieldNamesFactory.simpleFieldName((EField)EField.MEASUREMENT_STATE), (Object)eCurrentMeasurementState, String.format("Measurement cannot be Updated, due to missing Privilege: %s as its in State: %s", privilegeNeeded, eCurrentMeasurementState), Message.of((EMessageKey)EMessageKey.RULE_MEASUREMENT_STATE_UPDATE_NOT_ALLOWED_MISSING_PRIVILEGE, (List)ImmutableList.of((Object)privilegeName, (Object)eCurrentMeasurementState)));
        }
        return false;
    }

    public MeasurementStateBeforeMergeValidator(MessageService messageService, UserService userService) {
        this.messageService = messageService;
        this.userService = userService;
    }
}

