/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.service.validator.measurement;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import de.qfm.erp.common.request.measurement.MeasurementUpdateRequest;
import de.qfm.erp.service.helper.QuotationHelper;
import de.qfm.erp.service.model.exception.request.UpdateRejectException;
import de.qfm.erp.service.model.internal.fieldname.FieldName;
import de.qfm.erp.service.model.internal.fieldname.FieldNamesFactory;
import de.qfm.erp.service.model.internal.measurement.MeasurementUpdateBucket;
import de.qfm.erp.service.model.internal.message.EMessageKey;
import de.qfm.erp.service.model.internal.message.Message;
import de.qfm.erp.service.model.internal.message.Translatable;
import de.qfm.erp.service.model.jpa.quotation.EQStageState;
import de.qfm.erp.service.model.jpa.quotation.Quotation;
import de.qfm.erp.service.service.service.MessageService;
import de.qfm.erp.service.service.validator.measurement.MeasurementBeforeMergeValidator;
import java.util.List;
import lombok.NonNull;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Service;

@Service
@Order(value=-300)
public class MeasurementQuotationEndBeforeMergeValidator
extends MeasurementBeforeMergeValidator {
    private final MessageService messageService;

    public boolean validate(@NonNull MeasurementUpdateBucket measurementUpdateBucket) {
        if (measurementUpdateBucket == null) {
            throw new NullPointerException("measurementUpdateBucket is marked non-null but is null");
        }
        MeasurementUpdateRequest updateRequest = (MeasurementUpdateRequest)measurementUpdateBucket.getRequest();
        Quotation stage = measurementUpdateBucket.getQuotation();
        EQStageState stageState = (EQStageState)MoreObjects.firstNonNull((Object)stage.getStageState(), (Object)EQStageState.UNKNOWN);
        String rejectedValue = this.messageService.get((Translatable)stageState, new Object[0]);
        if (QuotationHelper.isStageEnded((Quotation)stage)) {
            throw new UpdateRejectException((FieldName)FieldNamesFactory.stageState(), (Object)rejectedValue, String.format("Measurement cannot be Updated, Quotation: %s is Ended (flagOrderEnd)", rejectedValue), Message.of((EMessageKey)EMessageKey.RULE_QUOTATION_ORDER_END, (List)ImmutableList.of((Object)rejectedValue)));
        }
        return true;
    }

    public MeasurementQuotationEndBeforeMergeValidator(MessageService messageService) {
        this.messageService = messageService;
    }
}

