/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.service.validator.measurement;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import de.qfm.erp.common.request.measurement.MeasurementUpdateRequest;
import de.qfm.erp.service.model.exception.request.BusinessRuleValidationException;
import de.qfm.erp.service.model.exception.request.RequestValidationException;
import de.qfm.erp.service.model.internal.ReleaseOrderUpdateBucket;
import de.qfm.erp.service.model.internal.fieldname.EField;
import de.qfm.erp.service.model.internal.fieldname.FieldName;
import de.qfm.erp.service.model.internal.fieldname.FieldNamesFactory;
import de.qfm.erp.service.model.internal.fieldname.SimpleFieldName;
import de.qfm.erp.service.model.internal.measurement.MeasurementUpdateBucket;
import de.qfm.erp.service.model.internal.message.EMessageKey;
import de.qfm.erp.service.model.internal.message.Message;
import de.qfm.erp.service.model.internal.message.Translatable;
import de.qfm.erp.service.model.jpa.measurement.Measurement;
import de.qfm.erp.service.model.jpa.measurement.MeasurementState;
import de.qfm.erp.service.model.jpa.measurement.PssReleaseOrder;
import de.qfm.erp.service.model.jpa.measurement.type.EMeasurementState;
import de.qfm.erp.service.model.jpa.measurement.type.EMeasurementType;
import de.qfm.erp.service.service.service.MessageService;
import de.qfm.erp.service.service.validator.measurement.MeasurementBeforeUpdateValidator;
import java.util.List;
import lombok.NonNull;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Service;

@Service
@Order(value=100)
public class MeasurementPssPreventDuplicateClosingMeasurementBeforeMergeValidator
extends MeasurementBeforeUpdateValidator {
    private final MessageService messageService;

    public boolean validate(@NonNull MeasurementUpdateBucket measurementUpdateBucket) {
        PssReleaseOrder pssReleaseOrder;
        if (measurementUpdateBucket == null) {
            throw new NullPointerException("measurementUpdateBucket is marked non-null but is null");
        }
        Measurement measurement = (Measurement)measurementUpdateBucket.getEntity();
        MeasurementUpdateRequest updateRequest = (MeasurementUpdateRequest)measurementUpdateBucket.getRequest();
        ReleaseOrderUpdateBucket releaseOrderUpdateBucket = measurementUpdateBucket.getReleaseOrderUpdateBucket();
        Iterable measurementsWithPssReleaseOrder = measurementUpdateBucket.getMeasurementsWithSamePSSRO();
        EMeasurementType measurementType = measurement.getMeasurementType();
        if (EMeasurementType.MAIN == measurementType && null != releaseOrderUpdateBucket && null != (pssReleaseOrder = releaseOrderUpdateBucket.getPssReleaseOrder())) {
            String pssReleaseOrderName = pssReleaseOrder.getReleaseOrderNameSelectCurrent();
            if (!Iterables.isEmpty((Iterable)measurementsWithPssReleaseOrder)) {
                Measurement measurementToCheck = (Measurement)Iterables.get((Iterable)measurementsWithPssReleaseOrder, (int)0);
                String measurementNumberCheck = measurementToCheck.getMeasurementNumber();
                EMeasurementType measurementTypeCheck = measurementToCheck.getMeasurementType();
                MeasurementState measurementStateCheck = measurementToCheck.getMeasurementState();
                EMeasurementState eMeasurementStateCheck = measurementStateCheck.getMeasurementState();
                String measurementTypeTranslated = this.messageService.getDE((Translatable)measurementTypeCheck, new Object[0]);
                String measurementStateTranslated = this.messageService.getDE((Translatable)eMeasurementStateCheck, new Object[0]);
                String messageText = String.format("Measurement cannot be saved, there is already a Measurement '%s' in state: '%s' with type: '%s' for PSS Release Order: '%s'", measurementNumberCheck, eMeasurementStateCheck, measurementType, pssReleaseOrderName);
                Message message = Message.of((EMessageKey)EMessageKey.RULE_MEASUREMENT__PREVENT_DUPLICATE_CLOSING_MEASUREMENT_FOR_PSS_ID, (List)ImmutableList.of((Object)measurementNumberCheck, (Object)measurementStateTranslated, (Object)measurementTypeTranslated, (Object)pssReleaseOrderName));
                SimpleFieldName fieldName = FieldNamesFactory.simpleFieldName((EField)EField.MEASUREMENT_TYPE);
                ImmutableList details = ImmutableList.of((Object)RequestValidationException.Detail.of((FieldName)fieldName, (Object)measurementTypeTranslated, (String)messageText, (Message)message, (List)ImmutableList.of()));
                throw new BusinessRuleValidationException("Business Rules Validation Error", (List)details);
            }
            if (Boolean.TRUE == pssReleaseOrder.getFlagDisabled()) {
                String messageText = String.format("Measurement cannot be saved, the PSS Release Order: '%s' is disabled", pssReleaseOrderName);
                Message message = Message.of((EMessageKey)EMessageKey.RULE_MEASUREMENT__PSS_RELEASE_ORDER_DISABLED, (List)ImmutableList.of((Object)pssReleaseOrderName));
                SimpleFieldName fieldName = FieldNamesFactory.simpleFieldName((EField)EField.MEASUREMENT__RELEASE_ORDER);
                ImmutableList details = ImmutableList.of((Object)RequestValidationException.Detail.of((FieldName)fieldName, (Object)pssReleaseOrder.getId(), (String)messageText, (Message)message, (List)ImmutableList.of()));
                throw new BusinessRuleValidationException("Business Rules Validation Error", (List)details);
            }
        }
        return true;
    }

    public MeasurementPssPreventDuplicateClosingMeasurementBeforeMergeValidator(MessageService messageService) {
        this.messageService = messageService;
    }
}

