/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.service.validator.invoice;

import com.google.common.base.Joiner;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Streams;
import de.qfm.erp.service.model.internal.invoice.InvoiceValidationBucket;
import de.qfm.erp.service.model.internal.message.EMessageKey;
import de.qfm.erp.service.model.internal.message.Message;
import de.qfm.erp.service.model.internal.validation.ValidationResult;
import de.qfm.erp.service.model.jpa.measurement.Measurement;
import de.qfm.erp.service.model.jpa.quotation.Quotation;
import de.qfm.erp.service.service.validator.invoice.InvoiceBeforeChangeValidator;
import de.qfm.erp.service.service.validator.invoice.InvoiceBeforeUpdateValidator;
import java.util.List;
import java.util.Objects;
import lombok.NonNull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class InvoiceMultiMeasurementValidator
extends InvoiceBeforeUpdateValidator {
    @Autowired
    public InvoiceMultiMeasurementValidator() {
        super((Iterable)ImmutableSet.of((Object)InvoiceBeforeChangeValidator.EInvoiceValidatorProperty.PDF, (Object)InvoiceBeforeChangeValidator.EInvoiceValidatorProperty.UPDATE));
    }

    public Iterable<ValidationResult> validate(@NonNull InvoiceValidationBucket validationBucket) {
        Iterable quotationNumbers;
        if (validationBucket == null) {
            throw new NullPointerException("validationBucket is marked non-null but is null");
        }
        ImmutableList.Builder validationResultBuilder = ImmutableList.builder();
        Iterable measurements = (Iterable)MoreObjects.firstNonNull((Object)validationBucket.getMeasurements(), (Object)ImmutableList.of());
        if (!Iterables.isEmpty((Iterable)measurements) && Iterables.size((Iterable)(quotationNumbers = (Iterable)Streams.stream((Iterable)measurements).map(Measurement::getQuotation).filter(Objects::nonNull).map(Quotation::getQuotationNumber).filter(Objects::nonNull).collect(ImmutableSet.toImmutableSet()))) > 1) {
            String quotationNumbersFound = Joiner.on((String)", ").join(quotationNumbers);
            validationResultBuilder.add((Object)ValidationResult.error((Message)Message.of((EMessageKey)EMessageKey.RULE_INVOICE__MEASUREMENT_MORE_THAN_ONE_STAGE, (List)ImmutableList.of((Object)quotationNumbersFound))));
        }
        return validationResultBuilder.build();
    }
}

