/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.service.validator.invoice;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import de.qfm.erp.service.model.internal.invoice.InvoiceValidationBucket;
import de.qfm.erp.service.model.internal.message.EMessageKey;
import de.qfm.erp.service.model.internal.message.Message;
import de.qfm.erp.service.model.internal.message.Translatable;
import de.qfm.erp.service.model.internal.validation.ValidationResult;
import de.qfm.erp.service.model.jpa.measurement.Measurement;
import de.qfm.erp.service.model.jpa.measurement.MeasurementState;
import de.qfm.erp.service.model.jpa.measurement.type.EMeasurementState;
import de.qfm.erp.service.service.service.MessageService;
import de.qfm.erp.service.service.validator.invoice.InvoiceBeforeChangeValidator;
import de.qfm.erp.service.service.validator.invoice.InvoiceBeforeUpdateValidator;
import java.util.List;
import lombok.NonNull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class InvoiceMeasurementAccountableValidator
extends InvoiceBeforeUpdateValidator {
    private final MessageService messageService;

    @Autowired
    public InvoiceMeasurementAccountableValidator(MessageService messageService) {
        super((Iterable)ImmutableSet.of((Object)InvoiceBeforeChangeValidator.EInvoiceValidatorProperty.PDF));
        this.messageService = messageService;
    }

    public Iterable<ValidationResult> validate(@NonNull InvoiceValidationBucket validationBucket) {
        if (validationBucket == null) {
            throw new NullPointerException("validationBucket is marked non-null but is null");
        }
        ImmutableList.Builder validationResultBuilder = ImmutableList.builder();
        Iterable measurements = validationBucket.getMeasurements();
        for (Measurement measurement : measurements) {
            MeasurementState measurementState = measurement.getMeasurementState();
            EMeasurementState eMeasurementState = measurementState.getMeasurementState();
            if (EMeasurementState.AVAILABLE_FOR_INVOICE_NON_B2B.contains(eMeasurementState)) continue;
            String measurementNumber = measurement.getMeasurementNumber();
            String measurementStateText = this.messageService.getDE((Translatable)eMeasurementState, new Object[0]);
            validationResultBuilder.add((Object)ValidationResult.error((Message)Message.of((EMessageKey)EMessageKey.RULE_INVOICE__MEASUREMENT_NOT_ACCOUNTABLE, (List)ImmutableList.of((Object)measurementNumber, (Object)measurementStateText))));
        }
        return validationResultBuilder.build();
    }
}

