/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.service.validator;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Range;
import de.qfm.erp.service.model.exception.request.RequestValidationException;
import de.qfm.erp.service.model.internal.fieldname.FieldName;
import de.qfm.erp.service.model.internal.message.EMessageKey;
import de.qfm.erp.service.model.internal.message.Message;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import lombok.NonNull;

public abstract class BeforeChangeValidator<T> {
    public abstract boolean validate(@NonNull T var1);

    @Nonnull
    protected List<RequestValidationException.Detail> checkWithinRangeIfSet(@NonNull FieldName fieldName, @Nullable LocalDate value, @NonNull Range<LocalDate> referenceRange, @NonNull String explain) {
        if (fieldName == null) {
            throw new NullPointerException("fieldName is marked non-null but is null");
        }
        if (referenceRange == null) {
            throw new NullPointerException("referenceRange is marked non-null but is null");
        }
        if (explain == null) {
            throw new NullPointerException("explain is marked non-null but is null");
        }
        ImmutableList.Builder detailBuilder = ImmutableList.builder();
        if (null != value && !referenceRange.contains((Comparable)value)) {
            String fieldPath = fieldName.path();
            String messageText = String.format("Field: %s has value: %s and is supposed to be in range: %s, Explain: %s", fieldPath, value, referenceRange, explain);
            Message message = Message.of((EMessageKey)EMessageKey.DATE_RANGE, (List)ImmutableList.of((Object)fieldPath, (Object)value.format(DateTimeFormatter.ISO_DATE), (Object)((LocalDate)referenceRange.lowerEndpoint()).format(DateTimeFormatter.ISO_DATE), (Object)((LocalDate)referenceRange.upperEndpoint()).format(DateTimeFormatter.ISO_DATE), (Object)explain));
            detailBuilder.add((Object)RequestValidationException.Detail.of((FieldName)fieldName, (Object)value, (String)messageText, (Message)message, (List)ImmutableList.of((Object)((LocalDate)referenceRange.lowerEndpoint()).format(DateTimeFormatter.ISO_DATE), (Object)((LocalDate)referenceRange.upperEndpoint()).format(DateTimeFormatter.ISO_DATE))));
        }
        return detailBuilder.build();
    }

    @Nonnull
    protected List<RequestValidationException.Detail> checkDateFollowsDate(@NonNull FieldName fieldNameBefore, @NonNull FieldName fieldNameAfter, @Nullable LocalDate before, @Nullable LocalDate after) {
        if (fieldNameBefore == null) {
            throw new NullPointerException("fieldNameBefore is marked non-null but is null");
        }
        if (fieldNameAfter == null) {
            throw new NullPointerException("fieldNameAfter is marked non-null but is null");
        }
        ImmutableList.Builder detailBuilder = ImmutableList.builder();
        if (before != null && after != null && before.compareTo(after) > 0) {
            String fieldBeforePath = fieldNameBefore.path();
            String fieldAfterPath = fieldNameAfter.path();
            String message = String.format("Field: %s with value: %s and is supposed to be before Field: %s with value: %s", fieldBeforePath, fieldAfterPath, before, after);
            Message fieldABeforeB = Message.of((EMessageKey)EMessageKey.FIELD_A_BEFORE_B, (List)ImmutableList.of((Object)fieldBeforePath, (Object)fieldAfterPath, (Object)before, (Object)after));
            Message min = Message.of((EMessageKey)EMessageKey.MIN, (List)ImmutableList.of((Object)before));
            Message max = Message.of((EMessageKey)EMessageKey.MAX, (List)ImmutableList.of((Object)after));
            detailBuilder.add((Object)RequestValidationException.Detail.of((FieldName)fieldNameAfter, (Object)after, (String)message, (Message)min, (List)ImmutableList.of((Object)before.format(DateTimeFormatter.ISO_DATE))));
            detailBuilder.add((Object)RequestValidationException.Detail.of((FieldName)fieldNameBefore, (Object)before, (String)message, (Message)max, (List)ImmutableList.of((Object)after.format(DateTimeFormatter.ISO_DATE))));
        }
        return detailBuilder.build();
    }
}

