/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.service.service.xls;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Streams;
import de.qfm.erp.service.helper.StagePositionHelper;
import de.qfm.erp.service.model.internal.message.Translatable;
import de.qfm.erp.service.model.internal.quotation.EQuotationPositionSortOption;
import de.qfm.erp.service.model.internal.xlsx.CellStyles;
import de.qfm.erp.service.model.jpa.quotation.EQStageType;
import de.qfm.erp.service.model.jpa.quotation.Quotation;
import de.qfm.erp.service.model.jpa.quotation.QuotationPosition;
import de.qfm.erp.service.model.jpa.shared.EPositionType;
import de.qfm.erp.service.service.service.MessageService;
import de.qfm.erp.service.service.service.xls.AbstractXlsExportService;
import de.qfm.erp.service.service.service.xls.StageXlsExportService;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import lombok.NonNull;
import org.apache.commons.compress.utils.Lists;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.xssf.streaming.SXSSFRow;
import org.apache.poi.xssf.streaming.SXSSFSheet;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class StageXlsExportService
extends AbstractXlsExportService {
    private static final Logger log = LogManager.getLogger(StageXlsExportService.class);
    private final MessageService messageService;

    @Autowired
    public StageXlsExportService(MessageService messageService) {
        this.messageService = messageService;
    }

    @Nonnull
    public SXSSFWorkbook detailXLS(@NonNull Iterable<Quotation> stages, @NonNull String sheetName) {
        if (stages == null) {
            throw new NullPointerException("stages is marked non-null but is null");
        }
        if (sheetName == null) {
            throw new NullPointerException("sheetName is marked non-null but is null");
        }
        SXSSFWorkbook workbook = new SXSSFWorkbook();
        workbook.setCompressTempFiles(true);
        SXSSFSheet sheet1 = workbook.createSheet(sheetName);
        sheet1.setRandomAccessWindowSize(100);
        SXSSFSheet sheet2 = workbook.createSheet(sheetName + " gruppiert");
        sheet2.setRandomAccessWindowSize(100);
        Font topHeaderFont = workbook.createFont();
        topHeaderFont.setBold(true);
        CellStyle headerStyle = workbook.createCellStyle();
        headerStyle.setFont(topHeaderFont);
        Font detailsFont = workbook.createFont();
        detailsFont.setBold(false);
        CellStyle detailsStyle = workbook.createCellStyle();
        detailsStyle.setFont(detailsFont);
        CellStyles cellStylesSheet1 = CellStyles.create((CellStyle)headerStyle, (CellStyle)detailsStyle, (CellStyle)CellStyles.decimal0CellStyle((SXSSFSheet)sheet1, (CellStyle)detailsStyle), (CellStyle)CellStyles.decimal2CellStyle((SXSSFSheet)sheet1, (CellStyle)detailsStyle), (CellStyle)CellStyles.formulaCellStyle((SXSSFSheet)sheet1, (CellStyle)detailsStyle));
        CellStyles cellStylesSheet2 = CellStyles.create((CellStyle)headerStyle, (CellStyle)detailsStyle, (CellStyle)CellStyles.decimal0CellStyle((SXSSFSheet)sheet2, (CellStyle)detailsStyle), (CellStyle)CellStyles.decimal2CellStyle((SXSSFSheet)sheet2, (CellStyle)detailsStyle), (CellStyle)CellStyles.formulaCellStyle((SXSSFSheet)sheet2, (CellStyle)detailsStyle));
        for (PositionColumn positionColumn : PositionColumn.values()) {
            sheet1.setColumnWidth(positionColumn.index, 3750);
        }
        Stream sortedPositions = Streams.stream(stages).flatMap(item -> Streams.stream((Iterable)StagePositionHelper.automaticShuffle((Quotation)item, (EQuotationPositionSortOption)EQuotationPositionSortOption.GROUPING_LEVELS_ASC, (Iterable)item.getQuotationPositions())));
        this.populateSheet(sortedPositions, sheet1, cellStylesSheet1);
        Map<String, List<QuotationPosition>> collect = Streams.stream(stages).flatMap(item -> ((Set)MoreObjects.firstNonNull((Object)item.getQuotationPositions(), (Object)ImmutableSet.of())).stream()).filter(item -> null != item.getSurrogatePositionNumber()).filter(item -> EQStageType.COMMISSION__COST_ESTIMATE != item.getQuotation().getStageType() || EPositionType.COMMENT != item.getPositionType() && EPositionType.REMARK != item.getPositionType()).collect(Collectors.groupingBy(QuotationPosition::getSurrogatePositionNumber));
        ArrayList groupedList = Lists.newArrayList();
        Set<Map.Entry<String, List<QuotationPosition>>> entries = collect.entrySet();
        for (Map.Entry<String, List<QuotationPosition>> entry : entries) {
            List<QuotationPosition> allPos = entry.getValue();
            QuotationPosition first = allPos.iterator().next();
            QuotationPosition grouped = this.group(first, allPos);
            groupedList.add(grouped);
        }
        Stream sortedGroupedPositions = groupedList.stream().sorted(EQuotationPositionSortOption.GROUPING_LEVELS_ASC.getComparator());
        this.populateSheet(sortedGroupedPositions, sheet2, cellStylesSheet2);
        sheet1.setDisplayGridlines(true);
        sheet2.setDisplayGridlines(true);
        return workbook;
    }

    private void populateSheet(@NonNull Stream<QuotationPosition> positions, SXSSFSheet sheet1, CellStyles cellStyles) {
        if (positions == null) {
            throw new NullPointerException("positions is marked non-null but is null");
        }
        AtomicInteger rowNum = new AtomicInteger();
        SXSSFRow detailsHeader = StageXlsExportService.newRow((SXSSFSheet)sheet1, (AtomicInteger)rowNum);
        for (PositionColumn positionColumn : PositionColumn.values()) {
            StageXlsExportService.createText((CellStyle)cellStyles.getHeader(), (String)positionColumn.name, (SXSSFRow)detailsHeader, (int)positionColumn.index);
        }
        positions.forEach(position -> {
            SXSSFRow detailRow = StageXlsExportService.newRow((SXSSFSheet)sheet1, (AtomicInteger)rowNum);
            block4: for (PositionColumn positionColumn : PositionColumn.values()) {
                COLUMN_TYPE COLUMNTYPE = positionColumn.getColumnType();
                Object value = positionColumn.getFn().apply(position);
                Object valueToUse = value instanceof Translatable ? this.messageService.getDE((Translatable)value, new Object[0]) : value;
                switch (COLUMNTYPE.ordinal()) {
                    case 1: {
                        BigDecimal bdValue = valueToUse instanceof BigDecimal ? (BigDecimal)valueToUse : null;
                        StageXlsExportService.createNumber((CellStyles)cellStyles, (BigDecimal)bdValue, (SXSSFRow)detailRow, (int)positionColumn.index);
                        continue block4;
                    }
                    case 0: 
                    case 2: {
                        String stringValue = valueToUse instanceof String ? (String)valueToUse : "";
                        StageXlsExportService.createText((CellStyle)cellStyles.getText(), (String)stringValue, (SXSSFRow)detailRow, (int)positionColumn.index);
                    }
                }
            }
        });
    }

    @Nonnull
    private QuotationPosition group(@NonNull QuotationPosition original, @NonNull Iterable<QuotationPosition> allOthers) {
        if (original == null) {
            throw new NullPointerException("original is marked non-null but is null");
        }
        if (allOthers == null) {
            throw new NullPointerException("allOthers is marked non-null but is null");
        }
        QuotationPosition position = new QuotationPosition();
        position.setGroupingElementLevel1(original.getGroupingElementLevel1());
        position.setGroupingElementLevel2(original.getGroupingElementLevel2());
        position.setGroupingElementLevel3(original.getGroupingElementLevel3());
        position.setGroupingElementLevel4(original.getGroupingElementLevel4());
        position.setAlternativePositionType(original.getAlternativePositionType());
        position.setPositionNumber(original.getPositionNumber());
        BigDecimal orderedAmountAggregated = Streams.stream(allOthers).map(QuotationPosition::getOrderedAmount).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add);
        position.setOrderedAmount(orderedAmountAggregated);
        position.setUnit(original.getUnit());
        position.setShortText(original.getShortText());
        position.setLongText(original.getLongText());
        position.setMaterialWholesalePriceIncludingDiscountPerItem(original.getMaterialWholesalePriceIncludingDiscountPerItem());
        BigDecimal materialWholesalePriceIncludingDiscountAggregated = Streams.stream(allOthers).map(QuotationPosition::getMaterialWholesalePriceIncludingDiscountAggregated).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add);
        position.setMaterialWholesalePriceIncludingDiscountAggregated(materialWholesalePriceIncludingDiscountAggregated);
        position.setMaterialPercentage(original.getMaterialPercentage());
        position.setMaterialSellingPricePerUnit(original.getMaterialSellingPricePerUnit());
        BigDecimal materialSellingPriceAggregated = Streams.stream(allOthers).map(QuotationPosition::getMaterialSellingPriceAggregated).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add);
        position.setMaterialSellingPriceAggregated(materialSellingPriceAggregated);
        position.setSquadWagePerUnit(original.getSquadWagePerUnit());
        BigDecimal squadWageAggregated = Streams.stream(allOthers).map(QuotationPosition::getSquadWageAggregated).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add);
        position.setSquadWageAggregated(squadWageAggregated);
        position.setWagePercentage(original.getWagePercentage());
        position.setCompanyWagePerItem(original.getCompanyWagePerItem());
        BigDecimal companyWageAggregated = Streams.stream(allOthers).map(QuotationPosition::getCompanyWageAggregated).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add);
        position.setCompanyWageAggregated(companyWageAggregated);
        position.setExternalServicePurchasePricePerUnit(original.getExternalServicePurchasePricePerUnit());
        BigDecimal externalServicePurchasePriceAggregated = Streams.stream(allOthers).map(QuotationPosition::getExternalServicePurchasePriceAggregated).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add);
        position.setExternalServicePurchasePriceAggregated(externalServicePurchasePriceAggregated);
        position.setExternalServicePercentage(original.getExternalServicePercentage());
        position.setExternalServiceSellingPricePerUnit(original.getExternalServiceSellingPricePerUnit());
        BigDecimal externalServiceSellingPriceAggregated = Streams.stream(allOthers).map(QuotationPosition::getExternalServiceSellingPriceAggregated).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add);
        position.setExternalServiceSellingPriceAggregated(externalServiceSellingPriceAggregated);
        position.setPricePerUnit(original.getPricePerUnit());
        BigDecimal priceAggregated = Streams.stream(allOthers).map(QuotationPosition::getPriceAggregated).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add);
        position.setPriceAggregated(priceAggregated);
        position.setFlagFeePosition(original.getFlagFeePosition());
        position.setRemarks(original.getRemarks());
        position.setBidderComplement(original.getBidderComplement());
        position.setPositionNumberExternal(original.getPositionNumberExternal());
        return position;
    }
}

