/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.service.service.xls;

import de.qfm.erp.service.model.internal.message.Translatable;
import de.qfm.erp.service.model.internal.payroll.WagesExport;
import de.qfm.erp.service.model.internal.xlsx.CellStyles;
import de.qfm.erp.service.service.service.MessageService;
import de.qfm.erp.service.service.service.xls.AbstractXlsExportService;
import de.qfm.erp.service.service.service.xls.PayrollMonthSnapShotXlsExportService;
import java.math.BigDecimal;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nonnull;
import lombok.NonNull;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.xssf.streaming.SXSSFRow;
import org.apache.poi.xssf.streaming.SXSSFSheet;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class PayrollMonthSnapShotXlsExportService
extends AbstractXlsExportService {
    private static final Logger log = LogManager.getLogger(PayrollMonthSnapShotXlsExportService.class);
    private final MessageService messageService;

    @Autowired
    public PayrollMonthSnapShotXlsExportService(MessageService messageService) {
        this.messageService = messageService;
    }

    @Nonnull
    public SXSSFWorkbook detailXLS(@NonNull WagesExport wagesExport) {
        if (wagesExport == null) {
            throw new NullPointerException("wagesExport is marked non-null but is null");
        }
        SXSSFWorkbook workbook = new SXSSFWorkbook();
        workbook.setCompressTempFiles(true);
        SXSSFSheet sheet1 = workbook.createSheet("Lohntopf");
        sheet1.setRandomAccessWindowSize(100);
        SXSSFSheet sheet2 = workbook.createSheet("Lohn ausbezahlt");
        sheet2.setRandomAccessWindowSize(100);
        Font topHeaderFont = workbook.createFont();
        topHeaderFont.setBold(true);
        Font detailsFoont = workbook.createFont();
        detailsFoont.setBold(false);
        for (StageWagesColumn stageWagesColumn : StageWagesColumn.values()) {
            sheet1.setColumnWidth(stageWagesColumn.index, 3750);
        }
        for (StageWagesColumn stageWagesColumn : PaidWagesColumn.values()) {
            sheet2.setColumnWidth(stageWagesColumn.index, 3750);
        }
        CellStyle headerStyle = workbook.createCellStyle();
        headerStyle.setFont(topHeaderFont);
        CellStyle detailsStyle = workbook.createCellStyle();
        detailsStyle.setFont(detailsFoont);
        CellStyles cellStylesSheet1 = CellStyles.create((CellStyle)headerStyle, (CellStyle)detailsStyle, (CellStyle)CellStyles.decimal0CellStyle((SXSSFSheet)sheet1, (CellStyle)detailsStyle), (CellStyle)CellStyles.decimal2CellStyle((SXSSFSheet)sheet1, (CellStyle)detailsStyle), (CellStyle)CellStyles.formulaCellStyle((SXSSFSheet)sheet1, (CellStyle)detailsStyle));
        CellStyles cellStyles = CellStyles.create((CellStyle)headerStyle, (CellStyle)detailsStyle, (CellStyle)CellStyles.decimal0CellStyle((SXSSFSheet)sheet2, (CellStyle)detailsStyle), (CellStyle)CellStyles.decimal2CellStyle((SXSSFSheet)sheet2, (CellStyle)detailsStyle), (CellStyle)CellStyles.formulaCellStyle((SXSSFSheet)sheet2, (CellStyle)detailsStyle));
        AtomicInteger rowNumSheet1 = new AtomicInteger();
        Iterable stageWageItems = wagesExport.getStageWageItems();
        SXSSFRow detailsHeader = PayrollMonthSnapShotXlsExportService.newRow((SXSSFSheet)sheet1, (AtomicInteger)rowNumSheet1);
        for (StageWagesColumn stageWagesColumn : StageWagesColumn.values()) {
            PayrollMonthSnapShotXlsExportService.createText((CellStyle)headerStyle, (String)stageWagesColumn.name, (SXSSFRow)detailsHeader, (int)stageWagesColumn.index);
        }
        stageWageItems.forEach(stageWageItem -> {
            SXSSFRow detailRow = PayrollMonthSnapShotXlsExportService.newRow((SXSSFSheet)sheet1, (AtomicInteger)rowNumSheet1);
            block4: for (StageWagesColumn stageWagesColumn : StageWagesColumn.values()) {
                ColumnType columnType = stageWagesColumn.getColumnType();
                Object value = stageWagesColumn.getFn().apply(stageWageItem);
                Object valueToUse = value instanceof Translatable ? this.messageService.getDE((Translatable)value, new Object[0]) : value;
                switch (columnType.ordinal()) {
                    case 1: {
                        BigDecimal bdValue = valueToUse instanceof BigDecimal ? (BigDecimal)valueToUse : BigDecimal.ZERO;
                        PayrollMonthSnapShotXlsExportService.createNumber((CellStyles)cellStylesSheet1, (BigDecimal)bdValue, (SXSSFRow)detailRow, (int)stageWagesColumn.index);
                        continue block4;
                    }
                    case 0: 
                    case 2: {
                        String stringValue = valueToUse instanceof String ? (String)valueToUse : "";
                        PayrollMonthSnapShotXlsExportService.createText((CellStyle)detailsStyle, (String)stringValue, (SXSSFRow)detailRow, (int)stageWagesColumn.index);
                    }
                }
            }
        });
        AtomicInteger rowNumSheet2 = new AtomicInteger();
        Iterable paidWageItems = wagesExport.getPaidWageItems();
        SXSSFRow detailsHeader2 = PayrollMonthSnapShotXlsExportService.newRow((SXSSFSheet)sheet2, (AtomicInteger)rowNumSheet2);
        for (PaidWagesColumn paidWagesColumn : PaidWagesColumn.values()) {
            PayrollMonthSnapShotXlsExportService.createText((CellStyle)headerStyle, (String)paidWagesColumn.name, (SXSSFRow)detailsHeader2, (int)paidWagesColumn.index);
        }
        paidWageItems.forEach(paidWageItem -> {
            SXSSFRow detailRow = PayrollMonthSnapShotXlsExportService.newRow((SXSSFSheet)sheet2, (AtomicInteger)rowNumSheet2);
            block4: for (PaidWagesColumn paidWagesColumn : PaidWagesColumn.values()) {
                ColumnType columnType = paidWagesColumn.getColumnType();
                Object value = paidWagesColumn.getFn().apply(paidWageItem);
                Object valueToUse = value instanceof Translatable ? this.messageService.getDE((Translatable)value, new Object[0]) : value;
                switch (columnType.ordinal()) {
                    case 1: {
                        BigDecimal bdValue = valueToUse instanceof BigDecimal ? (BigDecimal)valueToUse : BigDecimal.ZERO;
                        PayrollMonthSnapShotXlsExportService.createNumber((CellStyles)cellStylesSheet2, (BigDecimal)bdValue, (SXSSFRow)detailRow, (int)paidWagesColumn.index);
                        continue block4;
                    }
                    case 0: 
                    case 2: {
                        String stringValue = valueToUse instanceof String ? (String)valueToUse : "";
                        PayrollMonthSnapShotXlsExportService.createText((CellStyle)detailsStyle, (String)stringValue, (SXSSFRow)detailRow, (int)paidWagesColumn.index);
                    }
                }
            }
        });
        sheet1.setDisplayGridlines(true);
        sheet2.setDisplayGridlines(true);
        return workbook;
    }
}

