/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.service.service.xls;

import com.google.common.collect.ImmutableList;
import de.leancoders.common.helper.DateTimeHelper;
import de.qfm.erp.service.helper.BigDecimalHelper;
import de.qfm.erp.service.model.internal.measurement.MeasurementXLSImportRow;
import de.qfm.erp.service.model.internal.measurement.MeasurementXlsExtractResult;
import de.qfm.erp.service.service.service.DateTimeHelperService;
import de.qfm.erp.service.service.service.xls.MeasurementBOQDefinition;
import de.qfm.erp.service.service.service.xls.MeasurementXlsImportService;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.Date;
import java.util.Optional;
import javax.annotation.Nonnull;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.DateUtil;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import org.apache.poi.ss.util.CellAddress;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.springframework.stereotype.Service;

@Service
public class MeasurementXlsImportService
implements MeasurementBOQDefinition {
    private static final Logger log = LogManager.getLogger(MeasurementXlsImportService.class);

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nonnull
    public Optional<MeasurementXlsExtractResult> handleMultiPart(byte[] buffer) {
        try (ByteArrayInputStream fis = new ByteArrayInputStream(buffer);){
            Workbook myWorkBook = WorkbookFactory.create((InputStream)fis);
            Sheet mySheet = myWorkBook.getSheet("Aufmass");
            String releaseOrder = this.textValue(mySheet, "C5").orElse("n/a");
            String constructionSite = this.textValue(mySheet, "C6").orElse("n/a");
            String quotationNumber = this.textValue(mySheet, "R6").orElse("n/a");
            Integer personalNumber = this.numericValue(mySheet, "R5").map(BigDecimal::intValue).orElse(null);
            LocalDate projectExecutionStart = this.dateValue(mySheet, "C10").orElse(DateTimeHelper.today());
            LocalDate projectExecutionEnd = this.dateValue(mySheet, "G10").orElse(DateTimeHelper.today());
            String globalRemarks = this.textValue(mySheet, "C13").orElse("n/a");
            int firstPositionIndex = -1;
            for (int i = 1; i < 600; ++i) {
                String scannerText = this.textValue(mySheet, String.format("A%s", i)).orElse("");
                if (!StringUtils.equalsIgnoreCase((CharSequence)scannerText, (CharSequence)"Position")) continue;
                firstPositionIndex = 1 + i;
                break;
            }
            int lastPositonIndex = -1;
            for (int i = Math.max(firstPositionIndex, 1); i < 600; ++i) {
                String scannerText = this.textValue(mySheet, String.format("A%s", i)).orElse("");
                if (!StringUtils.isNotBlank((CharSequence)scannerText)) continue;
                lastPositonIndex = i;
            }
            ImmutableList.Builder rowBuilder = ImmutableList.builder();
            if (lastPositonIndex <= -1) return Optional.empty();
            if (firstPositionIndex <= -1) return Optional.empty();
            for (int rowIndex = firstPositionIndex; rowIndex <= lastPositonIndex; ++rowIndex) {
                String position = this.textValue(mySheet, PositionColumn.POSITION_NUMBER.address(rowIndex)).orElse("");
                BigDecimal amount = this.numericValue(mySheet, PositionColumn.AMOUNT.address(rowIndex)).orElse(null);
                BigDecimal length = this.numericValue(mySheet, PositionColumn.LENGTH.address(rowIndex)).orElse(null);
                BigDecimal width = this.numericValue(mySheet, PositionColumn.WIDTH.address(rowIndex)).orElse(null);
                BigDecimal height = this.numericValue(mySheet, PositionColumn.DEPTH.address(rowIndex)).orElse(null);
                BigDecimal product = this.numericValue(mySheet, PositionColumn.PRODUCT.address(rowIndex)).orElse(BigDecimal.ZERO);
                String unit = this.textValue(mySheet, PositionColumn.UNIT.address(rowIndex)).orElse("");
                String shortText = this.textValue(mySheet, PositionColumn.SHORT_TEXT.address(rowIndex)).orElse("");
                String remarks = this.textValue(mySheet, PositionColumn.REMARKS.address(rowIndex)).orElse("");
                BigDecimal pricePerUnit = this.numericValue(mySheet, PositionColumn.PRICE_PER_UNIT.address(rowIndex)).orElse(BigDecimal.ZERO);
                BigDecimal priceAggregated = this.numericValue(mySheet, PositionColumn.PRICE_AGGREGATED.address(rowIndex)).orElse(BigDecimal.ZERO);
                rowBuilder.add((Object)MeasurementXLSImportRow.of((int)rowIndex, (String)position, (String)shortText, (BigDecimal)amount, (BigDecimal)length, (BigDecimal)width, (BigDecimal)height, (BigDecimal)product, (String)unit, (String)remarks, (BigDecimal)pricePerUnit, (BigDecimal)priceAggregated));
            }
            ImmutableList positions = rowBuilder.build();
            Optional<MeasurementXlsExtractResult> optional = Optional.of(MeasurementXlsExtractResult.of((String)quotationNumber, (Integer)personalNumber, (String)releaseOrder, (String)constructionSite, (LocalDate)projectExecutionStart, (LocalDate)projectExecutionEnd, (String)globalRemarks, (Iterable)positions, (Iterable)ImmutableList.of()));
            return optional;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return Optional.empty();
    }

    @Nonnull
    private Optional<BigDecimal> numericValue(@NonNull Sheet sheet, @NonNull String cellAddressString) {
        Cell cell;
        if (sheet == null) {
            throw new NullPointerException("sheet is marked non-null but is null");
        }
        if (cellAddressString == null) {
            throw new NullPointerException("cellAddressString is marked non-null but is null");
        }
        CellAddress cellAddress = new CellAddress(cellAddressString);
        Row row = sheet.getRow(cellAddress.getRow());
        if (null != row && null != (cell = row.getCell(cellAddress.getColumn()))) {
            if (cell.getCellType() == CellType.BLANK) {
                return Optional.empty();
            }
            switch (1.$SwitchMap$org$apache$poi$ss$usermodel$CellType[cell.getCellType().ordinal()]) {
                case 1: {
                    break;
                }
                case 2: {
                    return Optional.of(BigDecimal.valueOf(cell.getNumericCellValue()));
                }
                case 3: {
                    break;
                }
                case 4: {
                    CellType cachedFormulaResultType = cell.getCachedFormulaResultType();
                    if (cachedFormulaResultType == CellType.ERROR) {
                        byte by = cell.getErrorCellValue();
                        break;
                    }
                    if (cachedFormulaResultType == CellType.STRING) {
                        String stringCellValue = cell.getStringCellValue();
                        BigDecimal bigDecimal = BigDecimalHelper.parseGermanCurrency((String)stringCellValue);
                        return Optional.of(bigDecimal);
                    }
                    if (cachedFormulaResultType == CellType.NUMERIC) {
                        double numericCellValue = cell.getNumericCellValue();
                        BigDecimal value = BigDecimal.valueOf(numericCellValue);
                        return Optional.of(value);
                    }
                    log.warn("TODO: {}", (Object)cell.getCellType().name());
                    break;
                }
                case 5: {
                    log.warn("ERROR Cell: {}", (Object)cell.getErrorCellValue());
                    break;
                }
                default: {
                    String rawValue = ((XSSFCell)cell).getRawValue();
                    log.warn("TODO: {}", (Object)rawValue);
                }
            }
        }
        return Optional.empty();
    }

    @Nonnull
    private Optional<String> textValue(@NonNull Sheet sheet, @NonNull String cellAddressString) {
        Cell cell;
        if (sheet == null) {
            throw new NullPointerException("sheet is marked non-null but is null");
        }
        if (cellAddressString == null) {
            throw new NullPointerException("cellAddressString is marked non-null but is null");
        }
        CellAddress cellAddress = new CellAddress(cellAddressString);
        Row row = sheet.getRow(cellAddress.getRow());
        if (null != row && null != (cell = row.getCell(cellAddress.getColumn()))) {
            switch (1.$SwitchMap$org$apache$poi$ss$usermodel$CellType[cell.getCellType().ordinal()]) {
                case 1: {
                    return Optional.of(cell.getStringCellValue());
                }
                case 2: {
                    return Optional.of(((XSSFCell)cell).getRawValue());
                }
                case 3: {
                    break;
                }
                case 4: {
                    CellType cachedFormulaResultType = cell.getCachedFormulaResultType();
                    if (cachedFormulaResultType == CellType.ERROR) {
                        byte by = cell.getErrorCellValue();
                        break;
                    }
                    if (cachedFormulaResultType == CellType.STRING) {
                        return Optional.of(cell.getStringCellValue());
                    }
                    if (cachedFormulaResultType == CellType.NUMERIC) break;
                    log.warn("TODO: {}", (Object)cell.getCellType().name());
                    break;
                }
                case 5: {
                    log.warn("ERROR Cell: {}", (Object)cell.getErrorCellValue());
                    break;
                }
                default: {
                    return Optional.of(cell.getStringCellValue());
                }
            }
        }
        return Optional.empty();
    }

    @Nonnull
    private Optional<LocalDate> dateValue(@NonNull Sheet sheet, @NonNull String cellAddressString) {
        Cell cell;
        if (sheet == null) {
            throw new NullPointerException("sheet is marked non-null but is null");
        }
        if (cellAddressString == null) {
            throw new NullPointerException("cellAddressString is marked non-null but is null");
        }
        CellAddress cellAddress = new CellAddress(cellAddressString);
        Row row = sheet.getRow(cellAddress.getRow());
        if (null != row && null != (cell = row.getCell(cellAddress.getColumn()))) {
            switch (1.$SwitchMap$org$apache$poi$ss$usermodel$CellType[cell.getCellType().ordinal()]) {
                case 2: {
                    if (!DateUtil.isCellDateFormatted((Cell)cell)) break;
                    Date dateCellValue = cell.getDateCellValue();
                    return Optional.of(DateTimeHelper.toLocalDateTime((Date)dateCellValue).toLocalDate());
                }
                case 1: {
                    String stringCellValue = StringUtils.trimToEmpty((String)cell.getStringCellValue());
                    return DateTimeHelperService.parseGermanDate((String)stringCellValue);
                }
                case 5: {
                    log.warn("ERROR Cell: {}", (Object)cell.getErrorCellValue());
                    break;
                }
            }
        }
        return Optional.empty();
    }
}

