/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.service.service.xls;

import de.qfm.erp.service.model.internal.measurement.MeasurementExport;
import de.qfm.erp.service.model.internal.message.Translatable;
import de.qfm.erp.service.model.internal.xlsx.CellStyles;
import de.qfm.erp.service.service.service.MessageService;
import de.qfm.erp.service.service.service.xls.AbstractXlsExportService;
import de.qfm.erp.service.service.service.xls.MeasurementXlsExportService;
import java.math.BigDecimal;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import lombok.NonNull;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.xssf.streaming.SXSSFRow;
import org.apache.poi.xssf.streaming.SXSSFSheet;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class MeasurementXlsExportService
extends AbstractXlsExportService {
    private static final Logger log = LogManager.getLogger(MeasurementXlsExportService.class);
    private final MessageService messageService;

    @Autowired
    public MeasurementXlsExportService(MessageService messageService) {
        this.messageService = messageService;
    }

    @Nonnull
    public SXSSFWorkbook detailXLS(@NonNull Stream<MeasurementExport> exportMeasurements, @NonNull String sheetName) {
        if (exportMeasurements == null) {
            throw new NullPointerException("exportMeasurements is marked non-null but is null");
        }
        if (sheetName == null) {
            throw new NullPointerException("sheetName is marked non-null but is null");
        }
        SXSSFWorkbook workbook = new SXSSFWorkbook();
        workbook.setCompressTempFiles(true);
        SXSSFSheet sheet = workbook.createSheet(sheetName);
        sheet.setRandomAccessWindowSize(100);
        Font topHeaderFont = workbook.createFont();
        topHeaderFont.setBold(true);
        Font detailsFoont = workbook.createFont();
        detailsFoont.setBold(false);
        for (MeasurementColumn measurementColumn : MeasurementColumn.values()) {
            sheet.setColumnWidth(measurementColumn.index, 3750);
        }
        CellStyle headerStyle = workbook.createCellStyle();
        headerStyle.setFont(topHeaderFont);
        CellStyle detailsStyle = workbook.createCellStyle();
        detailsStyle.setFont(detailsFoont);
        CellStyles cellStyles = CellStyles.create((CellStyle)headerStyle, (CellStyle)detailsStyle, (CellStyle)CellStyles.decimal0CellStyle((SXSSFSheet)sheet, (CellStyle)detailsStyle), (CellStyle)CellStyles.decimal2CellStyle((SXSSFSheet)sheet, (CellStyle)detailsStyle), (CellStyle)CellStyles.formulaCellStyle((SXSSFSheet)sheet, (CellStyle)detailsStyle));
        AtomicInteger rowNum = new AtomicInteger();
        SXSSFRow detailsHeader = MeasurementXlsExportService.newRow((SXSSFSheet)sheet, (AtomicInteger)rowNum);
        for (MeasurementColumn measurementColumn : MeasurementColumn.values()) {
            MeasurementXlsExportService.createText((CellStyle)headerStyle, (String)measurementColumn.name, (SXSSFRow)detailsHeader, (int)measurementColumn.index);
        }
        exportMeasurements.forEach(measurementExport -> {
            SXSSFRow detailRow = MeasurementXlsExportService.newRow((SXSSFSheet)sheet, (AtomicInteger)rowNum);
            block4: for (MeasurementColumn measurementColumn : MeasurementColumn.values()) {
                MeasurementColType measurementColType = measurementColumn.getMeasurementColType();
                Object value = measurementColumn.getFn().apply(measurementExport);
                Object valueToUse = value instanceof Translatable ? this.messageService.getDE((Translatable)value, new Object[0]) : value;
                switch (measurementColType.ordinal()) {
                    case 1: {
                        BigDecimal bdValue = valueToUse instanceof BigDecimal ? (BigDecimal)valueToUse : BigDecimal.ZERO;
                        MeasurementXlsExportService.createNumber((CellStyles)cellStyles, (BigDecimal)bdValue, (SXSSFRow)detailRow, (int)measurementColumn.index);
                        continue block4;
                    }
                    case 0: 
                    case 2: {
                        String stringValue = valueToUse instanceof String ? (String)valueToUse : "";
                        MeasurementXlsExportService.createText((CellStyle)detailsStyle, (String)stringValue, (SXSSFRow)detailRow, (int)measurementColumn.index);
                    }
                }
            }
        });
        sheet.setDisplayGridlines(true);
        return workbook;
    }
}

