/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.service.service.xls;

import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import com.google.common.collect.Streams;
import de.qfm.erp.service.helper.MeasurementHelper;
import de.qfm.erp.service.model.jpa.customer.ContactPerson;
import de.qfm.erp.service.model.jpa.measurement.Measurement;
import de.qfm.erp.service.model.jpa.measurement.MeasurementPosition;
import de.qfm.erp.service.model.jpa.quotation.Quotation;
import de.qfm.erp.service.service.service.xls.CustomerTemplateExportService;
import de.qfm.erp.service.service.service.xls.CustomerTemplateGeneralExportService;
import de.qfm.erp.service.service.service.xls.ECustomerTemplateAlgorithm;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.util.CellAddress;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.springframework.stereotype.Service;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class CustomerTemplateGeneralExportService
extends CustomerTemplateExportService {
    private static final Logger log = LogManager.getLogger(CustomerTemplateGeneralExportService.class);
    public static final int POSITIONS_HEADER = 9;
    @Nonnull
    private static final Map<String, Field> FIELD_MAPPING = ImmutableMap.of((Object)"PosNr", (Object)Field.SURROGATE_POSITION_NUMBER, (Object)"Externe PosNr", (Object)Field.EXTERNAL_POSITION_NUMBER, (Object)"Menge in Aufmassen", (Object)Field.AMOUNT_IN_MEASUREMENTS, (Object)"Aufmasse", (Object)Field.REMARKS_MEASUREMENT_NUMBERS);

    @Nonnull
    public ECustomerTemplateAlgorithm algorithm() {
        return ECustomerTemplateAlgorithm.GENERAL;
    }

    @Nonnull
    public String mediaType() {
        return "application/octet-stream";
    }

    public boolean detailXLS(@NonNull InputStream bis, @NonNull OutputStream bos, @NonNull Quotation stage, @NonNull String projectNumber, @NonNull String orderNumber, @NonNull String orderText, @NonNull Iterable<MeasurementPosition> measurementPositions) throws IOException {
        if (bis == null) {
            throw new NullPointerException("bis is marked non-null but is null");
        }
        if (bos == null) {
            throw new NullPointerException("bos is marked non-null but is null");
        }
        if (stage == null) {
            throw new NullPointerException("stage is marked non-null but is null");
        }
        if (projectNumber == null) {
            throw new NullPointerException("projectNumber is marked non-null but is null");
        }
        if (orderNumber == null) {
            throw new NullPointerException("orderNumber is marked non-null but is null");
        }
        if (orderText == null) {
            throw new NullPointerException("orderText is marked non-null but is null");
        }
        if (measurementPositions == null) {
            throw new NullPointerException("measurementPositions is marked non-null but is null");
        }
        XSSFWorkbook workbook = new XSSFWorkbook(bis);
        XSSFSheet sheetToPopulate = workbook.getSheet("Vertrag");
        String stageNumber = stage.getQNumber();
        ContactPerson contactPerson = stage.getContactPerson();
        String contactPersonName = null != contactPerson ? StringUtils.trimToEmpty((String)contactPerson.getFirstName()) + " " + StringUtils.trimToEmpty((String)contactPerson.getLastName()) : "";
        String measurementNumbers = Streams.stream(measurementPositions).map(MeasurementPosition::getMeasurement).filter(Objects::nonNull).map(Measurement::getMeasurementNumber).filter(Objects::nonNull).sorted().distinct().collect(Collectors.joining(","));
        CustomerTemplateGeneralExportService.updateText((String)stageNumber, (XSSFSheet)sheetToPopulate, (CellAddress)new CellAddress("B2"));
        CustomerTemplateGeneralExportService.updateText((String)orderText, (XSSFSheet)sheetToPopulate, (CellAddress)new CellAddress("B3"));
        CustomerTemplateGeneralExportService.updateText((String)measurementNumbers, (XSSFSheet)sheetToPopulate, (CellAddress)new CellAddress("B4"));
        CustomerTemplateGeneralExportService.updateText((String)projectNumber, (XSSFSheet)sheetToPopulate, (CellAddress)new CellAddress("B5"));
        CustomerTemplateGeneralExportService.updateText((String)contactPersonName, (XSSFSheet)sheetToPopulate, (CellAddress)new CellAddress("B6"));
        CustomerTemplateGeneralExportService.updateText((String)orderNumber, (XSSFSheet)sheetToPopulate, (CellAddress)new CellAddress("B7"));
        Map fieldColumns = this.fieldColumns(sheetToPopulate);
        Pair populateResult = this.populate(sheetToPopulate, fieldColumns, measurementPositions);
        workbook.setForceFormulaRecalculation(true);
        workbook.write(bos);
        return true;
    }

    @Nonnull
    private Pair<Integer, Integer> populate(@NonNull XSSFSheet sheetToPopulate, @NonNull Map<Field, Integer> fieldColumns, @NonNull Iterable<MeasurementPosition> measurementPositions) {
        if (sheetToPopulate == null) {
            throw new NullPointerException("sheetToPopulate is marked non-null but is null");
        }
        if (fieldColumns == null) {
            throw new NullPointerException("fieldColumns is marked non-null but is null");
        }
        if (measurementPositions == null) {
            throw new NullPointerException("measurementPositions is marked non-null but is null");
        }
        ImmutableListMultimap measurementPositionsBySPN = Multimaps.index(measurementPositions, MeasurementPosition::getSurrogatePositionNumber);
        Set surrogatePositionNumbers = measurementPositionsBySPN.keySet();
        Map rowPositionsExternalPosNr = this.rowPositions(sheetToPopulate, fieldColumns.get(Field.EXTERNAL_POSITION_NUMBER).intValue());
        Map rowPositionsSurrogatePosNr = this.rowPositions(sheetToPopulate, fieldColumns.get(Field.SURROGATE_POSITION_NUMBER).intValue());
        AtomicInteger successCounter = new AtomicInteger();
        surrogatePositionNumbers.forEach(arg_0 -> CustomerTemplateGeneralExportService.lambda$populate$1((Multimap)measurementPositionsBySPN, rowPositionsSurrogatePosNr, rowPositionsExternalPosNr, fieldColumns, sheetToPopulate, successCounter, arg_0));
        int expected = surrogatePositionNumbers.size();
        int success = successCounter.get();
        int error = expected - success;
        return Pair.of((Object)success, (Object)error);
    }

    @Nonnull
    private Map<Field, Integer> fieldColumns(@NonNull XSSFSheet sheet) {
        if (sheet == null) {
            throw new NullPointerException("sheet is marked non-null but is null");
        }
        XSSFRow row = sheet.getRow(9);
        HashMap cellContent = Maps.newHashMap();
        row.cellIterator().forEachRemaining(cell -> cellContent.put(CustomerTemplateGeneralExportService.textValue((Cell)cell).orElse(""), cell.getColumnIndex()));
        HashMap fieldPositions = Maps.newHashMap();
        FIELD_MAPPING.forEach((key, value) -> fieldPositions.put(value, cellContent.getOrDefault(key, -1)));
        return ImmutableMap.copyOf((Map)fieldPositions);
    }

    @Nonnull
    private Map<String, Integer> rowPositions(@NonNull XSSFSheet sheet, int column) {
        if (sheet == null) {
            throw new NullPointerException("sheet is marked non-null but is null");
        }
        HashMap cellContent = Maps.newHashMap();
        sheet.forEach(row -> {
            Cell cell;
            if (row.getRowNum() >= 9 && null != (cell = row.getCell(column))) {
                cellContent.put(CustomerTemplateGeneralExportService.textValue((Cell)cell).orElse(""), row.getRowNum());
            }
        });
        return ImmutableMap.copyOf((Map)cellContent);
    }

    private static void apply(XSSFSheet sheet, Multimap<String, MeasurementPosition> byExternalPosNr, Multimap<String, MeasurementPosition> byCleanedSPN, String extPosCol, String shortTextCol, String amountCol) {
        for (int i = 2; i < 100; ++i) {
            boolean containsExternalPosNr;
            CellAddress cellAddressExternalPosNR = new CellAddress(extPosCol + i);
            CellAddress cellAddressShortText = new CellAddress(shortTextCol + i);
            CellAddress cellAddressAmount = new CellAddress(amountCol + i);
            if (null == sheet.getRow(i)) break;
            String supposedExternalPosNr = CustomerTemplateGeneralExportService.textValue((Sheet)sheet, (CellAddress)cellAddressExternalPosNR).orElse("");
            boolean bl = containsExternalPosNr = StringUtils.isNotBlank((CharSequence)supposedExternalPosNr) && byExternalPosNr.containsKey((Object)supposedExternalPosNr);
            if (containsExternalPosNr) {
                Collection measurementPositionsByExtPosNr = byExternalPosNr.get((Object)supposedExternalPosNr);
                BigDecimal productByPosNr = measurementPositionsByExtPosNr.stream().map(MeasurementHelper.FN_JUMBO_PROD).reduce(BigDecimal.ZERO, BigDecimal::add);
                CustomerTemplateGeneralExportService.updateNumber((BigDecimal)productByPosNr, (XSSFSheet)sheet, (CellAddress)cellAddressAmount);
                continue;
            }
            String supposedShortText = CustomerTemplateGeneralExportService.textValue((Sheet)sheet, (CellAddress)cellAddressShortText).orElse("");
            String supposedCleanedSPN = StringUtils.remove((String)StringUtils.removeStart((String)StringUtils.substringBefore((String)supposedShortText, (String)" "), (String)"0"), (String)".");
            if (!byCleanedSPN.containsKey((Object)supposedCleanedSPN)) continue;
            Collection measurementPositionsByPosNr = byCleanedSPN.get((Object)supposedCleanedSPN);
            BigDecimal productByPosNr = measurementPositionsByPosNr.stream().map(MeasurementHelper.FN_JUMBO_PROD).reduce(BigDecimal.ZERO, BigDecimal::add);
            CustomerTemplateGeneralExportService.updateNumber((BigDecimal)productByPosNr, (XSSFSheet)sheet, (CellAddress)cellAddressAmount);
        }
    }

    @Nonnull
    protected static Optional<String> textValue(@NonNull Sheet sheet, @NonNull CellAddress cellAddress) {
        Cell cell;
        if (sheet == null) {
            throw new NullPointerException("sheet is marked non-null but is null");
        }
        if (cellAddress == null) {
            throw new NullPointerException("cellAddress is marked non-null but is null");
        }
        Row row = sheet.getRow(cellAddress.getRow());
        if (null != row && null != (cell = row.getCell(cellAddress.getColumn()))) {
            return CustomerTemplateGeneralExportService.textValue((Cell)cell);
        }
        return Optional.empty();
    }

    @Nonnull
    protected static Optional<String> textValue(@NonNull Cell cell) {
        if (cell == null) {
            throw new NullPointerException("cell is marked non-null but is null");
        }
        switch (1.$SwitchMap$org$apache$poi$ss$usermodel$CellType[cell.getCellType().ordinal()]) {
            case 1: {
                return Optional.of(cell.getStringCellValue());
            }
            case 2: {
                return Optional.of(((XSSFCell)cell).getRawValue());
            }
            case 3: {
                break;
            }
            case 4: {
                CellType cachedFormulaResultType = cell.getCachedFormulaResultType();
                if (cachedFormulaResultType == CellType.ERROR) {
                    byte by = cell.getErrorCellValue();
                    break;
                }
                if (cachedFormulaResultType == CellType.STRING) {
                    return Optional.of(cell.getStringCellValue());
                }
                if (cachedFormulaResultType == CellType.NUMERIC) break;
                log.warn("TODO: {}", (Object)cell.getCellType().name());
                break;
            }
            case 5: {
                log.warn("ERROR Cell: {}", (Object)cell.getErrorCellValue());
                break;
            }
            default: {
                return Optional.of(cell.getStringCellValue());
            }
        }
        return Optional.empty();
    }

    private static /* synthetic */ void lambda$populate$1(Multimap measurementPositionsBySPN, Map rowPositionsSurrogatePosNr, Map rowPositionsExternalPosNr, Map fieldColumns, XSSFSheet sheetToPopulate, AtomicInteger successCounter, String surrogatePositionNumber) {
        Collection measurementPositionsForSPN = measurementPositionsBySPN.get((Object)surrogatePositionNumber);
        if (!Iterables.isEmpty((Iterable)measurementPositionsForSPN)) {
            MeasurementPosition firstMeasurementPosition = (MeasurementPosition)measurementPositionsForSPN.iterator().next();
            String positionNumberExternal = firstMeasurementPosition.getPositionNumberExternal();
            Integer rowNumber = rowPositionsSurrogatePosNr.containsKey(surrogatePositionNumber) ? (Integer)rowPositionsSurrogatePosNr.get(surrogatePositionNumber) : (rowPositionsExternalPosNr.containsKey(positionNumberExternal) ? (Integer)rowPositionsExternalPosNr.get(positionNumberExternal) : null);
            if (null != rowNumber) {
                Integer cellNumberMeasurementNumbers;
                Integer cellNumberAmount = (Integer)fieldColumns.get(Field.AMOUNT_IN_MEASUREMENTS);
                if (null != cellNumberAmount) {
                    BigDecimal sum = measurementPositionsBySPN.get((Object)surrogatePositionNumber).stream().map(MeasurementPosition::getProduct).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add);
                    XSSFRow row = sheetToPopulate.getRow(rowNumber.intValue());
                    CustomerTemplateGeneralExportService.updateNumber((BigDecimal)sum, (XSSFRow)row, (int)cellNumberAmount);
                    successCounter.incrementAndGet();
                }
                if (null != (cellNumberMeasurementNumbers = (Integer)fieldColumns.get(Field.REMARKS_MEASUREMENT_NUMBERS))) {
                    String measurementNumbers = measurementPositionsBySPN.get((Object)surrogatePositionNumber).stream().map(MeasurementPosition::getMeasurement).map(Measurement::getMeasurementNumber).sorted(StringUtils::compare).filter(Objects::nonNull).reduce((l, r) -> l + ", " + r).orElse("");
                    XSSFRow row = sheetToPopulate.getRow(rowNumber.intValue());
                    CustomerTemplateGeneralExportService.updateText((String)measurementNumbers, (XSSFRow)row, (int)cellNumberMeasurementNumbers);
                    successCounter.incrementAndGet();
                }
            }
        }
    }
}

