/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.service.service.search;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Streams;
import de.qfm.erp.service.model.search.EStageIndexField;
import de.qfm.erp.service.model.search.IndexDocument;
import de.qfm.erp.service.model.search.IndexField;
import de.qfm.erp.service.model.search.IndexResult;
import de.qfm.erp.service.model.search.InternalSearchRequest;
import de.qfm.erp.service.model.search.PreparedQuery;
import de.qfm.erp.service.model.search.UserIndexEntry;
import de.qfm.erp.service.model.search.UserIndexSearchResult;
import de.qfm.erp.service.service.mapper.UserSearchMapper;
import de.qfm.erp.service.service.mapper.search.DomainQueryHelper;
import de.qfm.erp.service.service.mapper.search.InternalQueryHelper;
import de.qfm.erp.service.service.service.search.IndexService;
import de.qfm.erp.service.service.service.search.UserIndexSearchService;
import java.io.IOException;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nonnull;
import lombok.NonNull;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.document.Document;
import org.apache.lucene.search.Query;
import org.springframework.stereotype.Service;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class UserIndexSearchService {
    private static final Logger log = LogManager.getLogger(UserIndexSearchService.class);
    private final DomainQueryHelper domainQueryHelper;
    private final IndexService indexService;
    private final UserSearchMapper mapper;

    @Nonnull
    public UserIndexSearchResult search(@Nonnull String query, int page, int size) throws IOException {
        PreparedQuery preparedQuery = this.domainQueryHelper.users(query, (Iterable)ImmutableList.of());
        String queryString = InternalQueryHelper.prettyPrint((Query)preparedQuery.getQuery());
        log.info("Executing Query: {}", (Object)queryString);
        return this.indexService.users(InternalSearchRequest.of((PreparedQuery)preparedQuery, (int)page, (int)size));
    }

    public long remove(@NonNull String documentId) throws IOException {
        if (documentId == null) {
            throw new NullPointerException("documentId is marked non-null but is null");
        }
        return this.indexService.deleteFromIndex((Query)InternalQueryHelper.termQuery((IndexField)EStageIndexField._ID, (String)documentId));
    }

    @Nonnull
    public IndexResult index(@NonNull UserIndexEntry userIndexEntry) throws IOException {
        if (userIndexEntry == null) {
            throw new NullPointerException("userIndexEntry is marked non-null but is null");
        }
        IndexDocument indexDocument = this.mapper.mapToDocument(userIndexEntry);
        return this.indexService.updateIndex(indexDocument);
    }

    @Nonnull
    public Iterable<IndexResult> index(@NonNull Iterable<UserIndexEntry> userIndexEntries) throws IOException {
        if (userIndexEntries == null) {
            throw new NullPointerException("userIndexEntries is marked non-null but is null");
        }
        return (Iterable)Streams.stream(userIndexEntries).map(UserIndexSearchService.wrap(arg_0 -> ((UserSearchMapper)this.mapper).mapToDocument(arg_0))).map(UserIndexSearchService.wrap(arg_0 -> ((IndexService)this.indexService).updateIndex(arg_0))).collect(ImmutableList.toImmutableList());
    }

    public static <T, R> Function<T, R> wrap(@NonNull CheckedFunction<T, R> checkedFunction) {
        if (checkedFunction == null) {
            throw new NullPointerException("checkedFunction is marked non-null but is null");
        }
        return t -> {
            try {
                return checkedFunction.apply(t);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        };
    }

    @Nonnull
    private List<Pair<Document, Float>> document(@NonNull String documentId) throws IOException {
        if (documentId == null) {
            throw new NullPointerException("documentId is marked non-null but is null");
        }
        return this.indexService.document(documentId);
    }

    public UserIndexSearchService(DomainQueryHelper domainQueryHelper, IndexService indexService, UserSearchMapper mapper) {
        this.domainQueryHelper = domainQueryHelper;
        this.indexService = indexService;
        this.mapper = mapper;
    }
}

