/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.service.service.search;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Streams;
import de.qfm.erp.service.model.jpa.quotation.EQStageState;
import de.qfm.erp.service.model.jpa.quotation.EQStageType;
import de.qfm.erp.service.model.search.EStageIndexField;
import de.qfm.erp.service.model.search.IndexDocument;
import de.qfm.erp.service.model.search.IndexField;
import de.qfm.erp.service.model.search.IndexResult;
import de.qfm.erp.service.model.search.InternalSearchRequest;
import de.qfm.erp.service.model.search.PreparedQuery;
import de.qfm.erp.service.model.search.StageIndexEntry;
import de.qfm.erp.service.model.search.StageIndexSearchResult;
import de.qfm.erp.service.service.mapper.StageSearchMapper;
import de.qfm.erp.service.service.mapper.search.DomainQueryHelper;
import de.qfm.erp.service.service.mapper.search.InternalQueryHelper;
import de.qfm.erp.service.service.service.search.IndexService;
import de.qfm.erp.service.service.service.search.StageIndexSearchService;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nonnull;
import lombok.NonNull;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.document.Document;
import org.apache.lucene.search.Query;
import org.springframework.stereotype.Service;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class StageIndexSearchService {
    private static final Logger log = LogManager.getLogger(StageIndexSearchService.class);
    private final DomainQueryHelper domainQueryHelper;
    private final IndexService indexService;
    private final StageSearchMapper mapper;

    @Nonnull
    public StageIndexSearchResult search(@Nonnull String query, int page, int size, boolean includeArchived) throws IOException {
        Collection allStatesWithoutArchived = includeArchived ? EQStageState.ALL_VALID : EQStageState.ALL_STATES_WITHOUT_ARCHIVED;
        PreparedQuery preparedQuery = this.domainQueryHelper.stages(query, EQStageType.SEARCH_TYPES, (Iterable)allStatesWithoutArchived);
        String queryString = InternalQueryHelper.prettyPrint((Query)preparedQuery.getQuery());
        log.info("Executing Query: {}", (Object)queryString);
        return this.indexService.stages(InternalSearchRequest.of((PreparedQuery)preparedQuery, (int)page, (int)size));
    }

    public long remove(@NonNull String documentId) throws IOException {
        if (documentId == null) {
            throw new NullPointerException("documentId is marked non-null but is null");
        }
        return this.indexService.deleteFromIndex((Query)InternalQueryHelper.termQuery((IndexField)EStageIndexField._ID, (String)documentId));
    }

    @Nonnull
    public IndexResult index(@NonNull StageIndexEntry stageIndexEntry) throws IOException {
        if (stageIndexEntry == null) {
            throw new NullPointerException("stageIndexEntry is marked non-null but is null");
        }
        IndexDocument indexDocument = this.mapper.mapToDocument(stageIndexEntry);
        return this.indexService.updateIndex(indexDocument);
    }

    @Nonnull
    public Iterable<IndexResult> index(@NonNull Iterable<StageIndexEntry> stageIndexEntries) throws IOException {
        if (stageIndexEntries == null) {
            throw new NullPointerException("stageIndexEntries is marked non-null but is null");
        }
        return (Iterable)Streams.stream(stageIndexEntries).map(StageIndexSearchService.wrap(arg_0 -> ((StageSearchMapper)this.mapper).mapToDocument(arg_0))).map(StageIndexSearchService.wrap(arg_0 -> ((IndexService)this.indexService).updateIndex(arg_0))).collect(ImmutableList.toImmutableList());
    }

    public static <T, R> Function<T, R> wrap(@NonNull CheckedFunction<T, R> checkedFunction) {
        if (checkedFunction == null) {
            throw new NullPointerException("checkedFunction is marked non-null but is null");
        }
        return t -> {
            try {
                return checkedFunction.apply(t);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        };
    }

    @Nonnull
    private List<Pair<Document, Float>> document(@NonNull String documentId) throws IOException {
        if (documentId == null) {
            throw new NullPointerException("documentId is marked non-null but is null");
        }
        return this.indexService.document(documentId);
    }

    public StageIndexSearchService(DomainQueryHelper domainQueryHelper, IndexService indexService, StageSearchMapper mapper) {
        this.domainQueryHelper = domainQueryHelper;
        this.indexService = indexService;
        this.mapper = mapper;
    }
}

