/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.service.service.search;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Streams;
import de.qfm.erp.service.model.jpa.quotation.EQEntityState;
import de.qfm.erp.service.model.search.ECustomerIndexField;
import de.qfm.erp.service.model.search.EntityIndexEntry;
import de.qfm.erp.service.model.search.EntityIndexSearchResult;
import de.qfm.erp.service.model.search.IndexDocument;
import de.qfm.erp.service.model.search.IndexField;
import de.qfm.erp.service.model.search.IndexResult;
import de.qfm.erp.service.model.search.InternalSearchRequest;
import de.qfm.erp.service.model.search.PreparedQuery;
import de.qfm.erp.service.service.mapper.EntitySearchMapper;
import de.qfm.erp.service.service.mapper.search.DomainQueryHelper;
import de.qfm.erp.service.service.mapper.search.InternalQueryHelper;
import de.qfm.erp.service.service.service.search.EntityIndexSearchService;
import de.qfm.erp.service.service.service.search.IndexService;
import java.io.IOException;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nonnull;
import lombok.NonNull;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.document.Document;
import org.apache.lucene.search.Query;
import org.springframework.stereotype.Service;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class EntityIndexSearchService {
    private static final Logger log = LogManager.getLogger(EntityIndexSearchService.class);
    private final DomainQueryHelper domainQueryHelper;
    private final IndexService indexService;
    private final EntitySearchMapper mapper;

    @Nonnull
    public EntityIndexSearchResult search(@Nonnull String query, int page, int size, boolean includeArchived) throws IOException {
        Iterable states = includeArchived ? EQEntityState.ALL_VALID : EQEntityState.ALL_NON_ARCHIVED;
        PreparedQuery preparedQuery = this.domainQueryHelper.entities(query, states);
        String queryString = InternalQueryHelper.prettyPrint((Query)preparedQuery.getQuery());
        log.info("Executing Query: {}", (Object)queryString);
        return this.indexService.entities(InternalSearchRequest.of((PreparedQuery)preparedQuery, (int)page, (int)size));
    }

    public long remove(@NonNull String documentId) throws IOException {
        if (documentId == null) {
            throw new NullPointerException("documentId is marked non-null but is null");
        }
        return this.indexService.deleteFromIndex((Query)InternalQueryHelper.termQuery((IndexField)ECustomerIndexField._ID, (String)documentId));
    }

    @Nonnull
    public IndexResult index(@NonNull EntityIndexEntry indexEntry) throws IOException {
        if (indexEntry == null) {
            throw new NullPointerException("indexEntry is marked non-null but is null");
        }
        IndexDocument indexDocument = this.mapper.mapToDocument(indexEntry);
        return this.indexService.updateIndex(indexDocument);
    }

    @Nonnull
    public Iterable<IndexResult> index(@NonNull Iterable<EntityIndexEntry> indexEntries) throws IOException {
        if (indexEntries == null) {
            throw new NullPointerException("indexEntries is marked non-null but is null");
        }
        return (Iterable)Streams.stream(indexEntries).map(EntityIndexSearchService.wrap(arg_0 -> ((EntitySearchMapper)this.mapper).mapToDocument(arg_0))).map(EntityIndexSearchService.wrap(arg_0 -> ((IndexService)this.indexService).updateIndex(arg_0))).collect(ImmutableList.toImmutableList());
    }

    public static <T, R> Function<T, R> wrap(@NonNull CheckedFunction<T, R> checkedFunction) {
        if (checkedFunction == null) {
            throw new NullPointerException("checkedFunction is marked non-null but is null");
        }
        return t -> {
            try {
                return checkedFunction.apply(t);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        };
    }

    @Nonnull
    private List<Pair<Document, Float>> document(@NonNull String documentId) throws IOException {
        if (documentId == null) {
            throw new NullPointerException("documentId is marked non-null but is null");
        }
        return this.indexService.document(documentId);
    }

    public EntityIndexSearchService(DomainQueryHelper domainQueryHelper, IndexService indexService, EntitySearchMapper mapper) {
        this.domainQueryHelper = domainQueryHelper;
        this.indexService = indexService;
        this.mapper = mapper;
    }
}

