/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.service.service.print;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Multimap;
import de.leancoders.common.helper.IterableHelper;
import de.qfm.erp.service.configuration.PrintLayoutConfig;
import de.qfm.erp.service.helper.BigDecimalHelper;
import de.qfm.erp.service.model.internal.pdfbox.EBooleanPrintOption;
import de.qfm.erp.service.model.internal.pdfbox.ECellPrintOption;
import de.qfm.erp.service.model.internal.pdfbox.EValueSource;
import de.qfm.erp.service.model.internal.print.EPrintFontSize;
import de.qfm.erp.service.model.internal.print.PrintConfiguration;
import de.qfm.erp.service.model.internal.print.PrintFonts;
import de.qfm.erp.service.model.internal.print.PrintInfo;
import de.qfm.erp.service.model.internal.print.PrintSetup;
import de.qfm.erp.service.model.internal.print.measurement.MeasurementPrintConfiguration;
import de.qfm.erp.service.model.internal.print.measurement.MeasurementPrintInfo;
import de.qfm.erp.service.model.internal.print.measurement.MeasurementPrintTransposed;
import de.qfm.erp.service.model.internal.print.measurement.MeasurementTransposedPrintConfiguration;
import de.qfm.erp.service.model.internal.print.measurement.TransposedItem;
import de.qfm.erp.service.model.jpa.configuration.ConfigurationCompany;
import de.qfm.erp.service.service.route.impl.PrintHelper;
import de.qfm.erp.service.service.security.UserService;
import de.qfm.erp.service.service.service.DateTimeHelperService;
import de.qfm.erp.service.service.service.print.MeasurementPrintService;
import java.awt.Color;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import java.util.stream.IntStream;
import javax.annotation.Nonnull;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.PDPageContentStream;
import org.apache.pdfbox.pdmodel.common.PDRectangle;
import org.apache.pdfbox.pdmodel.font.PDFont;
import org.springframework.stereotype.Service;
import org.vandeseer.easytable.TableDrawer;
import org.vandeseer.easytable.settings.HorizontalAlignment;
import org.vandeseer.easytable.structure.Row;
import org.vandeseer.easytable.structure.Table;
import org.vandeseer.easytable.structure.cell.AbstractCell;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class MeasurementTransposedPrintService
extends MeasurementPrintService<MeasurementPrintTransposed, MeasurementTransposedPrintConfiguration> {
    private final PrintLayoutConfig printLayoutConfig;

    protected MeasurementTransposedPrintService(@NonNull UserService userService, @NonNull DateTimeHelperService dateTimeHelperService, @NonNull PrintHelper printHelper, PrintLayoutConfig printLayoutConfig) {
        super(userService, dateTimeHelperService, printHelper);
        if (userService == null) {
            throw new NullPointerException("userService is marked non-null but is null");
        }
        if (dateTimeHelperService == null) {
            throw new NullPointerException("dateTimeHelperService is marked non-null but is null");
        }
        if (printHelper == null) {
            throw new NullPointerException("printHelper is marked non-null but is null");
        }
        this.printLayoutConfig = printLayoutConfig;
    }

    @Nonnull
    public byte[] generatePDF(@NonNull MeasurementPrintTransposed measurementPrintTransposed, @NonNull MeasurementTransposedPrintConfiguration printConfiguration, @NonNull EPrintFontSize printFontSize, @NonNull ConfigurationCompany configurationCompany) {
        byte[] byArray;
        block24: {
            if (measurementPrintTransposed == null) {
                throw new NullPointerException("measurementPrintTransposed is marked non-null but is null");
            }
            if (printConfiguration == null) {
                throw new NullPointerException("printConfiguration is marked non-null but is null");
            }
            if (printFontSize == null) {
                throw new NullPointerException("printFontSize is marked non-null but is null");
            }
            if (configurationCompany == null) {
                throw new NullPointerException("configurationCompany is marked non-null but is null");
            }
            Preconditions.checkArgument((printConfiguration.getMaxColsPerPage() > 0 ? 1 : 0) != 0, (Object)"printConfiguration.maxColsPerPage() must be > 0");
            Preconditions.checkArgument((printConfiguration.getMaxRowsPerPage() > 0 ? 1 : 0) != 0, (Object)"printConfiguration.maxRowsPerPage() must be > 0");
            Preconditions.checkArgument((printConfiguration.getMaxHeaderTextLength() > 0 ? 1 : 0) != 0, (Object)"printConfiguration.maxHeaderTextLength() must be > 0");
            boolean printWages = Iterables.contains((Iterable)printConfiguration.getBooleanPrintOptions(), (Object)EBooleanPrintOption.PRINT_INTERNAL_WAGE_ENABLED);
            PDRectangle mediaBox = new PDRectangle(PDRectangle.A4.getHeight(), PDRectangle.A4.getWidth());
            PDDocument document = this.document((PrintInfo)measurementPrintTransposed, (PrintConfiguration)printConfiguration);
            try {
                PrintSetup printSetup = PrintHelper.printSetup((PrintLayoutConfig)this.printLayoutConfig, (ConfigurationCompany)configurationCompany, (EPrintFontSize)printFontSize, (PDDocument)document, PrintLayoutConfig::getMeasurementLogoPadding, PrintLayoutConfig::getMeasurementLogoHeight, PrintLayoutConfig::getMeasurementLogoBuffer);
                PrintFonts printFonts = printSetup.getPrintFonts();
                Table footer = MeasurementTransposedPrintService.footer((MeasurementPrintConfiguration)printConfiguration, (PrintSetup)printSetup, (PDRectangle)mediaBox);
                List headers = this.header((MeasurementPrintInfo)measurementPrintTransposed, (PrintConfiguration)printConfiguration, document, mediaBox, printSetup);
                ImmutableMultimap.Builder posProductsPerSPNBuilder = ImmutableMultimap.builder();
                measurementPrintTransposed.getTransposedItemsByRemark().forEach((remark, values) -> values.forEach((spn, ti) -> {
                    BigDecimal value = (BigDecimal)MoreObjects.firstNonNull((Object)ti.getProduct(), (Object)BigDecimal.ZERO);
                    posProductsPerSPNBuilder.put(spn, (Object)value);
                }));
                ImmutableMultimap posProductPerSPN = posProductsPerSPNBuilder.build();
                float headerHeight = MeasurementTransposedPrintService.height((Iterable)headers);
                float footerHeight = footer.getHeight();
                float maxDetailsWidth = MeasurementTransposedPrintService.maxDetailsWidth((PDRectangle)mediaBox);
                float maxDetailsHeight = MeasurementTransposedPrintService.maxDetailsHeight((PDRectangle)mediaBox, (float)headerHeight, (float)footerHeight, (float)0.0f);
                List details = this.rotatedDetails(measurementPrintTransposed, printConfiguration, printSetup, mediaBox);
                Iterable splittedDetails = MeasurementTransposedPrintService.splitVertically((Iterable)details, (int)3, (float)maxDetailsHeight, (float)10.0f, (boolean)true);
                if (details.isEmpty()) {
                    MeasurementTransposedPrintService.printEmptyPage((PDDocument)document, (PDRectangle)mediaBox, (List)headers);
                } else {
                    for (Iterable splittedDetail : splittedDetails) {
                        for (Table detailsTable : splittedDetail) {
                            PDPage page = MeasurementTransposedPrintService.page((PDDocument)document, (PDRectangle)mediaBox);
                            try (PDPageContentStream contentStream = new PDPageContentStream(document, page);){
                                float yOffset = MeasurementTransposedPrintService.printHeader((PDPageContentStream)contentStream, (PDPage)page, (Iterable)headers);
                                TableDrawer.builder().page(page).contentStream(contentStream).startX(20.0f).startY(yOffset -= 10.0f).table(detailsTable).build().draw();
                                float dataTableWidth = MeasurementTransposedPrintService.width((Table)detailsTable);
                                float dataTableHeight = MeasurementTransposedPrintService.height((Table)detailsTable);
                                ImmutableList.Builder filledUpColumnsBuilder = ImmutableList.builder();
                                boolean fillUpTable = Iterables.contains((Iterable)printConfiguration.getBooleanPrintOptions(), (Object)EBooleanPrintOption.FILL_UP_TABLE_ENABLED);
                                if (fillUpTable && !MeasurementTransposedPrintService.almostSame((float)dataTableWidth, (float)maxDetailsWidth)) {
                                    Table fillUpTableRight = MeasurementTransposedPrintService.fillUpTableRight((PrintSetup)printSetup, (Table)detailsTable, (PDRectangle)mediaBox, (float)maxDetailsHeight);
                                    TableDrawer.builder().page(page).contentStream(contentStream).startX(20.0f + dataTableWidth).startY(yOffset).table(fillUpTableRight).build().draw();
                                    filledUpColumnsBuilder.addAll((Iterable)fillUpTableRight.getColumns());
                                }
                                ImmutableList fillUpColumns = filledUpColumnsBuilder.build();
                                yOffset -= detailsTable.getHeight();
                                if (fillUpTable && !MeasurementTransposedPrintService.almostSame((float)dataTableHeight, (float)maxDetailsHeight)) {
                                    Table fillUpTableBelow = MeasurementTransposedPrintService.fillUpTableBelow((PrintSetup)printSetup, (Table)detailsTable, (int)3, (float)maxDetailsHeight);
                                    TableDrawer.builder().page(page).contentStream(contentStream).startX(20.0f).startY(yOffset).table(fillUpTableBelow).build().draw();
                                    yOffset -= fillUpTableBelow.getHeight();
                                    yOffset -= 10.0f;
                                }
                                yOffset -= 10.0f;
                                ImmutableList.Builder aggregationTablesBuilder = ImmutableList.builder();
                                Table aggregationTableAmounts = MeasurementTransposedPrintService.aggregationTable((PrintSetup)printSetup, (PDFont)printFonts.getRegular(), (Table)detailsTable, (Multimap)posProductPerSPN, (int)3, (String)"Menge Gesamt", (Iterable)fillUpColumns, item -> item.getSource() == EValueSource.AMOUNT ? item.getValue() : BigDecimal.ZERO);
                                aggregationTablesBuilder.add((Object)aggregationTableAmounts);
                                Table aggregationTableAmountsPerPage = MeasurementTransposedPrintService.aggregationTable((PrintSetup)printSetup, (PDFont)printFonts.getRegular(), (Table)detailsTable, (int)3, (String)"Menge pro Blatt", (Iterable)fillUpColumns, item -> item.getSource() == EValueSource.AMOUNT ? item.getValue() : BigDecimal.ZERO);
                                aggregationTablesBuilder.add((Object)aggregationTableAmountsPerPage);
                                if (printWages) {
                                    Table aggregationTableWages = MeasurementTransposedPrintService.aggregationTable((PrintSetup)printSetup, (PDFont)printFonts.getBold(), (Table)detailsTable, (int)3, (String)"Lohn pro Blatt", (Iterable)fillUpColumns, item -> item.getSource() == EValueSource.WAGE ? item.getValue() : BigDecimal.ZERO);
                                    aggregationTablesBuilder.add((Object)aggregationTableWages);
                                }
                                ImmutableList aggregationTables = aggregationTablesBuilder.build();
                                float aggregationBaseOffset = 30.0f + footerHeight + 10.0f;
                                yOffset -= MeasurementTransposedPrintService.writeAggregation((PDPage)page, (PDPageContentStream)contentStream, (float)aggregationBaseOffset, (Iterable)aggregationTables);
                            }
                        }
                    }
                }
                MeasurementTransposedPrintService.writeMeta((PrintSetup)printSetup, (PDDocument)document, (Table)footer);
                ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
                document.save((OutputStream)outputStream);
                byArray = outputStream.toByteArray();
                if (document == null) break block24;
            }
            catch (Throwable throwable) {
                try {
                    if (document != null) {
                        try {
                            document.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    e.printStackTrace();
                    return new byte[0];
                }
            }
            document.close();
        }
        return byArray;
    }

    @Nonnull
    private List<Table> rotatedDetails(@NonNull MeasurementPrintTransposed measurementPrintTransposed, @NonNull MeasurementTransposedPrintConfiguration printConfiguration, @NonNull PrintSetup printSetup, @NonNull PDRectangle mediaBox) {
        if (measurementPrintTransposed == null) {
            throw new NullPointerException("measurementPrintTransposed is marked non-null but is null");
        }
        if (printConfiguration == null) {
            throw new NullPointerException("printConfiguration is marked non-null but is null");
        }
        if (printSetup == null) {
            throw new NullPointerException("printSetup is marked non-null but is null");
        }
        if (mediaBox == null) {
            throw new NullPointerException("mediaBox is marked non-null but is null");
        }
        Preconditions.checkArgument((printConfiguration.getMaxColsPerPage() > 0 ? 1 : 0) != 0, (Object)"printConfiguration.maxColsPerPage() must be > 0");
        Preconditions.checkArgument((printConfiguration.getMaxRowsPerPage() > 0 ? 1 : 0) != 0, (Object)"printConfiguration.maxRowsPerPage() must be > 0");
        Preconditions.checkArgument((printConfiguration.getMaxHeaderTextLength() > 0 ? 1 : 0) != 0, (Object)"printConfiguration.maxHeaderTextLength() must be > 0");
        boolean printInternalWage = Iterables.contains((Iterable)printConfiguration.getBooleanPrintOptions(), (Object)EBooleanPrintOption.PRINT_INTERNAL_WAGE_ENABLED);
        int fontSize = printSetup.getDetailsFontSize();
        List quotationPositionNumbers = measurementPrintTransposed.getAllStagePositionNumbers();
        List remarks = measurementPrintTransposed.getAllRemarks();
        Map transposedItemsByRemark = measurementPrintTransposed.getTransposedItemsByRemark();
        Map shortTextByPositionNumber = measurementPrintTransposed.getNameByPositionNumber();
        Map unitByPositionNumber = measurementPrintTransposed.getUnitByPositionNumber();
        int maxColsPerPage = printConfiguration.getMaxColsPerPage();
        Iterable positionNumberPartitions = Iterables.partition((Iterable)quotationPositionNumbers, (int)maxColsPerPage);
        ImmutableList.Builder tablesBuilder = ImmutableList.builder();
        for (List positionNumberPartition : positionNumberPartitions) {
            ImmutableList nameCols = ImmutableList.copyOf(IntStream.range(0, 3).mapToObj(item -> Float.valueOf(0.083333336f)).iterator());
            float sizeLeft = 1.0f - IterableHelper.sum((Iterable)nameCols);
            float ratioPerCol = sizeLeft / (float)maxColsPerPage;
            int colsOnThisPage = Math.min(maxColsPerPage, Iterables.size((Iterable)positionNumberPartition));
            ImmutableList valueCols = ImmutableList.copyOf(IntStream.range(0, colsOnThisPage).mapToObj(item -> Float.valueOf(ratioPerCol)).iterator());
            ImmutableList columnWidths = ImmutableList.builder().addAll((Iterable)nameCols).addAll((Iterable)valueCols).build();
            float maxWidth = MeasurementTransposedPrintService.maxWidth((PDRectangle)mediaBox) * IterableHelper.sum((Iterable)columnWidths);
            Table.TableBuilder tableBuilder = MeasurementTransposedPrintService.table((Float)Float.valueOf(maxWidth), (Iterable)columnWidths);
            Row.RowBuilder headerRow1Builder = Row.builder().add((AbstractCell)MeasurementTransposedPrintService.detailHeader((PrintSetup)printSetup, (String)"", (int)2)).add((AbstractCell)MeasurementTransposedPrintService.detailHeader((PrintSetup)printSetup, (String)"Position"));
            Row.RowBuilder headerRow2Builder = Row.builder().add((AbstractCell)MeasurementTransposedPrintService.detailHeader((PrintSetup)printSetup, (String)"", (int)2)).add((AbstractCell)MeasurementTransposedPrintService.detailHeader((PrintSetup)printSetup, (String)"Einheit"));
            Row.RowBuilder headerRow3Builder = Row.builder().add((AbstractCell)MeasurementTransposedPrintService.detailHeader((PrintSetup)printSetup, (String)"", (int)2)).add((AbstractCell)MeasurementTransposedPrintService.detailHeader((PrintSetup)printSetup, (String)"Leistung"));
            positionNumberPartition.forEach(positionNumber -> {
                String unit = StringUtils.trimToEmpty((String)unitByPositionNumber.getOrDefault(positionNumber, "-"));
                String shortText = MeasurementTransposedPrintService.rotatedHeaderName((String)shortTextByPositionNumber.getOrDefault(positionNumber, "-"), (MeasurementTransposedPrintConfiguration)printConfiguration);
                headerRow1Builder.add((AbstractCell)MeasurementTransposedPrintService.detailHeader((PrintSetup)printSetup, (String)positionNumber));
                headerRow2Builder.add((AbstractCell)MeasurementTransposedPrintService.detailHeader((PrintSetup)printSetup, (String)unit));
                headerRow3Builder.add((AbstractCell)MeasurementTransposedPrintService.detailHeader((PrintSetup)printSetup, (String)shortText));
            });
            Row headerRow1 = headerRow1Builder.build();
            Row headerRow2 = headerRow2Builder.build();
            Row headerRow3 = headerRow3Builder.build();
            tableBuilder.addRow(headerRow1);
            tableBuilder.addRow(headerRow2);
            tableBuilder.addRow(headerRow3);
            for (String remark : remarks) {
                Map transposedItemsByPositionNumber = (Map)transposedItemsByRemark.getOrDefault(remark, ImmutableMap.of());
                Row.RowBuilder amountRowBuilder = Row.builder();
                Iterable amountBorders = printInternalWage ? TLR : ALL;
                int remarkRowSpan = printInternalWage ? 2 : 1;
                amountRowBuilder.add((AbstractCell)MeasurementTransposedPrintService.genericCell((PDFont)printSetup.getPrintFonts().getRegular(), (int)fontSize, (String)remark, (String)"remark", (String)remark, (BigDecimal)BigDecimal.ZERO, (EValueSource)EValueSource.IGNORE, (int)3, (int)remarkRowSpan, (Color)DETAIL_TEXT_COLOR, (Color)DEFAULT_BG_COLOR_DETAILS, (HorizontalAlignment)HorizontalAlignment.LEFT, (Map)MeasurementTransposedPrintService.defaultBorder((Iterable)ALL)));
                for (String quotationPositionNumber : positionNumberPartition) {
                    TransposedItem transposedItem = transposedItemsByPositionNumber.getOrDefault(quotationPositionNumber, TransposedItem.EMPTY);
                    BigDecimal product = BigDecimalHelper.nullSafeScale((BigDecimal)transposedItem.getProduct(), (int)3);
                    amountRowBuilder.add((AbstractCell)MeasurementTransposedPrintService.valueCell((PDFont)printSetup.getPrintFonts().getRegular(), (int)fontSize, (String)remark, (String)quotationPositionNumber, (BigDecimal)product, (EValueSource)EValueSource.AMOUNT, (HorizontalAlignment)HorizontalAlignment.RIGHT, (Iterable)amountBorders, (Iterable)ImmutableList.of((Object)ECellPrintOption.HIDE_ZERO_VALUE)));
                }
                Row amountRow = amountRowBuilder.build();
                tableBuilder.addRow(amountRow);
                if (!printInternalWage) continue;
                Row.RowBuilder wageRowBuilder = Row.builder();
                for (String quotationPositionNumber : positionNumberPartition) {
                    TransposedItem transposedItem = transposedItemsByPositionNumber.getOrDefault(quotationPositionNumber, TransposedItem.EMPTY);
                    BigDecimal wage = transposedItem.getInternalSquadWageAggregated();
                    wageRowBuilder.add((AbstractCell)MeasurementTransposedPrintService.valueCell((PDFont)printSetup.getPrintFonts().getBold(), (int)fontSize, (String)remark, (String)quotationPositionNumber, (BigDecimal)wage, (EValueSource)EValueSource.WAGE, (HorizontalAlignment)HorizontalAlignment.RIGHT, (Iterable)LRB, (Iterable)ImmutableList.of((Object)ECellPrintOption.HIDE_ZERO_VALUE)));
                }
                Row wageRow = wageRowBuilder.build();
                tableBuilder.addRow(wageRow);
            }
            Table table = tableBuilder.build();
            tablesBuilder.add((Object)table);
        }
        return tablesBuilder.build();
    }

    @Nonnull
    @VisibleForTesting
    static String rotatedHeaderName(@NonNull String candidate, @NonNull MeasurementTransposedPrintConfiguration printConfiguration) {
        if (candidate == null) {
            throw new NullPointerException("candidate is marked non-null but is null");
        }
        if (printConfiguration == null) {
            throw new NullPointerException("printConfiguration is marked non-null but is null");
        }
        int maxLengthAllowed = printConfiguration.getMaxHeaderTextLength();
        String cleaned = StringUtils.trimToEmpty((String)candidate);
        if (StringUtils.length((CharSequence)cleaned) > maxLengthAllowed) {
            String shortenedText = MeasurementTransposedPrintService.safeSubString((String)candidate, (int)printConfiguration.getMaxHeaderTextLength());
            return shortenedText + "...";
        }
        return cleaned;
    }
}

