/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.service.service.print;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import de.qfm.erp.service.model.internal.pdfbox.EBooleanPrintOption;
import de.qfm.erp.service.model.internal.print.PrintConfiguration;
import de.qfm.erp.service.model.internal.print.PrintFonts;
import de.qfm.erp.service.model.internal.print.PrintSetup;
import de.qfm.erp.service.model.internal.print.measurement.MeasurementPrintConfiguration;
import de.qfm.erp.service.model.internal.print.measurement.MeasurementPrintInfo;
import de.qfm.erp.service.service.route.impl.PrintHelper;
import de.qfm.erp.service.service.security.UserService;
import de.qfm.erp.service.service.service.DateTimeHelperService;
import de.qfm.erp.service.service.service.print.AbstractPrintService;
import java.io.IOException;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Currency;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDDocumentInformation;
import org.apache.pdfbox.pdmodel.common.PDRectangle;
import org.apache.pdfbox.pdmodel.font.PDFont;
import org.apache.pdfbox.pdmodel.graphics.image.PDImageXObject;
import org.vandeseer.easytable.settings.HorizontalAlignment;
import org.vandeseer.easytable.settings.VerticalAlignment;
import org.vandeseer.easytable.structure.Row;
import org.vandeseer.easytable.structure.Table;
import org.vandeseer.easytable.structure.cell.AbstractCell;
import org.vandeseer.easytable.structure.cell.ImageCell;

/*
 * Exception performing whole class analysis ignored.
 */
public abstract class MeasurementPrintService<T extends MeasurementPrintInfo, V extends PrintConfiguration>
extends AbstractPrintService<T, V> {
    protected MeasurementPrintService(@NonNull UserService userService, @NonNull DateTimeHelperService dateTimeHelperService, @NonNull PrintHelper printHelper) {
        super(userService, dateTimeHelperService, printHelper);
        if (userService == null) {
            throw new NullPointerException("userService is marked non-null but is null");
        }
        if (dateTimeHelperService == null) {
            throw new NullPointerException("dateTimeHelperService is marked non-null but is null");
        }
        if (printHelper == null) {
            throw new NullPointerException("printHelper is marked non-null but is null");
        }
    }

    @Nonnull
    public PDDocumentInformation apply(@NonNull PDDocumentInformation documentInformation, @NonNull T printInfo, @NonNull V printConfiguration) {
        if (documentInformation == null) {
            throw new NullPointerException("documentInformation is marked non-null but is null");
        }
        if (printInfo == null) {
            throw new NullPointerException("printInfo is marked non-null but is null");
        }
        if (printConfiguration == null) {
            throw new NullPointerException("printConfiguration is marked non-null but is null");
        }
        String quotationNumber = printInfo.getQuotationNumber();
        String constructionSite = printInfo.getConstructionSite();
        String measurementNumber = printInfo.getMeasurementNumber();
        documentInformation.setKeywords(quotationNumber);
        documentInformation.setTitle(String.format("Angebot: %s", quotationNumber));
        documentInformation.setSubject(String.format("Baustelle: %s, Aufmass: %s", constructionSite, measurementNumber));
        return documentInformation;
    }

    @Nonnull
    protected List<Table> header(@NonNull T measurementPrintInfo, @NonNull PrintConfiguration printConfiguration, @NonNull PDDocument document, @NonNull PDRectangle mediaBox, @NonNull PrintSetup printSetup) throws IOException {
        if (measurementPrintInfo == null) {
            throw new NullPointerException("measurementPrintInfo is marked non-null but is null");
        }
        if (printConfiguration == null) {
            throw new NullPointerException("printConfiguration is marked non-null but is null");
        }
        if (document == null) {
            throw new NullPointerException("document is marked non-null but is null");
        }
        if (mediaBox == null) {
            throw new NullPointerException("mediaBox is marked non-null but is null");
        }
        if (printSetup == null) {
            throw new NullPointerException("printSetup is marked non-null but is null");
        }
        PrintFonts printFonts = printSetup.getPrintFonts();
        byte[] logoBuffer = printSetup.getLogoBuffer();
        boolean isWageToBePrinted = this.isWageToBePrinted(printConfiguration);
        boolean isValueToBePrinted = this.isValueToBePrinted(printConfiguration);
        boolean isSquadToBePrinted = this.isSquadToBePrinted(printConfiguration);
        PDImageXObject pdImageXObject = PDImageXObject.createFromByteArray((PDDocument)document, (byte[])logoBuffer, (String)"");
        String name = MeasurementPrintService.headerName((boolean)isWageToBePrinted);
        Table.TableBuilder header1Builder = MeasurementPrintService.table((PDRectangle)mediaBox, (Iterable)ImmutableList.of((Object)Float.valueOf(0.15f), (Object)Float.valueOf(0.7f), (Object)Float.valueOf(0.15f)));
        boolean printMeasurementTypeEnabled = Iterables.contains((Iterable)printConfiguration.getBooleanPrintOptions(), (Object)EBooleanPrintOption.PRINT_MEASUREMENT_TYPE_ENABLED);
        if (printMeasurementTypeEnabled) {
            header1Row1 = Row.builder().add((AbstractCell)((ImageCell.ImageCellBuilder)((ImageCell.ImageCellBuilder)((ImageCell.ImageCellBuilder)((ImageCell.ImageCellBuilder)((ImageCell.ImageCellBuilder)((ImageCell.ImageCellBuilder)ImageCell.builder().horizontalAlignment(HorizontalAlignment.CENTER)).padding(0.0f)).paddingLeft(printSetup.getLogoPaddingLeft())).verticalAlignment(VerticalAlignment.MIDDLE)).image(pdImageXObject).maxHeight((float)printSetup.getLogoHeight()).borderWidth(0.25f)).rowSpan(2)).build()).add((AbstractCell)MeasurementPrintService.titleCell((PrintSetup)printSetup, (PDFont)printFonts.getRegular(), (String)name, (Map)MeasurementPrintService.defaultBorder((Iterable)ALL), (int)2)).add((AbstractCell)MeasurementPrintService.titleCell((PrintSetup)printSetup, (PDFont)printFonts.getRegular(), (String)measurementPrintInfo.getMeasurementNumber(), (Map)MeasurementPrintService.defaultBorder((Iterable)TR), (int)1)).build();
            header1Builder.addRow(header1Row1);
            Row header1Row2 = Row.builder().add((AbstractCell)MeasurementPrintService.headerCell((PrintSetup)printSetup, (PDFont)printSetup.getPrintFonts().getRegular(), (String)measurementPrintInfo.getMeasurementTypeTranslated(), (Iterable)RB, (int)1, (int)1, (HorizontalAlignment)HorizontalAlignment.CENTER, (VerticalAlignment)VerticalAlignment.TOP)).build();
            header1Builder.addRow(header1Row2);
        } else {
            header1Row1 = Row.builder().add((AbstractCell)((ImageCell.ImageCellBuilder)((ImageCell.ImageCellBuilder)((ImageCell.ImageCellBuilder)((ImageCell.ImageCellBuilder)((ImageCell.ImageCellBuilder)ImageCell.builder().horizontalAlignment(HorizontalAlignment.CENTER)).padding(0.0f)).paddingLeft(printSetup.getLogoPaddingLeft())).verticalAlignment(VerticalAlignment.MIDDLE)).image(pdImageXObject).maxHeight((float)printSetup.getLogoHeight()).borderWidth(0.25f)).build()).add((AbstractCell)MeasurementPrintService.titleCell((PrintSetup)printSetup, (PDFont)printFonts.getRegular(), (String)name)).add((AbstractCell)MeasurementPrintService.titleCell((PrintSetup)printSetup, (PDFont)printFonts.getRegular(), (String)measurementPrintInfo.getMeasurementNumber())).build();
            header1Builder.addRow(header1Row1);
        }
        String releaseOrderName = StringUtils.trimToEmpty((String)measurementPrintInfo.getReleaseOrderName());
        String constructionSite = StringUtils.trimToEmpty((String)measurementPrintInfo.getConstructionSite());
        String personResponsibleAtCustomer = measurementPrintInfo.getPersonResponsibleAtCustomer();
        boolean releaseOrderEqualsConstructionSite = StringUtils.equalsIgnoreCase((CharSequence)releaseOrderName, (CharSequence)constructionSite);
        boolean personResponsibleIsEmpty = StringUtils.isBlank((CharSequence)personResponsibleAtCustomer);
        Table.TableBuilder header2Builder = MeasurementPrintService.table((PDRectangle)mediaBox, (Iterable)ImmutableList.of((Object)Float.valueOf(0.125f), (Object)Float.valueOf(0.3f), (Object)Float.valueOf(0.1f), (Object)Float.valueOf(0.125f), (Object)Float.valueOf(0.15f), (Object)Float.valueOf(0.2f)));
        String orderDescriptionCustomer = measurementPrintInfo.getOrderDescriptionCustomer();
        String orderNumber = measurementPrintInfo.getOrderNumber();
        boolean orderDescriptionSet = StringUtils.isNotBlank((CharSequence)orderDescriptionCustomer);
        boolean orderNumberSet = StringUtils.isNotBlank((CharSequence)orderNumber);
        ArrayList orderLabelParts = Lists.newArrayList();
        if (orderDescriptionSet) {
            orderLabelParts.add("Auftrag");
        }
        if (orderNumberSet) {
            orderLabelParts.add("Bestellnummer");
        }
        String orderLabel = StringUtils.join((Iterable)orderLabelParts, (String)"; ");
        ArrayList orderValueParts = Lists.newArrayList();
        if (orderDescriptionSet) {
            orderValueParts.add(orderDescriptionCustomer);
        }
        if (orderNumberSet) {
            orderValueParts.add(orderNumber);
        }
        String orderValue = StringUtils.join((Iterable)orderValueParts, (String)"; ");
        Row header2Row1 = Row.builder().add((AbstractCell)MeasurementPrintService.headerCell((PrintSetup)printSetup, (PDFont)printFonts.getRegular(), (String)String.format("%s:", orderLabel), (Iterable)TLB)).add((AbstractCell)MeasurementPrintService.headerCell((PrintSetup)printSetup, (PDFont)printFonts.getRegular(), (String)orderValue, (Iterable)TB)).add((AbstractCell)MeasurementPrintService.headerCell((PrintSetup)printSetup, (PDFont)printFonts.getRegular(), (String)"", (Iterable)TB)).add((AbstractCell)MeasurementPrintService.headerCell((PrintSetup)printSetup, (PDFont)printFonts.getRegular(), (String)"", (Iterable)TB)).add((AbstractCell)MeasurementPrintService.headerCell((PrintSetup)printSetup, (PDFont)printFonts.getRegular(), (String)"Kostentr\u00e4ger:", (Iterable)TLB)).add((AbstractCell)MeasurementPrintService.headerCell((PrintSetup)printSetup, (PDFont)printFonts.getRegular(), (String)measurementPrintInfo.getQuotationNumber(), (Iterable)TBR)).build();
        String valueOverallAsString = MeasurementPrintService.nullSafeCurrency((BigDecimal)measurementPrintInfo.getValueOverall(), (Currency)measurementPrintInfo.getCurrency());
        Row header2Row2 = Row.builder().add((AbstractCell)MeasurementPrintService.headerCell((PrintSetup)printSetup, (PDFont)printFonts.getRegular(), (String)"Abruf:", (Iterable)TLB)).add((AbstractCell)MeasurementPrintService.headerCell((PrintSetup)printSetup, (PDFont)printFonts.getRegular(), (String)releaseOrderName, (Iterable)TB)).add((AbstractCell)MeasurementPrintService.headerCell((PrintSetup)printSetup, (PDFont)printFonts.getRegular(), (String)(isValueToBePrinted ? "Gesamtwert:" : ""), (Iterable)TB)).add((AbstractCell)MeasurementPrintService.headerCell((PrintSetup)printSetup, (PDFont)printFonts.getRegular(), (String)(isValueToBePrinted ? valueOverallAsString : ""), (Iterable)TB)).add((AbstractCell)MeasurementPrintService.headerCell((PrintSetup)printSetup, (PDFont)printFonts.getRegular(), (String)(isSquadToBePrinted ? "Trupp:" : ""), (Iterable)TLB)).add((AbstractCell)MeasurementPrintService.headerCell((PrintSetup)printSetup, (PDFont)printFonts.getRegular(), (String)(isSquadToBePrinted ? measurementPrintInfo.getAssignedUserName() : ""), (Iterable)TBR)).build();
        String wageOverallAsString = MeasurementPrintService.nullSafeCurrency((BigDecimal)measurementPrintInfo.getSquadWageOverall(), (Currency)measurementPrintInfo.getCurrency());
        String assignedSquadPersonalNumberAsString = MeasurementPrintService.nullSafeString((Integer)measurementPrintInfo.getAssignedSquadPersonalNumber());
        Row header2Row3 = Row.builder().add((AbstractCell)MeasurementPrintService.headerCell((PrintSetup)printSetup, (PDFont)printFonts.getRegular(), (String)(HIDE_NOT_RELEVANT_INFORMATION != false && releaseOrderEqualsConstructionSite ? "" : "Bauvorhaben:"), (Iterable)TLB)).add((AbstractCell)MeasurementPrintService.headerCell((PrintSetup)printSetup, (PDFont)printFonts.getRegular(), (String)(HIDE_NOT_RELEVANT_INFORMATION != false && releaseOrderEqualsConstructionSite ? "" : constructionSite), (Iterable)TB)).add((AbstractCell)MeasurementPrintService.headerCell((PrintSetup)printSetup, (PDFont)printFonts.getRegular(), (String)(isWageToBePrinted ? "Gesamtlohn:" : ""), (Iterable)TB)).add((AbstractCell)MeasurementPrintService.headerCell((PrintSetup)printSetup, (PDFont)printFonts.getRegular(), (String)(isWageToBePrinted ? wageOverallAsString : ""), (Iterable)TB)).add((AbstractCell)MeasurementPrintService.headerCell((PrintSetup)printSetup, (PDFont)printFonts.getRegular(), (String)(isSquadToBePrinted ? "Trupp-Nr:" : ""), (Iterable)TLB)).add((AbstractCell)MeasurementPrintService.headerCell((PrintSetup)printSetup, (PDFont)printFonts.getRegular(), (String)(isSquadToBePrinted ? assignedSquadPersonalNumberAsString : ""), (Iterable)TBR)).build();
        String projectExecutionRange = Joiner.on((String)" - ").join((Object)measurementPrintInfo.getProjectExecutionStartDate(), (Object)measurementPrintInfo.getProjectExecutionEndDate(), new Object[0]);
        Row header2Row4 = Row.builder().add((AbstractCell)MeasurementPrintService.headerCell((PrintSetup)printSetup, (PDFont)printFonts.getRegular(), (String)(HIDE_NOT_RELEVANT_INFORMATION != false && personResponsibleIsEmpty ? "" : "Ansprechpartner:"), (Iterable)TLB)).add((AbstractCell)MeasurementPrintService.headerCell((PrintSetup)printSetup, (PDFont)printFonts.getRegular(), (String)(HIDE_NOT_RELEVANT_INFORMATION != false && personResponsibleIsEmpty ? "" : personResponsibleAtCustomer), (Iterable)TB)).add((AbstractCell)MeasurementPrintService.headerCell((PrintSetup)printSetup, (PDFont)printFonts.getRegular(), (String)"", (Iterable)TB)).add((AbstractCell)MeasurementPrintService.headerCell((PrintSetup)printSetup, (PDFont)printFonts.getRegular(), (String)"", (Iterable)TB)).add((AbstractCell)MeasurementPrintService.headerCell((PrintSetup)printSetup, (PDFont)printFonts.getRegular(), (String)"Ausf\u00fchrungszeitraum:", (Iterable)TLB)).add((AbstractCell)MeasurementPrintService.headerCell((PrintSetup)printSetup, (PDFont)printFonts.getRegular(), (String)projectExecutionRange, (Iterable)TBR)).build();
        header2Builder.addRow(header2Row1);
        header2Builder.addRow(header2Row2);
        header2Builder.addRow(header2Row3);
        header2Builder.addRow(header2Row4);
        boolean printHeaderRemarks = Iterables.contains((Iterable)printConfiguration.getBooleanPrintOptions(), (Object)EBooleanPrintOption.PRINT_HEADER_REMARKS_ENABLED);
        if (printHeaderRemarks) {
            String remarks = StringUtils.trimToEmpty((String)measurementPrintInfo.getRemarks());
            Row header2Row5 = Row.builder().add((AbstractCell)MeasurementPrintService.headerCell((PrintSetup)printSetup, (PDFont)printFonts.getRegular(), (String)"Bemerkungen: ", (Iterable)LB)).add((AbstractCell)MeasurementPrintService.headerCell((PrintSetup)printSetup, (PDFont)printFonts.getRegular(), (String)remarks, (Iterable)RB, (int)5)).build();
            header2Builder.addRow(header2Row5);
        }
        return ImmutableList.of((Object)header1Builder.build(), (Object)header2Builder.build());
    }

    @Nonnull
    protected static Table footer(@NonNull MeasurementPrintConfiguration printConfiguration, @NonNull PrintSetup printSetup, @NonNull PDRectangle mediaBox) {
        if (printConfiguration == null) {
            throw new NullPointerException("printConfiguration is marked non-null but is null");
        }
        if (printSetup == null) {
            throw new NullPointerException("printSetup is marked non-null but is null");
        }
        if (mediaBox == null) {
            throw new NullPointerException("mediaBox is marked non-null but is null");
        }
        PrintFonts printFonts = printSetup.getPrintFonts();
        return MeasurementPrintService.footer((MeasurementPrintConfiguration)printConfiguration, (PrintSetup)printSetup, (PDFont)printFonts.getRegular(), (PDRectangle)mediaBox);
    }

    @Nonnull
    protected static Table footer(@NonNull MeasurementPrintConfiguration printConfiguration, @NonNull PrintSetup printSetup, @NonNull PDFont font, @NonNull PDRectangle mediaBox) {
        if (printConfiguration == null) {
            throw new NullPointerException("printConfiguration is marked non-null but is null");
        }
        if (printSetup == null) {
            throw new NullPointerException("printSetup is marked non-null but is null");
        }
        if (font == null) {
            throw new NullPointerException("font is marked non-null but is null");
        }
        if (mediaBox == null) {
            throw new NullPointerException("mediaBox is marked non-null but is null");
        }
        Table.TableBuilder footerBuilder = MeasurementPrintService.table((PDRectangle)mediaBox, (Iterable)ImmutableList.of((Object)Float.valueOf(0.125f), (Object)Float.valueOf(0.125f), (Object)Float.valueOf(0.125f), (Object)Float.valueOf(0.125f), (Object)Float.valueOf(0.25f), (Object)Float.valueOf(0.125f), (Object)Float.valueOf(0.125f)));
        boolean freeFromDefectsChecked = Iterables.contains((Iterable)printConfiguration.getBooleanPrintOptions(), (Object)EBooleanPrintOption.FREE_FROM_DEFECTS_CHECKED);
        String freeFromDefectsCheckBox = freeFromDefectsChecked ? "[X]" : "[ ]";
        Row footerRow1 = Row.builder().add((AbstractCell)MeasurementPrintService.footerCell((PrintSetup)printSetup, (PDFont)font, (String)"Auftragnehmer", (Iterable)TL)).add((AbstractCell)MeasurementPrintService.footerCell((PrintSetup)printSetup, (PDFont)font, (String)"", (Iterable)T)).add((AbstractCell)MeasurementPrintService.footerCell((PrintSetup)printSetup, (PDFont)font, (String)"", (Iterable)TR)).add((AbstractCell)MeasurementPrintService.footerCell((PrintSetup)printSetup, (PDFont)font, (String)"Auftraggeber", (Iterable)T)).add((AbstractCell)MeasurementPrintService.footerCell((PrintSetup)printSetup, (PDFont)font, (String)(freeFromDefectsCheckBox + " Leistung m\u00e4ngelfrei"), (Iterable)T)).add((AbstractCell)MeasurementPrintService.footerCell((PrintSetup)printSetup, (PDFont)font, (String)"", (Iterable)T)).add((AbstractCell)MeasurementPrintService.footerCell((PrintSetup)printSetup, (PDFont)font, (String)"", (Iterable)TR)).build();
        boolean workIsAcceptedChecked = Iterables.contains((Iterable)printConfiguration.getBooleanPrintOptions(), (Object)EBooleanPrintOption.WORK_IS_ACCEPTED_CHECKED);
        String workIsAcceptedCheckbox = workIsAcceptedChecked ? "[X]" : "[ ]";
        Row footerRow2 = Row.builder().add((AbstractCell)MeasurementPrintService.footerCell((PrintSetup)printSetup, (PDFont)font, (String)"", (Iterable)L)).add((AbstractCell)MeasurementPrintService.footerCell((PrintSetup)printSetup, (PDFont)font, (String)printConfiguration.getPrintDate().format(DATE_FORMAT), (Iterable)ImmutableList.of())).add((AbstractCell)MeasurementPrintService.footerCell((PrintSetup)printSetup, (PDFont)font, (String)"...............", (Iterable)R)).add((AbstractCell)MeasurementPrintService.footerCell((PrintSetup)printSetup, (PDFont)font, (String)"", (Iterable)ImmutableList.of())).add((AbstractCell)MeasurementPrintService.footerCell((PrintSetup)printSetup, (PDFont)font, (String)(workIsAcceptedCheckbox + " Leistung gilt als abgenommen"), (Iterable)ImmutableList.of())).add((AbstractCell)MeasurementPrintService.footerCell((PrintSetup)printSetup, (PDFont)font, (String)"...............", (Iterable)ImmutableList.of())).add((AbstractCell)MeasurementPrintService.footerCell((PrintSetup)printSetup, (PDFont)font, (String)"...............", (Iterable)R)).build();
        boolean transferOfPerilsChecked = Iterables.contains((Iterable)printConfiguration.getBooleanPrintOptions(), (Object)EBooleanPrintOption.TRANSFER_OF_PERIL_CHECKED);
        String transferOfPerilsCheckbox = transferOfPerilsChecked ? "[X]" : "[ ]";
        LocalDate transferOfPerilsDate = printConfiguration.getTransferOfPerilsDate();
        String transferOfPerilsDateAsString = transferOfPerilsChecked && null != transferOfPerilsDate ? DateTimeHelperService.germanDate((LocalDate)transferOfPerilsDate) : "";
        String transferOfPerilsContent = transferOfPerilsChecked ? transferOfPerilsCheckbox + " Gefahren\u00fcbergang zum: " + transferOfPerilsDateAsString : "";
        Row footerRow3 = Row.builder().add((AbstractCell)MeasurementPrintService.footerCell((PrintSetup)printSetup, (PDFont)font, (String)"", (Iterable)LB)).add((AbstractCell)MeasurementPrintService.footerCell((PrintSetup)printSetup, (PDFont)font, (String)"Datum", (Iterable)B)).add((AbstractCell)MeasurementPrintService.footerCell((PrintSetup)printSetup, (PDFont)font, (String)"Unterschrift", (Iterable)RB)).add((AbstractCell)MeasurementPrintService.footerCell((PrintSetup)printSetup, (PDFont)font, (String)"", (Iterable)B)).add((AbstractCell)MeasurementPrintService.footerCell((PrintSetup)printSetup, (PDFont)font, (String)transferOfPerilsContent, (Iterable)B)).add((AbstractCell)MeasurementPrintService.footerCell((PrintSetup)printSetup, (PDFont)font, (String)"Datum", (Iterable)B)).add((AbstractCell)MeasurementPrintService.footerCell((PrintSetup)printSetup, (PDFont)font, (String)"Unterschrift", (Iterable)RB)).build();
        footerBuilder.addRow(footerRow1);
        footerBuilder.addRow(footerRow2);
        footerBuilder.addRow(footerRow3);
        return footerBuilder.build();
    }

    @Nonnull
    @VisibleForTesting
    static String headerName(boolean printWage) {
        return "Leistungsaufstellung" + (printWage ? " (Lohn)" : "");
    }
}

