/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.service.service.print;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import com.google.common.collect.Streams;
import de.qfm.erp.service.configuration.PrintLayoutConfig;
import de.qfm.erp.service.model.internal.invoice.InvoiceNamePrintParam;
import de.qfm.erp.service.model.internal.print.CompanyPrintInfo;
import de.qfm.erp.service.model.internal.print.EPrintFontSize;
import de.qfm.erp.service.model.internal.print.PrintConfiguration;
import de.qfm.erp.service.model.internal.print.PrintFonts;
import de.qfm.erp.service.model.internal.print.PrintInfo;
import de.qfm.erp.service.model.internal.print.PrintSetup;
import de.qfm.erp.service.model.internal.print.invoice.InvoiceAddendumDiscountMetaData;
import de.qfm.erp.service.model.internal.print.invoice.InvoiceMetaData;
import de.qfm.erp.service.model.internal.print.invoice.InvoicePositionPrintGroup;
import de.qfm.erp.service.model.internal.print.invoice.InvoicePositionPrintRow;
import de.qfm.erp.service.model.internal.print.invoice.InvoicePrintConfiguration;
import de.qfm.erp.service.model.internal.print.invoice.InvoicePrintInfo;
import de.qfm.erp.service.model.internal.print.invoice.InvoiceSupplementMetaData;
import de.qfm.erp.service.model.jpa.configuration.ConfigurationCompany;
import de.qfm.erp.service.model.jpa.invoice.EInvoiceState;
import de.qfm.erp.service.model.jpa.invoice.EInvoiceType;
import de.qfm.erp.service.service.route.impl.PrintHelper;
import de.qfm.erp.service.service.security.UserService;
import de.qfm.erp.service.service.service.DateTimeHelperService;
import de.qfm.erp.service.service.service.print.AbstractPrintService;
import java.awt.Color;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.TreeSet;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import lombok.NonNull;
import org.apache.commons.compress.utils.Lists;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDDocumentInformation;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.PDPageContentStream;
import org.apache.pdfbox.pdmodel.common.PDRectangle;
import org.apache.pdfbox.pdmodel.font.PDFont;
import org.apache.pdfbox.pdmodel.graphics.image.PDImageXObject;
import org.apache.pdfbox.pdmodel.graphics.state.PDExtendedGraphicsState;
import org.apache.pdfbox.util.Matrix;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.vandeseer.easytable.TableDrawer;
import org.vandeseer.easytable.settings.HorizontalAlignment;
import org.vandeseer.easytable.settings.VerticalAlignment;
import org.vandeseer.easytable.structure.Row;
import org.vandeseer.easytable.structure.Table;
import org.vandeseer.easytable.structure.cell.AbstractCell;
import org.vandeseer.easytable.structure.cell.ImageCell;
import org.vandeseer.easytable.structure.cell.TextCell;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class InvoicePrintService
extends AbstractPrintService<InvoicePrintInfo, InvoicePrintConfiguration> {
    private static final Logger log = LogManager.getLogger(InvoicePrintService.class);
    protected static final float MM_PER_UNIT = 2.83f;
    protected static final float INVOICE_MARGIN_LEFT_RIGHT = 70.75f;
    protected static final float INVOICE_MARGIN_TOP_BOTTOM = 48.11f;
    protected static final float INVOICE_MARGIN_BOTTOM_2ND_PAGE = 8.49f;
    protected static final float FOOTER_MARGIN_LEFT_RIGHT = 70.75f;
    protected static final float LOGO_HEADER_DISTANCE = 36.79f;
    protected static final float HEADER_TEXT_SPACE = 2.83f;
    protected static final float HEADER_TO_CONTENT_SPACE = 8.49f;
    protected static final Color TEXT_COLOR = Color.BLACK;
    protected static final int SENDER_FONT_SIZE = 7;
    private static final Map<EInvoiceType, String> INVOICE_TYPE_NUMBER_NAMING = ImmutableMap.builder().put((Object)EInvoiceType.PARTIAL_INVOICE, (Object)"Rechnungsnummer").put((Object)EInvoiceType.PARTIAL_FINAL_INVOICE, (Object)"Rechnungsnummer").put((Object)EInvoiceType.FINAL_INVOICE, (Object)"Rechnungsnummer").put((Object)EInvoiceType.INVOICE, (Object)"Rechnungsnummer").put((Object)EInvoiceType.INTERNAL_INVOICE, (Object)"Interne Nummer").put((Object)EInvoiceType.INTERNAL_VOUCHER, (Object)"Interne Nummer").put((Object)EInvoiceType.CREDIT_VOUCHER, (Object)"Gutschriftnummer").put((Object)EInvoiceType.CUSTOMER_VOUCHER, (Object)"Gutschriftnummer").build();
    final Map<EInvoiceType, String> INVOICE_TYPE_GROSS_NAME = ImmutableMap.of((Object)EInvoiceType.CREDIT_VOUCHER, (Object)"Gutschriftsbetrag");
    final Map<EInvoiceType, String> INVOICE_TYPE_PAYOUT_NAME = ImmutableMap.of((Object)EInvoiceType.CREDIT_VOUCHER, (Object)"Auszahlungsbetrag", (Object)EInvoiceType.CUSTOMER_VOUCHER, (Object)"Gutschriftsbetrag", (Object)EInvoiceType.INVOICE, (Object)"Rechnungsbetrag", (Object)EInvoiceType.INTERNAL_VOUCHER, (Object)"Rechnungsbetrag", (Object)EInvoiceType.INTERNAL_INVOICE, (Object)"Rechnungsbetrag", (Object)EInvoiceType.PARTIAL_INVOICE, (Object)"Zu zahlender Betrag", (Object)EInvoiceType.PARTIAL_FINAL_INVOICE, (Object)"Zu zahlender Betrag", (Object)EInvoiceType.CUMULATIVE_INVOICE, (Object)"Zu zahlender Betrag", (Object)EInvoiceType.FINAL_INVOICE, (Object)"Zu zahlender Betrag");
    private static final Map<EInvoiceType, Function<InvoiceNamePrintParam, String>> INVOICE_TYPE_NAME_NAMING = ImmutableMap.builder().put((Object)EInvoiceType.PARTIAL_INVOICE, InvoicePrintService::partialInvoiceName).put((Object)EInvoiceType.PARTIAL_FINAL_INVOICE, InvoicePrintService::partialFinalInvoiceName).put((Object)EInvoiceType.FINAL_INVOICE, i -> "Schlussrechnung").put((Object)EInvoiceType.INVOICE, i -> "Rechnung").put((Object)EInvoiceType.INTERNAL_INVOICE, i -> "Interne Rechnung").put((Object)EInvoiceType.INTERNAL_VOUCHER, i -> "Interner Beleg").put((Object)EInvoiceType.CUSTOMER_VOUCHER, i -> "Kundengutschrift").put((Object)EInvoiceType.CREDIT_VOUCHER, i -> "Gutschrift").build();
    private static final String P_13B = "Kein Ausweis der Umsatzsteuer gem\u00e4\u00df \u00a7 13 b UStG\nSteuerschuldnerschaft des Leistungsempf\u00e4ngers";
    private static final String P_SC = "Gem\u00e4\u00df \u00a7 14 Abs. 2  Satz 3 UStG hat der Gutschriftsempf\u00e4nger (Auftragnehmer) die M\u00f6glichkeit, der Gutschrift zu widersprechen. Diese Widerrufsm\u00f6glichkeit wird in gegenseitigem Einverst\u00e4ndnis auf sechs Wochen nach Zugang der Gutschrift begrenzt. Danach gilt die Gutschrift im umsatzsteuerlichen Sinne als unwiderruflich. F\u00fcr den Fall des Widerrufs hat der Auftragnehmer seinerseits unverz\u00fcglich eine Rechnung \u00fcber die erbrachten Leistungen bzw. sonstige Leistungen zu erstellen.\n\nEs bleibt dem Auftragnehmer unbenommen, in berechtigten F\u00e4llen auch nach dieser Frist eine Berichtigung der Gutschrift vom Auftraggeber zu verlangen, ohne dass die bestehende Gutschrift damit widerrufen wird. In diesen F\u00e4llen wird vom Auftraggeber eine neue Gutschrift erstellt.";
    private final PrintLayoutConfig printLayoutConfig;
    public static final Comparator<LocalDate> LOCAL_DATE_COMPARATOR = Comparator.nullsLast(Comparator.naturalOrder());
    public static final Comparator<String> INVOICE_NUMBER_COMPARATOR = Comparator.nullsLast(Comparator.naturalOrder());
    private static final Comparator<InvoiceMetaData> SECONDARY_INVOICE_COMPARATOR = (left, right) -> {
        LocalDate invoiceDateRight;
        LocalDate invoiceDateLeft = left.getInvoiceDate();
        int compareStep1 = LOCAL_DATE_COMPARATOR.compare(invoiceDateLeft, invoiceDateRight = right.getInvoiceDate());
        if (compareStep1 != 0) {
            return compareStep1;
        }
        String invoiceNumberLeft = left.getInvoiceNumber();
        String invoiceNumberRight = right.getInvoiceNumber();
        return INVOICE_NUMBER_COMPARATOR.compare(invoiceNumberLeft, invoiceNumberRight);
    };
    private static final Comparator<LocalDate> DEFAULT_LD_CMP = Comparator.nullsLast(Comparator.naturalOrder());
    private static final Comparator<String> DEFAULT_STR_CMP = Comparator.nullsLast(Comparator.naturalOrder());
    private static final Comparator<InvoiceMetaData> CLOSING_INVOICE_COMPARATOR = (left, right) -> {
        LocalDate rightInvoiceDate;
        LocalDate leftInvoiceDate = left.getInvoiceDate();
        int cmp1 = DEFAULT_LD_CMP.compare(leftInvoiceDate, rightInvoiceDate = right.getInvoiceDate());
        if (cmp1 != 0) {
            return cmp1;
        }
        String leftInvoiceNumber = left.getInvoiceNumber();
        String rightInvoiceNumber = right.getInvoiceNumber();
        return DEFAULT_STR_CMP.compare(leftInvoiceNumber, rightInvoiceNumber);
    };

    @Autowired
    public InvoicePrintService(UserService userService, DateTimeHelperService dateTimeHelperService, PrintHelper printHelper, PrintLayoutConfig printLayoutConfig) {
        super(userService, dateTimeHelperService, printHelper);
        this.printLayoutConfig = printLayoutConfig;
    }

    public byte[] generatePDF(@NonNull InvoicePrintInfo printInfo, @NonNull InvoicePrintConfiguration printConfiguration, @NonNull EPrintFontSize printFontSize, @NonNull ConfigurationCompany configurationCompany) {
        byte[] byArray;
        block24: {
            if (printInfo == null) {
                throw new NullPointerException("printInfo is marked non-null but is null");
            }
            if (printConfiguration == null) {
                throw new NullPointerException("printConfiguration is marked non-null but is null");
            }
            if (printFontSize == null) {
                throw new NullPointerException("printFontSize is marked non-null but is null");
            }
            if (configurationCompany == null) {
                throw new NullPointerException("configurationCompany is marked non-null but is null");
            }
            PDRectangle mediaBox = new PDRectangle(PDRectangle.A4.getWidth(), PDRectangle.A4.getHeight());
            boolean isCancelled = Objects.equals(printInfo.getPrimaryInvoiceData().getInvoiceState(), EInvoiceState.CANCELLED);
            String primaryResponsibleUserFullName = StringUtils.trimToEmpty((String)printInfo.getPrimaryResponsibleUserFullName());
            PDDocument document = this.document((PrintInfo)printInfo, (PrintConfiguration)printConfiguration, primaryResponsibleUserFullName);
            try {
                PrintSetup printSetup = PrintHelper.printSetup((PrintLayoutConfig)this.printLayoutConfig, (ConfigurationCompany)configurationCompany, (EPrintFontSize)printFontSize, (PDDocument)document, PrintLayoutConfig::getInvoiceLogoPadding, PrintLayoutConfig::getInvoiceLogoHeight, PrintLayoutConfig::getInvoiceLogoBuffer);
                Table footer = this.legalCompanyFooter(mediaBox, printSetup);
                Table blankHeaderP1 = this.headersP1(printInfo, (PrintConfiguration)printConfiguration, document, printSetup, mediaBox, 0, 0);
                Table blankHeaderP2 = this.headersP2(printInfo, (PrintConfiguration)printConfiguration, document, printSetup, mediaBox, 0, 0);
                float heightHeader0 = blankHeaderP1.getHeight();
                float heightHeader1 = blankHeaderP2.getHeight();
                float maxDetailsHeightFirstPage = InvoicePrintService.maxDetailsHeight((PDRectangle)mediaBox, (float)heightHeader0, (float)footer.getHeight(), (float)10.0f, (float)48.11f, (float)48.11f);
                float maxDetailsHeightRest = InvoicePrintService.maxDetailsHeight((PDRectangle)mediaBox, (float)heightHeader1, (float)0.0f, (float)10.0f, (float)48.11f, (float)8.49f);
                Table details = this.details(printInfo, mediaBox, printSetup);
                Table groupPrices = this.groupPrices(printInfo, mediaBox, printSetup);
                Table summarization = this.summarization(printInfo, mediaBox, printSetup);
                Table paymentConditions = this.paymentConditions(printInfo, mediaBox, printSetup);
                Optional legalNotice = this.legalNoticeParagraphs(printInfo, mediaBox, printSetup);
                Optional closingInvoiceStatement = this.closingInvoiceStatement(printInfo, printConfiguration, mediaBox, printSetup);
                Optional attachments = this.attachments(printInfo, printConfiguration, mediaBox, printSetup);
                Optional secondaryInvoicesOverview = this.secondaryInvoicesOverview(printInfo, printConfiguration, mediaBox, printSetup);
                Iterable additionalTables = (Iterable)MoreObjects.firstNonNull((Object)printInfo.getAdditionalTables(), (Object)ImmutableSet.of());
                ImmutableList.Builder allTablesBuilder = ImmutableList.builder();
                allTablesBuilder.add((Object)AbstractPrintService.PrintPlanInput.of((String)"details", (Table)details, (boolean)false, (int)3, (float)0.0f));
                allTablesBuilder.add((Object)AbstractPrintService.PrintPlanInput.of((String)"group prices", (Table)groupPrices, (boolean)false, (int)0, (float)10.0f));
                allTablesBuilder.add((Object)AbstractPrintService.PrintPlanInput.of((String)"summarization", (Table)summarization, (boolean)false, (int)0, (float)10.0f));
                secondaryInvoicesOverview.ifPresent(table -> allTablesBuilder.add((Object)AbstractPrintService.PrintPlanInput.of((String)"secondary invoices", (Table)table, (boolean)false, (int)3, (float)10.0f)));
                attachments.ifPresent(table -> allTablesBuilder.add((Object)AbstractPrintService.PrintPlanInput.of((String)"attachments", (Table)table, (boolean)false, (int)0, (float)10.0f)));
                allTablesBuilder.add((Object)AbstractPrintService.PrintPlanInput.of((String)"payment conditions", (Table)paymentConditions, (boolean)false, (int)0, (float)10.0f));
                closingInvoiceStatement.ifPresent(table -> allTablesBuilder.add((Object)AbstractPrintService.PrintPlanInput.of((String)"closing invoice statement", (Table)table, (boolean)false, (int)3, (float)10.0f)));
                legalNotice.ifPresent(table -> allTablesBuilder.add((Object)AbstractPrintService.PrintPlanInput.of((String)"legal notice", (Table)table, (boolean)false, (int)0, (float)10.0f)));
                additionalTables.forEach(table -> allTablesBuilder.add((Object)AbstractPrintService.PrintPlanInput.of((String)"additional tables", (Table)table, (boolean)false, (int)0, (float)10.0f)));
                ImmutableList allTables = allTablesBuilder.build();
                Multimap printPlan = InvoicePrintService.printPlan((Iterable)allTables, (float)maxDetailsHeightFirstPage, (float)maxDetailsHeightRest);
                if (details.getRows().isEmpty()) {
                    InvoicePrintService.printEmptyPage((PDDocument)document, (PDRectangle)mediaBox, (List)ImmutableList.of());
                } else {
                    TreeSet pages = Sets.newTreeSet((Iterable)printPlan.keySet());
                    Integer pageCount = pages.size();
                    for (Integer pageNumber : pages) {
                        ImmutableList headers;
                        if (pageNumber == 0) {
                            Table headersP1 = this.headersP1(printInfo, (PrintConfiguration)printConfiguration, document, printSetup, mediaBox, 1 + pageNumber, pageCount.intValue());
                            headers = ImmutableList.of((Object)headersP1);
                        } else {
                            Table headersP2 = this.headersP2(printInfo, (PrintConfiguration)printConfiguration, document, printSetup, mediaBox, 1 + pageNumber, pageCount.intValue());
                            headers = ImmutableList.of((Object)headersP2);
                        }
                        PDPage pdPage = InvoicePrintService.page((PDDocument)document, (PDRectangle)mediaBox);
                        PDExtendedGraphicsState alpha = new PDExtendedGraphicsState();
                        alpha.setNonStrokingAlphaConstant(Float.valueOf(0.2f));
                        Collection printPlanOutputs = printPlan.get((Object)pageNumber);
                        try (PDPageContentStream contentStream = new PDPageContentStream(document, pdPage);){
                            float yOffset = InvoicePrintService.printHeader((PDPageContentStream)contentStream, (PDPage)pdPage, (Iterable)headers);
                            for (AbstractPrintService.PrintPlanOutput printPlanOutput : printPlanOutputs) {
                                Table table2 = printPlanOutput.getTable();
                                float marginAfterTable = printPlanOutput.getMarginAfterTable();
                                TableDrawer.builder().page(pdPage).contentStream(contentStream).startX(70.75f).startY(yOffset -= marginAfterTable).table(table2).build().draw();
                                yOffset -= table2.getHeight();
                            }
                            if (pageNumber == 0) {
                                yOffset -= this.printFooter(contentStream, pdPage, footer);
                            }
                            if (!isCancelled) continue;
                            contentStream.transform(Matrix.getRotateInstance((double)Math.toRadians(30.0), (float)(mediaBox.getWidth() / 3.0f), (float)(mediaBox.getHeight() / 2.0f)));
                            contentStream.beginText();
                            contentStream.newLineAtOffset(0.0f, 0.0f);
                            contentStream.setStrokingColor(TEXT_COLOR);
                            contentStream.setNonStrokingColor(TEXT_COLOR);
                            contentStream.setFont(printSetup.getPrintFonts().getBold(), 75.0f);
                            contentStream.setGraphicsStateParameters(alpha);
                            contentStream.showText("Storniert");
                            contentStream.endText();
                        }
                    }
                }
                ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
                document.save((OutputStream)outputStream);
                byArray = outputStream.toByteArray();
                if (document == null) break block24;
            }
            catch (Throwable throwable) {
                try {
                    if (document != null) {
                        try {
                            document.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    e.printStackTrace();
                    return new byte[0];
                }
            }
            document.close();
        }
        return byArray;
    }

    @Nonnull
    public PDDocumentInformation apply(@NonNull PDDocumentInformation documentInformation, @NonNull InvoicePrintInfo printInfo, @NonNull InvoicePrintConfiguration printConfiguration) {
        if (documentInformation == null) {
            throw new NullPointerException("documentInformation is marked non-null but is null");
        }
        if (printInfo == null) {
            throw new NullPointerException("printInfo is marked non-null but is null");
        }
        if (printConfiguration == null) {
            throw new NullPointerException("printConfiguration is marked non-null but is null");
        }
        documentInformation.setKeywords("TODO");
        documentInformation.setTitle(String.format("INVOICE: %s", UUID.randomUUID()));
        documentInformation.setSubject(String.format("EMPLOYEE: %s", UUID.randomUUID()));
        return documentInformation;
    }

    protected static float maxWidth(@NonNull PDRectangle mediaBox) {
        if (mediaBox == null) {
            throw new NullPointerException("mediaBox is marked non-null but is null");
        }
        return mediaBox.getWidth() - 141.5f;
    }

    protected static float footerMaxWidth(@NonNull PDRectangle mediaBox) {
        if (mediaBox == null) {
            throw new NullPointerException("mediaBox is marked non-null but is null");
        }
        return mediaBox.getWidth() - 141.5f;
    }

    @Nonnull
    private Table headersP1(@NonNull InvoicePrintInfo printInfo, @NonNull PrintConfiguration printConfiguration, @NonNull PDDocument document, @NonNull PrintSetup printSetup, @NonNull PDRectangle mediaBox, int page, int pageCount) throws IOException {
        String additionalInfoDetail2;
        String additionalInfoHeader2;
        String additionalInfoDetail1;
        String invoiceTypeComment;
        String recipientRightRow4;
        String recipientRightRow3;
        String recipientRightRow2;
        String recipientRightRow1;
        String recipientLeftRow4;
        String recipientLeftRow3;
        String recipientLeftRow2;
        String recipientLeftRow1;
        boolean printRef;
        boolean recipientRefSet;
        if (printInfo == null) {
            throw new NullPointerException("printInfo is marked non-null but is null");
        }
        if (printConfiguration == null) {
            throw new NullPointerException("printConfiguration is marked non-null but is null");
        }
        if (document == null) {
            throw new NullPointerException("document is marked non-null but is null");
        }
        if (printSetup == null) {
            throw new NullPointerException("printSetup is marked non-null but is null");
        }
        if (mediaBox == null) {
            throw new NullPointerException("mediaBox is marked non-null but is null");
        }
        PrintFonts printFonts = printSetup.getPrintFonts();
        CompanyPrintInfo senderPrintInfo = printInfo.getSenderPrintInfo();
        CompanyPrintInfo recipientPrintInfo = printInfo.getRecipientPrintInfo();
        CompanyPrintInfo recipientRefPrintInfo = printInfo.getRecipientRefPrintInfo();
        byte[] logoBuffer = printSetup.getLogoBuffer();
        PDImageXObject pdImageXObject = PDImageXObject.createFromByteArray((PDDocument)document, (byte[])logoBuffer, (String)"");
        PDFont fontRegular = printFonts.getRegular();
        PDFont fontBold = printFonts.getBold();
        float header1Width = printSetup.getHeaderColumn1Width().floatValue();
        float header2Width = printSetup.getHeaderColumn2Width().floatValue();
        float header3Width = printSetup.getHeaderColumn3Width().floatValue();
        float header4Width = printSetup.getHeaderColumn4Width().floatValue();
        ImmutableList columnWidths = ImmutableList.of((Object)Float.valueOf(header1Width), (Object)Float.valueOf(header2Width), (Object)Float.valueOf(header3Width), (Object)Float.valueOf(header4Width));
        int columnCount = columnWidths.size();
        Table.TableBuilder header1Builder = InvoicePrintService.table((Float)Float.valueOf(InvoicePrintService.maxWidth((PDRectangle)mediaBox)), (Iterable)columnWidths);
        header1Builder.addRow(Row.builder().add((AbstractCell)((ImageCell.ImageCellBuilder)((ImageCell.ImageCellBuilder)((ImageCell.ImageCellBuilder)((ImageCell.ImageCellBuilder)((ImageCell.ImageCellBuilder)((ImageCell.ImageCellBuilder)ImageCell.builder().horizontalAlignment(HorizontalAlignment.LEFT)).padding(0.0f)).paddingLeft(printSetup.getLogoPaddingLeft())).verticalAlignment(VerticalAlignment.MIDDLE)).image(pdImageXObject).maxHeight((float)printSetup.getLogoHeight()).borderWidth(0.0f)).colSpan(2)).build()).add((AbstractCell)InvoicePrintService.emptyCell((PrintSetup)printSetup, (int)2)).build());
        header1Builder.addRow(Row.builder().fontSize(Integer.valueOf(1)).height(Float.valueOf(36.79f)).add((AbstractCell)InvoicePrintService.emptyCell((int)1, (int)columnWidths.size())).build());
        String senderRow1Left = StringUtils.trimToEmpty((String)Joiner.on((String)" ").skipNulls().join((Object)StringUtils.trimToEmpty((String)senderPrintInfo.getCustomerName1()), (Object)StringUtils.trimToEmpty((String)senderPrintInfo.getCustomerName2()), new Object[0]));
        String senderRow2Left = StringUtils.trimToEmpty((String)Joiner.on((String)" ").skipNulls().join((Object)StringUtils.trimToEmpty((String)senderPrintInfo.getCustomerStreet()), (Object)StringUtils.trimToEmpty((String)senderPrintInfo.getCustomerStreetNo()), new Object[0]));
        String senderRow2Right = StringUtils.trimToEmpty((String)Joiner.on((String)" ").skipNulls().join((Object)StringUtils.trimToEmpty((String)senderPrintInfo.getCustomerZipCode()), (Object)StringUtils.trimToEmpty((String)senderPrintInfo.getCustomerCity()), new Object[0]));
        String senderRow2 = String.format("%s | %s", senderRow2Left, senderRow2Right);
        boolean recipientSet = null != recipientPrintInfo.getAddressId();
        boolean bl = recipientRefSet = null != recipientRefPrintInfo.getAddressId();
        if (recipientRefSet && recipientSet) {
            printRef = true;
            recipientLeftRow1 = StringUtils.trimToEmpty((String)recipientRefPrintInfo.getCustomerName1());
            recipientLeftRow2 = StringUtils.trimToEmpty((String)recipientRefPrintInfo.getCustomerName2());
            recipientLeftRow3 = StringUtils.trimToEmpty((String)Joiner.on((String)" ").skipNulls().join((Object)StringUtils.trimToEmpty((String)recipientRefPrintInfo.getCustomerStreet()), (Object)StringUtils.trimToEmpty((String)recipientRefPrintInfo.getCustomerStreetNo()), new Object[0]));
            recipientLeftRow4 = StringUtils.trimToEmpty((String)Joiner.on((String)" ").skipNulls().join((Object)StringUtils.trimToEmpty((String)recipientRefPrintInfo.getCustomerZipCode()), (Object)StringUtils.trimToEmpty((String)recipientRefPrintInfo.getCustomerCity()), new Object[0]));
            recipientRightRow1 = StringUtils.trimToEmpty((String)recipientPrintInfo.getCustomerName1());
            recipientRightRow2 = StringUtils.trimToEmpty((String)recipientPrintInfo.getCustomerName2());
            recipientRightRow3 = StringUtils.trimToEmpty((String)Joiner.on((String)" ").skipNulls().join((Object)StringUtils.trimToEmpty((String)recipientPrintInfo.getCustomerStreet()), (Object)StringUtils.trimToEmpty((String)recipientPrintInfo.getCustomerStreetNo()), new Object[0]));
            recipientRightRow4 = StringUtils.trimToEmpty((String)Joiner.on((String)" ").skipNulls().join((Object)StringUtils.trimToEmpty((String)recipientPrintInfo.getCustomerZipCode()), (Object)StringUtils.trimToEmpty((String)recipientPrintInfo.getCustomerCity()), new Object[0]));
        } else if (recipientSet) {
            printRef = false;
            recipientLeftRow1 = StringUtils.trimToEmpty((String)recipientPrintInfo.getCustomerName1());
            recipientLeftRow2 = StringUtils.trimToEmpty((String)recipientPrintInfo.getCustomerName2());
            recipientLeftRow3 = StringUtils.trimToEmpty((String)Joiner.on((String)" ").skipNulls().join((Object)StringUtils.trimToEmpty((String)recipientPrintInfo.getCustomerStreet()), (Object)StringUtils.trimToEmpty((String)recipientPrintInfo.getCustomerStreetNo()), new Object[0]));
            recipientLeftRow4 = StringUtils.trimToEmpty((String)Joiner.on((String)" ").skipNulls().join((Object)StringUtils.trimToEmpty((String)recipientPrintInfo.getCustomerZipCode()), (Object)StringUtils.trimToEmpty((String)recipientPrintInfo.getCustomerCity()), new Object[0]));
            recipientRightRow1 = "";
            recipientRightRow2 = "";
            recipientRightRow3 = "";
            recipientRightRow4 = "";
        } else {
            printRef = false;
            recipientLeftRow1 = StringUtils.trimToEmpty((String)recipientRefPrintInfo.getCustomerName1());
            recipientLeftRow2 = StringUtils.trimToEmpty((String)recipientRefPrintInfo.getCustomerName2());
            recipientLeftRow3 = StringUtils.trimToEmpty((String)Joiner.on((String)" ").skipNulls().join((Object)StringUtils.trimToEmpty((String)recipientRefPrintInfo.getCustomerStreet()), (Object)StringUtils.trimToEmpty((String)recipientRefPrintInfo.getCustomerStreetNo()), new Object[0]));
            recipientLeftRow4 = StringUtils.trimToEmpty((String)Joiner.on((String)" ").skipNulls().join((Object)StringUtils.trimToEmpty((String)recipientRefPrintInfo.getCustomerZipCode()), (Object)StringUtils.trimToEmpty((String)recipientRefPrintInfo.getCustomerCity()), new Object[0]));
            recipientRightRow1 = "";
            recipientRightRow2 = "";
            recipientRightRow3 = "";
            recipientRightRow4 = "";
        }
        header1Builder.addRow(Row.builder().add((AbstractCell)InvoicePrintService.descriptionCell((int)7, (PDFont)fontRegular, (Color)TEXT_COLOR, (int)2, (int)2, (String)(senderRow1Left + "\n" + senderRow2))).add((AbstractCell)InvoicePrintService.descriptionCell((PrintSetup)printSetup, (PDFont)fontBold, (Color)TEXT_COLOR, (String)"Datum")).add((AbstractCell)InvoicePrintService.emptyCell((PrintSetup)printSetup)).build());
        LocalDate invoiceDate = printInfo.getInvoiceDate();
        String germanFullDate = null != invoiceDate ? DateTimeHelperService.germanFullDate((LocalDate)invoiceDate) : "";
        String dateAndPage = String.format("%s | Seite %s/%s", germanFullDate, page, pageCount);
        header1Builder.addRow(Row.builder().add((AbstractCell)InvoicePrintService.descriptionCell((PDFont)fontRegular, (int)printSetup.getDetailsFontSize(), (String)dateAndPage, (int)2, (int)1, (Color)TEXT_COLOR, (Color)DEFAULT_BG_COLOR_DETAILS, (HorizontalAlignment)HorizontalAlignment.LEFT, (Map)ImmutableMap.of())).build());
        header1Builder.addRow(Row.builder().fontSize(Integer.valueOf(1)).height(Float.valueOf(2.83f)).add((AbstractCell)InvoicePrintService.emptyCell((int)1, (int)4)).build());
        EInvoiceType invoiceType = printInfo.getInvoiceType();
        InvoiceNamePrintParam invoiceNamePrintParam = InvoiceNamePrintParam.of((InvoiceMetaData)printInfo.getPrimaryInvoiceData(), (Boolean)printInfo.isOptionCumulativePrint(), (Boolean)Boolean.TRUE);
        String invoiceTypeDE = (String)INVOICE_TYPE_NAME_NAMING.getOrDefault(invoiceType, i -> "<name fehlt>").apply((Object)invoiceNamePrintParam);
        header1Builder.addRow(Row.builder().add((AbstractCell)InvoicePrintService.emptyCell((PrintSetup)printSetup, (int)2)).add((AbstractCell)InvoicePrintService.descriptionCell((PDFont)fontBold, (int)printSetup.getHeaderFontSize(), (String)invoiceTypeDE, (int)2, (int)1, (Color)TEXT_COLOR, (Color)DEFAULT_BG_COLOR_DETAILS, (HorizontalAlignment)HorizontalAlignment.LEFT, (Map)ImmutableMap.of())).build());
        if ((Iterables.contains((Iterable)EInvoiceType.INVOICE_TYPE__COMMENT_PRINT, (Object)invoiceType) || printRef) && (StringUtils.isNotBlank((CharSequence)(invoiceTypeComment = StringUtils.trimToEmpty((String)printInfo.getPrimaryInvoiceData().getInvoiceTypeComment()))) || printRef)) {
            String invoiceRecipientLabel = printRef ? "Rechnungsempf\u00e4nger" : "";
            header1Builder.addRow(Row.builder().add((AbstractCell)InvoicePrintService.descriptionCell((PrintSetup)printSetup, (PDFont)fontBold, (Color)TEXT_COLOR, (String)"")).add((AbstractCell)InvoicePrintService.descriptionCell((PrintSetup)printSetup, (PDFont)fontBold, (Color)TEXT_COLOR, (String)invoiceRecipientLabel)).add((AbstractCell)InvoicePrintService.descriptionCell((PrintSetup)printSetup, (PDFont)fontRegular, (Color)TEXT_COLOR, (int)2, (String)invoiceTypeComment)).build());
        }
        String invoiceNumberName = INVOICE_TYPE_NUMBER_NAMING.getOrDefault(invoiceType, "<name fehlt>");
        header1Builder.addRow(Row.builder().add((AbstractCell)InvoicePrintService.descriptionCell((PrintSetup)printSetup, (PDFont)fontBold, (Color)TEXT_COLOR, (String)recipientLeftRow1)).add((AbstractCell)InvoicePrintService.descriptionCell((PrintSetup)printSetup, (PDFont)fontBold, (Color)TEXT_COLOR, (String)recipientRightRow1)).add((AbstractCell)InvoicePrintService.descriptionCell((PrintSetup)printSetup, (PDFont)fontBold, (Color)TEXT_COLOR, (String)invoiceNumberName)).add((AbstractCell)InvoicePrintService.descriptionCell((PrintSetup)printSetup, (PDFont)fontRegular, (Color)TEXT_COLOR, (String)printInfo.getInvoiceNumber())).build());
        String referenceInvoiceNumber = printInfo.getReferenceInvoiceNumber();
        String referenceTypeName = StringUtils.isNotBlank((CharSequence)referenceInvoiceNumber) ? INVOICE_TYPE_NUMBER_NAMING.getOrDefault(printInfo.getReferenceInvoiceType(), "") : "";
        header1Builder.addRow(Row.builder().add((AbstractCell)InvoicePrintService.descriptionCell((PrintSetup)printSetup, (PDFont)fontBold, (Color)TEXT_COLOR, (String)recipientLeftRow2)).add((AbstractCell)InvoicePrintService.descriptionCell((PrintSetup)printSetup, (PDFont)fontBold, (Color)TEXT_COLOR, (String)recipientRightRow2)).add((AbstractCell)InvoicePrintService.descriptionCell((PrintSetup)printSetup, (PDFont)fontBold, (Color)TEXT_COLOR, (String)referenceTypeName)).add((AbstractCell)InvoicePrintService.descriptionCell((PrintSetup)printSetup, (PDFont)fontRegular, (Color)TEXT_COLOR, (String)referenceInvoiceNumber)).build());
        header1Builder.addRow(Row.builder().add((AbstractCell)InvoicePrintService.descriptionCell((PrintSetup)printSetup, (PDFont)fontBold, (Color)TEXT_COLOR, (String)recipientLeftRow3)).add((AbstractCell)InvoicePrintService.descriptionCell((PrintSetup)printSetup, (PDFont)fontBold, (Color)TEXT_COLOR, (String)recipientRightRow3)).add((AbstractCell)InvoicePrintService.descriptionCell((PrintSetup)printSetup, (PDFont)fontBold, (Color)TEXT_COLOR, (String)"Interne Nummer")).add((AbstractCell)InvoicePrintService.descriptionCell((PrintSetup)printSetup, (PDFont)fontRegular, (Color)TEXT_COLOR, (String)printInfo.getInternalNumber())).build());
        header1Builder.addRow(Row.builder().add((AbstractCell)InvoicePrintService.descriptionCell((PrintSetup)printSetup, (PDFont)fontBold, (Color)TEXT_COLOR, (String)recipientLeftRow4)).add((AbstractCell)InvoicePrintService.descriptionCell((PrintSetup)printSetup, (PDFont)fontBold, (Color)TEXT_COLOR, (String)recipientRightRow4)).add((AbstractCell)InvoicePrintService.descriptionCell((PrintSetup)printSetup, (PDFont)fontBold, (Color)TEXT_COLOR, (String)"")).add((AbstractCell)InvoicePrintService.descriptionCell((PrintSetup)printSetup, (PDFont)fontRegular, (Color)TEXT_COLOR, (String)"")).build());
        header1Builder.addRow(Row.builder().add((AbstractCell)InvoicePrintService.emptyCell((PrintSetup)printSetup, (int)2)).add((AbstractCell)InvoicePrintService.descriptionCell((PrintSetup)printSetup, (PDFont)fontBold, (Color)TEXT_COLOR, (String)"Erstellt von")).add((AbstractCell)InvoicePrintService.descriptionCell((PrintSetup)printSetup, (PDFont)fontRegular, (Color)TEXT_COLOR, (String)printInfo.getPrimaryResponsibleUserFullName())).build());
        header1Builder.addRow(Row.builder().add((AbstractCell)InvoicePrintService.emptyCell((PrintSetup)printSetup, (int)2)).add((AbstractCell)InvoicePrintService.descriptionCell((PrintSetup)printSetup, (PDFont)fontBold, (Color)TEXT_COLOR, (String)"Ihre Kundennummer")).add((AbstractCell)InvoicePrintService.descriptionCell((PrintSetup)printSetup, (PDFont)fontRegular, (Color)TEXT_COLOR, (String)printInfo.getCustomerNumber())).build());
        header1Builder.addRow(Row.builder().fontSize(Integer.valueOf(1)).height(Float.valueOf(5.66f)).add((AbstractCell)InvoicePrintService.emptyCell((int)1, (int)4)).build());
        header1Builder.addRow(Row.builder().add((AbstractCell)InvoicePrintService.descriptionCell((PrintSetup)printSetup, (PDFont)fontBold, (Color)TEXT_COLOR, (int)2, (String)"Leistungszeitraum")).add((AbstractCell)InvoicePrintService.descriptionCell((PrintSetup)printSetup, (PDFont)fontBold, (Color)TEXT_COLOR, (String)"Bestelldatum")).add((AbstractCell)InvoicePrintService.emptyCell((PrintSetup)printSetup)).build());
        LocalDate projectExecutionStartDate = printInfo.getProjectExecutionStartDate();
        LocalDate projectExecutionEndDate = printInfo.getProjectExecutionEndDate();
        String projectExecutionStartDateString = null != projectExecutionStartDate ? DateTimeHelperService.germanDate((LocalDate)projectExecutionStartDate) : "";
        String projectExecutionEndDateString = null != projectExecutionEndDate ? DateTimeHelperService.germanDate((LocalDate)projectExecutionEndDate) : "";
        String projectExecutionPeriod = Joiner.on((String)" - ").skipNulls().join((Object)projectExecutionStartDateString, (Object)projectExecutionEndDateString, new Object[0]);
        String orderDate = this.dateAsString(printInfo.getOrderDate());
        header1Builder.addRow(Row.builder().add((AbstractCell)InvoicePrintService.descriptionCell((PrintSetup)printSetup, (PDFont)fontRegular, (Color)TEXT_COLOR, (int)2, (String)projectExecutionPeriod)).add((AbstractCell)InvoicePrintService.descriptionCell((PrintSetup)printSetup, (PDFont)fontRegular, (Color)TEXT_COLOR, (String)orderDate)).add((AbstractCell)InvoicePrintService.emptyCell((PrintSetup)printSetup)).build());
        header1Builder.addRow(Row.builder().fontSize(Integer.valueOf(1)).height(Float.valueOf(2.83f)).add((AbstractCell)InvoicePrintService.emptyCell((int)1, (int)4)).build());
        header1Builder.addRow(Row.builder().add((AbstractCell)InvoicePrintService.descriptionCell((PrintSetup)printSetup, (PDFont)fontBold, (Color)TEXT_COLOR, (int)2, (String)"Bauvorhaben")).add((AbstractCell)InvoicePrintService.descriptionCell((PrintSetup)printSetup, (PDFont)fontBold, (Color)TEXT_COLOR, (int)2, (String)"Bestellnummer")).build());
        header1Builder.addRow(Row.builder().add((AbstractCell)InvoicePrintService.descriptionCell((PrintSetup)printSetup, (PDFont)fontRegular, (Color)TEXT_COLOR, (int)2, (String)printInfo.getConstructionSite())).add((AbstractCell)InvoicePrintService.descriptionCell((PrintSetup)printSetup, (PDFont)fontRegular, (Color)TEXT_COLOR, (int)2, (String)printInfo.getOrderNumber())).build());
        header1Builder.addRow(Row.builder().fontSize(Integer.valueOf(1)).height(Float.valueOf(2.83f)).add((AbstractCell)InvoicePrintService.emptyCell((int)1, (int)4)).build());
        String contactPerson = StringUtils.trimToEmpty((String)printInfo.getContactPerson());
        boolean showContactPerson = StringUtils.isNotBlank((CharSequence)contactPerson);
        String contactPersonLabel = showContactPerson ? "Ansprechpartner" : "";
        header1Builder.addRow(Row.builder().add((AbstractCell)InvoicePrintService.descriptionCell((PrintSetup)printSetup, (PDFont)fontBold, (Color)TEXT_COLOR, (int)2, (String)"Kostenstelle")).add((AbstractCell)InvoicePrintService.descriptionCell((PrintSetup)printSetup, (PDFont)fontBold, (Color)TEXT_COLOR, (String)contactPersonLabel)).add((AbstractCell)InvoicePrintService.emptyCell((PrintSetup)printSetup)).build());
        header1Builder.addRow(Row.builder().add((AbstractCell)InvoicePrintService.descriptionCell((PrintSetup)printSetup, (PDFont)fontRegular, (Color)TEXT_COLOR, (int)2, (String)printInfo.getCostCenter())).add((AbstractCell)InvoicePrintService.descriptionCell((PrintSetup)printSetup, (PDFont)fontRegular, (Color)TEXT_COLOR, (String)contactPerson)).add((AbstractCell)InvoicePrintService.emptyCell((PrintSetup)printSetup)).build());
        header1Builder.addRow(Row.builder().fontSize(Integer.valueOf(1)).height(Float.valueOf(2.83f)).add((AbstractCell)InvoicePrintService.emptyCell((int)1, (int)4)).build());
        ImmutableList measurementNumbers = ImmutableList.copyOf((Iterable)printInfo.getMeasurementNumbers());
        String measurementText = Iterables.size((Iterable)measurementNumbers) > 1 ? "Aufma\u00dfe" : "Aufma\u00df";
        header1Builder.addRow(Row.builder().add((AbstractCell)InvoicePrintService.descriptionCell((PrintSetup)printSetup, (PDFont)fontBold, (Color)TEXT_COLOR, (int)2, (String)measurementText)).add((AbstractCell)InvoicePrintService.descriptionCell((PrintSetup)printSetup, (PDFont)fontBold, (Color)TEXT_COLOR, (int)2, (String)"Auftragsbezeichnung")).build());
        String measurementNumberString = Joiner.on((String)", ").skipNulls().join((Iterable)measurementNumbers);
        header1Builder.addRow(Row.builder().add((AbstractCell)InvoicePrintService.descriptionCell((PrintSetup)printSetup, (PDFont)fontRegular, (Color)TEXT_COLOR, (int)2, (String)measurementNumberString)).add((AbstractCell)InvoicePrintService.descriptionCell((PrintSetup)printSetup, (PDFont)fontRegular, (Color)TEXT_COLOR, (int)2, (String)printInfo.getOrderDescription())).build());
        String additionalInfoHeader1 = printInfo.getAdditionalInfoHeader1();
        if (StringUtils.isNotBlank((CharSequence)additionalInfoHeader1)) {
            header1Builder.addRow(Row.builder().add((AbstractCell)InvoicePrintService.descriptionCell((PrintSetup)printSetup, (PDFont)fontBold, (Color)TEXT_COLOR, (int)4, (String)additionalInfoHeader1)).build());
        }
        if (StringUtils.isNotBlank((CharSequence)(additionalInfoDetail1 = printInfo.getAdditionalInfoDetail1()))) {
            header1Builder.addRow(Row.builder().add((AbstractCell)InvoicePrintService.descriptionCell((PrintSetup)printSetup, (PDFont)fontRegular, (Color)TEXT_COLOR, (int)4, (String)additionalInfoDetail1)).build());
        }
        if (StringUtils.isNotBlank((CharSequence)(additionalInfoHeader2 = printInfo.getAdditionalInfoHeader2()))) {
            header1Builder.addRow(Row.builder().add((AbstractCell)InvoicePrintService.descriptionCell((PrintSetup)printSetup, (PDFont)fontBold, (Color)TEXT_COLOR, (int)4, (String)additionalInfoHeader2)).build());
        }
        if (StringUtils.isNotBlank((CharSequence)(additionalInfoDetail2 = printInfo.getAdditionalInfoDetail2()))) {
            header1Builder.addRow(Row.builder().add((AbstractCell)InvoicePrintService.descriptionCell((PrintSetup)printSetup, (PDFont)fontRegular, (Color)TEXT_COLOR, (int)4, (String)additionalInfoDetail2)).build());
        }
        header1Builder.addRow(Row.builder().fontSize(Integer.valueOf(1)).height(Float.valueOf(8.49f)).add((AbstractCell)InvoicePrintService.emptyCell((int)1, (int)4)).build());
        return header1Builder.build();
    }

    @Nonnull
    private String paymentConditions(@NonNull Integer financeTimeForPayment) {
        if (financeTimeForPayment == null) {
            throw new NullPointerException("financeTimeForPayment is marked non-null but is null");
        }
        return String.format("%s Tage ohne Abzug", financeTimeForPayment);
    }

    @Nonnull
    private String cashDiscount(@Nullable Integer financeCashDiscountTime, @Nullable BigDecimal financeCashDiscount) {
        if (null != financeCashDiscountTime && null != financeCashDiscount && financeCashDiscount.compareTo(BigDecimal.ZERO) != 0) {
            String discountAsString = PrintHelper.asString((BigDecimal)financeCashDiscount, (String)"0,00", (boolean)true);
            return String.format("%s Tage %s %%", financeCashDiscountTime, discountAsString);
        }
        return "";
    }

    @Nonnull
    private Table headersP2(@NonNull InvoicePrintInfo printInfo, @NonNull PrintConfiguration printConfiguration, @NonNull PDDocument document, @NonNull PrintSetup printSetup, @NonNull PDRectangle mediaBox, int page, int pageCount) throws IOException {
        if (printInfo == null) {
            throw new NullPointerException("printInfo is marked non-null but is null");
        }
        if (printConfiguration == null) {
            throw new NullPointerException("printConfiguration is marked non-null but is null");
        }
        if (document == null) {
            throw new NullPointerException("document is marked non-null but is null");
        }
        if (printSetup == null) {
            throw new NullPointerException("printSetup is marked non-null but is null");
        }
        if (mediaBox == null) {
            throw new NullPointerException("mediaBox is marked non-null but is null");
        }
        PrintFonts printFonts = printSetup.getPrintFonts();
        byte[] logoBuffer = printSetup.getLogoBuffer();
        PDImageXObject pdImageXObject = PDImageXObject.createFromByteArray((PDDocument)document, (byte[])logoBuffer, (String)"");
        PDFont fontRegular = printFonts.getRegular();
        PDFont fontBold = printFonts.getBold();
        float header1Width = printSetup.getHeaderColumn1Width().floatValue();
        float header2Width = printSetup.getHeaderColumn2Width().floatValue();
        float header3Width = printSetup.getHeaderColumn3Width().floatValue();
        float header4Width = printSetup.getHeaderColumn4Width().floatValue();
        ImmutableList columnWidths = ImmutableList.of((Object)Float.valueOf(header1Width), (Object)Float.valueOf(header2Width), (Object)Float.valueOf(header3Width), (Object)Float.valueOf(header4Width));
        int columnCount = columnWidths.size();
        Table.TableBuilder headerBuilder = InvoicePrintService.table((Float)Float.valueOf(InvoicePrintService.maxWidth((PDRectangle)mediaBox)), (Iterable)columnWidths);
        headerBuilder.addRow(Row.builder().add((AbstractCell)((ImageCell.ImageCellBuilder)((ImageCell.ImageCellBuilder)((ImageCell.ImageCellBuilder)((ImageCell.ImageCellBuilder)((ImageCell.ImageCellBuilder)ImageCell.builder().horizontalAlignment(HorizontalAlignment.LEFT)).padding(0.0f)).paddingLeft(printSetup.getLogoPaddingLeft())).verticalAlignment(VerticalAlignment.MIDDLE)).image(pdImageXObject).maxHeight((float)printSetup.getLogoHeight()).borderWidth(0.0f)).build()).add((AbstractCell)InvoicePrintService.emptyCell((PrintSetup)printSetup, (int)3)).build());
        headerBuilder.addRow(Row.builder().fontSize(Integer.valueOf(1)).height(Float.valueOf(36.79f)).add((AbstractCell)InvoicePrintService.emptyCell((int)1, (int)4)).build());
        headerBuilder.addRow(Row.builder().add((AbstractCell)InvoicePrintService.emptyCell((PrintSetup)printSetup, (int)2)).add((AbstractCell)InvoicePrintService.descriptionCell((PrintSetup)printSetup, (PDFont)fontBold, (Color)TEXT_COLOR, (String)"Datum")).add((AbstractCell)InvoicePrintService.emptyCell((PrintSetup)printSetup, (int)1)).build());
        LocalDate invoiceDate = printInfo.getInvoiceDate();
        String germanFullDate = null != invoiceDate ? DateTimeHelperService.germanFullDate((LocalDate)invoiceDate) : "";
        String dateAndPage = String.format("%s | Seite %s/%s", germanFullDate, page, pageCount);
        headerBuilder.addRow(Row.builder().add((AbstractCell)InvoicePrintService.emptyCell((PrintSetup)printSetup, (int)2)).add((AbstractCell)InvoicePrintService.descriptionCell((PDFont)fontRegular, (int)printSetup.getDetailsFontSize(), (String)dateAndPage, (int)2, (int)1, (Color)TEXT_COLOR, (Color)DEFAULT_BG_COLOR_DETAILS, (HorizontalAlignment)HorizontalAlignment.LEFT, (Map)ImmutableMap.of())).build());
        headerBuilder.addRow(Row.builder().fontSize(Integer.valueOf(1)).height(Float.valueOf(2.83f)).add((AbstractCell)InvoicePrintService.emptyCell((int)1, (int)4)).build());
        EInvoiceType invoiceType = printInfo.getInvoiceType();
        String invoiceNumberName = INVOICE_TYPE_NUMBER_NAMING.getOrDefault(invoiceType, "<name fehlt>");
        headerBuilder.addRow(Row.builder().add((AbstractCell)InvoicePrintService.emptyCell((PrintSetup)printSetup, (int)2)).add((AbstractCell)InvoicePrintService.descriptionCell((PrintSetup)printSetup, (PDFont)fontRegular, (Color)TEXT_COLOR, (String)invoiceNumberName)).add((AbstractCell)InvoicePrintService.descriptionCell((PrintSetup)printSetup, (PDFont)fontRegular, (Color)TEXT_COLOR, (String)printInfo.getInvoiceNumber())).build());
        headerBuilder.addRow(Row.builder().fontSize(Integer.valueOf(1)).height(Float.valueOf(2.83f)).add((AbstractCell)InvoicePrintService.emptyCell((int)1, (int)4)).build());
        return headerBuilder.build();
    }

    protected static float printHeader(@Nonnull PDPageContentStream contentStream, @Nonnull PDPage page, @Nonnull Iterable<Table> headers) {
        PDRectangle mediaBox = page.getMediaBox();
        float yOffset = mediaBox.getHeight() - 48.11f;
        for (Table header : headers) {
            TableDrawer.builder().page(page).contentStream(contentStream).startX(70.75f).startY(yOffset).table(header).build().draw();
            yOffset -= header.getHeight();
        }
        return yOffset;
    }

    private float printFooter(@NonNull PDPageContentStream contentStream, @NonNull PDPage page, @NonNull Table footer) {
        if (contentStream == null) {
            throw new NullPointerException("contentStream is marked non-null but is null");
        }
        if (page == null) {
            throw new NullPointerException("page is marked non-null but is null");
        }
        if (footer == null) {
            throw new NullPointerException("footer is marked non-null but is null");
        }
        float footerHeight = footer.getHeight();
        float yOffset = 48.11f + footerHeight;
        TableDrawer.builder().page(page).contentStream(contentStream).startX(70.75f).startY(yOffset).table(footer).build().draw();
        return yOffset -= footer.getHeight();
    }

    @Nonnull
    private Table details(@NonNull InvoicePrintInfo printInfo, @NonNull PDRectangle mediaBox, @NonNull PrintSetup printSetup) {
        if (printInfo == null) {
            throw new NullPointerException("printInfo is marked non-null but is null");
        }
        if (mediaBox == null) {
            throw new NullPointerException("mediaBox is marked non-null but is null");
        }
        if (printSetup == null) {
            throw new NullPointerException("printSetup is marked non-null but is null");
        }
        PrintFonts printFonts = printSetup.getPrintFonts();
        PDFont fontRegular = printFonts.getRegular();
        PDFont fontBold = printFonts.getBold();
        Iterable printGroups = (Iterable)MoreObjects.firstNonNull((Object)printInfo.getPositionPrintGroups(), (Object)ImmutableList.of());
        ImmutableList columnWidths = ImmutableList.of((Object)Float.valueOf(0.1875f), (Object)Float.valueOf(0.34375f), (Object)Float.valueOf(0.125f), (Object)Float.valueOf(0.09375f), (Object)Float.valueOf(0.125f), (Object)Float.valueOf(0.15625f));
        int columnCount = Iterables.size((Iterable)columnWidths);
        Table.TableBuilder tableBuilder = InvoicePrintService.table((Float)Float.valueOf(InvoicePrintService.maxWidth((PDRectangle)mediaBox)), (Iterable)columnWidths);
        tableBuilder.addRow(this.hLineB(columnCount));
        Row headline1 = Row.builder().backgroundColor(DETAIL_BG_COLOR_HEADER).add((AbstractCell)InvoicePrintService.descriptionCell((PrintSetup)printSetup, (PDFont)fontBold, (Color)TEXT_COLOR, (String)"Positionsnummer")).add((AbstractCell)InvoicePrintService.descriptionCell((PrintSetup)printSetup, (PDFont)fontBold, (Color)TEXT_COLOR, (String)"Bezeichnung")).add((AbstractCell)InvoicePrintService.descriptionCell((PrintSetup)printSetup, (PDFont)fontBold, (Color)TEXT_COLOR, (String)"Menge", (HorizontalAlignment)HorizontalAlignment.RIGHT)).add((AbstractCell)InvoicePrintService.descriptionCell((PrintSetup)printSetup, (PDFont)fontBold, (Color)TEXT_COLOR, (String)"Einheit", (HorizontalAlignment)HorizontalAlignment.LEFT)).add((AbstractCell)InvoicePrintService.descriptionCell((PrintSetup)printSetup, (PDFont)fontBold, (Color)TEXT_COLOR, (String)"EP in EUR", (HorizontalAlignment)HorizontalAlignment.RIGHT)).add((AbstractCell)InvoicePrintService.descriptionCell((PrintSetup)printSetup, (PDFont)fontBold, (Color)TEXT_COLOR, (String)"GP in EUR", (HorizontalAlignment)HorizontalAlignment.RIGHT)).build();
        tableBuilder.addRow(headline1);
        tableBuilder.addRow(this.hLineT(columnCount));
        for (InvoicePositionPrintGroup printGroup : printGroups) {
            Iterable positionPrintRowsUnsorted = printGroup.getRows();
            ImmutableList positionPrintRowsSorted = (ImmutableList)Streams.stream((Iterable)positionPrintRowsUnsorted).sorted(Comparator.comparing(InvoicePositionPrintRow::getPositionNumber, Comparator.nullsLast(Comparator.naturalOrder()))).collect(ImmutableList.toImmutableList());
            for (InvoicePositionPrintRow item : positionPrintRowsSorted) {
                BigDecimal product = item.getProduct();
                String unit = item.getUnit();
                String amount = PrintHelper.asString((BigDecimal)product, (String)"", (boolean)true);
                String pricePerUnit = PrintHelper.asString((BigDecimal)item.getPricePerUnit(), (String)"", (boolean)true);
                String priceSum = PrintHelper.asString((BigDecimal)item.getPriceAggregated(), (String)"", (boolean)true);
                String positionNumber = item.getPositionNumber();
                String shortText = item.getShortText();
                Color bg = DEFAULT_BG_COLOR_DETAILS;
                Row detail = Row.builder().backgroundColor(DETAIL_BG_COLOR_HEADER).add((AbstractCell)InvoicePrintService.descriptionCell((PrintSetup)printSetup, (PDFont)fontRegular, (Color)TEXT_COLOR, (Color)bg, (String)positionNumber, (HorizontalAlignment)HorizontalAlignment.LEFT)).add((AbstractCell)InvoicePrintService.descriptionCell((PrintSetup)printSetup, (PDFont)fontRegular, (Color)TEXT_COLOR, (Color)bg, (String)shortText, (HorizontalAlignment)HorizontalAlignment.LEFT)).add((AbstractCell)InvoicePrintService.descriptionCell((PrintSetup)printSetup, (PDFont)fontRegular, (Color)TEXT_COLOR, (Color)bg, (String)amount, (HorizontalAlignment)HorizontalAlignment.RIGHT)).add((AbstractCell)InvoicePrintService.descriptionCell((PrintSetup)printSetup, (PDFont)fontRegular, (Color)TEXT_COLOR, (Color)bg, (String)unit, (HorizontalAlignment)HorizontalAlignment.LEFT)).add((AbstractCell)InvoicePrintService.descriptionCell((PrintSetup)printSetup, (PDFont)fontRegular, (Color)TEXT_COLOR, (Color)bg, (String)pricePerUnit, (HorizontalAlignment)HorizontalAlignment.RIGHT)).add((AbstractCell)InvoicePrintService.descriptionCell((PrintSetup)printSetup, (PDFont)fontRegular, (Color)TEXT_COLOR, (Color)bg, (String)priceSum, (HorizontalAlignment)HorizontalAlignment.RIGHT)).build();
                tableBuilder.addRow(detail);
            }
            tableBuilder.addRow(this.hLineB(Iterables.size((Iterable)columnWidths)));
            if (!printGroup.isPrintAsGroup()) continue;
            String title = PrintHelper.addendumName((InvoicePositionPrintGroup)printGroup, (InvoicePrintInfo)printInfo);
            String priceSum = PrintHelper.asString((BigDecimal)printGroup.getPriceAggregated(), (String)"", (boolean)true);
            Row aggregationRow1 = Row.builder().backgroundColor(DETAIL_BG_COLOR_HEADER).add((AbstractCell)InvoicePrintService.descriptionCell((PrintSetup)printSetup, (PDFont)fontRegular, (Color)TEXT_COLOR, (int)(columnCount - 1), (String)title, (HorizontalAlignment)HorizontalAlignment.RIGHT)).add((AbstractCell)InvoicePrintService.descriptionCell((PrintSetup)printSetup, (PDFont)fontRegular, (Color)TEXT_COLOR, (int)1, (String)priceSum, (HorizontalAlignment)HorizontalAlignment.RIGHT)).build();
            tableBuilder.addRow(aggregationRow1);
            tableBuilder.addRow(this.hLineB(Iterables.size((Iterable)columnWidths)));
            Row blankRow = Row.builder().backgroundColor(DETAIL_BG_COLOR_HEADER).add((AbstractCell)InvoicePrintService.descriptionCell((PrintSetup)printSetup, (PDFont)fontRegular, (Color)TEXT_COLOR, (int)columnCount, (String)"", (HorizontalAlignment)HorizontalAlignment.LEFT)).build();
            tableBuilder.addRow(blankRow);
        }
        tableBuilder.addRow(Row.builder().backgroundColor(DETAIL_BG_COLOR_HEADER).add((AbstractCell)InvoicePrintService.emptyCell((PrintSetup)printSetup, (int)columnCount)).build());
        return tableBuilder.build();
    }

    @Nonnull
    private Table groupPrices(@NonNull InvoicePrintInfo printInfo, @NonNull PDRectangle mediaBox, @NonNull PrintSetup printSetup) {
        if (printInfo == null) {
            throw new NullPointerException("printInfo is marked non-null but is null");
        }
        if (mediaBox == null) {
            throw new NullPointerException("mediaBox is marked non-null but is null");
        }
        if (printSetup == null) {
            throw new NullPointerException("printSetup is marked non-null but is null");
        }
        Iterable printGroups = (Iterable)MoreObjects.firstNonNull((Object)printInfo.getPositionPrintGroups(), (Object)ImmutableList.of());
        Iterable distinctAddendumNumbers = (Iterable)Streams.stream((Iterable)printGroups).map(InvoicePositionPrintGroup::getAddendumNumber).distinct().collect(ImmutableSet.toImmutableSet());
        ImmutableList columnWidths = ImmutableList.of((Object)Float.valueOf(0.59375f), (Object)Float.valueOf(0.09375f), (Object)Float.valueOf(0.09375f), (Object)Float.valueOf(0.09375f), (Object)Float.valueOf(0.15625f));
        int columnAmount = Iterables.size((Iterable)columnWidths);
        Table.TableBuilder tableBuilder = InvoicePrintService.table((Float)Float.valueOf(InvoicePrintService.maxWidth((PDRectangle)mediaBox)), (Iterable)columnWidths);
        if (Iterables.size((Iterable)distinctAddendumNumbers) > 1) {
            for (InvoicePositionPrintGroup printGroup : printGroups) {
                Iterable rows = printGroup.getRows();
                if (Iterables.isEmpty((Iterable)rows)) continue;
                BigDecimal sumNet = printGroup.getPriceAggregated();
                String title = PrintHelper.addendumName((InvoicePositionPrintGroup)printGroup, (InvoicePrintInfo)printInfo);
                Row sumNetRow = Row.builder().backgroundColor(DETAIL_BG_COLOR_HEADER).add((AbstractCell)InvoicePrintService.descriptionCell((PrintSetup)printSetup, (Color)TEXT_COLOR, (int)(columnAmount - 2), (String)title, (HorizontalAlignment)HorizontalAlignment.RIGHT)).add((AbstractCell)InvoicePrintService.descriptionCell((PrintSetup)printSetup, (Color)TEXT_COLOR, (String)"", (HorizontalAlignment)HorizontalAlignment.RIGHT)).add((AbstractCell)InvoicePrintService.descriptionCell((PrintSetup)printSetup, (Color)TEXT_COLOR, (String)PrintHelper.asString((BigDecimal)sumNet, (String)"", (boolean)true), (HorizontalAlignment)HorizontalAlignment.RIGHT)).build();
                tableBuilder.addRow(sumNetRow);
            }
            tableBuilder.addRow(this.hLineB(5));
        }
        return tableBuilder.build();
    }

    @Nonnull
    private Table summarization(@NonNull InvoicePrintInfo printInfo, @NonNull PDRectangle mediaBox, @NonNull PrintSetup printSetup) {
        if (printInfo == null) {
            throw new NullPointerException("printInfo is marked non-null but is null");
        }
        if (mediaBox == null) {
            throw new NullPointerException("mediaBox is marked non-null but is null");
        }
        if (printSetup == null) {
            throw new NullPointerException("printSetup is marked non-null but is null");
        }
        boolean isCumulative = printInfo.isOptionCumulativePrint();
        if (isCumulative) {
            return this.summarizationCumulative(printInfo, mediaBox, printSetup);
        }
        return this.summarizationNonCumulative(printInfo, mediaBox, printSetup);
    }

    @Nonnull
    private Table summarizationCumulative(@NonNull InvoicePrintInfo printInfo, @NonNull PDRectangle mediaBox, @NonNull PrintSetup printSetup) {
        if (printInfo == null) {
            throw new NullPointerException("printInfo is marked non-null but is null");
        }
        if (mediaBox == null) {
            throw new NullPointerException("mediaBox is marked non-null but is null");
        }
        if (printSetup == null) {
            throw new NullPointerException("printSetup is marked non-null but is null");
        }
        ImmutableList columnWidths = ImmutableList.of((Object)Float.valueOf(0.59375f), (Object)Float.valueOf(0.09375f), (Object)Float.valueOf(0.09375f), (Object)Float.valueOf(0.09375f), (Object)Float.valueOf(0.15625f));
        int columnAmount = Iterables.size((Iterable)columnWidths);
        Table.TableBuilder tableBuilder = InvoicePrintService.table((Float)Float.valueOf(InvoicePrintService.maxWidth((PDRectangle)mediaBox)), (Iterable)columnWidths);
        BigDecimal vat = (BigDecimal)MoreObjects.firstNonNull((Object)printInfo.getVatPercent(), (Object)BigDecimal.ZERO);
        BigDecimal totalValueNetPrimary = printInfo.getTotalValueNet();
        BigDecimal vatValuePrimary = printInfo.getVatValue();
        BigDecimal totalValueGrossPrimary = printInfo.getTotalValueGross();
        BigDecimal warrantySecurityRetentionPercentPrimary = printInfo.getWarrantySecurityRetentionPercent();
        BigDecimal totalValueNetSecondary = Streams.stream((Iterable)printInfo.getSecondaryInvoicesData()).map(InvoiceMetaData::getTotalValueNet).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal vatValueSecondary = Streams.stream((Iterable)printInfo.getSecondaryInvoicesData()).map(InvoiceMetaData::getVatValue).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal totalValueGrossSecondary = Streams.stream((Iterable)printInfo.getSecondaryInvoicesData()).map(InvoiceMetaData::getTotalValueGross).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal warrantySecurityRetentionValueSecondary = Streams.stream((Iterable)printInfo.getSecondaryInvoicesData()).map(InvoiceMetaData::getWarrantySecurityRetentionValue).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal fulfillmentSecurityRetentionValueSecondary = Streams.stream((Iterable)printInfo.getSecondaryInvoicesData()).map(InvoiceMetaData::getFulfillmentSecurityRetentionValue).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal sumNetCumulative = totalValueNetPrimary.add(totalValueNetSecondary);
        BigDecimal sumVATCumulative = vatValuePrimary.add(vatValueSecondary);
        BigDecimal sumGrossCumulative = totalValueGrossPrimary.add(totalValueGrossSecondary);
        BigDecimal totalWarrantySecurityRetention = sumNetCumulative.multiply(warrantySecurityRetentionPercentPrimary).divide(BigDecimal.valueOf(100L), 2, RoundingMode.HALF_UP).negate();
        BigDecimal totalValueGrossWithWarrantySecurityRetention = sumGrossCumulative.add(totalWarrantySecurityRetention);
        Row sumNetRow = Row.builder().backgroundColor(DETAIL_BG_COLOR_HEADER).add((AbstractCell)InvoicePrintService.descriptionCell((PrintSetup)printSetup, (Color)TEXT_COLOR, (int)(columnAmount - 2), (String)"Netto", (HorizontalAlignment)HorizontalAlignment.RIGHT)).add((AbstractCell)InvoicePrintService.descriptionCell((PrintSetup)printSetup, (Color)TEXT_COLOR, (String)"", (HorizontalAlignment)HorizontalAlignment.RIGHT)).add((AbstractCell)InvoicePrintService.descriptionCell((PrintSetup)printSetup, (Color)TEXT_COLOR, (String)PrintHelper.asString((BigDecimal)sumNetCumulative, (String)"", (boolean)true), (HorizontalAlignment)HorizontalAlignment.RIGHT)).build();
        tableBuilder.addRow(sumNetRow);
        Row sumVATRow = Row.builder().backgroundColor(DETAIL_BG_COLOR_HEADER).add((AbstractCell)InvoicePrintService.descriptionCell((PrintSetup)printSetup, (Color)TEXT_COLOR, (int)(columnAmount - 2), (String)"Umsatzsteuer", (HorizontalAlignment)HorizontalAlignment.RIGHT)).add((AbstractCell)InvoicePrintService.descriptionCell((PrintSetup)printSetup, (Color)TEXT_COLOR, (String)String.format("%s %%", PrintHelper.asString((BigDecimal)vat, (String)"", (boolean)true)), (HorizontalAlignment)HorizontalAlignment.RIGHT)).add((AbstractCell)InvoicePrintService.descriptionCell((PrintSetup)printSetup, (Color)TEXT_COLOR, (String)PrintHelper.asString((BigDecimal)sumVATCumulative, (String)"", (boolean)true), (HorizontalAlignment)HorizontalAlignment.RIGHT)).build();
        tableBuilder.addRow(sumVATRow);
        tableBuilder.addRow(this.hLineB((Iterable)ImmutableList.of((Object)Pair.of((Object)1, (Object)false), (Object)Pair.of((Object)4, (Object)true))));
        Boolean flagSecurityRetention = printInfo.getFlagSecurityRetention();
        boolean anySecRet = false;
        if (flagSecurityRetention.booleanValue()) {
            if (fulfillmentSecurityRetentionValueSecondary.compareTo(BigDecimal.ZERO) != 0 || warrantySecurityRetentionValueSecondary.compareTo(BigDecimal.ZERO) != 0) {
                Row warrantySecurityRetentionPercentRow = Row.builder().backgroundColor(DETAIL_BG_COLOR_HEADER).add((AbstractCell)InvoicePrintService.descriptionCell((PrintSetup)printSetup, (Color)TEXT_COLOR, (int)(columnAmount - 2), (String)"Gew\u00e4hrleistungssicherheitseinbehalt", (HorizontalAlignment)HorizontalAlignment.RIGHT)).add((AbstractCell)InvoicePrintService.descriptionCell((PrintSetup)printSetup, (Color)TEXT_COLOR, (String)PrintHelper.asPercentage((BigDecimal)warrantySecurityRetentionPercentPrimary, (String)"", (boolean)true), (HorizontalAlignment)HorizontalAlignment.RIGHT)).add((AbstractCell)InvoicePrintService.descriptionCell((PrintSetup)printSetup, (Color)TEXT_COLOR, (String)PrintHelper.asString((BigDecimal)totalWarrantySecurityRetention, (String)"", (boolean)true), (HorizontalAlignment)HorizontalAlignment.RIGHT)).build();
                tableBuilder.addRow(warrantySecurityRetentionPercentRow);
            }
            anySecRet = true;
        }
        String invoiceAmountLabel = "Zwischensumme m. SB";
        Row sumGrossRow = Row.builder().backgroundColor(DETAIL_BG_COLOR_HEADER).add((AbstractCell)InvoicePrintService.descriptionCell((PrintSetup)printSetup, (Color)TEXT_COLOR, (int)(columnAmount - 2), (String)"Zwischensumme m. SB", (HorizontalAlignment)HorizontalAlignment.RIGHT)).add((AbstractCell)InvoicePrintService.descriptionCell((PrintSetup)printSetup, (Color)TEXT_COLOR, (String)"", (HorizontalAlignment)HorizontalAlignment.RIGHT)).add((AbstractCell)InvoicePrintService.descriptionCell((PrintSetup)printSetup, (Color)TEXT_COLOR, (String)PrintHelper.asString((BigDecimal)totalValueGrossWithWarrantySecurityRetention, (String)"", (boolean)true), (HorizontalAlignment)HorizontalAlignment.RIGHT)).build();
        tableBuilder.addRow(sumGrossRow);
        return tableBuilder.build();
    }

    @Nonnull
    private Table summarizationNonCumulative(@NonNull InvoicePrintInfo printInfo, @NonNull PDRectangle mediaBox, @NonNull PrintSetup printSetup) {
        String invoiceDueValueGrossName;
        Iterable invoiceSupplementsMetaData;
        boolean hasAddendumDiscount;
        if (printInfo == null) {
            throw new NullPointerException("printInfo is marked non-null but is null");
        }
        if (mediaBox == null) {
            throw new NullPointerException("mediaBox is marked non-null but is null");
        }
        if (printSetup == null) {
            throw new NullPointerException("printSetup is marked non-null but is null");
        }
        PDFont fontBold = printSetup.getPrintFonts().getBold();
        PDFont fontRegular = printSetup.getPrintFonts().getRegular();
        Boolean flagSecurityRetention = printInfo.getFlagSecurityRetention();
        EInvoiceType invoiceType = printInfo.getInvoiceType();
        BigDecimal warrantySecurityRetentionPercent = (BigDecimal)MoreObjects.firstNonNull((Object)printInfo.getWarrantySecurityRetentionPercent(), (Object)BigDecimal.ZERO);
        BigDecimal warrantySecurityRetentionValue = (BigDecimal)MoreObjects.firstNonNull((Object)printInfo.getWarrantySecurityRetentionValue(), (Object)BigDecimal.ZERO);
        BigDecimal fulfillmentSecurityRetentionPercent = printInfo.getFulfillmentSecurityRetentionPercent();
        BigDecimal fulfillmentSecurityRetentionValue = printInfo.getFulfillmentSecurityRetentionValue();
        BigDecimal cumulativeFulfillmentSecurityRetentionValue = printInfo.getFulfillmentSecurityRetentionCumulativeValue();
        boolean anySecRet = flagSecurityRetention != false && (warrantySecurityRetentionValue.compareTo(BigDecimal.ZERO) != 0 || fulfillmentSecurityRetentionValue.compareTo(BigDecimal.ZERO) != 0 || cumulativeFulfillmentSecurityRetentionValue.compareTo(BigDecimal.ZERO) != 0);
        ImmutableList columnWidths = ImmutableList.of((Object)Float.valueOf(0.46875f), (Object)Float.valueOf(0.125f), (Object)Float.valueOf(0.15625f), (Object)Float.valueOf(0.09375f), (Object)Float.valueOf(0.15625f));
        int columnAmount = Iterables.size((Iterable)columnWidths);
        BigDecimal totalValueNet = printInfo.getTotalValueNet();
        BigDecimal vatPercent = (BigDecimal)MoreObjects.firstNonNull((Object)printInfo.getVatPercent(), (Object)BigDecimal.ZERO);
        BigDecimal vatValue = printInfo.getVatValue();
        BigDecimal totalValueGross = printInfo.getTotalValueGross();
        BigDecimal subtotalWithoutDiscountValueNet = (BigDecimal)MoreObjects.firstNonNull((Object)printInfo.getSubtotalWithoutDiscountValueNet(), (Object)BigDecimal.ZERO);
        BigDecimal subtotalWithDiscountValueNet = (BigDecimal)MoreObjects.firstNonNull((Object)printInfo.getSubtotalWithDiscountValueNet(), (Object)BigDecimal.ZERO);
        boolean totalNetEqualsSubtotalWithDiscountNet = totalValueNet.compareTo(subtotalWithDiscountValueNet) == 0;
        Table.TableBuilder tableBuilder = InvoicePrintService.table((Float)Float.valueOf(InvoicePrintService.maxWidth((PDRectangle)mediaBox)), (Iterable)columnWidths);
        Row subtotalWithoutDiscountValueNetRow = Row.builder().backgroundColor(DETAIL_BG_COLOR_HEADER).add((AbstractCell)InvoicePrintService.descriptionCell((PrintSetup)printSetup, (Color)TEXT_COLOR, (int)(columnAmount - 2), (String)"Summe", (HorizontalAlignment)HorizontalAlignment.RIGHT)).add((AbstractCell)InvoicePrintService.descriptionCell((PrintSetup)printSetup, (Color)TEXT_COLOR, (String)"", (HorizontalAlignment)HorizontalAlignment.RIGHT)).add((AbstractCell)InvoicePrintService.descriptionCell((PrintSetup)printSetup, (Color)TEXT_COLOR, (String)PrintHelper.asString((BigDecimal)subtotalWithoutDiscountValueNet, (String)"", (boolean)true), (HorizontalAlignment)HorizontalAlignment.RIGHT)).build();
        tableBuilder.addRow(subtotalWithoutDiscountValueNetRow);
        tableBuilder.addRow(this.hLineB((Iterable)ImmutableList.of((Object)Pair.of((Object)1, (Object)false), (Object)Pair.of((Object)4, (Object)true))));
        Iterable addendumDiscountsMetaData = printInfo.getAddendumDiscountsMetaData();
        boolean bl = hasAddendumDiscount = !Iterables.isEmpty((Iterable)addendumDiscountsMetaData) && Streams.stream((Iterable)addendumDiscountsMetaData).anyMatch(item -> BigDecimal.ZERO.compareTo(item.getPercent()) != 0 && BigDecimal.ZERO.compareTo(item.getDiscountableValueNet()) != 0);
        if (hasAddendumDiscount) {
            ArrayList addendumDiscountRows1st = com.google.common.collect.Lists.newArrayList();
            ArrayList addendumDiscountRows2nd = com.google.common.collect.Lists.newArrayList();
            for (InvoiceAddendumDiscountMetaData addendumDiscountsMetaDatum : addendumDiscountsMetaData) {
                String row2Name;
                long addendumNumber = addendumDiscountsMetaDatum.getAddendumNumber();
                BigDecimal discountableValueNet = addendumDiscountsMetaDatum.getDiscountableValueNet();
                BigDecimal percent = addendumDiscountsMetaDatum.getPercent();
                BigDecimal valueNet = addendumDiscountsMetaDatum.getValueNet();
                boolean isNegative = percent.compareTo(BigDecimal.ZERO) < 0;
                String discountName = isNegative ? "Zuschlag" : "Nachlass";
                String discountOrAdditionLabel = isNegative ? "Zuschlagsf\u00e4hige" : "Rabattierf\u00e4hige";
                BigDecimal percentAbs = percent.abs();
                String row1Name = addendumNumber == 0L ? "%s Summe Auftrag".formatted(discountOrAdditionLabel) : "%s Summe NT %s".formatted(discountOrAdditionLabel, addendumNumber);
                String string = row2Name = addendumNumber == 0L ? "%s aus Auftrag".formatted(discountName) : "%s aus NT %s".formatted(discountName, addendumNumber);
                if (percentAbs.compareTo(BigDecimal.ZERO) == 0 || discountableValueNet.compareTo(BigDecimal.ZERO) == 0) continue;
                Row addendumDiscountRow1 = Row.builder().backgroundColor(DETAIL_BG_COLOR_HEADER).add((AbstractCell)InvoicePrintService.descriptionCell((PrintSetup)printSetup, (Color)TEXT_COLOR, (int)(columnAmount - 2), (String)row1Name, (HorizontalAlignment)HorizontalAlignment.RIGHT)).add((AbstractCell)InvoicePrintService.descriptionCell((PrintSetup)printSetup, (Color)TEXT_COLOR, (String)"", (HorizontalAlignment)HorizontalAlignment.RIGHT)).add((AbstractCell)InvoicePrintService.descriptionCell((PrintSetup)printSetup, (Color)TEXT_COLOR, (String)PrintHelper.asString((BigDecimal)discountableValueNet, (String)"", (boolean)true), (HorizontalAlignment)HorizontalAlignment.RIGHT)).build();
                addendumDiscountRows1st.add(addendumDiscountRow1);
                Row addendumDiscountRow2 = Row.builder().backgroundColor(DETAIL_BG_COLOR_HEADER).add((AbstractCell)InvoicePrintService.descriptionCell((PrintSetup)printSetup, (Color)TEXT_COLOR, (int)(columnAmount - 2), (String)row2Name, (HorizontalAlignment)HorizontalAlignment.RIGHT)).add((AbstractCell)InvoicePrintService.descriptionCell((PrintSetup)printSetup, (Color)TEXT_COLOR, (String)PrintHelper.asPercentage((BigDecimal)percentAbs, (String)"", (boolean)true), (HorizontalAlignment)HorizontalAlignment.RIGHT)).add((AbstractCell)InvoicePrintService.descriptionCell((PrintSetup)printSetup, (Color)TEXT_COLOR, (String)PrintHelper.asString((BigDecimal)valueNet, (String)"", (boolean)true), (HorizontalAlignment)HorizontalAlignment.RIGHT)).build();
                addendumDiscountRows2nd.add(addendumDiscountRow2);
            }
            addendumDiscountRows1st.forEach(arg_0 -> ((Table.TableBuilder)tableBuilder).addRow(arg_0));
            addendumDiscountRows2nd.forEach(arg_0 -> ((Table.TableBuilder)tableBuilder).addRow(arg_0));
            if (!totalNetEqualsSubtotalWithDiscountNet) {
                Row subTotalWithDiscountValueNetRow = Row.builder().backgroundColor(DETAIL_BG_COLOR_HEADER).add((AbstractCell)InvoicePrintService.descriptionCell((PrintSetup)printSetup, (Color)TEXT_COLOR, (int)(columnAmount - 2), (String)"Zwischensumme", (HorizontalAlignment)HorizontalAlignment.RIGHT)).add((AbstractCell)InvoicePrintService.descriptionCell((PrintSetup)printSetup, (Color)TEXT_COLOR, (String)"", (HorizontalAlignment)HorizontalAlignment.RIGHT)).add((AbstractCell)InvoicePrintService.descriptionCell((PrintSetup)printSetup, (Color)TEXT_COLOR, (String)PrintHelper.asString((BigDecimal)subtotalWithDiscountValueNet, (String)"", (boolean)true), (HorizontalAlignment)HorizontalAlignment.RIGHT)).build();
                tableBuilder.addRow(subTotalWithDiscountValueNetRow);
                tableBuilder.addRow(this.hLineB((Iterable)ImmutableList.of((Object)Pair.of((Object)1, (Object)false), (Object)Pair.of((Object)4, (Object)true))));
            }
        }
        if (!Iterables.isEmpty((Iterable)(invoiceSupplementsMetaData = printInfo.getInvoiceSupplementsMetaData()))) {
            for (InvoiceSupplementMetaData invoiceSupplementsMetaDatum : invoiceSupplementsMetaData) {
                String name = invoiceSupplementsMetaDatum.getName();
                BigDecimal percent = invoiceSupplementsMetaDatum.getPercent();
                BigDecimal value = invoiceSupplementsMetaDatum.getValue();
                Row addendumDiscountRow1 = Row.builder().backgroundColor(DETAIL_BG_COLOR_HEADER).add((AbstractCell)InvoicePrintService.descriptionCell((PrintSetup)printSetup, (Color)TEXT_COLOR, (int)(columnAmount - 2), (String)name, (HorizontalAlignment)HorizontalAlignment.RIGHT)).add((AbstractCell)InvoicePrintService.descriptionCell((PrintSetup)printSetup, (Color)TEXT_COLOR, (String)PrintHelper.asPercentage((BigDecimal)percent, (String)"", (boolean)true), (HorizontalAlignment)HorizontalAlignment.RIGHT)).add((AbstractCell)InvoicePrintService.descriptionCell((PrintSetup)printSetup, (Color)TEXT_COLOR, (String)PrintHelper.asString((BigDecimal)value, (String)"", (boolean)true), (HorizontalAlignment)HorizontalAlignment.RIGHT)).build();
                tableBuilder.addRow(addendumDiscountRow1);
            }
            tableBuilder.addRow(this.hLineB((Iterable)ImmutableList.of((Object)Pair.of((Object)1, (Object)false), (Object)Pair.of((Object)4, (Object)true))));
        }
        Row totalValueNetRow = Row.builder().backgroundColor(DETAIL_BG_COLOR_HEADER).add((AbstractCell)InvoicePrintService.descriptionCell((PrintSetup)printSetup, (Color)TEXT_COLOR, (int)(columnAmount - 2), (String)"Netto", (HorizontalAlignment)HorizontalAlignment.RIGHT)).add((AbstractCell)InvoicePrintService.descriptionCell((PrintSetup)printSetup, (Color)TEXT_COLOR, (String)"", (HorizontalAlignment)HorizontalAlignment.RIGHT)).add((AbstractCell)InvoicePrintService.descriptionCell((PrintSetup)printSetup, (Color)TEXT_COLOR, (String)PrintHelper.asString((BigDecimal)totalValueNet, (String)"", (boolean)true), (HorizontalAlignment)HorizontalAlignment.RIGHT)).build();
        tableBuilder.addRow(totalValueNetRow);
        Row vatRow = Row.builder().backgroundColor(DETAIL_BG_COLOR_HEADER).add((AbstractCell)InvoicePrintService.descriptionCell((PrintSetup)printSetup, (Color)TEXT_COLOR, (int)(columnAmount - 2), (String)"Umsatzsteuer", (HorizontalAlignment)HorizontalAlignment.RIGHT)).add((AbstractCell)InvoicePrintService.descriptionCell((PrintSetup)printSetup, (Color)TEXT_COLOR, (String)PrintHelper.asPercentage((BigDecimal)vatPercent, (String)"", (boolean)true), (HorizontalAlignment)HorizontalAlignment.RIGHT)).add((AbstractCell)InvoicePrintService.descriptionCell((PrintSetup)printSetup, (Color)TEXT_COLOR, (String)PrintHelper.asString((BigDecimal)vatValue, (String)"", (boolean)true), (HorizontalAlignment)HorizontalAlignment.RIGHT)).build();
        tableBuilder.addRow(vatRow);
        if (flagSecurityRetention.booleanValue()) {
            Row totalValueGrossRow = Row.builder().backgroundColor(DETAIL_BG_COLOR_HEADER).add((AbstractCell)InvoicePrintService.descriptionCell((PrintSetup)printSetup, (Color)TEXT_COLOR, (int)(columnAmount - 2), (String)"Brutto", (HorizontalAlignment)HorizontalAlignment.RIGHT)).add((AbstractCell)InvoicePrintService.descriptionCell((PrintSetup)printSetup, (Color)TEXT_COLOR, (String)"", (HorizontalAlignment)HorizontalAlignment.RIGHT)).add((AbstractCell)InvoicePrintService.descriptionCell((PrintSetup)printSetup, (Color)TEXT_COLOR, (String)PrintHelper.asString((BigDecimal)totalValueGross, (String)"", (boolean)true), (HorizontalAlignment)HorizontalAlignment.RIGHT)).build();
            tableBuilder.addRow(totalValueGrossRow);
        }
        tableBuilder.addRow(this.hLineB((Iterable)ImmutableList.of((Object)Pair.of((Object)1, (Object)false), (Object)Pair.of((Object)4, (Object)true))));
        if (EInvoiceType.CREDIT_VOUCHER == invoiceType) {
            invoiceDueValueGrossName = this.INVOICE_TYPE_GROSS_NAME.getOrDefault(invoiceType, "n/a");
            Row invoiceDueValueGrossRow = Row.builder().backgroundColor(DETAIL_BG_COLOR_HEADER).add((AbstractCell)InvoicePrintService.descriptionCell((PrintSetup)printSetup, (Color)TEXT_COLOR, (int)(columnAmount - 2), (String)invoiceDueValueGrossName, (HorizontalAlignment)HorizontalAlignment.RIGHT)).add((AbstractCell)InvoicePrintService.descriptionCell((PrintSetup)printSetup, (Color)TEXT_COLOR, (String)"", (HorizontalAlignment)HorizontalAlignment.RIGHT)).add((AbstractCell)InvoicePrintService.descriptionCell((PrintSetup)printSetup, (Color)TEXT_COLOR, (String)PrintHelper.asString((BigDecimal)totalValueGross, (String)"", (boolean)true), (HorizontalAlignment)HorizontalAlignment.RIGHT)).build();
            tableBuilder.addRow(invoiceDueValueGrossRow);
        }
        if (flagSecurityRetention.booleanValue()) {
            if (warrantySecurityRetentionPercent.compareTo(BigDecimal.ZERO) != 0 || warrantySecurityRetentionValue.compareTo(BigDecimal.ZERO) != 0) {
                Row warrantySecurityRetentionPercentRow = Row.builder().backgroundColor(DETAIL_BG_COLOR_HEADER).add((AbstractCell)InvoicePrintService.descriptionCell((PrintSetup)printSetup, (Color)TEXT_COLOR, (int)(columnAmount - 2), (String)"Gew\u00e4hrleistungseinbehalt", (HorizontalAlignment)HorizontalAlignment.RIGHT)).add((AbstractCell)InvoicePrintService.descriptionCell((PrintSetup)printSetup, (Color)TEXT_COLOR, (String)PrintHelper.asPercentage((BigDecimal)warrantySecurityRetentionPercent, (String)"", (boolean)true), (HorizontalAlignment)HorizontalAlignment.RIGHT)).add((AbstractCell)InvoicePrintService.descriptionCell((PrintSetup)printSetup, (Color)TEXT_COLOR, (String)PrintHelper.asString((BigDecimal)warrantySecurityRetentionValue, (String)"", (boolean)true), (HorizontalAlignment)HorizontalAlignment.RIGHT)).build();
                tableBuilder.addRow(warrantySecurityRetentionPercentRow);
            }
            if (fulfillmentSecurityRetentionPercent.compareTo(BigDecimal.ZERO) != 0 || fulfillmentSecurityRetentionValue.compareTo(BigDecimal.ZERO) != 0) {
                Row fulfillmentSecurityRetentionPercentRow = Row.builder().backgroundColor(DETAIL_BG_COLOR_HEADER).add((AbstractCell)InvoicePrintService.descriptionCell((PrintSetup)printSetup, (Color)TEXT_COLOR, (int)(columnAmount - 2), (String)"Vertragserf\u00fcllungseinbehalt", (HorizontalAlignment)HorizontalAlignment.RIGHT)).add((AbstractCell)InvoicePrintService.descriptionCell((PrintSetup)printSetup, (Color)TEXT_COLOR, (String)PrintHelper.asPercentage((BigDecimal)fulfillmentSecurityRetentionPercent, (String)"", (boolean)true), (HorizontalAlignment)HorizontalAlignment.RIGHT)).add((AbstractCell)InvoicePrintService.descriptionCell((PrintSetup)printSetup, (Color)TEXT_COLOR, (String)PrintHelper.asString((BigDecimal)fulfillmentSecurityRetentionValue, (String)"", (boolean)true), (HorizontalAlignment)HorizontalAlignment.RIGHT)).build();
                tableBuilder.addRow(fulfillmentSecurityRetentionPercentRow);
            }
        }
        if (cumulativeFulfillmentSecurityRetentionValue.compareTo(BigDecimal.ZERO) != 0) {
            Row cumulativeFulfillmentSecurityRetentionRow = Row.builder().backgroundColor(DETAIL_BG_COLOR_HEADER).add((AbstractCell)InvoicePrintService.descriptionCell((PrintSetup)printSetup, (Color)TEXT_COLOR, (int)(columnAmount - 2), (String)"zushl. kumulierter Sicherheitseinbehalt", (HorizontalAlignment)HorizontalAlignment.RIGHT)).add((AbstractCell)InvoicePrintService.descriptionCell((PrintSetup)printSetup, (Color)TEXT_COLOR, (String)"", (HorizontalAlignment)HorizontalAlignment.RIGHT)).add((AbstractCell)InvoicePrintService.descriptionCell((PrintSetup)printSetup, (Color)TEXT_COLOR, (String)PrintHelper.asString((BigDecimal)cumulativeFulfillmentSecurityRetentionValue, (String)"", (boolean)true), (HorizontalAlignment)HorizontalAlignment.RIGHT)).build();
            tableBuilder.addRow(cumulativeFulfillmentSecurityRetentionRow);
        }
        if (anySecRet) {
            tableBuilder.addRow(this.hLineB((Iterable)ImmutableList.of((Object)Pair.of((Object)1, (Object)false), (Object)Pair.of((Object)4, (Object)true))));
        }
        invoiceDueValueGrossName = this.INVOICE_TYPE_PAYOUT_NAME.getOrDefault(invoiceType, "n/a");
        BigDecimal invoiceDueValueGross = printInfo.getInvoiceDueValueGross();
        PDFont fontToBeUsed = EInvoiceType.CREDIT_VOUCHER == invoiceType ? fontBold : fontRegular;
        Row invoiceDueValueGrossRow = Row.builder().backgroundColor(DETAIL_BG_COLOR_HEADER).add((AbstractCell)InvoicePrintService.descriptionCell((PrintSetup)printSetup, (PDFont)fontToBeUsed, (Color)TEXT_COLOR, (int)(columnAmount - 2), (String)invoiceDueValueGrossName, (HorizontalAlignment)HorizontalAlignment.RIGHT)).add((AbstractCell)InvoicePrintService.descriptionCell((PrintSetup)printSetup, (Color)TEXT_COLOR, (String)"", (HorizontalAlignment)HorizontalAlignment.RIGHT)).add((AbstractCell)InvoicePrintService.descriptionCell((PrintSetup)printSetup, (PDFont)fontToBeUsed, (Color)TEXT_COLOR, (String)PrintHelper.asString((BigDecimal)invoiceDueValueGross, (String)"", (boolean)true), (HorizontalAlignment)HorizontalAlignment.RIGHT)).build();
        tableBuilder.addRow(invoiceDueValueGrossRow);
        boolean isCumulative = printInfo.isOptionCumulativePrint();
        if (!isCumulative) {
            tableBuilder.addRow(this.hLineTB((Iterable)ImmutableList.of((Object)Pair.of((Object)1, (Object)false), (Object)Pair.of((Object)4, (Object)true))));
        }
        return tableBuilder.build();
    }

    @Nonnull
    private Table paymentConditions(@NonNull InvoicePrintInfo printInfo, @NonNull PDRectangle mediaBox, @NonNull PrintSetup printSetup) {
        if (printInfo == null) {
            throw new NullPointerException("printInfo is marked non-null but is null");
        }
        if (mediaBox == null) {
            throw new NullPointerException("mediaBox is marked non-null but is null");
        }
        if (printSetup == null) {
            throw new NullPointerException("printSetup is marked non-null but is null");
        }
        PrintFonts printFonts = printSetup.getPrintFonts();
        Integer financeTimeForPayment = printInfo.getFinanceTimeForPayment();
        Integer financeCashDiscountTime1 = printInfo.getFinanceCashDiscountTime1();
        BigDecimal financeCashDiscount1 = printInfo.getFinanceCashDiscount1();
        Integer financeCashDiscountTime2 = printInfo.getFinanceCashDiscountTime2();
        BigDecimal financeCashDiscount2 = printInfo.getFinanceCashDiscount2();
        String paymentConditionsR1 = this.paymentConditions(financeTimeForPayment);
        String paymentConditionsR2 = this.cashDiscount(financeCashDiscountTime1, financeCashDiscount1);
        String paymentConditionsR3 = this.cashDiscount(financeCashDiscountTime2, financeCashDiscount2);
        ImmutableList columnWidths = ImmutableList.of((Object)Float.valueOf(1.0f));
        Table.TableBuilder tableBuilder = InvoicePrintService.table((Float)Float.valueOf(InvoicePrintService.maxWidth((PDRectangle)mediaBox)), (Iterable)columnWidths);
        tableBuilder.addRow(Row.builder().add((AbstractCell)InvoicePrintService.descriptionCell((PrintSetup)printSetup, (PDFont)printFonts.getBold(), (Color)TEXT_COLOR, (String)"Zahlungsbedingungen")).build());
        tableBuilder.addRow(Row.builder().add((AbstractCell)InvoicePrintService.descriptionCell((PrintSetup)printSetup, (Color)TEXT_COLOR, (String)paymentConditionsR1)).build());
        if (StringUtils.isNotBlank((CharSequence)paymentConditionsR2)) {
            tableBuilder.addRow(Row.builder().add((AbstractCell)InvoicePrintService.descriptionCell((PrintSetup)printSetup, (Color)TEXT_COLOR, (String)paymentConditionsR2)).build());
        }
        if (StringUtils.isNotBlank((CharSequence)paymentConditionsR3)) {
            tableBuilder.addRow(Row.builder().add((AbstractCell)InvoicePrintService.descriptionCell((PrintSetup)printSetup, (Color)TEXT_COLOR, (String)paymentConditionsR3)).build());
        }
        if (EInvoiceType.CREDIT_VOUCHER != printInfo.getInvoiceType()) {
            tableBuilder.addRow(Row.builder().add((AbstractCell)InvoicePrintService.emptyCell((PrintSetup)printSetup)).build());
            tableBuilder.addRow(Row.builder().add((AbstractCell)InvoicePrintService.descriptionCell((PrintSetup)printSetup, (PDFont)printFonts.getBold(), (Color)TEXT_COLOR, (String)"HINWEIS")).build());
            tableBuilder.addRow(Row.builder().add((AbstractCell)InvoicePrintService.descriptionCell((PrintSetup)printSetup, (Color)TEXT_COLOR, (String)"Bitte beachten Sie bei \u00dcberweisungen die exakte Schreibweise unserer Firmierung.")).build());
            tableBuilder.addRow(Row.builder().add((AbstractCell)InvoicePrintService.descriptionCell((PrintSetup)printSetup, (PDFont)printFonts.getBold(), (Color)TEXT_COLOR, (String)printSetup.getCompanyBankName())).build());
            tableBuilder.addRow(Row.builder().add((AbstractCell)InvoicePrintService.descriptionCell((PrintSetup)printSetup, (Color)TEXT_COLOR, (String)"Ab dem 09.10.2025 ist dies gem\u00e4\u00df neuer VoP-Regelung f\u00fcr die Ausf\u00fchrung von Zahlungen zwingend erforderlich.")).build());
        }
        return tableBuilder.build();
    }

    @Nonnull
    private Optional<Table> secondaryInvoicesOverview(@NonNull InvoicePrintInfo printInfo, @NonNull InvoicePrintConfiguration printConfiguration, @NonNull PDRectangle mediaBox, @NonNull PrintSetup printSetup) {
        if (printInfo == null) {
            throw new NullPointerException("printInfo is marked non-null but is null");
        }
        if (printConfiguration == null) {
            throw new NullPointerException("printConfiguration is marked non-null but is null");
        }
        if (mediaBox == null) {
            throw new NullPointerException("mediaBox is marked non-null but is null");
        }
        if (printSetup == null) {
            throw new NullPointerException("printSetup is marked non-null but is null");
        }
        PrintFonts printFonts = printSetup.getPrintFonts();
        PDFont fontBold = printFonts.getBold();
        InvoiceMetaData primaryInvoiceData = printInfo.getPrimaryInvoiceData();
        Iterable secondaryInvoicesDataOriginal = printInfo.getSecondaryInvoicesData();
        Iterable secondaryInvoicesDataSorted = (Iterable)Streams.stream((Iterable)secondaryInvoicesDataOriginal).sorted(SECONDARY_INVOICE_COMPARATOR).collect(ImmutableList.toImmutableList());
        if (!Iterables.isEmpty((Iterable)secondaryInvoicesDataSorted)) {
            ImmutableList allInvoiceMeta = ImmutableList.builder().add((Object)primaryInvoiceData).addAll(secondaryInvoicesDataSorted).build();
            ImmutableList columnWidths = ImmutableList.of((Object)Float.valueOf(0.0625f), (Object)Float.valueOf(0.1875f), (Object)Float.valueOf(0.21875f), (Object)Float.valueOf(0.125f), (Object)Float.valueOf(0.09375f), (Object)Float.valueOf(0.1875f), (Object)Float.valueOf(0.125f));
            int columnAmount = Iterables.size((Iterable)columnWidths);
            Table.TableBuilder tableBuilder = InvoicePrintService.table((Float)Float.valueOf(InvoicePrintService.maxWidth((PDRectangle)mediaBox)), (Iterable)columnWidths);
            BigDecimal invoicesNetValueAll = Streams.stream((Iterable)allInvoiceMeta).map(InvoiceMetaData::getTotalValueNet).reduce(BigDecimal.ZERO, BigDecimal::add);
            String invoicesNetValueAllAsString = PrintHelper.asString((BigDecimal)invoicesNetValueAll, (String)"0,00", (boolean)true);
            BigDecimal invoicesVatValueAll = Streams.stream((Iterable)allInvoiceMeta).map(InvoiceMetaData::getVatValue).reduce(BigDecimal.ZERO, BigDecimal::add);
            String invoicesVatValueAllAsString = PrintHelper.asString((BigDecimal)invoicesVatValueAll, (String)"0,00", (boolean)true);
            BigDecimal invoicesGrossValueAll = Streams.stream((Iterable)allInvoiceMeta).map(InvoiceMetaData::getTotalValueGross).reduce(BigDecimal.ZERO, BigDecimal::add);
            String invoicesGrossValueAllAsString = PrintHelper.asString((BigDecimal)invoicesGrossValueAll, (String)"0,00", (boolean)true);
            BigDecimal warrantySecurityRetentionPercentPrimary = printInfo.getWarrantySecurityRetentionPercent();
            BigDecimal warrantySecurityRetentionValuePrimary = printInfo.getWarrantySecurityRetentionValue();
            BigDecimal fulfillmentSecurityRetentionValuePrimary = printInfo.getFulfillmentSecurityRetentionValue();
            BigDecimal totalValueNetPrimary = primaryInvoiceData.getTotalValueNet();
            BigDecimal vatValuePrimary = primaryInvoiceData.getVatValue();
            BigDecimal totalValueGrossPrimary = primaryInvoiceData.getTotalValueGross();
            BigDecimal totalValueNetSecondary = Streams.stream((Iterable)printInfo.getSecondaryInvoicesData()).map(InvoiceMetaData::getTotalValueNet).reduce(BigDecimal.ZERO, BigDecimal::add);
            BigDecimal vatValueSecondary = Streams.stream((Iterable)printInfo.getSecondaryInvoicesData()).map(InvoiceMetaData::getVatValue).reduce(BigDecimal.ZERO, BigDecimal::add);
            BigDecimal totalValueGrossSecondary = Streams.stream((Iterable)printInfo.getSecondaryInvoicesData()).map(InvoiceMetaData::getTotalValueGross).reduce(BigDecimal.ZERO, BigDecimal::add);
            BigDecimal sumNetCumulative = totalValueNetPrimary.add(totalValueNetSecondary);
            BigDecimal sumVATCumulative = vatValuePrimary.add(vatValueSecondary);
            BigDecimal sumGrossCumulative = totalValueGrossPrimary.add(totalValueGrossSecondary);
            String sumNetCumulativeString = PrintHelper.asString((BigDecimal)sumNetCumulative, (String)"0,00", (boolean)true);
            String sumVATCumulativeString = PrintHelper.asString((BigDecimal)sumVATCumulative, (String)"0,00", (boolean)true);
            String sumGrossCumulativeString = PrintHelper.asString((BigDecimal)sumGrossCumulative, (String)"0,00", (boolean)true);
            BigDecimal totalWarrantySecurityRetention = sumNetCumulative.multiply(warrantySecurityRetentionPercentPrimary).divide(BigDecimal.valueOf(100L), 2, RoundingMode.HALF_UP).negate();
            BigDecimal totalValueGrossWithWarrantySecurityRetention = sumGrossCumulative.add(totalWarrantySecurityRetention);
            String totalValueGrossWithWarrantySecurityRetentionAsString = PrintHelper.asString((BigDecimal)totalValueGrossWithWarrantySecurityRetention, (String)"0,00", (boolean)true);
            BigDecimal secondaryInvoiceGrossWithoutSecurityRetention = Streams.stream((Iterable)secondaryInvoicesDataSorted).map(InvoiceMetaData::getTotalValueGross).reduce(BigDecimal.ZERO, BigDecimal::add);
            BigDecimal totalValueCumulativeWithoutSecondaryInvoices = totalValueGrossWithWarrantySecurityRetention.subtract(secondaryInvoiceGrossWithoutSecurityRetention);
            String totalValueCumulativeWithoutSecondaryInvoicesAsString = PrintHelper.asString((BigDecimal)totalValueCumulativeWithoutSecondaryInvoices, (String)"0,00", (boolean)true);
            BigDecimal fulfillmentSecurityRetentionCumulativeValue = printInfo.getPrimaryInvoiceData().getFulfillmentSecurityRetentionCumulativeValue();
            String fulfillmentSecurityRetentionCumulativeValueAsString = PrintHelper.asString((BigDecimal)fulfillmentSecurityRetentionCumulativeValue, (String)"0,00", (boolean)true);
            BigDecimal totalValueGrossWithFulfillmentSecRetCumuValue = totalValueCumulativeWithoutSecondaryInvoices.add(fulfillmentSecurityRetentionCumulativeValue);
            String totalValueGrossWithFulfillmentSecRetCumuValueAsString = PrintHelper.asString((BigDecimal)totalValueGrossWithFulfillmentSecRetCumuValue, (String)"0,00", (boolean)true);
            Row title = Row.builder().backgroundColor(DETAIL_BG_COLOR_HEADER).add((AbstractCell)InvoicePrintService.descriptionCell((PrintSetup)printSetup, (Color)TEXT_COLOR, (String)"", (HorizontalAlignment)HorizontalAlignment.LEFT)).add((AbstractCell)InvoicePrintService.descriptionCell((PrintSetup)printSetup, (Color)TEXT_COLOR, (String)"", (HorizontalAlignment)HorizontalAlignment.LEFT)).add((AbstractCell)InvoicePrintService.descriptionCell((PrintSetup)printSetup, (Color)TEXT_COLOR, (String)"", (HorizontalAlignment)HorizontalAlignment.LEFT)).add((AbstractCell)InvoicePrintService.descriptionCell((PrintSetup)printSetup, (Color)TEXT_COLOR, (String)"Netto in EUR", (HorizontalAlignment)HorizontalAlignment.RIGHT)).add((AbstractCell)InvoicePrintService.descriptionCell((PrintSetup)printSetup, (Color)TEXT_COLOR, (String)"USt-Satz", (HorizontalAlignment)HorizontalAlignment.RIGHT)).add((AbstractCell)InvoicePrintService.descriptionCell((PrintSetup)printSetup, (Color)TEXT_COLOR, (String)"Umsatzsteuer in EUR", (HorizontalAlignment)HorizontalAlignment.RIGHT)).add((AbstractCell)InvoicePrintService.descriptionCell((PrintSetup)printSetup, (Color)TEXT_COLOR, (String)"Brutto in EUR", (HorizontalAlignment)HorizontalAlignment.RIGHT)).build();
            tableBuilder.addRow(title);
            tableBuilder.addRow(this.hLineT(columnAmount));
            Row invoiceValueRow1 = Row.builder().backgroundColor(DETAIL_BG_COLOR_HEADER).add((AbstractCell)InvoicePrintService.descriptionCell((PrintSetup)printSetup, (Color)TEXT_COLOR, (int)3, (String)"Rechnungswert", (HorizontalAlignment)HorizontalAlignment.LEFT)).add((AbstractCell)InvoicePrintService.descriptionCell((PrintSetup)printSetup, (Color)TEXT_COLOR, (String)sumNetCumulativeString, (HorizontalAlignment)HorizontalAlignment.RIGHT)).add((AbstractCell)InvoicePrintService.emptyCell((PrintSetup)printSetup)).add((AbstractCell)InvoicePrintService.descriptionCell((PrintSetup)printSetup, (Color)TEXT_COLOR, (String)sumVATCumulativeString, (HorizontalAlignment)HorizontalAlignment.RIGHT)).add((AbstractCell)InvoicePrintService.descriptionCell((PrintSetup)printSetup, (Color)TEXT_COLOR, (String)sumGrossCumulativeString, (HorizontalAlignment)HorizontalAlignment.RIGHT)).build();
            tableBuilder.addRow(invoiceValueRow1);
            Row invoiceValueRow2 = Row.builder().backgroundColor(DETAIL_BG_COLOR_HEADER).add((AbstractCell)InvoicePrintService.descriptionCell((PrintSetup)printSetup, (Color)TEXT_COLOR, (int)3, (String)"Zwischensumme m. SB", (HorizontalAlignment)HorizontalAlignment.LEFT)).add((AbstractCell)InvoicePrintService.descriptionCell((PrintSetup)printSetup, (Color)TEXT_COLOR, (String)"", (HorizontalAlignment)HorizontalAlignment.RIGHT)).add((AbstractCell)InvoicePrintService.emptyCell((PrintSetup)printSetup)).add((AbstractCell)InvoicePrintService.descriptionCell((PrintSetup)printSetup, (Color)TEXT_COLOR, (String)"", (HorizontalAlignment)HorizontalAlignment.RIGHT)).add((AbstractCell)InvoicePrintService.descriptionCell((PrintSetup)printSetup, (Color)TEXT_COLOR, (String)totalValueGrossWithWarrantySecurityRetentionAsString, (HorizontalAlignment)HorizontalAlignment.RIGHT)).build();
            tableBuilder.addRow(invoiceValueRow2);
            tableBuilder.addRow(Row.builder().backgroundColor(DETAIL_BG_COLOR_HEADER).add((AbstractCell)InvoicePrintService.emptyCell((PrintSetup)printSetup, (int)Iterables.size((Iterable)columnWidths))).build());
            int i = 1;
            for (InvoiceMetaData secondaryInvoice : secondaryInvoicesDataSorted) {
                String invoiceTypeComment = String.format("abzgl. %s", StringUtils.trimToEmpty((String)secondaryInvoice.getInvoiceTypeComment()));
                String invoiceNumber = StringUtils.trimToEmpty((String)secondaryInvoice.getInvoiceNumber());
                String netAsString = PrintHelper.asString((BigDecimal)secondaryInvoice.getTotalValueNet(), (String)"0,00", (boolean)true);
                String vatAsString = String.format("%s %%", PrintHelper.asString((BigDecimal)secondaryInvoice.getVatPercent(), (String)"0,00", (boolean)true));
                String vatValueAsString = PrintHelper.asString((BigDecimal)secondaryInvoice.getVatValue(), (String)"0,00", (boolean)true);
                String grossAsString = PrintHelper.asString((BigDecimal)secondaryInvoice.getTotalValueGross(), (String)"0,00", (boolean)true);
                Row invoiceMetaDataRow = Row.builder().backgroundColor(DETAIL_BG_COLOR_HEADER).add((AbstractCell)InvoicePrintService.descriptionCell((PrintSetup)printSetup, (Color)TEXT_COLOR, (String)Integer.toString(i++), (HorizontalAlignment)HorizontalAlignment.LEFT)).add((AbstractCell)InvoicePrintService.descriptionCell((PrintSetup)printSetup, (Color)TEXT_COLOR, (String)invoiceTypeComment, (HorizontalAlignment)HorizontalAlignment.LEFT)).add((AbstractCell)InvoicePrintService.descriptionCell((PrintSetup)printSetup, (Color)TEXT_COLOR, (String)invoiceNumber, (HorizontalAlignment)HorizontalAlignment.LEFT)).add((AbstractCell)InvoicePrintService.descriptionCell((PrintSetup)printSetup, (Color)TEXT_COLOR, (String)netAsString, (HorizontalAlignment)HorizontalAlignment.RIGHT)).add((AbstractCell)InvoicePrintService.descriptionCell((PrintSetup)printSetup, (Color)TEXT_COLOR, (String)vatAsString, (HorizontalAlignment)HorizontalAlignment.RIGHT)).add((AbstractCell)InvoicePrintService.descriptionCell((PrintSetup)printSetup, (Color)TEXT_COLOR, (String)vatValueAsString, (HorizontalAlignment)HorizontalAlignment.RIGHT)).add((AbstractCell)InvoicePrintService.descriptionCell((PrintSetup)printSetup, (Color)TEXT_COLOR, (String)grossAsString, (HorizontalAlignment)HorizontalAlignment.RIGHT)).build();
                tableBuilder.addRow(invoiceMetaDataRow);
            }
            tableBuilder.addRow(Row.builder().backgroundColor(DETAIL_BG_COLOR_HEADER).add((AbstractCell)InvoicePrintService.emptyCell((PrintSetup)printSetup, (int)Iterables.size((Iterable)columnWidths))).build());
            tableBuilder.addRow(this.hLineT(columnAmount));
            String totalValueNetAsString = PrintHelper.asString((BigDecimal)primaryInvoiceData.getTotalValueNet(), (String)"0,00", (boolean)true);
            String vatPercentAsString = String.format("%s %%", PrintHelper.asString((BigDecimal)primaryInvoiceData.getVatPercent(), (String)"0,00", (boolean)true));
            String vatValueAsString = PrintHelper.asString((BigDecimal)primaryInvoiceData.getVatValue(), (String)"0,00", (boolean)true);
            Row invoiceMetaDataRow2 = Row.builder().backgroundColor(DETAIL_BG_COLOR_HEADER).add((AbstractCell)InvoicePrintService.descriptionCell((PrintSetup)printSetup, (PDFont)fontBold, (Color)TEXT_COLOR, (int)3, (String)"Rechnungsbetrag abz\u00fcglich erfolgter Teil-(schluss)rechungen", (HorizontalAlignment)HorizontalAlignment.LEFT)).add((AbstractCell)InvoicePrintService.descriptionCell((PrintSetup)printSetup, (PDFont)fontBold, (Color)TEXT_COLOR, (String)totalValueNetAsString, (HorizontalAlignment)HorizontalAlignment.RIGHT)).add((AbstractCell)InvoicePrintService.descriptionCell((PrintSetup)printSetup, (PDFont)fontBold, (Color)TEXT_COLOR, (String)vatPercentAsString, (HorizontalAlignment)HorizontalAlignment.RIGHT)).add((AbstractCell)InvoicePrintService.descriptionCell((PrintSetup)printSetup, (PDFont)fontBold, (Color)TEXT_COLOR, (String)vatValueAsString, (HorizontalAlignment)HorizontalAlignment.RIGHT)).add((AbstractCell)InvoicePrintService.descriptionCell((PrintSetup)printSetup, (PDFont)fontBold, (Color)TEXT_COLOR, (String)totalValueCumulativeWithoutSecondaryInvoicesAsString, (HorizontalAlignment)HorizontalAlignment.RIGHT)).build();
            tableBuilder.addRow(invoiceMetaDataRow2);
            Row invoiceMetaDataRow1 = Row.builder().backgroundColor(DETAIL_BG_COLOR_HEADER).add((AbstractCell)InvoicePrintService.descriptionCell((PrintSetup)printSetup, (PDFont)fontBold, (Color)TEXT_COLOR, (int)3, (String)"zuz\u00fcglich gew\u00e4hrtem Vertragserf\u00fcllungssicherheitseinbehalt", (HorizontalAlignment)HorizontalAlignment.LEFT)).add((AbstractCell)InvoicePrintService.descriptionCell((PrintSetup)printSetup, (PDFont)fontBold, (Color)TEXT_COLOR, (String)"", (HorizontalAlignment)HorizontalAlignment.RIGHT)).add((AbstractCell)InvoicePrintService.descriptionCell((PrintSetup)printSetup, (PDFont)fontBold, (Color)TEXT_COLOR, (String)"", (HorizontalAlignment)HorizontalAlignment.RIGHT)).add((AbstractCell)InvoicePrintService.descriptionCell((PrintSetup)printSetup, (PDFont)fontBold, (Color)TEXT_COLOR, (String)"", (HorizontalAlignment)HorizontalAlignment.RIGHT)).add((AbstractCell)InvoicePrintService.descriptionCell((PrintSetup)printSetup, (PDFont)fontBold, (Color)TEXT_COLOR, (String)fulfillmentSecurityRetentionCumulativeValueAsString, (HorizontalAlignment)HorizontalAlignment.RIGHT)).build();
            tableBuilder.addRow(invoiceMetaDataRow1);
            Row invoiceMetaDataRow3 = Row.builder().backgroundColor(DETAIL_BG_COLOR_HEADER).add((AbstractCell)InvoicePrintService.descriptionCell((PrintSetup)printSetup, (PDFont)fontBold, (Color)TEXT_COLOR, (int)3, (String)"Zu zahlender Betrag", (HorizontalAlignment)HorizontalAlignment.LEFT)).add((AbstractCell)InvoicePrintService.descriptionCell((PrintSetup)printSetup, (PDFont)fontBold, (Color)TEXT_COLOR, (String)"", (HorizontalAlignment)HorizontalAlignment.RIGHT)).add((AbstractCell)InvoicePrintService.descriptionCell((PrintSetup)printSetup, (PDFont)fontBold, (Color)TEXT_COLOR, (String)"", (HorizontalAlignment)HorizontalAlignment.RIGHT)).add((AbstractCell)InvoicePrintService.descriptionCell((PrintSetup)printSetup, (PDFont)fontBold, (Color)TEXT_COLOR, (String)"", (HorizontalAlignment)HorizontalAlignment.RIGHT)).add((AbstractCell)InvoicePrintService.descriptionCell((PrintSetup)printSetup, (PDFont)fontBold, (Color)TEXT_COLOR, (String)totalValueGrossWithFulfillmentSecRetCumuValueAsString, (HorizontalAlignment)HorizontalAlignment.RIGHT)).build();
            tableBuilder.addRow(invoiceMetaDataRow3);
            tableBuilder.addRow(this.hlineTB(columnAmount));
            Table table = tableBuilder.build();
            return Optional.of(table);
        }
        return Optional.empty();
    }

    @Nonnull
    private Optional<Table> legalNoticeParagraphs(@NonNull InvoicePrintInfo printInfo, @NonNull PDRectangle mediaBox, @NonNull PrintSetup printSetup) {
        Table table;
        String footerText;
        if (printInfo == null) {
            throw new NullPointerException("printInfo is marked non-null but is null");
        }
        if (mediaBox == null) {
            throw new NullPointerException("mediaBox is marked non-null but is null");
        }
        if (printSetup == null) {
            throw new NullPointerException("printSetup is marked non-null but is null");
        }
        PrintFonts printFonts = printSetup.getPrintFonts();
        int detailsFontSize = printSetup.getDetailsFontSize();
        ImmutableList columnWidths = ImmutableList.of((Object)Float.valueOf(1.0f));
        Table.TableBuilder tableBuilder = InvoicePrintService.table((Float)Float.valueOf(InvoicePrintService.maxWidth((PDRectangle)mediaBox)), (Iterable)columnWidths);
        if (printInfo.isOptionPrint13bParagraph()) {
            Row paragraph13b = Row.builder().backgroundColor(DETAIL_BG_COLOR_HEADER).add((AbstractCell)InvoicePrintService.descriptionCell((PrintFonts)printFonts, (int)detailsFontSize, (Color)TEXT_COLOR, (String)"Kein Ausweis der Umsatzsteuer gem\u00e4\u00df \u00a7 13 b UStG\nSteuerschuldnerschaft des Leistungsempf\u00e4ngers")).build();
            tableBuilder.addRow(paragraph13b);
        }
        tableBuilder.addRow(Row.builder().add((AbstractCell)InvoicePrintService.emptyCell((PrintSetup)printSetup)).build());
        if (printInfo.isOptionPrintSubcontractorParagraph()) {
            Row paragraphSubcontractor = Row.builder().backgroundColor(DETAIL_BG_COLOR_HEADER).add((AbstractCell)InvoicePrintService.descriptionCell((PrintFonts)printFonts, (int)detailsFontSize, (Color)TEXT_COLOR, (String)"Gem\u00e4\u00df \u00a7 14 Abs. 2  Satz 3 UStG hat der Gutschriftsempf\u00e4nger (Auftragnehmer) die M\u00f6glichkeit, der Gutschrift zu widersprechen. Diese Widerrufsm\u00f6glichkeit wird in gegenseitigem Einverst\u00e4ndnis auf sechs Wochen nach Zugang der Gutschrift begrenzt. Danach gilt die Gutschrift im umsatzsteuerlichen Sinne als unwiderruflich. F\u00fcr den Fall des Widerrufs hat der Auftragnehmer seinerseits unverz\u00fcglich eine Rechnung \u00fcber die erbrachten Leistungen bzw. sonstige Leistungen zu erstellen.\n\nEs bleibt dem Auftragnehmer unbenommen, in berechtigten F\u00e4llen auch nach dieser Frist eine Berichtigung der Gutschrift vom Auftraggeber zu verlangen, ohne dass die bestehende Gutschrift damit widerrufen wird. In diesen F\u00e4llen wird vom Auftraggeber eine neue Gutschrift erstellt.")).build();
            tableBuilder.addRow(paragraphSubcontractor);
        }
        if (StringUtils.isNotBlank((CharSequence)(footerText = printInfo.getFooterText()))) {
            Row footerTextParagraph = Row.builder().backgroundColor(DETAIL_BG_COLOR_HEADER).add((AbstractCell)InvoicePrintService.descriptionCell((PrintFonts)printFonts, (int)detailsFontSize, (Color)TEXT_COLOR, (String)footerText)).build();
            tableBuilder.addRow(footerTextParagraph);
        }
        if (!Iterables.isEmpty((Iterable)(table = tableBuilder.build()).getRows())) {
            return Optional.of(table);
        }
        return Optional.empty();
    }

    @Nonnull
    private Optional<Table> closingInvoiceStatement(@NonNull InvoicePrintInfo printInfo, @NonNull InvoicePrintConfiguration printConfiguration, @NonNull PDRectangle mediaBox, @NonNull PrintSetup printSetup) {
        if (printInfo == null) {
            throw new NullPointerException("printInfo is marked non-null but is null");
        }
        if (printConfiguration == null) {
            throw new NullPointerException("printConfiguration is marked non-null but is null");
        }
        if (mediaBox == null) {
            throw new NullPointerException("mediaBox is marked non-null but is null");
        }
        if (printSetup == null) {
            throw new NullPointerException("printSetup is marked non-null but is null");
        }
        PrintFonts printFonts = printSetup.getPrintFonts();
        PDFont fontBold = printFonts.getBold();
        EInvoiceType invoiceType = printInfo.getInvoiceType();
        Iterable closingInvoiceData = printInfo.getClosingInvoiceData();
        if (!Iterables.isEmpty((Iterable)closingInvoiceData)) {
            Iterable closingInvoiceDataSorted = (Iterable)Streams.stream((Iterable)closingInvoiceData).sorted(CLOSING_INVOICE_COMPARATOR).collect(ImmutableList.toImmutableList());
            ImmutableList columnWidths = ImmutableList.of((Object)Float.valueOf(1.0f));
            Table.TableBuilder tableBuilder = InvoicePrintService.table((Float)Float.valueOf(InvoicePrintService.maxWidth((PDRectangle)mediaBox)), (Iterable)columnWidths);
            ImmutableList details = (ImmutableList)Streams.stream((Iterable)closingInvoiceDataSorted).map(item -> {
                String invoiceNumber = item.getInvoiceNumber();
                String invoiceTypeComment = item.getInvoiceTypeComment();
                LocalDate invoiceDate = item.getInvoiceDate();
                String invoiceDateString = null != invoiceDate ? DateTimeHelperService.germanDate((LocalDate)invoiceDate) : "<keine Angabe>";
                BigDecimal sumGross = item.getTotalValueGross();
                String sumGrossAsString = PrintHelper.asString((BigDecimal)sumGross, (String)"0,00", (boolean)true);
                return String.format("%s RE-Nummer: %s vom: %s RE-Betrag: %s EUR", invoiceTypeComment, invoiceNumber, invoiceDateString, sumGrossAsString);
            }).collect(ImmutableList.toImmutableList());
            String followingLabel = Iterables.size((Iterable)details) > 1 ? "folgenden" : "folgende";
            String partialInvoiceName = Iterables.size((Iterable)details) > 1 ? "Teilrechnungen" : "Teilrechnung";
            InvoiceNamePrintParam invoiceNamePrintParam = InvoiceNamePrintParam.of((InvoiceMetaData)printInfo.getPrimaryInvoiceData(), (Boolean)printInfo.isOptionCumulativePrint(), (Boolean)Boolean.FALSE);
            String currentInvoiceName = (String)INVOICE_TYPE_NAME_NAMING.getOrDefault(invoiceType, i -> "<name fehlt>").apply((Object)invoiceNamePrintParam);
            String headerText = String.format("Hiermit erkl\u00e4ren wir die %s %s zur %s", followingLabel, partialInvoiceName, currentInvoiceName);
            Row header = Row.builder().backgroundColor(DETAIL_BG_COLOR_HEADER).add((AbstractCell)InvoicePrintService.descriptionCell((PrintSetup)printSetup, (PDFont)fontBold, (Color)TEXT_COLOR, (String)headerText, (HorizontalAlignment)HorizontalAlignment.LEFT)).build();
            tableBuilder.addRow(header);
            for (String detail : details) {
                Row detailRow = Row.builder().backgroundColor(DETAIL_BG_COLOR_HEADER).add((AbstractCell)InvoicePrintService.descriptionCell((PrintSetup)printSetup, (Color)TEXT_COLOR, (String)detail, (HorizontalAlignment)HorizontalAlignment.LEFT)).build();
                tableBuilder.addRow(detailRow);
            }
            Row f1 = Row.builder().backgroundColor(DETAIL_BG_COLOR_HEADER).add((AbstractCell)InvoicePrintService.emptyCell((PrintSetup)printSetup)).build();
            tableBuilder.addRow(f1);
            String f2Text = "Wir bitten um gleichlautende Buchung.\nSollten Ihrerseits Einw\u00e4nde gegen diese Erkl\u00e4rung bestehen, stehen wir Ihnen gerne, telefonisch und per E-Mail, zur Verf\u00fcgung.";
            Row f2 = Row.builder().backgroundColor(DETAIL_BG_COLOR_HEADER).add((AbstractCell)InvoicePrintService.descriptionCell((PrintSetup)printSetup, (PDFont)fontBold, (Color)TEXT_COLOR, (String)"Wir bitten um gleichlautende Buchung.\nSollten Ihrerseits Einw\u00e4nde gegen diese Erkl\u00e4rung bestehen, stehen wir Ihnen gerne, telefonisch und per E-Mail, zur Verf\u00fcgung.", (HorizontalAlignment)HorizontalAlignment.LEFT)).build();
            tableBuilder.addRow(f2);
            Table table = tableBuilder.build();
            return Optional.of(table);
        }
        return Optional.empty();
    }

    @Nonnull
    private Optional<Table> attachments(@NonNull InvoicePrintInfo printInfo, @NonNull InvoicePrintConfiguration printConfiguration, @NonNull PDRectangle mediaBox, @NonNull PrintSetup printSetup) {
        ImmutableSet allAttachments;
        if (printInfo == null) {
            throw new NullPointerException("printInfo is marked non-null but is null");
        }
        if (printConfiguration == null) {
            throw new NullPointerException("printConfiguration is marked non-null but is null");
        }
        if (mediaBox == null) {
            throw new NullPointerException("mediaBox is marked non-null but is null");
        }
        if (printSetup == null) {
            throw new NullPointerException("printSetup is marked non-null but is null");
        }
        PrintFonts printFonts = printSetup.getPrintFonts();
        String attachments = StringUtils.trimToEmpty((String)printInfo.getAttachments());
        String additionalAttachments = StringUtils.trimToEmpty((String)printInfo.getAdditionalAttachments());
        ImmutableSet.Builder allAttachmentsBuilder = ImmutableSet.builder();
        if (StringUtils.isNotBlank((CharSequence)attachments)) {
            allAttachmentsBuilder.add((Object)attachments);
        }
        if (StringUtils.isNotBlank((CharSequence)additionalAttachments)) {
            allAttachmentsBuilder.add((Object)additionalAttachments);
        }
        if (!(allAttachments = allAttachmentsBuilder.build()).isEmpty()) {
            int detailsFontSize = printSetup.getDetailsFontSize();
            ImmutableList columnWidths = ImmutableList.of((Object)Float.valueOf(0.125f), (Object)Float.valueOf(0.875f));
            Table.TableBuilder tableBuilder = InvoicePrintService.table((Float)Float.valueOf(InvoicePrintService.maxWidth((PDRectangle)mediaBox)), (Iterable)columnWidths);
            String allAttachmentsText = Joiner.on((String)", ").join((Iterable)allAttachments);
            Row attachmentParagraph = Row.builder().backgroundColor(DETAIL_BG_COLOR_HEADER).add((AbstractCell)InvoicePrintService.descriptionCell((PrintFonts)printFonts, (int)detailsFontSize, (Color)TEXT_COLOR, (String)"Anh\u00e4nge:")).add((AbstractCell)InvoicePrintService.descriptionCell((PrintFonts)printFonts, (int)detailsFontSize, (Color)TEXT_COLOR, (String)allAttachmentsText)).build();
            tableBuilder.addRow(attachmentParagraph);
            Table table = tableBuilder.build();
            return Optional.of(table);
        }
        return Optional.empty();
    }

    protected static TextCell footerCell(@NonNull PrintFonts printFonts, int fontSize, @NonNull Color textColor, @Nullable String text) {
        if (printFonts == null) {
            throw new NullPointerException("printFonts is marked non-null but is null");
        }
        if (textColor == null) {
            throw new NullPointerException("textColor is marked non-null but is null");
        }
        String validText = InvoicePrintService.validText((String)text);
        return ((TextCell.TextCellBuilder)((TextCell.TextCellBuilder)((TextCell.TextCellBuilder)((TextCell.TextCellBuilder)((TextCell.TextCellBuilder)((TextCell.TextCellBuilder)((TextCell.TextCellBuilder)((TextCell.TextCellBuilder)((TextCell.TextCellBuilder)((TextCell.TextCellBuilder)((TextCell.TextCellBuilder)((TextCell.TextCellBuilder)TextCell.builder().font(printFonts.getRegular())).fontSize(Integer.valueOf(fontSize))).colSpan(1)).rowSpan(1)).padding(0.0f)).horizontalAlignment(HorizontalAlignment.LEFT)).text(validText).textColor(textColor)).lineSpacing(0.5f)).borderWidthTop(0.0f)).borderWidthLeft(0.0f)).borderWidthRight(0.0f)).borderWidthBottom(0.0f)).build();
    }

    @Nonnull
    private static String partialInvoiceName(@NonNull InvoiceNamePrintParam printParam) {
        if (printParam == null) {
            throw new NullPointerException("printParam is marked non-null but is null");
        }
        return InvoicePrintService.invoiceName((InvoiceNamePrintParam)printParam, (String)"Teilrechnung");
    }

    @Nonnull
    private static String partialFinalInvoiceName(@NonNull InvoiceNamePrintParam printParam) {
        if (printParam == null) {
            throw new NullPointerException("printParam is marked non-null but is null");
        }
        return InvoicePrintService.invoiceName((InvoiceNamePrintParam)printParam, (String)"Teilschlussrechnung");
    }

    @Nonnull
    private static String invoiceName(@NonNull InvoiceNamePrintParam printParam, @NonNull String invoiceType) {
        if (printParam == null) {
            throw new NullPointerException("printParam is marked non-null but is null");
        }
        if (invoiceType == null) {
            throw new NullPointerException("invoiceType is marked non-null but is null");
        }
        InvoiceMetaData invoiceMetaData = printParam.getInvoiceMetaData();
        Boolean optionCumulative = printParam.getOptionCumulativePrint();
        Boolean nameIsSingular = printParam.getNameIsSingular();
        Optional internalPartialNumber = invoiceMetaData.getInternalPartialNumber();
        Optional internalPartialFinalNumber = invoiceMetaData.getInternalPartialFinalNumber();
        ArrayList parts = Lists.newArrayList();
        if (EInvoiceType.PARTIAL_INVOICE == invoiceMetaData.getInvoiceType()) {
            internalPartialNumber.ifPresent(integer -> parts.add(integer + "."));
        } else if (EInvoiceType.PARTIAL_FINAL_INVOICE == invoiceMetaData.getInvoiceType()) {
            internalPartialFinalNumber.ifPresent(integer -> parts.add(integer + "."));
        }
        if (Boolean.TRUE == optionCumulative) {
            if (Boolean.TRUE == nameIsSingular) {
                parts.add("kumulierte");
            } else {
                parts.add("kumulierten");
            }
        }
        parts.add(invoiceType);
        return Joiner.on((char)' ').skipNulls().join((Iterable)parts);
    }
}

