/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.service.service.print;

import com.google.common.base.Joiner;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Range;
import com.google.common.collect.Sets;
import com.google.common.collect.Streams;
import de.leancoders.common.helper.DateTimeHelper;
import de.qfm.erp.service.configuration.PrintLayoutConfig;
import de.qfm.erp.service.helper.BigDecimalHelper;
import de.qfm.erp.service.helper.DateRange;
import de.qfm.erp.service.helper.DurationHelper;
import de.qfm.erp.service.model.internal.print.EPrintFontSize;
import de.qfm.erp.service.model.internal.print.PrintConfiguration;
import de.qfm.erp.service.model.internal.print.PrintFonts;
import de.qfm.erp.service.model.internal.print.PrintInfo;
import de.qfm.erp.service.model.internal.print.PrintSetup;
import de.qfm.erp.service.model.internal.print.payroll.AttendanceReportInfo;
import de.qfm.erp.service.model.internal.print.payroll.AttendanceReportPrintConfiguration;
import de.qfm.erp.service.model.internal.print.payroll.AttendanceReportPrintStandard;
import de.qfm.erp.service.model.internal.print.payroll.AttendanceReportPrintStandardRow;
import de.qfm.erp.service.model.jpa.configuration.ConfigurationCompany;
import de.qfm.erp.service.model.jpa.employee.attendance.EAggregatedAttendanceDayType;
import de.qfm.erp.service.model.jpa.employee.attendance.EAttendanceDayType;
import de.qfm.erp.service.model.jpa.employee.payroll.EPayrollItemUnit;
import de.qfm.erp.service.model.jpa.user.User;
import de.qfm.erp.service.service.route.impl.PrintHelper;
import de.qfm.erp.service.service.security.UserService;
import de.qfm.erp.service.service.service.DateTimeHelperService;
import de.qfm.erp.service.service.service.print.AbstractPrintService;
import de.qfm.erp.service.service.service.print.AttendanceReportPrintService;
import java.awt.Color;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.Duration;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.YearMonth;
import java.util.Collection;
import java.util.Currency;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.IntStream;
import javax.annotation.Nonnull;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDDocumentInformation;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.PDPageContentStream;
import org.apache.pdfbox.pdmodel.common.PDRectangle;
import org.apache.pdfbox.pdmodel.font.PDFont;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.vandeseer.easytable.TableDrawer;
import org.vandeseer.easytable.settings.HorizontalAlignment;
import org.vandeseer.easytable.structure.Row;
import org.vandeseer.easytable.structure.Table;
import org.vandeseer.easytable.structure.cell.AbstractCell;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class AttendanceReportPrintService
extends AbstractPrintService<AttendanceReportInfo, AttendanceReportPrintConfiguration> {
    private static final Set<EAttendanceDayType> BOLD_ATTENDANCE_TYPES = ImmutableSet.of((Object)EAttendanceDayType.ABSENT);
    private final PrintLayoutConfig printLayoutConfig;

    @Autowired
    public AttendanceReportPrintService(UserService userService, DateTimeHelperService dateTimeHelperService, PrintHelper printHelper, PrintLayoutConfig printLayoutConfig) {
        super(userService, dateTimeHelperService, printHelper);
        this.printLayoutConfig = printLayoutConfig;
    }

    @Nonnull
    public PDDocumentInformation apply(@NonNull PDDocumentInformation documentInformation, @NonNull AttendanceReportInfo printInfo, @NonNull AttendanceReportPrintConfiguration printConfiguration) {
        if (documentInformation == null) {
            throw new NullPointerException("documentInformation is marked non-null but is null");
        }
        if (printInfo == null) {
            throw new NullPointerException("printInfo is marked non-null but is null");
        }
        if (printConfiguration == null) {
            throw new NullPointerException("printConfiguration is marked non-null but is null");
        }
        YearMonth yearMonth = printInfo.getYearMonth();
        String yearMonthsAsString = String.format("%s/%s", yearMonth.getMonthValue(), yearMonth.getYear());
        Long userId = printInfo.getUserId();
        String userFullName = printInfo.getUserFullName();
        Long managerId = printInfo.getManagerId();
        String managerFullName = printInfo.getManagerFullName();
        documentInformation.setKeywords("TODO");
        documentInformation.setTitle(String.format("Monatsbericht: %s", yearMonthsAsString));
        documentInformation.setSubject(String.format("Bauleiter: %s, Mitarbeiter: %s", managerFullName, userFullName));
        return documentInformation;
    }

    public byte[] generatePDF(@NonNull AttendanceReportInfo printInfo, @NonNull AttendanceReportPrintConfiguration printConfiguration, @NonNull EPrintFontSize printFontSize, @NonNull ConfigurationCompany configurationCompany) {
        byte[] byArray;
        block33: {
            if (printInfo == null) {
                throw new NullPointerException("printInfo is marked non-null but is null");
            }
            if (printConfiguration == null) {
                throw new NullPointerException("printConfiguration is marked non-null but is null");
            }
            if (printFontSize == null) {
                throw new NullPointerException("printFontSize is marked non-null but is null");
            }
            if (configurationCompany == null) {
                throw new NullPointerException("configurationCompany is marked non-null but is null");
            }
            PDRectangle mediaBox = new PDRectangle(PDRectangle.A4.getHeight(), PDRectangle.A4.getWidth());
            PDDocument document = this.document((PrintInfo)printInfo, (PrintConfiguration)printConfiguration);
            try {
                PrintSetup printSetup = PrintHelper.printSetup((PrintLayoutConfig)this.printLayoutConfig, (ConfigurationCompany)configurationCompany, (EPrintFontSize)printFontSize, (PDDocument)document, PrintLayoutConfig::getPayrollLogoPadding, PrintLayoutConfig::getPayrollLogoHeight, PrintLayoutConfig::getPayrollLogoBuffer);
                List headers = this.header(printInfo, printSetup, mediaBox);
                Table footer = this.footer(printInfo, printSetup, mediaBox);
                float maxDetailsHeightWithout = AttendanceReportPrintService.maxDetailsHeight((PDRectangle)mediaBox, (float)AttendanceReportPrintService.height((Iterable)headers), (float)0.0f, (float)10.0f) + 10.0f;
                float maxDetailsHeightWith = AttendanceReportPrintService.maxDetailsHeight((PDRectangle)mediaBox, (float)AttendanceReportPrintService.height((Iterable)headers), (float)AttendanceReportPrintService.height((Table)footer), (float)10.0f) + 10.0f;
                Table details = this.details(printInfo, printSetup, mediaBox);
                ImmutableList.Builder allTablesBuilder = ImmutableList.builder();
                allTablesBuilder.add((Object)AbstractPrintService.PrintPlanInput.of((String)"details", (Table)details, (boolean)false, (int)2, (float)10.0f));
                ImmutableList allTables = allTablesBuilder.build();
                Multimap printPlan = AttendanceReportPrintService.printPlan((Iterable)allTables, (float)maxDetailsHeightWithout, (float)maxDetailsHeightWith);
                if (details.getRows().isEmpty()) {
                    AttendanceReportPrintService.printEmptyPage((PDDocument)document, (PDRectangle)mediaBox, (List)ImmutableList.of());
                } else {
                    TreeSet pages = Sets.newTreeSet((Iterable)printPlan.keySet());
                    Integer lastPage = (Integer)pages.last();
                    for (Integer pageNumber : pages) {
                        PDPageContentStream contentStream;
                        PDPage footerPage;
                        PDPage page = AttendanceReportPrintService.page((PDDocument)document, (PDRectangle)mediaBox);
                        float yOffset = 0.0f;
                        Collection printPlanOutputs = printPlan.get((Object)pageNumber);
                        try (PDPageContentStream contentStream2 = new PDPageContentStream(document, page);){
                            yOffset = AttendanceReportPrintService.printHeader((PDPageContentStream)contentStream2, (PDPage)page, (Iterable)headers);
                            for (AbstractPrintService.PrintPlanOutput printPlanOutput : printPlanOutputs) {
                                Table table = printPlanOutput.getTable();
                                float marginAfterTable = printPlanOutput.getMarginAfterTable();
                                TableDrawer.builder().page(page).contentStream(contentStream2).startX(20.0f).startY(yOffset -= marginAfterTable).table(table).build().draw();
                                yOffset -= table.getHeight();
                            }
                        }
                        if (!Objects.equals(pageNumber, lastPage)) continue;
                        float footerHeight = footer.getHeight();
                        if (footerHeight > yOffset) {
                            footerPage = AttendanceReportPrintService.page((PDDocument)document, (PDRectangle)mediaBox);
                            contentStream = new PDPageContentStream(document, footerPage);
                            try {
                                TableDrawer.builder().page(page).contentStream(contentStream).startX(20.0f).startY(30.0f + footerHeight).table(footer).build().draw();
                                continue;
                            }
                            finally {
                                contentStream.close();
                                continue;
                            }
                        }
                        footerPage = page;
                        contentStream = new PDPageContentStream(document, footerPage, PDPageContentStream.AppendMode.APPEND, true);
                        try {
                            TableDrawer.builder().page(page).contentStream(contentStream).startX(20.0f).startY(30.0f + footerHeight).table(footer).build().draw();
                        }
                        finally {
                            contentStream.close();
                        }
                    }
                    AttendanceReportPrintService.writePageNumber((PrintSetup)printSetup, (PDDocument)document);
                }
                ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
                document.save((OutputStream)outputStream);
                byArray = outputStream.toByteArray();
                if (document == null) break block33;
            }
            catch (Throwable throwable) {
                try {
                    if (document != null) {
                        try {
                            document.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    e.printStackTrace();
                    return new byte[0];
                }
            }
            document.close();
        }
        return byArray;
    }

    @Nonnull
    private List<Table> header(@NonNull AttendanceReportInfo printInfo, @NonNull PrintSetup printSetup, @NonNull PDRectangle mediaBox) {
        if (printInfo == null) {
            throw new NullPointerException("printInfo is marked non-null but is null");
        }
        if (printSetup == null) {
            throw new NullPointerException("printSetup is marked non-null but is null");
        }
        if (mediaBox == null) {
            throw new NullPointerException("mediaBox is marked non-null but is null");
        }
        YearMonth accountingMonth = printInfo.getYearMonth();
        String yearMonthsAsString = String.format("%s/%s", accountingMonth.getMonthValue(), accountingMonth.getYear());
        Table.TableBuilder tableBuilder = AttendanceReportPrintService.table((PDRectangle)mediaBox, (Iterable)ImmutableList.of((Object)Float.valueOf(0.25f), (Object)Float.valueOf(0.25f), (Object)Float.valueOf(0.25f), (Object)Float.valueOf(0.25f)));
        Row.RowBuilder headlineBuilder = Row.builder().backgroundColor(DETAIL_BG_COLOR_HEADER);
        headlineBuilder.add((AbstractCell)AttendanceReportPrintService.headerCell((PrintSetup)printSetup, (String)"Monats\u00fcbersicht Kostenstelle", (Map)AttendanceReportPrintService.defaultBorder((Iterable)TLB, (float)0.75f, (float)0.25f), (int)1, (HorizontalAlignment)HorizontalAlignment.LEFT));
        headlineBuilder.add((AbstractCell)AttendanceReportPrintService.headerCell((PrintSetup)printSetup, (String)String.format("KST: %s", printInfo.getCostCenter()), (Map)AttendanceReportPrintService.defaultBorder((Iterable)TB, (float)0.75f, (float)0.25f), (int)1, (HorizontalAlignment)HorizontalAlignment.LEFT));
        headlineBuilder.add((AbstractCell)AttendanceReportPrintService.headerCell((PrintSetup)printSetup, (String)String.format("Bauleiter: %s", printInfo.getManagerFullName()), (Map)AttendanceReportPrintService.defaultBorder((Iterable)TB, (float)0.75f, (float)0.25f), (int)1, (HorizontalAlignment)HorizontalAlignment.LEFT));
        headlineBuilder.add((AbstractCell)AttendanceReportPrintService.headerCell((PrintSetup)printSetup, (String)String.format("Monat/Jahr: %s", yearMonthsAsString), (Map)AttendanceReportPrintService.defaultBorder((Iterable)TBR, (float)0.75f, (float)0.25f), (int)1, (HorizontalAlignment)HorizontalAlignment.LEFT));
        Row headline = headlineBuilder.build();
        tableBuilder.addRow(headline);
        Table build = tableBuilder.build();
        return ImmutableList.of((Object)build);
    }

    @Nonnull
    private Table footer(@NonNull AttendanceReportInfo printInfo, @NonNull PrintSetup printSetup, @NonNull PDRectangle mediaBox) {
        if (printInfo == null) {
            throw new NullPointerException("printInfo is marked non-null but is null");
        }
        if (printSetup == null) {
            throw new NullPointerException("printSetup is marked non-null but is null");
        }
        if (mediaBox == null) {
            throw new NullPointerException("mediaBox is marked non-null but is null");
        }
        Iterable attendancePrintStandardRows = printInfo.getAttendancePrintStandardRows();
        Iterable additionalAggregationRows = printInfo.getAdditionalAggregationRows();
        BigDecimal sickDaysAggregated = Streams.stream((Iterable)attendancePrintStandardRows).map(AttendanceReportPrintStandardRow::getDayCountAggregatedByType).map(item -> item.getOrDefault(EAggregatedAttendanceDayType.AGG_SICK, BigDecimal.ZERO)).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal badWeatherSickDaysAggregated = Streams.stream((Iterable)attendancePrintStandardRows).map(AttendanceReportPrintStandardRow::getDayCountAggregatedByType).map(item -> item.getOrDefault(EAggregatedAttendanceDayType.AGG_BAD_WEATHER_SICK, BigDecimal.ZERO)).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal sickDaysSum = badWeatherSickDaysAggregated.add(sickDaysAggregated);
        BigDecimal vacationDaysAggregated = Streams.stream((Iterable)attendancePrintStandardRows).map(AttendanceReportPrintStandardRow::getDayCountAggregatedByType).map(item -> item.getOrDefault(EAggregatedAttendanceDayType.AGG_VACATION, BigDecimal.ZERO)).reduce(BigDecimal.ZERO, BigDecimal::add);
        Duration helpWageDurationAggregated = Streams.stream((Iterable)attendancePrintStandardRows).map(AttendanceReportPrintStandardRow::getDurationAggregatedByType).map(item -> item.getOrDefault(EAggregatedAttendanceDayType.AGG_HELP_WAGE_HOURS, Duration.ZERO)).reduce(Duration.ZERO, Duration::plus);
        BigDecimal helpWageEURAggregated = Streams.stream((Iterable)attendancePrintStandardRows).map(item -> {
            Duration duration = item.getDurationAggregatedByType().getOrDefault(EAggregatedAttendanceDayType.AGG_HELP_WAGE_HOURS, Duration.ZERO);
            BigDecimal effectiveWagePerHour = (BigDecimal)MoreObjects.firstNonNull((Object)item.getEffectiveWagePerHour(), (Object)BigDecimal.ZERO);
            return DurationHelper.hours((Duration)duration).multiply(effectiveWagePerHour).setScale(2, RoundingMode.HALF_UP);
        }).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal absentOnDutyDaysAggregated = Streams.stream((Iterable)attendancePrintStandardRows).map(AttendanceReportPrintStandardRow::getDayCountAggregatedByType).map(item -> item.getOrDefault(EAggregatedAttendanceDayType.AGG_ON_DUTY, BigDecimal.ZERO)).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal absentOnDutyEURAggregated = Streams.stream((Iterable)attendancePrintStandardRows).map(item -> {
            Duration duration = item.getDurationAggregatedByType().getOrDefault(EAggregatedAttendanceDayType.AGG_ON_DUTY, Duration.ZERO);
            BigDecimal effectiveWagePerHour = (BigDecimal)MoreObjects.firstNonNull((Object)item.getEffectiveWagePerHour(), (Object)BigDecimal.ZERO);
            return DurationHelper.hours((Duration)duration).multiply(effectiveWagePerHour).setScale(2, RoundingMode.HALF_UP);
        }).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal incentiveWageAggregated = Streams.stream((Iterable)attendancePrintStandardRows).map(AttendanceReportPrintStandardRow::getIncentiveWageAggregated).reduce(BigDecimal.ZERO, BigDecimal::add);
        String incentiveWageAggregatedString = AttendanceReportPrintService.nullSafeCurrency((BigDecimal)incentiveWageAggregated, (Currency)printInfo.getCurrency());
        String sickDaysAggregatedString = String.format("%s Tage", BigDecimalHelper.asString((BigDecimal)sickDaysSum, (int)2));
        String vacationDaysAggregatedString = String.format("%s Tage", BigDecimalHelper.asString((BigDecimal)vacationDaysAggregated, (int)2));
        String absendOnDutyEURAggregatedString = AttendanceReportPrintService.nullSafeCurrency((BigDecimal)absentOnDutyEURAggregated, (Currency)printInfo.getCurrency());
        String absendOnDutyDaysAggregatedString = String.format("%s Tage", BigDecimalHelper.asString((BigDecimal)absentOnDutyDaysAggregated, (int)2));
        String helpWageEURAggregatedString = AttendanceReportPrintService.nullSafeCurrency((BigDecimal)helpWageEURAggregated, (Currency)printInfo.getCurrency());
        String helpWageDurationAggregatedString = String.format("%s Std.", AttendanceReportPrintService.formatDuration((Duration)helpWageDurationAggregated));
        Table.TableBuilder footerTableBuilder = AttendanceReportPrintService.table((PDRectangle)mediaBox, (Iterable)ImmutableList.of((Object)Float.valueOf(0.5625f), (Object)Float.valueOf(0.1875f), (Object)Float.valueOf(0.125f), (Object)Float.valueOf(0.0625f), (Object)Float.valueOf(0.0625f)));
        PDFont fontBold = printSetup.getPrintFonts().getBold();
        int fontSize = printSetup.getAggregationFontSize();
        HashMap allBorders = Maps.newHashMap();
        ALL.forEach(item -> allBorders.put(item, Float.valueOf(0.25f)));
        Row.RowBuilder r1Builder = Row.builder().backgroundColor(DETAIL_BG_COLOR_HEADER);
        r1Builder.add((AbstractCell)AttendanceReportPrintService.descriptionCell((PDFont)fontBold, (int)fontSize, (String)"", (Color)Color.WHITE, (HorizontalAlignment)HorizontalAlignment.LEFT, (Map)ImmutableMap.of()));
        r1Builder.add((AbstractCell)AttendanceReportPrintService.descriptionCell((PDFont)fontBold, (int)fontSize, (String)"", (Color)Color.WHITE, (HorizontalAlignment)HorizontalAlignment.LEFT, (Map)ImmutableMap.of()));
        r1Builder.add((AbstractCell)AttendanceReportPrintService.descriptionCell((PDFont)fontBold, (int)fontSize, (String)"", (Color)Color.WHITE, (HorizontalAlignment)HorizontalAlignment.LEFT, (Map)allBorders));
        r1Builder.add((AbstractCell)AttendanceReportPrintService.descriptionCell((PDFont)fontBold, (int)fontSize, (String)"EUR", (Color)Color.WHITE, (HorizontalAlignment)HorizontalAlignment.CENTER, (Map)allBorders));
        r1Builder.add((AbstractCell)AttendanceReportPrintService.descriptionCell((PDFont)fontBold, (int)fontSize, (String)"Zeit", (Color)Color.WHITE, (HorizontalAlignment)HorizontalAlignment.CENTER, (Map)allBorders));
        Row r1 = r1Builder.build();
        Row.RowBuilder r2Builder = Row.builder().backgroundColor(DETAIL_BG_COLOR_HEADER);
        r2Builder.add((AbstractCell)AttendanceReportPrintService.descriptionCell((PDFont)fontBold, (int)fontSize, (String)"", (Color)Color.WHITE, (HorizontalAlignment)HorizontalAlignment.LEFT, (Map)ImmutableMap.of()));
        r2Builder.add((AbstractCell)AttendanceReportPrintService.descriptionCell((PDFont)fontBold, (int)fontSize, (String)"", (Color)Color.WHITE, (HorizontalAlignment)HorizontalAlignment.LEFT, (Map)ImmutableMap.of()));
        r2Builder.add((AbstractCell)AttendanceReportPrintService.descriptionCell((PDFont)fontBold, (int)fontSize, (String)"Krank", (Color)Color.WHITE, (HorizontalAlignment)HorizontalAlignment.LEFT, (Map)allBorders));
        r2Builder.add((AbstractCell)AttendanceReportPrintService.descriptionCell((PDFont)fontBold, (int)fontSize, (String)"", (Color)Color.WHITE, (HorizontalAlignment)HorizontalAlignment.RIGHT, (Map)allBorders));
        r2Builder.add((AbstractCell)AttendanceReportPrintService.descriptionCell((PDFont)fontBold, (int)fontSize, (String)sickDaysAggregatedString, (Color)Color.WHITE, (HorizontalAlignment)HorizontalAlignment.RIGHT, (Map)allBorders));
        Row r2 = r2Builder.build();
        Row.RowBuilder r3Builder = Row.builder().backgroundColor(DETAIL_BG_COLOR_HEADER);
        r3Builder.add((AbstractCell)AttendanceReportPrintService.descriptionCell((PDFont)fontBold, (int)fontSize, (String)"", (Color)Color.WHITE, (HorizontalAlignment)HorizontalAlignment.LEFT, (Map)ImmutableMap.of()));
        r3Builder.add((AbstractCell)AttendanceReportPrintService.descriptionCell((PDFont)fontBold, (int)fontSize, (String)"", (Color)Color.WHITE, (HorizontalAlignment)HorizontalAlignment.LEFT, (Map)ImmutableMap.of()));
        r3Builder.add((AbstractCell)AttendanceReportPrintService.descriptionCell((PDFont)fontBold, (int)fontSize, (String)"Urlaub", (Color)Color.WHITE, (HorizontalAlignment)HorizontalAlignment.LEFT, (Map)allBorders));
        r3Builder.add((AbstractCell)AttendanceReportPrintService.descriptionCell((PDFont)fontBold, (int)fontSize, (String)"", (Color)Color.WHITE, (HorizontalAlignment)HorizontalAlignment.RIGHT, (Map)allBorders));
        r3Builder.add((AbstractCell)AttendanceReportPrintService.descriptionCell((PDFont)fontBold, (int)fontSize, (String)vacationDaysAggregatedString, (Color)Color.WHITE, (HorizontalAlignment)HorizontalAlignment.RIGHT, (Map)allBorders));
        Row r3 = r3Builder.build();
        Iterable aggRows = (Iterable)Streams.stream((Iterable)additionalAggregationRows).map(attendanceReportPrintAggregationRow -> {
            String name = attendanceReportPrintAggregationRow.getName();
            EPayrollItemUnit unit = attendanceReportPrintAggregationRow.getUnit();
            BigDecimal value = attendanceReportPrintAggregationRow.getValue();
            String timeUnitString = unit == EPayrollItemUnit.DAY ? "Tage" : (unit == EPayrollItemUnit.HOUR ? "Std." : "");
            String aggRowEUR = unit == EPayrollItemUnit.VALUE ? String.format("%s EUR", BigDecimalHelper.asString((BigDecimal)value, (int)2)) : "";
            String aggRowTime = unit == EPayrollItemUnit.DAY || unit == EPayrollItemUnit.HOUR ? String.format("%s %s", BigDecimalHelper.asString((BigDecimal)value, (int)2), timeUnitString) : "";
            Row.RowBuilder aggRowBuilder = Row.builder().backgroundColor(DETAIL_BG_COLOR_HEADER);
            aggRowBuilder.add((AbstractCell)AttendanceReportPrintService.descriptionCell((PDFont)fontBold, (int)fontSize, (String)"", (Color)Color.WHITE, (HorizontalAlignment)HorizontalAlignment.LEFT, (Map)ImmutableMap.of()));
            aggRowBuilder.add((AbstractCell)AttendanceReportPrintService.descriptionCell((PDFont)fontBold, (int)fontSize, (String)"", (Color)Color.WHITE, (HorizontalAlignment)HorizontalAlignment.LEFT, (Map)ImmutableMap.of()));
            aggRowBuilder.add((AbstractCell)AttendanceReportPrintService.descriptionCell((PDFont)fontBold, (int)fontSize, (String)name, (Color)Color.WHITE, (HorizontalAlignment)HorizontalAlignment.LEFT, (Map)allBorders));
            aggRowBuilder.add((AbstractCell)AttendanceReportPrintService.descriptionCell((PDFont)fontBold, (int)fontSize, (String)aggRowEUR, (Color)Color.WHITE, (HorizontalAlignment)HorizontalAlignment.RIGHT, (Map)allBorders));
            aggRowBuilder.add((AbstractCell)AttendanceReportPrintService.descriptionCell((PDFont)fontBold, (int)fontSize, (String)aggRowTime, (Color)Color.WHITE, (HorizontalAlignment)HorizontalAlignment.RIGHT, (Map)allBorders));
            return aggRowBuilder.build();
        }).collect(ImmutableList.toImmutableList());
        User authenticatedUser = this.userService.authenticatedUser();
        String authenticatedUserFullName = (String)MoreObjects.firstNonNull((Object)authenticatedUser.getFullName(), (Object)"");
        String authenticatedUserFullNameAndTime = authenticatedUserFullName + " / " + DateTimeHelperService.germanDateTime((LocalDateTime)this.dateTimeHelperService.convertToDestination(DateTimeHelper.now()));
        Row.RowBuilder lastRow1Builder = Row.builder().backgroundColor(DETAIL_BG_COLOR_HEADER);
        lastRow1Builder.add((AbstractCell)AttendanceReportPrintService.descriptionCell((PDFont)fontBold, (int)fontSize, (String)"", (Color)Color.WHITE, (HorizontalAlignment)HorizontalAlignment.LEFT, (Map)ImmutableMap.of((Object)AbstractPrintService.EBorder.BOTTOM, (Object)Float.valueOf(0.25f))));
        lastRow1Builder.add((AbstractCell)AttendanceReportPrintService.descriptionCell((PDFont)fontBold, (int)fontSize, (String)authenticatedUserFullNameAndTime, (Color)Color.WHITE, (HorizontalAlignment)HorizontalAlignment.LEFT, (Map)ImmutableMap.of((Object)AbstractPrintService.EBorder.BOTTOM, (Object)Float.valueOf(0.25f))));
        lastRow1Builder.add((AbstractCell)AttendanceReportPrintService.descriptionCell((PDFont)fontBold, (int)fontSize, (String)"Hilfslohn", (Color)Color.WHITE, (HorizontalAlignment)HorizontalAlignment.LEFT, (Map)allBorders));
        lastRow1Builder.add((AbstractCell)AttendanceReportPrintService.descriptionCell((PDFont)fontBold, (int)fontSize, (String)helpWageEURAggregatedString, (Color)Color.WHITE, (HorizontalAlignment)HorizontalAlignment.RIGHT, (Map)allBorders));
        lastRow1Builder.add((AbstractCell)AttendanceReportPrintService.descriptionCell((PDFont)fontBold, (int)fontSize, (String)helpWageDurationAggregatedString, (Color)Color.WHITE, (HorizontalAlignment)HorizontalAlignment.RIGHT, (Map)allBorders));
        Row lastRow1 = lastRow1Builder.build();
        Row.RowBuilder lastRow2Builder = Row.builder().backgroundColor(DETAIL_BG_COLOR_HEADER);
        lastRow2Builder.add((AbstractCell)AttendanceReportPrintService.descriptionCell((PDFont)fontBold, (int)fontSize, (String)"", (Color)Color.WHITE, (HorizontalAlignment)HorizontalAlignment.LEFT, (Map)ImmutableMap.of()));
        lastRow2Builder.add((AbstractCell)AttendanceReportPrintService.descriptionCell((PDFont)fontBold, (int)fontSize, (String)"Freigegeben von / am", (Color)Color.WHITE, (HorizontalAlignment)HorizontalAlignment.LEFT, (Map)ImmutableMap.of()));
        lastRow2Builder.add((AbstractCell)AttendanceReportPrintService.descriptionCell((PDFont)fontBold, (int)fontSize, (String)"Leistungslohn", (Color)Color.WHITE, (HorizontalAlignment)HorizontalAlignment.LEFT, (Map)allBorders));
        lastRow2Builder.add((AbstractCell)AttendanceReportPrintService.descriptionCell((PDFont)fontBold, (int)fontSize, (String)incentiveWageAggregatedString, (Color)Color.WHITE, (HorizontalAlignment)HorizontalAlignment.RIGHT, (Map)allBorders));
        lastRow2Builder.add((AbstractCell)AttendanceReportPrintService.descriptionCell((PDFont)fontBold, (int)fontSize, (String)"", (Color)Color.WHITE, (HorizontalAlignment)HorizontalAlignment.RIGHT, (Map)allBorders));
        Row lastRow2 = lastRow2Builder.build();
        footerTableBuilder.addRow(r1);
        footerTableBuilder.addRow(r2);
        footerTableBuilder.addRow(r3);
        aggRows.forEach(arg_0 -> ((Table.TableBuilder)footerTableBuilder).addRow(arg_0));
        footerTableBuilder.addRow(lastRow1);
        footerTableBuilder.addRow(lastRow2);
        return footerTableBuilder.build();
    }

    @Nonnull
    private Table details(@NonNull AttendanceReportInfo attendanceReportInfo, @NonNull PrintSetup printSetup, @NonNull PDRectangle mediaBox) {
        if (attendanceReportInfo == null) {
            throw new NullPointerException("attendanceReportInfo is marked non-null but is null");
        }
        if (printSetup == null) {
            throw new NullPointerException("printSetup is marked non-null but is null");
        }
        if (mediaBox == null) {
            throw new NullPointerException("mediaBox is marked non-null but is null");
        }
        PrintFonts printFonts = printSetup.getPrintFonts();
        int detailsFontSize = printSetup.getDetailsFontSize();
        YearMonth yearMonth = attendanceReportInfo.getYearMonth();
        Iterable attendancePrintStandardRows = attendanceReportInfo.getAttendancePrintStandardRows();
        LocalDate startDate = yearMonth.atDay(1);
        LocalDate endDate = yearMonth.atEndOfMonth();
        int lengthOfMonth = yearMonth.lengthOfMonth();
        Range dateRange = Range.closed((Comparable)startDate, (Comparable)endDate);
        Set neededDates = (Set)DateRange.of((Range)dateRange).stream().collect(ImmutableSet.toImmutableSet());
        float baseWidth = 210.0f;
        float nameColWidth = 0.1904762f;
        float calendarColWidth = 0.7619048f / (float)lengthOfMonth;
        float summarizeColWidth = 0.045714285f;
        float wageSumColWidth = 0.07904762f;
        ImmutableList.Builder columnWidthsBuilder = ImmutableList.builder();
        columnWidthsBuilder.add((Object)Float.valueOf(0.1904762f));
        IntStream.range(0, lengthOfMonth).forEach(item -> columnWidthsBuilder.add((Object)Float.valueOf(calendarColWidth)));
        IntStream.range(0, 4).forEach(item -> columnWidthsBuilder.add((Object)Float.valueOf(0.045714285f)));
        columnWidthsBuilder.add((Object)Float.valueOf(0.07904762f));
        ImmutableList columnWidths = columnWidthsBuilder.build();
        Table.TableBuilder attendancesTableBuilder = AttendanceReportPrintService.table((PDRectangle)mediaBox, (Iterable)columnWidths);
        ImmutableMap daysBorderR1 = ImmutableMap.of((Object)AbstractPrintService.EBorder.TOP, (Object)Float.valueOf(0.75f), (Object)AbstractPrintService.EBorder.LEFT, (Object)Float.valueOf(0.25f), (Object)AbstractPrintService.EBorder.RIGHT, (Object)Float.valueOf(0.25f), (Object)AbstractPrintService.EBorder.BOTTOM, (Object)Float.valueOf(0.0f));
        ImmutableMap daysBorderR2 = ImmutableMap.of((Object)AbstractPrintService.EBorder.TOP, (Object)Float.valueOf(0.0f), (Object)AbstractPrintService.EBorder.LEFT, (Object)Float.valueOf(0.25f), (Object)AbstractPrintService.EBorder.RIGHT, (Object)Float.valueOf(0.25f), (Object)AbstractPrintService.EBorder.BOTTOM, (Object)Float.valueOf(0.75f));
        PDFont fontBold = printSetup.getPrintFonts().getBold();
        int fontSize = printSetup.getAggregationFontSize();
        Row.RowBuilder headlineBuilder_1 = Row.builder().backgroundColor(DETAIL_BG_COLOR_HEADER);
        headlineBuilder_1.add((AbstractCell)AttendanceReportPrintService.descriptionCell((PDFont)fontBold, (int)fontSize, (String)"Mitarbeiter", (Color)Color.WHITE, (HorizontalAlignment)HorizontalAlignment.LEFT, (Map)AttendanceReportPrintService.defaultBorder((Iterable)TL, (float)0.75f, (float)0.0f)));
        IntStream.range(0, lengthOfMonth).forEach(arg_0 -> AttendanceReportPrintService.lambda$details$11(headlineBuilder_1, fontBold, fontSize, (Map)daysBorderR1, arg_0));
        headlineBuilder_1.add((AbstractCell)AttendanceReportPrintService.descriptionCell((PDFont)fontBold, (int)fontSize, (String)"A", (Color)Color.WHITE, (HorizontalAlignment)HorizontalAlignment.LEFT, (Map)AttendanceReportPrintService.defaultBorder((Iterable)T, (float)0.75f, (float)0.25f)));
        headlineBuilder_1.add((AbstractCell)AttendanceReportPrintService.descriptionCell((PDFont)fontBold, (int)fontSize, (String)"U", (Color)Color.WHITE, (HorizontalAlignment)HorizontalAlignment.LEFT, (Map)AttendanceReportPrintService.defaultBorder((Iterable)T, (float)0.75f, (float)0.25f)));
        headlineBuilder_1.add((AbstractCell)AttendanceReportPrintService.descriptionCell((PDFont)fontBold, (int)fontSize, (String)"F", (Color)Color.WHITE, (HorizontalAlignment)HorizontalAlignment.LEFT, (Map)AttendanceReportPrintService.defaultBorder((Iterable)T, (float)0.75f, (float)0.25f)));
        headlineBuilder_1.add((AbstractCell)AttendanceReportPrintService.descriptionCell((PDFont)fontBold, (int)fontSize, (String)"RB", (Color)Color.WHITE, (HorizontalAlignment)HorizontalAlignment.LEFT, (Map)AttendanceReportPrintService.defaultBorder((Iterable)T, (float)0.75f, (float)0.25f)));
        headlineBuilder_1.add((AbstractCell)AttendanceReportPrintService.descriptionCell((PDFont)fontBold, (int)fontSize, (String)"Gesamtstunden", (Color)Color.WHITE, (HorizontalAlignment)HorizontalAlignment.LEFT, (Map)AttendanceReportPrintService.defaultBorder((Iterable)TR, (float)0.75f, (float)0.25f)));
        Row headline_1 = headlineBuilder_1.build();
        attendancesTableBuilder.addRow(headline_1);
        Row.RowBuilder headlineBuilder_2 = Row.builder().backgroundColor(DETAIL_BG_COLOR_HEADER);
        headlineBuilder_2.add((AbstractCell)AttendanceReportPrintService.descriptionCell((PDFont)fontBold, (int)fontSize, (String)"", (Color)Color.WHITE, (HorizontalAlignment)HorizontalAlignment.LEFT, (Map)AttendanceReportPrintService.defaultBorder((Iterable)LB, (float)0.75f, (float)0.0f)));
        IntStream.range(0, lengthOfMonth).forEach(arg_0 -> AttendanceReportPrintService.lambda$details$12(headlineBuilder_2, fontBold, fontSize, (Map)daysBorderR2, arg_0));
        headlineBuilder_2.add((AbstractCell)AttendanceReportPrintService.descriptionCell((PDFont)fontBold, (int)fontSize, (String)"SW", (Color)Color.WHITE, (HorizontalAlignment)HorizontalAlignment.LEFT, (Map)AttendanceReportPrintService.defaultBorder((Iterable)B, (float)0.75f, (float)0.25f)));
        headlineBuilder_2.add((AbstractCell)AttendanceReportPrintService.descriptionCell((PDFont)fontBold, (int)fontSize, (String)"K", (Color)Color.WHITE, (HorizontalAlignment)HorizontalAlignment.LEFT, (Map)AttendanceReportPrintService.defaultBorder((Iterable)B, (float)0.75f, (float)0.25f)));
        headlineBuilder_2.add((AbstractCell)AttendanceReportPrintService.descriptionCell((PDFont)fontBold, (int)fontSize, (String)"H", (Color)Color.WHITE, (HorizontalAlignment)HorizontalAlignment.LEFT, (Map)AttendanceReportPrintService.defaultBorder((Iterable)B, (float)0.75f, (float)0.25f)));
        headlineBuilder_2.add((AbstractCell)AttendanceReportPrintService.descriptionCell((PDFont)fontBold, (int)fontSize, (String)"KK", (Color)Color.WHITE, (HorizontalAlignment)HorizontalAlignment.LEFT, (Map)AttendanceReportPrintService.defaultBorder((Iterable)B, (float)0.75f, (float)0.25f)));
        headlineBuilder_2.add((AbstractCell)AttendanceReportPrintService.descriptionCell((PDFont)fontBold, (int)fontSize, (String)"Leistungslohn", (Color)Color.WHITE, (HorizontalAlignment)HorizontalAlignment.LEFT, (Map)AttendanceReportPrintService.defaultBorder((Iterable)RB, (float)0.75f, (float)0.25f)));
        Row headline_2 = headlineBuilder_2.build();
        attendancesTableBuilder.addRow(headline_2);
        boolean even = false;
        for (AttendanceReportPrintStandardRow attendanceReportPrintStandardRow : attendancePrintStandardRows) {
            even = !even;
            Color bgColor = even ? DETAIL_BG_COLOR_EVEN : DETAIL_BG_COLOR_UNEVEN;
            Map attendances = attendanceReportPrintStandardRow.getAttendances();
            Row.RowBuilder rowBuilder1 = Row.builder();
            String employeePersonalNumber = StringUtils.trimToEmpty((String)attendanceReportPrintStandardRow.getEmployeePersonalNumber());
            String firstName = StringUtils.trimToEmpty((String)attendanceReportPrintStandardRow.getEmployeeFirstName());
            String lastName = StringUtils.trimToEmpty((String)attendanceReportPrintStandardRow.getEmployeeLastName());
            String employeeFullName = Joiner.on((String)", ").join((Object)lastName, (Object)firstName, new Object[0]);
            String employeeName = String.format("%s [%s]", employeeFullName, employeePersonalNumber);
            rowBuilder1.add((AbstractCell)AttendanceReportPrintService.descriptionCell((PrintFonts)printFonts, (int)detailsFontSize, (String)employeeName, (Color)bgColor, (HorizontalAlignment)HorizontalAlignment.LEFT, (Map)AttendanceReportPrintService.defaultBorder((Iterable)TL, (float)0.75f, (float)0.0f)));
            for (LocalDate neededDate : neededDates) {
                if (attendances.containsKey(neededDate)) {
                    AttendanceReportPrintStandard attendanceReportPrintStandard = (AttendanceReportPrintStandard)attendances.get(neededDate);
                    EAttendanceDayType employeeDayType = (EAttendanceDayType)MoreObjects.firstNonNull((Object)attendanceReportPrintStandard.getEmployeeDayType(), (Object)EAttendanceDayType.UNKNOWN);
                    PDFont font = BOLD_ATTENDANCE_TYPES.contains(employeeDayType) ? printFonts.getBold() : printFonts.getRegular();
                    Color dayColor = AttendanceReportPrintService.attendanceBGColor((AttendanceReportPrintStandard)attendanceReportPrintStandard, (Color)bgColor);
                    String text = AttendanceReportPrintService.firstRow((EAttendanceDayType)employeeDayType, (AttendanceReportPrintStandard)attendanceReportPrintStandard);
                    rowBuilder1.add((AbstractCell)AttendanceReportPrintService.descriptionCell((PDFont)font, (int)detailsFontSize, (String)text, (Color)dayColor, (HorizontalAlignment)HorizontalAlignment.LEFT, (Map)AttendanceReportPrintService.defaultBorder((Iterable)T, (float)0.75f, (float)0.25f)));
                    continue;
                }
                rowBuilder1.add((AbstractCell)AttendanceReportPrintService.descriptionCell((PrintSetup)printSetup, (String)"?"));
            }
            Map durationAggregatedByType = attendanceReportPrintStandardRow.getDurationAggregatedByType();
            Duration standardDurationAggregated = durationAggregatedByType.getOrDefault(EAggregatedAttendanceDayType.AGG_WORK, Duration.ZERO);
            String standardDurationAggregatedString = AttendanceReportPrintService.formatDuration((Duration)standardDurationAggregated);
            rowBuilder1.add((AbstractCell)AttendanceReportPrintService.descriptionCell((PrintFonts)printFonts, (int)detailsFontSize, (String)standardDurationAggregatedString, (Color)bgColor, (HorizontalAlignment)HorizontalAlignment.LEFT, (Map)AttendanceReportPrintService.defaultBorder((Iterable)T, (float)0.75f, (float)0.25f)));
            Duration vacationDurationAggregated = durationAggregatedByType.getOrDefault(EAggregatedAttendanceDayType.AGG_VACATION, Duration.ZERO);
            String vacationDurationAggregatedString = AttendanceReportPrintService.formatDuration((Duration)vacationDurationAggregated);
            rowBuilder1.add((AbstractCell)AttendanceReportPrintService.descriptionCell((PrintFonts)printFonts, (int)detailsFontSize, (String)vacationDurationAggregatedString, (Color)bgColor, (HorizontalAlignment)HorizontalAlignment.LEFT, (Map)AttendanceReportPrintService.defaultBorder((Iterable)T, (float)0.75f, (float)0.25f)));
            Duration missingDurationAggregated = durationAggregatedByType.getOrDefault(EAggregatedAttendanceDayType.AGG_ABSENT, Duration.ZERO);
            String missingDurationAggregatedString = AttendanceReportPrintService.formatDuration((Duration)missingDurationAggregated);
            rowBuilder1.add((AbstractCell)AttendanceReportPrintService.descriptionCell((PrintFonts)printFonts, (int)detailsFontSize, (String)missingDurationAggregatedString, (Color)bgColor, (HorizontalAlignment)HorizontalAlignment.LEFT, (Map)AttendanceReportPrintService.defaultBorder((Iterable)T, (float)0.75f, (float)0.25f)));
            Duration onDutyDurationAggregated = durationAggregatedByType.getOrDefault(EAggregatedAttendanceDayType.AGG_ON_DUTY, Duration.ZERO);
            String onDutyDurationAggregatedString = AttendanceReportPrintService.formatDuration((Duration)onDutyDurationAggregated);
            rowBuilder1.add((AbstractCell)AttendanceReportPrintService.descriptionCell((PrintFonts)printFonts, (int)detailsFontSize, (String)onDutyDurationAggregatedString, (Color)bgColor, (HorizontalAlignment)HorizontalAlignment.LEFT, (Map)AttendanceReportPrintService.defaultBorder((Iterable)T, (float)0.75f, (float)0.25f)));
            Duration durationAggregated = AttendanceReportPrintService.durationSum((Map)durationAggregatedByType);
            String durationAggregatedString = AttendanceReportPrintService.durationAsHourString((Duration)durationAggregated);
            rowBuilder1.add((AbstractCell)AttendanceReportPrintService.descriptionCell((PrintFonts)printFonts, (int)detailsFontSize, (String)durationAggregatedString, (int)1, (int)1, (Color)bgColor, (HorizontalAlignment)HorizontalAlignment.LEFT, (Map)AttendanceReportPrintService.defaultBorder((Iterable)TR, (float)0.75f, (float)0.25f)));
            Row row1 = rowBuilder1.build();
            Row.RowBuilder rowBuilder2 = Row.builder();
            rowBuilder2.add((AbstractCell)AttendanceReportPrintService.descriptionCell((PrintFonts)printFonts, (int)detailsFontSize, (String)"", (Color)bgColor, (HorizontalAlignment)HorizontalAlignment.RIGHT, (Map)AttendanceReportPrintService.defaultBorder((Iterable)LB, (float)0.75f, (float)0.0f)));
            for (LocalDate neededDate : neededDates) {
                if (attendances.containsKey(neededDate)) {
                    AttendanceReportPrintStandard attendanceReportPrintStandard = (AttendanceReportPrintStandard)attendances.get(neededDate);
                    EAttendanceDayType employeeDayType = attendanceReportPrintStandard.getEmployeeDayType();
                    PDFont font = BOLD_ATTENDANCE_TYPES.contains(employeeDayType) ? printFonts.getBold() : printFonts.getRegular();
                    Color dayColor = AttendanceReportPrintService.attendanceBGColor((AttendanceReportPrintStandard)attendanceReportPrintStandard, (Color)bgColor);
                    String text = AttendanceReportPrintService.secondRow((EAttendanceDayType)employeeDayType, (AttendanceReportPrintStandard)attendanceReportPrintStandard);
                    rowBuilder2.add((AbstractCell)AttendanceReportPrintService.descriptionCell((PDFont)font, (int)detailsFontSize, (String)text, (Color)dayColor, (HorizontalAlignment)HorizontalAlignment.LEFT, (Map)AttendanceReportPrintService.defaultBorder((Iterable)B, (float)0.75f, (float)0.25f)));
                    continue;
                }
                rowBuilder2.add((AbstractCell)AttendanceReportPrintService.descriptionCell((PrintSetup)printSetup, (String)"?"));
            }
            Duration badWeatherAggregated = durationAggregatedByType.getOrDefault(EAggregatedAttendanceDayType.AGG_BAD_WEATHER, Duration.ZERO);
            String badWeatherAggregatedString = AttendanceReportPrintService.formatDuration((Duration)badWeatherAggregated);
            rowBuilder2.add((AbstractCell)AttendanceReportPrintService.descriptionCell((PrintFonts)printFonts, (int)detailsFontSize, (String)badWeatherAggregatedString, (Color)bgColor, (HorizontalAlignment)HorizontalAlignment.LEFT, (Map)AttendanceReportPrintService.defaultBorder((Iterable)B, (float)0.75f, (float)0.25f)));
            Duration sickDurationAggregated = durationAggregatedByType.getOrDefault(EAggregatedAttendanceDayType.AGG_SICK, Duration.ZERO);
            Duration badWeatherSickDurationAggregated = durationAggregatedByType.getOrDefault(EAggregatedAttendanceDayType.AGG_BAD_WEATHER_SICK, Duration.ZERO);
            Duration sickSum = sickDurationAggregated.plus(badWeatherSickDurationAggregated);
            String sickSumAsString = AttendanceReportPrintService.formatDuration((Duration)sickSum);
            rowBuilder2.add((AbstractCell)AttendanceReportPrintService.descriptionCell((PrintFonts)printFonts, (int)detailsFontSize, (String)sickSumAsString, (Color)bgColor, (HorizontalAlignment)HorizontalAlignment.LEFT, (Map)AttendanceReportPrintService.defaultBorder((Iterable)B, (float)0.75f, (float)0.25f)));
            Duration helpDurationAggregated = durationAggregatedByType.getOrDefault(EAggregatedAttendanceDayType.AGG_HELP_WAGE_HOURS, Duration.ZERO);
            String helpDurationAggregatedString = AttendanceReportPrintService.formatDuration((Duration)helpDurationAggregated);
            rowBuilder2.add((AbstractCell)AttendanceReportPrintService.descriptionCell((PrintFonts)printFonts, (int)detailsFontSize, (String)helpDurationAggregatedString, (Color)bgColor, (HorizontalAlignment)HorizontalAlignment.LEFT, (Map)AttendanceReportPrintService.defaultBorder((Iterable)B, (float)0.75f, (float)0.25f)));
            Duration childSickDurationAggregated = durationAggregatedByType.getOrDefault(EAggregatedAttendanceDayType.AGG_CHILD_SICK_LEAVE, Duration.ZERO);
            String childSickDurationAggregatedString = AttendanceReportPrintService.formatDuration((Duration)childSickDurationAggregated);
            rowBuilder2.add((AbstractCell)AttendanceReportPrintService.descriptionCell((PrintFonts)printFonts, (int)detailsFontSize, (String)childSickDurationAggregatedString, (Color)bgColor, (HorizontalAlignment)HorizontalAlignment.LEFT, (Map)AttendanceReportPrintService.defaultBorder((Iterable)B, (float)0.75f, (float)0.25f)));
            BigDecimal incentiveWage = attendanceReportPrintStandardRow.getIncentiveWageAggregated();
            String incentiveWageAsString = AttendanceReportPrintService.nullSafeCurrency((BigDecimal)incentiveWage, (Currency)attendanceReportInfo.getCurrency());
            rowBuilder2.add((AbstractCell)AttendanceReportPrintService.descriptionCell((PrintFonts)printFonts, (int)detailsFontSize, (String)incentiveWageAsString, (int)1, (int)1, (Color)bgColor, (HorizontalAlignment)HorizontalAlignment.LEFT, (Map)AttendanceReportPrintService.defaultBorder((Iterable)RB, (float)0.75f, (float)0.25f)));
            Row row2 = rowBuilder2.build();
            attendancesTableBuilder.addRow(row1);
            attendancesTableBuilder.addRow(row2);
        }
        return attendancesTableBuilder.build();
    }

    @Nonnull
    private static String firstRow(@NonNull EAttendanceDayType attendanceDayType, @NonNull AttendanceReportPrintStandard attendanceReportPrintStandard) {
        if (attendanceDayType == null) {
            throw new NullPointerException("attendanceDayType is marked non-null but is null");
        }
        if (attendanceReportPrintStandard == null) {
            throw new NullPointerException("attendanceReportPrintStandard is marked non-null but is null");
        }
        Duration badWeatherDuration = attendanceReportPrintStandard.getBadWeatherDuration();
        Duration workTimeDuration = attendanceReportPrintStandard.getWorkDuration();
        Duration workDuration = attendanceReportPrintStandard.getWorkDuration();
        switch (1.$SwitchMap$de$qfm$erp$service$model$jpa$employee$attendance$EAttendanceDayType[attendanceDayType.ordinal()]) {
            case 1: 
            case 2: 
            case 3: {
                return AttendanceReportPrintService.formatDuration((Duration)workDuration);
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                return attendanceDayType.abbreviation();
            }
            case 10: {
                return "";
            }
        }
        return "N/A";
    }

    @Nonnull
    private static String secondRow(@NonNull EAttendanceDayType attendanceDayType, @NonNull AttendanceReportPrintStandard attendanceReportPrintStandard) {
        if (attendanceDayType == null) {
            throw new NullPointerException("attendanceDayType is marked non-null but is null");
        }
        if (attendanceReportPrintStandard == null) {
            throw new NullPointerException("attendanceReportPrintStandard is marked non-null but is null");
        }
        Duration badWeatherDuration = attendanceReportPrintStandard.getBadWeatherDuration();
        Duration workTimeDuration = attendanceReportPrintStandard.getWorkDuration();
        Duration workDuration = attendanceReportPrintStandard.getWorkDuration();
        switch (1.$SwitchMap$de$qfm$erp$service$model$jpa$employee$attendance$EAttendanceDayType[attendanceDayType.ordinal()]) {
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                return "";
            }
            case 2: {
                return AttendanceReportPrintService.formatDuration((Duration)badWeatherDuration);
            }
            case 10: {
                return "";
            }
        }
        return "N/A";
    }

    private static /* synthetic */ void lambda$details$12(Row.RowBuilder headlineBuilder_2, PDFont fontBold, int fontSize, Map daysBorderR2, int item) {
        headlineBuilder_2.add((AbstractCell)AttendanceReportPrintService.descriptionCell((PDFont)fontBold, (int)fontSize, (String)"", (Color)Color.WHITE, (HorizontalAlignment)HorizontalAlignment.LEFT, (Map)daysBorderR2));
    }

    private static /* synthetic */ void lambda$details$11(Row.RowBuilder headlineBuilder_1, PDFont fontBold, int fontSize, Map daysBorderR1, int item) {
        headlineBuilder_1.add((AbstractCell)AttendanceReportPrintService.descriptionCell((PDFont)fontBold, (int)fontSize, (String)Integer.toString(1 + item), (Color)Color.WHITE, (HorizontalAlignment)HorizontalAlignment.LEFT, (Map)daysBorderR1));
    }
}

