/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.service.service.pdf;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import de.leancoders.common.helper.DateTimeHelper;
import de.qfm.erp.service.model.jpa.configuration.ConfigurationCompany;
import de.qfm.erp.service.model.jpa.filestore.FileStore;
import de.qfm.erp.service.model.jpa.invoice.InvoiceAttachment;
import de.qfm.erp.service.model.jpa.invoice.InvoicePosition;
import de.qfm.erp.service.model.jpa.user.User;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.sql.Blob;
import java.sql.SQLException;
import java.time.LocalDate;
import java.time.ZoneOffset;
import java.util.Date;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nonnull;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.mustangproject.BankDetails;
import org.mustangproject.Contact;
import org.mustangproject.FileAttachment;
import org.mustangproject.Invoice;
import org.mustangproject.Item;
import org.mustangproject.Product;
import org.mustangproject.TradeParty;
import org.mustangproject.XMLTools;
import org.mustangproject.ZUGFeRD.IExportableTransaction;
import org.mustangproject.ZUGFeRD.OXExporterFromA1;
import org.mustangproject.ZUGFeRD.Profiles;
import org.mustangproject.ZUGFeRD.ZUGFeRD2PullProvider;
import org.springframework.stereotype.Service;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class ZugferdService {
    private static final Logger log = LogManager.getLogger(ZugferdService.class);

    public boolean inject(@NonNull InputStream inputStream, @NonNull OutputStream outputStream, @NonNull ConfigurationCompany configurationCompany, @NonNull de.qfm.erp.service.model.jpa.invoice.Invoice invoice) throws SQLException {
        boolean bl;
        block12: {
            if (inputStream == null) {
                throw new NullPointerException("inputStream is marked non-null but is null");
            }
            if (outputStream == null) {
                throw new NullPointerException("outputStream is marked non-null but is null");
            }
            if (configurationCompany == null) {
                throw new NullPointerException("configurationCompany is marked non-null but is null");
            }
            if (invoice == null) {
                throw new NullPointerException("invoice is marked non-null but is null");
            }
            User accountedByUser = invoice.getAccountedByUser();
            String creator = null != accountedByUser ? accountedByUser.getFullName() : "n/a";
            Invoice zugferdInvoice = ZugferdService.createInvoice((ConfigurationCompany)configurationCompany, (de.qfm.erp.service.model.jpa.invoice.Invoice)invoice);
            OXExporterFromA1 exporter = new OXExporterFromA1().setProducer("AppQ").setCreator(creator).setZUGFeRDVersion(1).ignorePDFAErrors().load(inputStream);
            try {
                exporter.setTransaction((IExportableTransaction)zugferdInvoice);
                exporter.export(outputStream);
                bl = true;
                if (exporter == null) break block12;
            }
            catch (Throwable throwable) {
                try {
                    if (exporter != null) {
                        try {
                            exporter.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    log.error("Error inject Zugferd Invoice: {}", (Object)e.getMessage(), (Object)e);
                    return false;
                }
            }
            exporter.close();
        }
        return bl;
    }

    @Nonnull
    public byte[] xml(@NonNull ConfigurationCompany configurationCompany, @NonNull de.qfm.erp.service.model.jpa.invoice.Invoice invoice) throws SQLException {
        if (configurationCompany == null) {
            throw new NullPointerException("configurationCompany is marked non-null but is null");
        }
        if (invoice == null) {
            throw new NullPointerException("invoice is marked non-null but is null");
        }
        Invoice zugferdInvoice = ZugferdService.createInvoice((ConfigurationCompany)configurationCompany, (de.qfm.erp.service.model.jpa.invoice.Invoice)invoice);
        ZUGFeRD2PullProvider zf2p = new ZUGFeRD2PullProvider();
        zf2p.setProfile(Profiles.getByName((String)"XRechnung"));
        zf2p.generateXML((IExportableTransaction)zugferdInvoice);
        return zf2p.getXML();
    }

    @Nonnull
    private static Invoice createInvoice(@NonNull ConfigurationCompany configurationCompany, @NonNull de.qfm.erp.service.model.jpa.invoice.Invoice invoice) throws SQLException {
        if (configurationCompany == null) {
            throw new NullPointerException("configurationCompany is marked non-null but is null");
        }
        if (invoice == null) {
            throw new NullPointerException("invoice is marked non-null but is null");
        }
        String financeRoutingReferenceId = StringUtils.trimToEmpty((String)invoice.getFinanceRoutingReferenceId());
        String invoiceNumber = StringUtils.trimToEmpty((String)invoice.getInvoiceNumber());
        LocalDate invoiceDateLD = (LocalDate)MoreObjects.firstNonNull((Object)invoice.getInvoiceDate(), (Object)DateTimeHelper.today());
        LocalDate dueDateLD = invoiceDateLD.plusDays(((Integer)MoreObjects.firstNonNull((Object)invoice.getFinanceTimeForPayment(), (Object)30)).intValue());
        String orderNumber = invoice.getOrderNumber();
        Date invoiceDate = ZugferdService.date((LocalDate)invoiceDateLD);
        Date dueDate = ZugferdService.date((LocalDate)dueDateLD);
        TradeParty sender = ZugferdService.sender((ConfigurationCompany)configurationCompany);
        TradeParty recipient = ZugferdService.recipient((de.qfm.erp.service.model.jpa.invoice.Invoice)invoice);
        Iterable zugferdItems = ZugferdService.items((de.qfm.erp.service.model.jpa.invoice.Invoice)invoice);
        Invoice zugferd = new Invoice().setDueDate(dueDate).setIssueDate(invoiceDate).setDeliveryDate(invoiceDate).setSender(sender).setRecipient(recipient).setBuyerOrderReferencedDocumentID(orderNumber).setReferenceNumber(financeRoutingReferenceId).setNumber(invoiceNumber);
        zugferdItems.forEach(arg_0 -> ((Invoice)zugferd).addItem(arg_0));
        Set invoiceAttachments = invoice.getInvoiceAttachments();
        for (InvoiceAttachment invoiceAttachment : invoiceAttachments) {
            int length;
            Long id = invoiceAttachment.getId();
            String fileName = XMLTools.encodeXML((CharSequence)invoiceAttachment.getName());
            String uniqueFileName = "%s-%s".formatted(id, fileName);
            FileStore fileStore = invoiceAttachment.getFileStore();
            String mimeType = fileStore.getUploadContentType();
            Blob data = fileStore.getData();
            if (null == data || (length = (int)data.length()) <= 0) continue;
            byte[] bytes = data.getBytes(1L, length);
            zugferd.embedFileInXML(new FileAttachment(uniqueFileName, mimeType, uniqueFileName, bytes));
        }
        return zugferd;
    }

    @Nonnull
    private static TradeParty recipient(@NonNull de.qfm.erp.service.model.jpa.invoice.Invoice invoice) {
        if (invoice == null) {
            throw new NullPointerException("invoice is marked non-null but is null");
        }
        String invoiceName = StringUtils.trimToEmpty((String)invoice.getInvoiceName());
        String invoiceStreet = StringUtils.trimToEmpty((String)invoice.getInvoiceStreet());
        String invoiceStreetNo = StringUtils.trimToEmpty((String)invoice.getInvoiceStreetNo());
        String invoiceZip = StringUtils.trimToEmpty((String)invoice.getInvoiceZip());
        String invoiceCity = StringUtils.trimToEmpty((String)invoice.getInvoiceCity());
        String street = StringUtils.trimToEmpty((String)String.format("%s %s", invoiceStreet, invoiceStreetNo));
        return new TradeParty(invoiceName, street, invoiceZip, invoiceCity, "DE");
    }

    @Nonnull
    private static TradeParty sender(@NonNull ConfigurationCompany configurationCompany) {
        if (configurationCompany == null) {
            throw new NullPointerException("configurationCompany is marked non-null but is null");
        }
        String customerName1 = StringUtils.trimToEmpty((String)configurationCompany.getCompanyName1());
        String customerName2 = StringUtils.trimToEmpty((String)configurationCompany.getCompanyName2());
        String customerStreet = StringUtils.trimToEmpty((String)configurationCompany.getCompanyStreet());
        String customerStreetNo = StringUtils.trimToEmpty((String)configurationCompany.getCompanyStreetNo());
        String city = StringUtils.trimToEmpty((String)configurationCompany.getCompanyCity());
        String zipCode = StringUtils.trimToEmpty((String)configurationCompany.getCompanyZipCode());
        String vatId = StringUtils.trimToEmpty((String)configurationCompany.getCompanyVatId());
        String contactName = StringUtils.trimToEmpty((String)configurationCompany.getCompanyContactName());
        String contactPhone = StringUtils.trimToEmpty((String)configurationCompany.getCompanyPhone());
        String contactEmail = StringUtils.trimToEmpty((String)configurationCompany.getCompanyEmail());
        String name = StringUtils.trimToEmpty((String)String.format("%s %s", customerName1, customerName2));
        String street = StringUtils.trimToEmpty((String)String.format("%s %s", customerStreet, customerStreetNo));
        Iterable bankDetails = ZugferdService.bankDetails((ConfigurationCompany)configurationCompany);
        TradeParty tradeParty = new TradeParty(name, street, zipCode, city, "DE").addTaxID(vatId).addVATID(vatId).setContact(new Contact(contactName, contactPhone, contactEmail));
        bankDetails.forEach(arg_0 -> ((TradeParty)tradeParty).addBankDetails(arg_0));
        return tradeParty;
    }

    @Nonnull
    private static Iterable<BankDetails> bankDetails(@NonNull ConfigurationCompany configurationCompany) {
        if (configurationCompany == null) {
            throw new NullPointerException("configurationCompany is marked non-null but is null");
        }
        ImmutableList.Builder bankDetailsBuilder = ImmutableList.builder();
        ZugferdService.bankDetail((String)StringUtils.trimToEmpty((String)configurationCompany.getCompanyBank1Bic()), (String)StringUtils.trimToEmpty((String)configurationCompany.getCompanyBank1IBAN())).ifPresent(arg_0 -> ((ImmutableList.Builder)bankDetailsBuilder).add(arg_0));
        ZugferdService.bankDetail((String)StringUtils.trimToEmpty((String)configurationCompany.getCompanyBank2Bic()), (String)StringUtils.trimToEmpty((String)configurationCompany.getCompanyBank2IBAN())).ifPresent(arg_0 -> ((ImmutableList.Builder)bankDetailsBuilder).add(arg_0));
        ZugferdService.bankDetail((String)StringUtils.trimToEmpty((String)configurationCompany.getCompanyBank3Bic()), (String)StringUtils.trimToEmpty((String)configurationCompany.getCompanyBank3IBAN())).ifPresent(arg_0 -> ((ImmutableList.Builder)bankDetailsBuilder).add(arg_0));
        return bankDetailsBuilder.build();
    }

    @Nonnull
    private static Optional<BankDetails> bankDetail(@NonNull String bic, @NonNull String iban) {
        if (bic == null) {
            throw new NullPointerException("bic is marked non-null but is null");
        }
        if (iban == null) {
            throw new NullPointerException("iban is marked non-null but is null");
        }
        if (StringUtils.isNotBlank((CharSequence)bic) && StringUtils.isNotBlank((CharSequence)iban)) {
            return Optional.of(new BankDetails(iban, bic));
        }
        return Optional.empty();
    }

    @Nonnull
    private static Iterable<Item> items(de.qfm.erp.service.model.jpa.invoice.Invoice invoice) {
        BigDecimal financeVAT = (BigDecimal)MoreObjects.firstNonNull((Object)invoice.getVatPercent(), (Object)BigDecimal.ZERO);
        Set invoicePositions = (Set)MoreObjects.firstNonNull((Object)invoice.getInvoicePositions(), (Object)ImmutableSet.of());
        return (Iterable)invoicePositions.stream().sorted((l, r) -> {
            String left = StringUtils.trimToEmpty((String)l.getPositionNumber());
            String right = StringUtils.trimToEmpty((String)r.getPositionNumber());
            return StringUtils.compareIgnoreCase((String)left, (String)right);
        }).map(item -> ZugferdService.item((BigDecimal)financeVAT, (InvoicePosition)item)).collect(ImmutableList.toImmutableList());
    }

    @Nonnull
    private static Item item(@NonNull BigDecimal vat, @NonNull InvoicePosition invoicePosition) {
        if (vat == null) {
            throw new NullPointerException("vat is marked non-null but is null");
        }
        if (invoicePosition == null) {
            throw new NullPointerException("invoicePosition is marked non-null but is null");
        }
        BigDecimal amount = (BigDecimal)MoreObjects.firstNonNull((Object)invoicePosition.getAmount(), (Object)BigDecimal.ZERO);
        BigDecimal pricePerUnit = (BigDecimal)MoreObjects.firstNonNull((Object)invoicePosition.getPricePerUnit(), (Object)BigDecimal.ZERO);
        String positionNumber = StringUtils.trimToEmpty((String)invoicePosition.getPositionNumber());
        String shortText = StringUtils.trimToEmpty((String)invoicePosition.getShortText());
        String unit = StringUtils.trimToEmpty((String)invoicePosition.getUnit());
        return new Item(new Product(positionNumber, shortText, unit, vat), pricePerUnit, amount);
    }

    @Nonnull
    private static Date date(@NonNull LocalDate referenceDate) {
        if (referenceDate == null) {
            throw new NullPointerException("referenceDate is marked non-null but is null");
        }
        return Date.from(referenceDate.atStartOfDay().toInstant(ZoneOffset.UTC));
    }
}

