/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.service.service.pdf;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import de.qfm.erp.service.helper.BigDecimalHelper;
import de.qfm.erp.service.model.internal.invoice.EPdfExtractType;
import de.qfm.erp.service.model.internal.invoice.InvoicePdfExtraction;
import de.qfm.erp.service.model.internal.message.EMessageKey;
import de.qfm.erp.service.service.service.MessageService;
import de.qfm.erp.service.service.service.pdf.InvoicePdfExtractor;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.time.format.FormatStyle;
import java.util.List;
import java.util.Locale;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.springframework.stereotype.Service;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class TelekomInvoicePdfExtractor
extends InvoicePdfExtractor {
    private static final Logger log = LogManager.getLogger(TelekomInvoicePdfExtractor.class);
    protected static final DateTimeFormatter DATE_TIME_FORMATTER_DE = DateTimeFormatter.ofLocalizedDate(FormatStyle.MEDIUM).withLocale(Locale.GERMAN);
    private final MessageService messageService;

    public TelekomInvoicePdfExtractor(MessageService messageService) {
        super(EPdfExtractType.TELEKOM);
        this.messageService = messageService;
    }

    public boolean canExtract(@NonNull PDDocument document, @NonNull String text, @NonNull Iterable<String> rows) {
        if (document == null) {
            throw new NullPointerException("document is marked non-null but is null");
        }
        if (text == null) {
            throw new NullPointerException("text is marked non-null but is null");
        }
        if (rows == null) {
            throw new NullPointerException("rows is marked non-null but is null");
        }
        log.info("Parsing Result: {}", (Object)text);
        return StringUtils.contains((CharSequence)text, (CharSequence)"Telekom Deutschland GmbH");
    }

    public InvoicePdfExtraction extract(@NonNull String text, @NonNull Iterable<String> rows) {
        if (text == null) {
            throw new NullPointerException("text is marked non-null but is null");
        }
        if (rows == null) {
            throw new NullPointerException("rows is marked non-null but is null");
        }
        String lerfs = TelekomInvoicePdfExtractor.extract(rows, (String)"LERF-Nr.:");
        String referenceNumberCandidate = TelekomInvoicePdfExtractor.extract(rows, (String)"Referenznummer:");
        String projectExecutionPeriodCandidate = TelekomInvoicePdfExtractor.extract(rows, (String)"Leistungszeitraum:");
        String orderNumber1Candidate = TelekomInvoicePdfExtractor.extract(rows, (String)"Bestellnr.:");
        String orderNumber2Candidate = TelekomInvoicePdfExtractor.extract(rows, (String)"SM Auftragsnummer:");
        String voucherNumberCandidate = TelekomInvoicePdfExtractor.extract(rows, (String)"Gutschrift Nr.");
        String creditVoucherNumberCandidate = TelekomInvoicePdfExtractor.extract(rows, (String)"Belegnummer");
        String voucherDateCandidate = TelekomInvoicePdfExtractor.extract(rows, (String)"Datum");
        String orderNumber1 = StringUtils.substringBefore((String)orderNumber1Candidate, (String)" ");
        String orderNumber2 = StringUtils.substringBefore((String)orderNumber2Candidate, (String)" ");
        String referenceNumber = StringUtils.substringBefore((String)referenceNumberCandidate, (String)" ");
        String voucherNumber = StringUtils.substringBefore((String)voucherNumberCandidate, (String)" ");
        String creditVoucherNumber = StringUtils.substringBefore((String)creditVoucherNumberCandidate, (String)" ");
        String orderDateString = StringUtils.substringAfterLast((String)referenceNumberCandidate, (String)" ");
        String projectExecutionFromString = StringUtils.substringBefore((String)projectExecutionPeriodCandidate, (String)" ");
        String projectExecutionEndString = StringUtils.substringAfterLast((String)projectExecutionPeriodCandidate, (String)" ");
        String voucherDateString = StringUtils.trimToEmpty((String)voucherDateCandidate);
        String priceNetRow = TelekomInvoicePdfExtractor.extract(rows, (String)"Nettowert");
        String priceGrossRow = TelekomInvoicePdfExtractor.extract(rows, (String)"Rechnungsbetrag:");
        String taxRow = TelekomInvoicePdfExtractor.extract(rows, (String)"USt.:");
        String priceNetString = StringUtils.trimToEmpty((String)StringUtils.substringBefore((String)priceNetRow, (String)"EUR"));
        String priceGrossString = StringUtils.trimToEmpty((String)StringUtils.substringBefore((String)priceGrossRow, (String)"EUR"));
        String taxString = StringUtils.trimToEmpty((String)StringUtils.substringBefore((String)taxRow, (String)"%"));
        ImmutableList costCenters = ImmutableList.copyOf((Iterable)TelekomInvoicePdfExtractor.costCenters((String)lerfs));
        ImmutableList measurementNumbers = ImmutableList.copyOf((Iterable)TelekomInvoicePdfExtractor.measurementNumbers((String)lerfs));
        if (measurementNumbers.isEmpty()) {
            return InvoicePdfExtraction.error((String)this.messageService.get(EMessageKey.INVOICE__UPLOAD_PDF_ERROR__NO_MEASUREMENT_FOUND), (EPdfExtractType)this.pdfExtractType);
        }
        String costCenter = (String)Iterables.get((Iterable)costCenters, (int)0, (Object)"");
        LocalDate orderDate = LocalDate.from(DATE_TIME_FORMATTER_DE.parse(orderDateString));
        LocalDate voucherDate = LocalDate.from(DATE_TIME_FORMATTER_DE.parse(voucherDateString));
        LocalDate projectExecutionFrom = LocalDate.from(DATE_TIME_FORMATTER_DE.parse(projectExecutionFromString));
        LocalDate projectExecutionEnd = LocalDate.from(DATE_TIME_FORMATTER_DE.parse(projectExecutionEndString));
        BigDecimal valueOverallNet = BigDecimalHelper.parseGermanCurrency((String)priceNetString);
        BigDecimal valueOverallGross = BigDecimalHelper.parseGermanCurrency((String)priceGrossString);
        BigDecimal VAT = BigDecimalHelper.parseGermanCurrency((String)taxString);
        BigDecimal valueOverallVAT = BigDecimal.ZERO;
        return InvoicePdfExtraction.success((EPdfExtractType)this.pdfExtractType, (String)orderNumber1, (String)orderNumber2, (String)referenceNumber, (String)voucherNumber, (String)creditVoucherNumber, (LocalDate)orderDate, (LocalDate)voucherDate, (String)costCenter, (LocalDate)projectExecutionFrom, (LocalDate)projectExecutionEnd, (BigDecimal)valueOverallNet, (BigDecimal)VAT, (BigDecimal)valueOverallVAT, (BigDecimal)valueOverallGross, (List)measurementNumbers);
    }
}

