/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.service.service.pdf;

import com.google.common.base.CharMatcher;
import com.google.common.base.Splitter;
import de.qfm.erp.service.model.internal.invoice.EPdfExtractType;
import de.qfm.erp.service.model.internal.invoice.InvoicePdfExtraction;
import de.qfm.erp.service.service.service.pdf.InvoicePdfExtractor;
import java.io.IOException;
import java.util.List;
import javax.annotation.Nonnull;
import lombok.NonNull;
import org.apache.pdfbox.Loader;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.text.PDFTextStripper;
import org.springframework.stereotype.Service;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class PdfExtractor {
    protected static final Splitter ROW_SPLITTER = Splitter.on((CharMatcher)CharMatcher.anyOf((CharSequence)"\n\r").precomputed());
    private final List<InvoicePdfExtractor> pdfExtractors;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nonnull
    public InvoicePdfExtraction extract(byte[] buffer) throws IOException {
        if (null == buffer) return InvoicePdfExtraction.error((String)"document is empty", (EPdfExtractType)EPdfExtractType.NONE);
        if (buffer.length <= 0) return InvoicePdfExtraction.error((String)"document is empty", (EPdfExtractType)EPdfExtractType.NONE);
        try {
            Iterable rows;
            PDFTextStripper stripper;
            String text;
            InvoicePdfExtractor pdfExtractor;
            boolean canExtract;
            PDDocument document;
            block12: {
                document = Loader.loadPDF((byte[])buffer);
                if (document.isEncrypted()) {
                    InvoicePdfExtraction invoicePdfExtraction = InvoicePdfExtraction.error((String)"document is encrypted", (EPdfExtractType)EPdfExtractType.NONE);
                    return invoicePdfExtraction;
                }
                break block12;
                finally {
                    if (document != null) {
                        document.close();
                    }
                }
            }
            InvoicePdfExtraction invoicePdfExtraction = this.pdfExtractors.iterator();
            do {
                if (invoicePdfExtraction.hasNext()) continue;
                invoicePdfExtraction = InvoicePdfExtraction.error((String)"no Extractor for PDF", (EPdfExtractType)EPdfExtractType.NONE);
                return invoicePdfExtraction;
            } while (!(canExtract = (pdfExtractor = (InvoicePdfExtractor)invoicePdfExtraction.next()).canExtract(document, text = (stripper = new PDFTextStripper()).getText(document), rows = PdfExtractor.rows((String)text))));
            InvoicePdfExtraction invoicePdfExtraction2 = pdfExtractor.extract(text, rows);
            return invoicePdfExtraction2;
        }
        catch (Exception e) {
            return InvoicePdfExtraction.error((String)("document is not a PDF: " + e.getMessage()), (EPdfExtractType)EPdfExtractType.NONE);
        }
    }

    @Nonnull
    protected static Iterable<String> rows(@NonNull String text) {
        if (text == null) {
            throw new NullPointerException("text is marked non-null but is null");
        }
        return ROW_SPLITTER.trimResults().omitEmptyStrings().splitToList((CharSequence)text);
    }

    public PdfExtractor(List<InvoicePdfExtractor> pdfExtractors) {
        this.pdfExtractors = pdfExtractors;
    }
}

