/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.service.service.pdf;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.CharMatcher;
import com.google.common.base.Predicate;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Streams;
import de.qfm.erp.service.model.internal.invoice.EPdfExtractType;
import de.qfm.erp.service.model.internal.invoice.InvoicePdfExtraction;
import javax.annotation.Nonnull;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;
import org.apache.pdfbox.pdmodel.PDDocument;

public abstract class InvoicePdfExtractor {
    protected final EPdfExtractType pdfExtractType;
    private static final CharMatcher MEASUREMENT_NUMBER_CM = CharMatcher.anyOf((CharSequence)"0123456789").precomputed();
    private static final String MEASUREMENT_SEPARATOR_CHAR = " ";
    private static final Splitter MEASUREMENT_NUMBER_SPLITTER = Splitter.on((String)" ").trimResults().omitEmptyStrings();
    private static final Predicate<String> VALID_MEASUREMENT_NUMBER = x -> null != x && x.matches("^\\d{6}$");
    private static final CharMatcher CC_NUMBER_CM = CharMatcher.anyOf((CharSequence)"0123456789").precomputed();
    private static final String CC_SEPARATOR_CHAR = " ";
    private static final Splitter CC_NUMBER_SPLITTER = Splitter.on((String)" ").trimResults().omitEmptyStrings();
    private static final Predicate<String> VALID_CC_NUMBER = x -> null != x && x.matches("^\\d{3}$");

    public abstract boolean canExtract(@NonNull PDDocument var1, @NonNull String var2, @NonNull Iterable<String> var3);

    public abstract InvoicePdfExtraction extract(@NonNull String var1, @NonNull Iterable<String> var2);

    @Nonnull
    protected static String extract(@NonNull Iterable<String> rows, @NonNull String prefix) {
        if (rows == null) {
            throw new NullPointerException("rows is marked non-null but is null");
        }
        if (prefix == null) {
            throw new NullPointerException("prefix is marked non-null but is null");
        }
        return Streams.stream(rows).filter(item -> StringUtils.startsWithIgnoreCase((CharSequence)item, (CharSequence)prefix)).map(item -> StringUtils.removeStartIgnoreCase((String)item, (String)prefix)).map(StringUtils::trimToEmpty).filter(StringUtils::isNotEmpty).findFirst().orElse("");
    }

    @Nonnull
    protected static Iterable<String> contains(@NonNull Iterable<String> rows, @NonNull String contains) {
        if (rows == null) {
            throw new NullPointerException("rows is marked non-null but is null");
        }
        if (contains == null) {
            throw new NullPointerException("contains is marked non-null but is null");
        }
        return (Iterable)Streams.stream(rows).filter(item -> StringUtils.contains((CharSequence)item, (CharSequence)contains)).map(StringUtils::trimToEmpty).filter(StringUtils::isNotEmpty).collect(ImmutableList.toImmutableList());
    }

    @VisibleForTesting
    protected static Iterable<String> measurementNumbers(@NonNull String text) {
        if (text == null) {
            throw new NullPointerException("text is marked non-null but is null");
        }
        String cleaned = MEASUREMENT_NUMBER_CM.negate().replaceFrom((CharSequence)text, (CharSequence)" ");
        return (Iterable)MEASUREMENT_NUMBER_SPLITTER.splitToList((CharSequence)cleaned).stream().filter(VALID_MEASUREMENT_NUMBER).collect(ImmutableList.toImmutableList());
    }

    @VisibleForTesting
    protected static Iterable<String> costCenters(@NonNull String text) {
        if (text == null) {
            throw new NullPointerException("text is marked non-null but is null");
        }
        String cleaned = CC_NUMBER_CM.negate().replaceFrom((CharSequence)text, (CharSequence)" ");
        return (Iterable)CC_NUMBER_SPLITTER.splitToList((CharSequence)cleaned).stream().filter(VALID_CC_NUMBER).collect(ImmutableList.toImmutableList());
    }

    protected InvoicePdfExtractor(EPdfExtractType pdfExtractType) {
        this.pdfExtractType = pdfExtractType;
    }
}

