/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.service.service.pdf;

import de.qfm.erp.service.model.jpa.user.User;
import de.qfm.erp.service.service.security.UserService;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Calendar;
import java.util.Locale;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import lombok.NonNull;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDDocumentInformation;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.PDPageContentStream;
import org.apache.pdfbox.pdmodel.common.PDRectangle;
import org.apache.pdfbox.pdmodel.graphics.image.PDImageXObject;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class ImageToPdfConverter {
    private static final float POINTS_PER_INCH = 72.0f;
    private static final float POINTS_PER_MM = 2.8346457f;
    private static final float MARGIN = 25.0f;
    private final UserService userService;

    public ImageToPdfConverter(UserService userService) {
        this.userService = userService;
    }

    @Nullable
    public byte[] convertToPdf(@NonNull MultipartFile file) throws IOException {
        byte[] byteArray;
        if (file == null) {
            throw new NullPointerException("file is marked non-null but is null");
        }
        String fileName = file.getName();
        byte[] jpegBytes = file.getBytes();
        User authenticatedUser = this.userService.authenticatedUser();
        String fullName = authenticatedUser.getFullName();
        try (PDDocument document = this.document(fileName, fullName);
             ByteArrayOutputStream outputStream = new ByteArrayOutputStream();){
            float printWidth;
            float printHeight;
            PDImageXObject pdImage = PDImageXObject.createFromByteArray((PDDocument)document, (byte[])jpegBytes, (String)fileName);
            int height = pdImage.getHeight();
            int width = pdImage.getWidth();
            PDRectangle mediaBox = height > width ? new PDRectangle(PDRectangle.A4.getWidth(), PDRectangle.A4.getHeight()) : new PDRectangle(PDRectangle.A4.getHeight(), PDRectangle.A4.getWidth());
            PDPage pdPage = ImageToPdfConverter.page((PDDocument)document, (PDRectangle)mediaBox);
            float supposedHeight = mediaBox.getHeight() - 50.0f;
            float supposedWidth = mediaBox.getWidth() - 50.0f;
            if ((float)height > supposedHeight * 2.8346457f || (float)width > supposedWidth * 2.8346457f) {
                float heightRatio = (float)height / supposedHeight;
                float widthRatio = (float)width / supposedWidth;
                float ratio = Math.max(heightRatio, widthRatio);
                printHeight = (float)height / ratio;
                printWidth = (float)width / ratio;
            } else {
                float heightFactor = height > width ? 1.0f : supposedWidth / supposedHeight;
                float widthFactor = height > width ? supposedWidth / supposedHeight : 1.0f;
                printHeight = supposedHeight * heightFactor;
                printWidth = supposedWidth * widthFactor;
            }
            PDPageContentStream contentStream = new PDPageContentStream(document, pdPage);
            contentStream.drawImage(pdImage, 25.0f, 25.0f, printWidth, printHeight);
            contentStream.close();
            document.save((OutputStream)outputStream);
            byteArray = outputStream.toByteArray();
        }
        return byteArray;
    }

    @Nonnull
    protected PDDocument document(@NonNull String fileName, @NonNull String fullName) {
        if (fileName == null) {
            throw new NullPointerException("fileName is marked non-null but is null");
        }
        if (fullName == null) {
            throw new NullPointerException("fullName is marked non-null but is null");
        }
        PDDocumentInformation info = new PDDocumentInformation();
        info.setAuthor(fullName);
        info.setCreationDate(Calendar.getInstance(Locale.GERMAN));
        info.setCreator("AppQ - PDF/Druck");
        info.setProducer("AppQ - eine QFM Anwendung");
        PDDocument document = new PDDocument();
        document.setDocumentInformation(this.apply(info, fileName, fullName));
        return document;
    }

    @Nonnull
    private PDDocumentInformation apply(@NonNull PDDocumentInformation documentInformation, @NonNull String fileName, @NonNull String fullName) {
        if (documentInformation == null) {
            throw new NullPointerException("documentInformation is marked non-null but is null");
        }
        if (fileName == null) {
            throw new NullPointerException("fileName is marked non-null but is null");
        }
        if (fullName == null) {
            throw new NullPointerException("fullName is marked non-null but is null");
        }
        documentInformation.setKeywords("");
        documentInformation.setTitle(String.format("INVOICE Attachment: %s", fileName));
        documentInformation.setSubject(String.format("EMPLOYEE: %s", fullName));
        return documentInformation;
    }

    @Nonnull
    protected static PDPage page(@NonNull PDDocument document, @NonNull PDRectangle mediaBox) {
        if (document == null) {
            throw new NullPointerException("document is marked non-null but is null");
        }
        if (mediaBox == null) {
            throw new NullPointerException("mediaBox is marked non-null but is null");
        }
        PDPage page = new PDPage(mediaBox);
        document.addPage(page);
        return page;
    }
}

