/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.service.service.gaeb;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.CharMatcher;
import com.google.common.base.Function;
import com.google.common.base.MoreObjects;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.common.collect.Streams;
import com.thoughtworks.xstream.XStream;
import de.leancoders.common.helper.DateTimeHelper;
import de.qfm.erp.service.helper.BidderComplementHelper;
import de.qfm.erp.service.helper.QuotationHelper;
import de.qfm.erp.service.model.external.gaeb.generic.ComplBody;
import de.qfm.erp.service.model.external.gaeb.generic.Span;
import de.qfm.erp.service.model.external.gaeb.generic.TextComplement;
import de.qfm.erp.service.model.external.gaeb.x84.Address;
import de.qfm.erp.service.model.external.gaeb.x84.Award;
import de.qfm.erp.service.model.external.gaeb.x84.AwardInfo;
import de.qfm.erp.service.model.external.gaeb.x84.BoQ;
import de.qfm.erp.service.model.external.gaeb.x84.BoQBkdn;
import de.qfm.erp.service.model.external.gaeb.x84.BoQBody;
import de.qfm.erp.service.model.external.gaeb.x84.BoQCtgy;
import de.qfm.erp.service.model.external.gaeb.x84.BoQInfo;
import de.qfm.erp.service.model.external.gaeb.x84.CompleteText;
import de.qfm.erp.service.model.external.gaeb.x84.Contractor;
import de.qfm.erp.service.model.external.gaeb.x84.Description;
import de.qfm.erp.service.model.external.gaeb.x84.DetailTxt;
import de.qfm.erp.service.model.external.gaeb.x84.GAEB;
import de.qfm.erp.service.model.external.gaeb.x84.GAEBInfo;
import de.qfm.erp.service.model.external.gaeb.x84.Item;
import de.qfm.erp.service.model.external.gaeb.x84.ProjectInfo;
import de.qfm.erp.service.model.external.gaeb.x84.Remark;
import de.qfm.erp.service.model.external.gaeb.x84.Total;
import de.qfm.erp.service.model.external.gaeb.x84.Totals;
import de.qfm.erp.service.model.internal.gaeb.GaebX84ExportResult;
import de.qfm.erp.service.model.internal.quotation.BidderComplement;
import de.qfm.erp.service.model.internal.quotation.StagePositionGroup;
import de.qfm.erp.service.model.jpa.configuration.ConfigurationCompany;
import de.qfm.erp.service.model.jpa.quotation.Quotation;
import de.qfm.erp.service.model.jpa.quotation.QuotationPosition;
import de.qfm.erp.service.model.jpa.shared.EPositionType;
import de.qfm.erp.service.service.handler.ConfigurationCompanyHandler;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.nio.charset.StandardCharsets;
import java.time.LocalTime;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import javax.annotation.Nonnull;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class GaebX84ExportService {
    private static final Logger log = LogManager.getLogger(GaebX84ExportService.class);
    private final ConfigurationCompanyHandler configurationCompanyHandler;
    private final XStream xStream;
    private static final CharMatcher DIGIT = CharMatcher.inRange((char)'0', (char)'9').precomputed();
    private static final Splitter NEW_LINE_SPLITTER = Splitter.on((char)'\n').omitEmptyStrings();
    private static final CharMatcher CLEAN_MATCHER = CharMatcher.anyOf((CharSequence)"\u00a0");

    @Autowired
    public GaebX84ExportService(ConfigurationCompanyHandler configurationCompanyHandler, @Qualifier(value="xStreamX84") XStream xStream) {
        this.configurationCompanyHandler = configurationCompanyHandler;
        this.xStream = xStream;
    }

    @NonNull
    public GaebX84ExportResult generateX84(@NonNull Quotation stage) {
        if (stage == null) {
            throw new NullPointerException("stage is marked non-null but is null");
        }
        GAEB gaeb = new GAEB();
        Award award = this.award(stage);
        gaeb.setAward(award);
        GAEBInfo gaebInfo = this.gaebInfo(stage);
        gaeb.setGaebInfo(gaebInfo);
        ProjectInfo projectInfo = this.projectInfo(stage);
        gaeb.setProjectInfo(projectInfo);
        String xml = this.xStream.toXML((Object)gaeb);
        return GaebX84ExportResult.of((GAEB)gaeb, (byte[])xml.getBytes(StandardCharsets.UTF_8));
    }

    @Nonnull
    private ProjectInfo projectInfo(@NonNull Quotation stage) {
        if (stage == null) {
            throw new NullPointerException("stage is marked non-null but is null");
        }
        ProjectInfo projectInfo = new ProjectInfo();
        projectInfo.setName(stage.getX83ProjectName());
        projectInfo.setLabel(stage.getX83ProjectLabel());
        projectInfo.setCurrency(stage.getX83ProjectCurrency());
        projectInfo.setCurrencyLabel(stage.getX83ProjectCurrencyLabel());
        return projectInfo;
    }

    @Nonnull
    private GAEBInfo gaebInfo(@NonNull Quotation stage) {
        if (stage == null) {
            throw new NullPointerException("stage is marked non-null but is null");
        }
        GAEBInfo gaebInfo = new GAEBInfo();
        gaebInfo.setTime(LocalTime.now().truncatedTo(ChronoUnit.SECONDS));
        gaebInfo.setDate(DateTimeHelper.today());
        gaebInfo.setProgName("AppQ");
        gaebInfo.setProgSystem("AppQ");
        gaebInfo.setVersion("3.2");
        gaebInfo.setVersionDate("2013-10");
        return gaebInfo;
    }

    @Nonnull
    private Award award(@NonNull Quotation stage) {
        if (stage == null) {
            throw new NullPointerException("stage is marked non-null but is null");
        }
        Award award = new Award();
        AwardInfo awardInfo = this.awardInfo(stage);
        award.setAwardInfo(awardInfo);
        award.setDp("84");
        Contractor contractor = this.contractor(stage);
        award.setContractor(contractor);
        BoQ boQ = this.boq(stage);
        award.setBoQ(boQ);
        return award;
    }

    @Nonnull
    private Contractor contractor(@NonNull Quotation stage) {
        if (stage == null) {
            throw new NullPointerException("stage is marked non-null but is null");
        }
        Contractor contractor = new Contractor();
        ConfigurationCompany configurationCompany = this.configurationCompanyHandler.getDefaultFailing();
        String companyName = StringUtils.trimToEmpty((String)String.format("%s %s", configurationCompany.getCompanyName1(), configurationCompany.getCompanyName2()));
        String street = StringUtils.trimToEmpty((String)String.format("%s %s", configurationCompany.getCompanyStreet(), configurationCompany.getCompanyStreetNo()));
        Address address = new Address();
        address.setName1(companyName);
        address.setStreet(street);
        address.setZipCode(configurationCompany.getCompanyZipCode());
        address.setCity(configurationCompany.getCompanyCity());
        contractor.setAddress(address);
        return contractor;
    }

    @Nonnull
    private BoQ boq(@NonNull Quotation stage) {
        if (stage == null) {
            throw new NullPointerException("stage is marked non-null but is null");
        }
        BoQInfo boQInfo = this.boQInfo(stage);
        BoQBody boQBody = this.rootBody(stage);
        BoQ boQ = new BoQ();
        boQ.setId("ID" + stage.getId());
        boQ.setBoQInfo(boQInfo);
        boQ.setBoQBody(boQBody);
        return boQ;
    }

    @Nonnull
    private BoQInfo boQInfo(@NonNull Quotation stage) {
        if (stage == null) {
            throw new NullPointerException("stage is marked non-null but is null");
        }
        BoQInfo boQInfo = new BoQInfo();
        ArrayList groupingLevels = Lists.newArrayList();
        this.bkdn("BoQLevel", stage, true, Quotation::getHeadlineG1, QuotationPosition::getGroupingElementLevel1).ifPresent(groupingLevels::add);
        this.bkdn("BoQLevel", stage, true, Quotation::getHeadlineG2, QuotationPosition::getGroupingElementLevel2).ifPresent(groupingLevels::add);
        this.bkdn("BoQLevel", stage, true, Quotation::getHeadlineG3, QuotationPosition::getGroupingElementLevel3).ifPresent(groupingLevels::add);
        this.bkdn("BoQLevel", stage, true, Quotation::getHeadlineG4, QuotationPosition::getGroupingElementLevel4).ifPresent(groupingLevels::add);
        boQInfo.setName(StringUtils.left((String)stage.getOrderDescriptionCustomer(), (int)20));
        this.bkdn("Item", stage, false, x -> "", QuotationPosition::getPositionNumber).ifPresent(groupingLevels::add);
        BoQBkdn indexLevel = new BoQBkdn();
        indexLevel.setType("Index");
        indexLevel.setNum("No");
        indexLevel.setLength(Integer.valueOf(1));
        groupingLevels.add(indexLevel);
        boQInfo.setBkdn((List)groupingLevels);
        Totals totals = this.totals(stage);
        boQInfo.setTotals(totals);
        return boQInfo;
    }

    @Nonnull
    private Totals totals(@NonNull Quotation stage) {
        if (stage == null) {
            throw new NullPointerException("stage is marked non-null but is null");
        }
        Totals totals = new Totals();
        BigDecimal valueAggregated = ((BigDecimal)MoreObjects.firstNonNull((Object)stage.getPriceWithDiscountSum(), (Object)BigDecimal.ZERO)).setScale(2, RoundingMode.HALF_UP);
        totals.setTotal(valueAggregated);
        BigDecimal financeVAT = ((BigDecimal)MoreObjects.firstNonNull((Object)stage.getVatPercent(), (Object)BigDecimal.ZERO)).setScale(2, RoundingMode.HALF_UP);
        totals.setVat(financeVAT);
        BigDecimal priceAggregated = ((BigDecimal)MoreObjects.firstNonNull((Object)stage.getPriceGrossWithDiscountSum(), (Object)BigDecimal.ZERO)).setScale(2, RoundingMode.HALF_UP);
        totals.setTotalGross(priceAggregated);
        return totals;
    }

    @Nonnull
    private Optional<BoQBkdn> bkdn(@NonNull String levelType, @NonNull Quotation stage, boolean groupingLevelIndicator, @NonNull Function<Quotation, String> headlineFN, @NonNull Function<QuotationPosition, String> groupFN) {
        Iterable groupedValues;
        boolean isEmpty;
        if (levelType == null) {
            throw new NullPointerException("levelType is marked non-null but is null");
        }
        if (stage == null) {
            throw new NullPointerException("stage is marked non-null but is null");
        }
        if (headlineFN == null) {
            throw new NullPointerException("headlineFN is marked non-null but is null");
        }
        if (groupFN == null) {
            throw new NullPointerException("groupFN is marked non-null but is null");
        }
        String headLine = StringUtils.trimToNull((String)((String)headlineFN.apply((Object)stage)));
        Set quotationPositions = (Set)MoreObjects.firstNonNull((Object)stage.getQuotationPositions(), (Object)ImmutableSet.of());
        ImmutableSet allGColValues = (ImmutableSet)quotationPositions.stream().filter(item -> StringUtils.isNotBlank((CharSequence)((CharSequence)groupFN.apply(item)))).collect(ImmutableSet.toImmutableSet());
        if (!allGColValues.isEmpty() && !(isEmpty = Iterables.isEmpty((Iterable)(groupedValues = (Iterable)allGColValues.stream().filter(item -> Iterables.contains((Iterable)EPositionType.WAGE_AND_VALUE_TYPES, (Object)item.getPositionType())).map(groupFN).filter(StringUtils::isNotBlank).collect(ImmutableSet.toImmutableSet()))))) {
            boolean allDigit = Streams.stream((Iterable)groupedValues).map(arg_0 -> ((CharMatcher)DIGIT).matchesAllOf(arg_0)).reduce(true, (l, r) -> l != false && r != false);
            int maxLength = Streams.stream((Iterable)groupedValues).map(String::length).max(Integer::compareTo).orElse(0);
            BoQBkdn bkdn = new BoQBkdn();
            bkdn.setType(levelType);
            bkdn.setLblBoQBkdn(headLine);
            bkdn.setLength(Integer.valueOf(maxLength));
            bkdn.setNum(allDigit ? "Yes" : "No");
            return Optional.of(bkdn);
        }
        return Optional.empty();
    }

    @Nonnull
    private BoQBody rootBody(@NonNull Quotation stage) {
        if (stage == null) {
            throw new NullPointerException("stage is marked non-null but is null");
        }
        Iterable positionGroups = QuotationHelper.positionGroups((Quotation)stage, (boolean)false, (boolean)false);
        ArrayList allCategories = Lists.newArrayList();
        for (StagePositionGroup positionGroup : positionGroups) {
            List categories = this.category(positionGroup);
            allCategories.addAll(categories);
        }
        BoQBody boQBody = new BoQBody();
        boQBody.setCategories((List)allCategories);
        boQBody.setItemlist(null);
        return boQBody;
    }

    @Nonnull
    private BoQBody childBody(@NonNull StagePositionGroup positionGroup) {
        if (positionGroup == null) {
            throw new NullPointerException("positionGroup is marked non-null but is null");
        }
        BoQBody boQBody = new BoQBody();
        ArrayList categories = Lists.newArrayList((Iterable)this.category(positionGroup));
        boQBody.setCategories((List)categories);
        BigDecimal valueAggregated = positionGroup.sumCascade(true, QuotationPosition::getPriceAggregated);
        Total total = new Total();
        total.setTotal(valueAggregated);
        boQBody.setItemlist(null);
        return boQBody;
    }

    @Nonnull
    private BoQBody itemBody(@NonNull StagePositionGroup positionGroup) {
        if (positionGroup == null) {
            throw new NullPointerException("positionGroup is marked non-null but is null");
        }
        BoQBody boQBody = new BoQBody();
        ArrayList items = Lists.newArrayList();
        ArrayList objects = Lists.newArrayList();
        List positions = positionGroup.getPositions();
        for (QuotationPosition quotationPosition : positions) {
            Item item;
            EPositionType positionType = quotationPosition.getPositionType();
            if (positionType == EPositionType.STANDARD) {
                item = GaebX84ExportService.item((QuotationPosition)quotationPosition);
                items.add(item);
                objects.add(item);
                continue;
            }
            if (positionType != EPositionType.REMARK) continue;
            item = GaebX84ExportService.remark((QuotationPosition)quotationPosition);
            objects.add(item);
        }
        Map children = positionGroup.getChildren();
        TreeSet strings = Sets.newTreeSet(children.keySet());
        ArrayList categories = Lists.newArrayList();
        for (String string : strings) {
            StagePositionGroup childPositionGroup = (StagePositionGroup)children.get(string);
            List childCategories = this.category(childPositionGroup);
            categories.addAll(childCategories);
        }
        boQBody.setCategories((List)categories);
        BigDecimal valueAggregated = positionGroup.sumCascade(true, QuotationPosition::getPriceAggregated);
        Total total = new Total();
        total.setTotal(valueAggregated);
        if (!objects.isEmpty() && items.isEmpty()) {
            boQBody.setRemarksOnly((List)objects);
        } else if (!objects.isEmpty()) {
            ArrayList itemlist = new ArrayList(objects);
            boQBody.setItemlist(itemlist);
        }
        return boQBody;
    }

    @Nonnull
    @VisibleForTesting
    static Item item(@NonNull QuotationPosition quotationPosition) {
        if (quotationPosition == null) {
            throw new NullPointerException("quotationPosition is marked non-null but is null");
        }
        Item item = new Item();
        BigDecimal orderedAmount = ((BigDecimal)MoreObjects.firstNonNull((Object)quotationPosition.getOrderedAmount(), (Object)BigDecimal.ZERO)).setScale(3, RoundingMode.HALF_UP);
        BigDecimal pricePerUnit = ((BigDecimal)MoreObjects.firstNonNull((Object)quotationPosition.getPricePerUnit(), (Object)BigDecimal.ZERO)).setScale(2, RoundingMode.HALF_UP);
        BigDecimal priceAggregated = ((BigDecimal)MoreObjects.firstNonNull((Object)quotationPosition.getPriceAggregated(), (Object)BigDecimal.ZERO)).setScale(2, RoundingMode.HALF_UP);
        String positionNumber = StringUtils.remove((String)quotationPosition.getPositionNumber(), (String)"#");
        Long id = quotationPosition.getId();
        item.setId(String.format("ID%s", id));
        item.setRNoPart(positionNumber);
        item.setAmount(orderedAmount);
        item.setPricePerUnit(pricePerUnit);
        item.setPriceOverall(priceAggregated);
        Boolean hasBidderComplement = quotationPosition.getHasBidderComplement();
        if (Boolean.TRUE == hasBidderComplement) {
            String bidderComplementText = quotationPosition.getBidderComplement();
            Iterable allBidderComplements = BidderComplementHelper.bidderComplements((String)bidderComplementText);
            Description description = new Description();
            CompleteText completeText = new CompleteText();
            DetailTxt detailTxt = new DetailTxt();
            ArrayList textComplements = Lists.newArrayList();
            for (BidderComplement bidderComplement : allBidderComplements) {
                BidderComplement.EBidderComplementType complementType = bidderComplement.getType();
                String complementId = bidderComplement.getId();
                if (BidderComplement.EBidderComplementType.BIDDER != complementType) continue;
                ComplBody complBody = new ComplBody();
                List spans = GaebX84ExportService.bidderSpans((BidderComplement)bidderComplement);
                complBody.setSpans(spans);
                TextComplement textComplement = new TextComplement();
                textComplement.setKind("Bidder");
                textComplement.setMarkLabel(complementId);
                textComplement.setBodies(List.of(complBody));
                textComplements.add(textComplement);
            }
            detailTxt.setTextComplements((List)textComplements);
            completeText.setDetailTxts((List)Lists.newArrayList((Object[])new DetailTxt[]{detailTxt}));
            description.setCompleteTexts((List)Lists.newArrayList((Object[])new CompleteText[]{completeText}));
            item.setDescriptions((List)Lists.newArrayList((Object[])new Description[]{description}));
        }
        return item;
    }

    @Nonnull
    private static Remark remark(@NonNull QuotationPosition quotationPosition) {
        if (quotationPosition == null) {
            throw new NullPointerException("quotationPosition is marked non-null but is null");
        }
        Remark remark = new Remark();
        String positionNumber = quotationPosition.getPositionNumber();
        Long id = quotationPosition.getId();
        remark.setId(String.format("ID%s", id));
        return remark;
    }

    @Nonnull
    static String clean(@NonNull String input) {
        if (input == null) {
            throw new NullPointerException("input is marked non-null but is null");
        }
        return StringUtils.trimToEmpty((String)CLEAN_MATCHER.removeFrom((CharSequence)input));
    }

    @VisibleForTesting
    static List<Span> bidderSpans(@NonNull BidderComplement bidderComplement) {
        if (bidderComplement == null) {
            throw new NullPointerException("bidderComplement is marked non-null but is null");
        }
        ArrayList spans = Lists.newArrayList();
        String bidderComplementText = GaebX84ExportService.clean((String)bidderComplement.getComplement());
        List strings = NEW_LINE_SPLITTER.splitToList((CharSequence)bidderComplementText);
        strings.forEach(item -> {
            Span span = new Span();
            span.setContent(" '" + item + "' ");
            span.setStyle("font-family:'Arial';font-size:10pt;");
            spans.add(span);
        });
        return spans;
    }

    @Nonnull
    private List<BoQCtgy> category(@NonNull StagePositionGroup positionGroup) {
        if (positionGroup == null) {
            throw new NullPointerException("positionGroup is marked non-null but is null");
        }
        BoQCtgy self = new BoQCtgy();
        Long id = positionGroup.getId();
        String key = positionGroup.getKey();
        Integer level = positionGroup.getLevel();
        String shortText = positionGroup.getShortText();
        long safeId = id < 0L ? 0L : id;
        boolean isChildKey = StringUtils.contains((CharSequence)key, (int)46);
        String rowNumberPartString = isChildKey ? StringUtils.substringAfterLast((String)key, (String)".") : key;
        String rowNumberPartSafe = StringUtils.remove((String)rowNumberPartString, (String)"#");
        self.setId("ID" + safeId);
        self.setRowNumberPart(rowNumberPartSafe);
        BoQBody itemBody = this.itemBody(positionGroup);
        BigDecimal totalValue = positionGroup.sumCascade(true, QuotationPosition::getPriceAggregated).setScale(2, RoundingMode.HALF_UP);
        Totals totals = new Totals();
        totals.setTotal(totalValue);
        self.setTotals(totals);
        self.setBodies((List)Lists.newArrayList((Object[])new BoQBody[]{itemBody}));
        return ImmutableList.builder().add((Object)self).build();
    }

    @Nonnull
    private AwardInfo awardInfo(Quotation stage) {
        AwardInfo awardInfo = new AwardInfo();
        awardInfo.setCurrency(stage.getX83BoqAwardCurrency());
        awardInfo.setCurrencyLabel(stage.getX83BoqAwardCurrencyLabel());
        return awardInfo;
    }
}

