/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.service.service.gaeb;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Joiner;
import com.google.common.base.MoreObjects;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import de.qfm.erp.service.helper.IMeasurementComparators;
import de.qfm.erp.service.model.jpa.measurement.Measurement;
import de.qfm.erp.service.model.jpa.measurement.MeasurementPosition;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nonnull;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;

/*
 * Exception performing whole class analysis ignored.
 */
public class GaebD11Helper {
    private static final Splitter SPLITTER_56 = Splitter.fixedLength((int)56).trimResults().omitEmptyStrings();
    private static final List<String> ALPHA_ROW_INDEX = ImmutableList.of((Object)"A", (Object)"B", (Object)"C", (Object)"D", (Object)"E", (Object)"F", (Object)"G", (Object)"H", (Object)"I", (Object)"J", (Object)"K", (Object)"L", (Object[])new String[]{"M", "N", "O", "P", "Q", "R", "S", "T", "U", "V", "W", "X", "Y", "Z"});
    private static final DecimalFormat NUMBER_FORMAT;

    @Nonnull
    public static Iterable<String> itemRows(@NonNull Measurement measurement, boolean renderPosNr) {
        if (measurement == null) {
            throw new NullPointerException("measurement is marked non-null but is null");
        }
        Long sheetNumberValue = measurement.getSheetNumberValue();
        List measurementPositions = (List)MoreObjects.firstNonNull((Object)measurement.getMeasurementPositions(), (Object)ImmutableList.of());
        ImmutableList positionsSorted = (ImmutableList)measurementPositions.stream().sorted(IMeasurementComparators.MEASUREMENT_POSITION_COMPARATOR).collect(ImmutableList.toImmutableList());
        ImmutableList.Builder rowsBuilder = ImmutableList.builder();
        AtomicInteger rowIndex = new AtomicInteger(0);
        for (MeasurementPosition measurementPosition : positionsSorted) {
            rowsBuilder.addAll(GaebD11Helper.commentRows((MeasurementPosition)measurementPosition, (long)sheetNumberValue, (int)rowIndex.get()));
            rowsBuilder.add((Object)GaebD11Helper.dataRow((MeasurementPosition)measurementPosition, (boolean)renderPosNr, (long)sheetNumberValue, (int)rowIndex.getAndIncrement()));
        }
        return rowsBuilder.build();
    }

    @Nonnull
    public static Iterable<String> commentRows(@NonNull MeasurementPosition measurementPosition, long sheetNo, int rowIndex) {
        if (measurementPosition == null) {
            throw new NullPointerException("measurementPosition is marked non-null but is null");
        }
        String remark = StringUtils.trimToEmpty((String)measurementPosition.getRemarks());
        List remarks = SPLITTER_56.splitToList((CharSequence)remark);
        ImmutableList.Builder rowsBuilder = ImmutableList.builder();
        for (String partOfRemark : remarks) {
            ArrayList parts = Lists.newArrayList();
            parts.add("11");
            parts.add(StringUtils.repeat((char)' ', (int)9));
            parts.add(" ");
            parts.add("*");
            parts.add(StringUtils.rightPad((String)partOfRemark, (int)56, (char)' '));
            parts.add(StringUtils.leftPad((String)("" + sheetNo), (int)4, (char)'0'));
            parts.add(GaebD11Helper.rowIndex((int)rowIndex));
            parts.add(StringUtils.repeat((char)' ', (int)5));
            String row = StringUtils.join((Iterable)parts, (String)"");
            rowsBuilder.add((Object)row);
        }
        return rowsBuilder.build();
    }

    @Nonnull
    public static String dataRow(@NonNull MeasurementPosition measurementPosition, boolean renderPosNr, long sheetNo, int rowIndex) {
        if (measurementPosition == null) {
            throw new NullPointerException("measurementPosition is marked non-null but is null");
        }
        ArrayList parts = Lists.newArrayList();
        String da11 = renderPosNr ? "11" : StringUtils.repeat((char)' ', (int)2);
        parts.add(da11);
        String g1 = renderPosNr ? StringUtils.leftPad((String)StringUtils.left((String)StringUtils.trimToEmpty((String)measurementPosition.getGroupingElementLevel1()), (int)2), (int)2, (char)'0') : StringUtils.repeat((char)' ', (int)2);
        String g2 = renderPosNr ? StringUtils.leftPad((String)StringUtils.left((String)StringUtils.trimToEmpty((String)measurementPosition.getGroupingElementLevel2()), (int)2), (int)2, (char)'0') : StringUtils.repeat((char)' ', (int)2);
        String pos = renderPosNr ? StringUtils.leftPad((String)StringUtils.left((String)StringUtils.trimToEmpty((String)measurementPosition.getQuotationPositionNumber()), (int)4), (int)4, (char)'0') : StringUtils.repeat((char)' ', (int)4);
        String i = renderPosNr ? "0" : " ";
        parts.add(g1 + g2 + pos + i);
        parts.add(" ");
        parts.add(" ");
        parts.add(StringUtils.repeat((char)' ', (int)9));
        boolean negate = ((BigDecimal)MoreObjects.firstNonNull((Object)measurementPosition.getProduct(), (Object)BigDecimal.ZERO)).compareTo(BigDecimal.ZERO) < 0;
        parts.add(negate ? "-" : " ");
        parts.add(StringUtils.repeat((char)' ', (int)6));
        parts.add("91");
        String e = StringUtils.rightPad((String)GaebD11Helper.formula((MeasurementPosition)measurementPosition), (int)38, (char)' ');
        parts.add(e);
        parts.add(StringUtils.leftPad((String)("" + sheetNo), (int)4, (char)'0'));
        parts.add(GaebD11Helper.rowIndex((int)rowIndex));
        parts.add(StringUtils.repeat((char)' ', (int)5));
        return StringUtils.join((Iterable)parts, (String)"");
    }

    @Nonnull
    private static String formula(@NonNull MeasurementPosition measurementPosition) {
        BigDecimal factor3;
        BigDecimal factor2;
        BigDecimal factor1;
        if (measurementPosition == null) {
            throw new NullPointerException("measurementPosition is marked non-null but is null");
        }
        ArrayList parts = Lists.newArrayList();
        BigDecimal amount = measurementPosition.getAmount();
        if (null != amount) {
            parts.add(GaebD11Helper.amount((BigDecimal)amount.abs()));
        }
        if (null != (factor1 = measurementPosition.getFactor1())) {
            parts.add(GaebD11Helper.amount((BigDecimal)factor1.abs()));
        }
        if (null != (factor2 = measurementPosition.getFactor2())) {
            parts.add(GaebD11Helper.amount((BigDecimal)factor2.abs()));
        }
        if (null != (factor3 = measurementPosition.getFactor3())) {
            parts.add(GaebD11Helper.amount((BigDecimal)factor3.abs()));
        }
        return Joiner.on((char)'*').join((Iterable)parts) + "=";
    }

    @Nonnull
    @VisibleForTesting
    static String amount(BigDecimal amount) {
        int currentScale = amount.scale();
        return GaebD11Helper.asString((BigDecimal)amount, (int)currentScale);
    }

    @VisibleForTesting
    static String rowIndex(int row) {
        int left = row / 10;
        int right = row % 10;
        String alpha = (String)ALPHA_ROW_INDEX.get(left);
        return alpha + right;
    }

    @Nonnull
    public static String asString(@NonNull BigDecimal bigDecimal, int factionDigits) {
        if (bigDecimal == null) {
            throw new NullPointerException("bigDecimal is marked non-null but is null");
        }
        BigDecimal valueWithScale = bigDecimal.setScale(factionDigits, RoundingMode.HALF_UP);
        NUMBER_FORMAT.setMinimumFractionDigits(factionDigits);
        NUMBER_FORMAT.setMaximumFractionDigits(factionDigits);
        return NUMBER_FORMAT.format(valueWithScale);
    }

    static {
        DecimalFormat numberFormat3 = new DecimalFormat("###0.000");
        numberFormat3.setDecimalFormatSymbols(new DecimalFormatSymbols(Locale.GERMAN));
        NUMBER_FORMAT = numberFormat3;
    }
}

