/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.service.service.er2.old;

import com.google.common.base.CharMatcher;
import com.google.common.collect.ImmutableList;
import de.qfm.erp.service.model.internal.quotation.EER2OutputType;
import de.qfm.erp.service.model.jpa.invoice.EInvoiceType;
import de.qfm.erp.service.model.jpa.invoice.Invoice;
import de.qfm.erp.service.service.service.er2.ER2InvoiceService;
import de.qfm.erp.service.service.service.er2.old.ER2ServiceCreditVoucher;
import java.math.BigDecimal;
import java.time.format.DateTimeFormatter;
import java.util.Set;
import javax.annotation.Nonnull;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;

/*
 * Exception performing whole class analysis ignored.
 */
public class ER2ServiceCreditVoucher
extends ER2InvoiceService {
    public ER2ServiceCreditVoucher() {
        super(EER2OutputType.NORMAL, EInvoiceType.CREDIT_VOUCHER);
    }

    @Nonnull
    public Iterable<Iterable<String>> generate(@NonNull Invoice invoice) {
        if (invoice == null) {
            throw new NullPointerException("invoice is marked non-null but is null");
        }
        return this.er2Rows(invoice);
    }

    @Nonnull
    private Iterable<Iterable<String>> er2Rows(@NonNull Invoice invoice) {
        String value;
        if (invoice == null) {
            throw new NullPointerException("invoice is marked non-null but is null");
        }
        ImmutableList.Builder rowsBuilder = ImmutableList.builder();
        ImmutableList.Builder fPartsBuilder = ImmutableList.builder();
        for (ER2F er2F : ER2F.values()) {
            String value2 = StringUtils.trimToEmpty((String)((String)er2F.getFn().apply(invoice)));
            fPartsBuilder.add((Object)value2);
        }
        ImmutableList fParts = fPartsBuilder.build();
        ImmutableList.Builder kSenderPartsBuilder = ImmutableList.builder();
        for (ER2K_SENDER eR2K_SENDER : ER2K_SENDER.values()) {
            String value3 = StringUtils.trimToEmpty((String)((String)eR2K_SENDER.getFn().apply(invoice)));
            kSenderPartsBuilder.add((Object)value3);
        }
        ImmutableList kSenderParts = kSenderPartsBuilder.build();
        ImmutableList.Builder gPartRowsBuilder = ImmutableList.builder();
        if (Boolean.TRUE == invoice.getFlagSecurityRetention()) {
            ImmutableList.Builder gParts1stBuilder = ImmutableList.builder();
            ER2G_SEC_RET[] eR2G_SEC_RETArray = ER2G_SEC_RET.values();
            int value3 = eR2G_SEC_RETArray.length;
            for (int i = 0; i < value3; ++i) {
                ER2G_SEC_RET er2G1ST = eR2G_SEC_RETArray[i];
                value = StringUtils.trimToEmpty((String)((String)er2G1ST.getFn().apply(invoice)));
                gParts1stBuilder.add((Object)value);
            }
            ImmutableList immutableList = gParts1stBuilder.build();
            if (!immutableList.isEmpty()) {
                gPartRowsBuilder.add((Object)immutableList);
            }
        }
        ImmutableList.Builder gParts2stBuilder = ImmutableList.builder();
        for (ER2G_GROSS er2G2NDGROSS : ER2G_GROSS.values()) {
            value = StringUtils.trimToEmpty((String)((String)er2G2NDGROSS.getFn().apply(invoice)));
            gParts2stBuilder.add((Object)value);
        }
        ImmutableList immutableList = gParts2stBuilder.build();
        if (!immutableList.isEmpty()) {
            gPartRowsBuilder.add((Object)immutableList);
        }
        ImmutableList gPartRows = gPartRowsBuilder.build();
        rowsBuilder.add((Object)fParts);
        rowsBuilder.addAll((Iterable)gPartRows);
        rowsBuilder.add((Object)kSenderParts);
        return rowsBuilder.build();
    }

    @Nonnull
    private static String grossWithSecRetER2(@NonNull Invoice invoice) {
        if (invoice == null) {
            throw new NullPointerException("invoice is marked non-null but is null");
        }
        BigDecimal netWithSecRet = invoice.getTotalValueNet();
        BigDecimal vat = invoice.getVatValue();
        BigDecimal grossWithSecRet = netWithSecRet.add(vat);
        return ER2ServiceCreditVoucher.er2BigDecimalAsString((BigDecimal)grossWithSecRet);
    }

    static /* synthetic */ CharMatcher access$000() {
        return STR;
    }

    static /* synthetic */ CharMatcher access$100() {
        return STR;
    }

    static /* synthetic */ CharMatcher access$200() {
        return INT;
    }

    static /* synthetic */ CharMatcher access$300() {
        return STR;
    }

    static /* synthetic */ CharMatcher access$400() {
        return STR;
    }

    static /* synthetic */ CharMatcher access$500() {
        return STR;
    }

    static /* synthetic */ CharMatcher access$600() {
        return INT;
    }

    static /* synthetic */ CharMatcher access$700() {
        return INT;
    }

    static /* synthetic */ CharMatcher access$800() {
        return STR;
    }

    static /* synthetic */ CharMatcher access$900() {
        return STR;
    }

    static /* synthetic */ CharMatcher access$1000() {
        return STR;
    }

    static /* synthetic */ CharMatcher access$1100() {
        return STR;
    }

    static /* synthetic */ CharMatcher access$1200() {
        return INT;
    }

    static /* synthetic */ CharMatcher access$1300() {
        return DEC;
    }

    static /* synthetic */ CharMatcher access$1400() {
        return DEC;
    }

    static /* synthetic */ CharMatcher access$1500() {
        return STR;
    }

    static /* synthetic */ CharMatcher access$1600() {
        return STR;
    }

    static /* synthetic */ CharMatcher access$1700() {
        return STR;
    }

    static /* synthetic */ CharMatcher access$1800() {
        return STR;
    }

    static /* synthetic */ CharMatcher access$1900() {
        return STR;
    }

    static /* synthetic */ CharMatcher access$2000() {
        return STR;
    }

    static /* synthetic */ CharMatcher access$2100() {
        return STR;
    }

    static /* synthetic */ CharMatcher access$2200() {
        return STR;
    }

    static /* synthetic */ CharMatcher access$2300() {
        return INT;
    }

    static /* synthetic */ CharMatcher access$2400() {
        return DEC;
    }

    static /* synthetic */ CharMatcher access$2500() {
        return INT;
    }

    static /* synthetic */ CharMatcher access$2600() {
        return DEC;
    }

    static /* synthetic */ CharMatcher access$2700() {
        return DEC;
    }

    static /* synthetic */ CharMatcher access$2800() {
        return STR;
    }

    static /* synthetic */ CharMatcher access$2900() {
        return STR;
    }

    static /* synthetic */ CharMatcher access$3000() {
        return DEC;
    }

    static /* synthetic */ CharMatcher access$3100() {
        return STR;
    }

    static /* synthetic */ DateTimeFormatter access$3200() {
        return DDMMYYYY;
    }

    static /* synthetic */ Set access$3300() {
        return NEGATE_INVOICE_STATES;
    }

    static /* synthetic */ Set access$3400() {
        return NEGATE_INVOICE_TYPES;
    }

    static /* synthetic */ DateTimeFormatter access$3500() {
        return DDMMYYYY;
    }

    static /* synthetic */ DateTimeFormatter access$3600() {
        return DDMMYYYY;
    }

    static /* synthetic */ DateTimeFormatter access$3700() {
        return MMYYYY;
    }

    static /* synthetic */ DateTimeFormatter access$3800() {
        return DDMMYYYY;
    }

    static /* synthetic */ String access$3900(Invoice x0) {
        return ER2ServiceCreditVoucher.invoiceType((Invoice)x0);
    }

    static /* synthetic */ CharMatcher access$4000() {
        return STR;
    }

    static /* synthetic */ CharMatcher access$4100() {
        return STR;
    }

    static /* synthetic */ CharMatcher access$4200() {
        return INT;
    }

    static /* synthetic */ CharMatcher access$4300() {
        return STR;
    }

    static /* synthetic */ CharMatcher access$4400() {
        return STR;
    }

    static /* synthetic */ CharMatcher access$4500() {
        return DEC;
    }

    static /* synthetic */ CharMatcher access$4600() {
        return DEC;
    }

    static /* synthetic */ CharMatcher access$4700() {
        return DEC;
    }

    static /* synthetic */ CharMatcher access$4800() {
        return DEC;
    }

    static /* synthetic */ CharMatcher access$4900() {
        return STR;
    }

    static /* synthetic */ Set access$5000() {
        return NEGATE_INVOICE_STATES;
    }

    static /* synthetic */ CharMatcher access$5100() {
        return STR;
    }

    static /* synthetic */ CharMatcher access$5200() {
        return STR;
    }

    static /* synthetic */ CharMatcher access$5300() {
        return STR;
    }

    static /* synthetic */ CharMatcher access$5400() {
        return DEC;
    }

    static /* synthetic */ CharMatcher access$5500() {
        return DEC;
    }

    static /* synthetic */ CharMatcher access$5600() {
        return DEC;
    }

    static /* synthetic */ CharMatcher access$5700() {
        return STR;
    }

    static /* synthetic */ CharMatcher access$5800() {
        return STR;
    }

    static /* synthetic */ CharMatcher access$5900() {
        return STR;
    }

    static /* synthetic */ CharMatcher access$6000() {
        return STR;
    }

    static /* synthetic */ CharMatcher access$6100() {
        return STR;
    }

    static /* synthetic */ CharMatcher access$6200() {
        return STR;
    }

    static /* synthetic */ CharMatcher access$6300() {
        return STR;
    }

    static /* synthetic */ CharMatcher access$6400() {
        return DEC;
    }

    static /* synthetic */ CharMatcher access$6500() {
        return DEC;
    }

    static /* synthetic */ CharMatcher access$6600() {
        return DEC;
    }

    static /* synthetic */ CharMatcher access$6700() {
        return STR;
    }

    static /* synthetic */ CharMatcher access$6800() {
        return STR;
    }

    static /* synthetic */ CharMatcher access$6900() {
        return STR;
    }

    static /* synthetic */ CharMatcher access$7000() {
        return STR;
    }
}

