/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.service.service.er2;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import de.qfm.erp.service.model.internal.quotation.EER2OutputType;
import de.qfm.erp.service.model.jpa.customer.Customer;
import de.qfm.erp.service.model.jpa.invoice.EInvoiceState;
import de.qfm.erp.service.model.jpa.invoice.EInvoiceType;
import de.qfm.erp.service.model.jpa.invoice.Invoice;
import de.qfm.erp.service.model.jpa.quotation.Quotation;
import de.qfm.erp.service.service.service.er2.ER2InvoiceService;
import de.qfm.erp.service.service.service.er2.ER2ServiceInvoiceCompanyGroupP305;
import java.math.BigDecimal;
import javax.annotation.Nonnull;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Service;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
@Order
public class ER2ServiceInvoiceCompanyGroupP305
extends ER2InvoiceService {
    public ER2ServiceInvoiceCompanyGroupP305() {
        super(EER2OutputType.COMPANY_GROUP, (Iterable)ImmutableSet.of((Object)EInvoiceType.INVOICE));
    }

    @Nonnull
    public Iterable<Iterable<String>> generate(@NonNull Invoice invoice) {
        if (invoice == null) {
            throw new NullPointerException("invoice is marked non-null but is null");
        }
        Quotation stage = invoice.getQuotation();
        Customer customer = stage.getCustomer();
        boolean companyGroup = (Boolean)MoreObjects.firstNonNull((Object)customer.getFlagCompanyGroup(), (Object)false);
        if (companyGroup) {
            return this.er2Rows(invoice);
        }
        return ImmutableList.of();
    }

    @Nonnull
    private Iterable<Iterable<String>> er2Rows(@NonNull Invoice invoice) {
        String value;
        if (invoice == null) {
            throw new NullPointerException("invoice is marked non-null but is null");
        }
        ImmutableList.Builder rowsBuilder = ImmutableList.builder();
        ImmutableList.Builder fPartsBuilder = ImmutableList.builder();
        for (ER2F er2F : ER2F.values()) {
            String value2 = StringUtils.trimToEmpty((String)((String)er2F.getFn().apply(invoice)));
            fPartsBuilder.add((Object)value2);
        }
        ImmutableList fParts = fPartsBuilder.build();
        ImmutableList.Builder kSenderPartsBuilder = ImmutableList.builder();
        for (ER2K_SENDER eR2K_SENDER : ER2K_SENDER.values()) {
            String value3 = StringUtils.trimToEmpty((String)((String)eR2K_SENDER.getFn().apply(invoice)));
            kSenderPartsBuilder.add((Object)value3);
        }
        ImmutableList kSenderParts = kSenderPartsBuilder.build();
        ImmutableList.Builder gPartRowsBuilder = ImmutableList.builder();
        if (Boolean.TRUE == invoice.getFlagSecurityRetention()) {
            ImmutableList.Builder gParts1stBuilder = ImmutableList.builder();
            ER2G_SEC_RET[] eR2G_SEC_RETArray = ER2G_SEC_RET.values();
            int value3 = eR2G_SEC_RETArray.length;
            for (int i = 0; i < value3; ++i) {
                ER2G_SEC_RET er2G1ST = eR2G_SEC_RETArray[i];
                value = StringUtils.trimToEmpty((String)((String)er2G1ST.getFn().apply(invoice)));
                gParts1stBuilder.add((Object)value);
            }
            ImmutableList immutableList = gParts1stBuilder.build();
            if (!immutableList.isEmpty()) {
                gPartRowsBuilder.add((Object)immutableList);
            }
        }
        ImmutableList.Builder gParts2stBuilder = ImmutableList.builder();
        for (ER2G_GROSS er2G2NDGROSS : ER2G_GROSS.values()) {
            value = StringUtils.trimToEmpty((String)((String)er2G2NDGROSS.getFn().apply(invoice)));
            gParts2stBuilder.add((Object)value);
        }
        ImmutableList immutableList = gParts2stBuilder.build();
        if (!immutableList.isEmpty()) {
            gPartRowsBuilder.add((Object)immutableList);
        }
        ImmutableList gPartRows = gPartRowsBuilder.build();
        rowsBuilder.add((Object)fParts);
        rowsBuilder.addAll((Iterable)gPartRows);
        rowsBuilder.add((Object)kSenderParts);
        return rowsBuilder.build();
    }

    @Nonnull
    private static String grossWithSecRetER2(@NonNull Invoice invoice) {
        if (invoice == null) {
            throw new NullPointerException("invoice is marked non-null but is null");
        }
        EInvoiceState invoiceState = (EInvoiceState)MoreObjects.firstNonNull((Object)invoice.getInvoiceState(), (Object)EInvoiceState.UNKNOWN);
        boolean negateByState = NEGATE_INVOICE_STATES.contains(invoiceState);
        BigDecimal netWithSecRet = invoice.getTotalValueNet();
        BigDecimal vat = invoice.getVatValue();
        BigDecimal grossWithSecRet = netWithSecRet.add(vat);
        BigDecimal valueRecalculated1 = negateByState ? grossWithSecRet.negate() : grossWithSecRet;
        return ER2ServiceInvoiceCompanyGroupP305.er2BigDecimalAsString((BigDecimal)valueRecalculated1);
    }
}

