/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.service.service;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import de.qfm.erp.service.helper.InvoiceDefinition;
import de.qfm.erp.service.model.jpa.EntityBase;
import de.qfm.erp.service.model.jpa.invoice.EInvoiceNumberGroup;
import de.qfm.erp.service.model.jpa.invoice.EInvoiceType;
import de.qfm.erp.service.model.jpa.invoice.InvoiceNumber;
import de.qfm.erp.service.service.handler.EntityFactory;
import de.qfm.erp.service.service.handler.InvoiceHandler;
import de.qfm.erp.service.service.handler.InvoiceNumberHandler;
import java.time.LocalDate;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nonnull;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class InvoiceService {
    public final EntityFactory entityFactory;
    public final InvoiceHandler invoiceHandler;
    public final InvoiceNumberHandler invoiceNumberHandler;
    private static final Map<EInvoiceType, EInvoiceNumberGroup> INVOICE_TYPE__TO__INVOICE_NUMBER_GROUP = ImmutableMap.builder().put((Object)EInvoiceType.INVOICE, (Object)EInvoiceNumberGroup.EXTERNAL_INVOICE).put((Object)EInvoiceType.PARTIAL_INVOICE, (Object)EInvoiceNumberGroup.EXTERNAL_INVOICE).put((Object)EInvoiceType.PARTIAL_FINAL_INVOICE, (Object)EInvoiceNumberGroup.EXTERNAL_INVOICE).put((Object)EInvoiceType.FINAL_INVOICE, (Object)EInvoiceNumberGroup.EXTERNAL_INVOICE).put((Object)EInvoiceType.CUMULATIVE_INVOICE, (Object)EInvoiceNumberGroup.EXTERNAL_INVOICE).put((Object)EInvoiceType.PARTIAL_CUMULATIVE_INVOICE, (Object)EInvoiceNumberGroup.EXTERNAL_INVOICE).put((Object)EInvoiceType.FINAL_CUMULATIVE_INVOICE, (Object)EInvoiceNumberGroup.EXTERNAL_INVOICE).put((Object)EInvoiceType.INTERNAL_INVOICE, (Object)EInvoiceNumberGroup.INTERNAL_INVOICE).put((Object)EInvoiceType.INTERNAL_VOUCHER, (Object)EInvoiceNumberGroup.INTERNAL_VOUCHER).put((Object)EInvoiceType.CREDIT_VOUCHER, (Object)EInvoiceNumberGroup.SUBCONTRACTOR_CREDIT_VOUCHER).put((Object)EInvoiceType.CUSTOMER_VOUCHER, (Object)EInvoiceNumberGroup.SUBCONTRACTOR_CREDIT_VOUCHER).build();

    @Nonnull
    public synchronized String determineNextInvoiceNumber(@NonNull EInvoiceType invoiceType, @NonNull LocalDate invoiceDate) {
        if (invoiceType == null) {
            throw new NullPointerException("invoiceType is marked non-null but is null");
        }
        if (invoiceDate == null) {
            throw new NullPointerException("invoiceDate is marked non-null but is null");
        }
        EInvoiceNumberGroup invoiceNumberGroup = INVOICE_TYPE__TO__INVOICE_NUMBER_GROUP.getOrDefault(invoiceType, EInvoiceNumberGroup.UNKNOWN);
        String prefix = InvoiceDefinition.INVOICE_NUMBER_GROUP__TO__PREFIX.getOrDefault(invoiceNumberGroup, "n/a");
        int year = invoiceDate.getYear();
        InvoiceNumber invoiceNumber = this.invoiceNumberHandler.byTypeAndYearNotFailing(invoiceNumberGroup, Integer.valueOf(year)).orElseGet(() -> this.entityFactory.invoiceNumber(invoiceNumberGroup, year));
        Long currentNumber = (Long)MoreObjects.firstNonNull((Object)invoiceNumber.getInvoiceNumber(), (Object)0L);
        Long nextNumber = 1L + currentNumber;
        invoiceNumber.setInvoiceNumber(nextNumber);
        InvoiceNumber invoiceNumberUpdated = (InvoiceNumber)this.invoiceNumberHandler.update((EntityBase)invoiceNumber);
        return InvoiceService.yearNumber((String)prefix, (InvoiceNumber)invoiceNumberUpdated);
    }

    @Nonnull
    public static String yearNumber(@NonNull String prefix, @NonNull InvoiceNumber invoiceNumber) {
        if (prefix == null) {
            throw new NullPointerException("prefix is marked non-null but is null");
        }
        if (invoiceNumber == null) {
            throw new NullPointerException("invoiceNumber is marked non-null but is null");
        }
        Integer year = invoiceNumber.getInvoiceYear();
        Long number = invoiceNumber.getInvoiceNumber();
        return InvoiceService.yearNumber((String)prefix, (Integer)year, (Long)number);
    }

    @Nonnull
    public static String yearNumber(@NonNull String prefix, @NonNull Integer year, @NonNull Long number) {
        if (prefix == null) {
            throw new NullPointerException("prefix is marked non-null but is null");
        }
        if (year == null) {
            throw new NullPointerException("year is marked non-null but is null");
        }
        if (number == null) {
            throw new NullPointerException("number is marked non-null but is null");
        }
        String numberAsString = Long.toString(number);
        String numberAsStringLPad = StringUtils.leftPad((String)numberAsString, (int)5, (String)"0");
        String yearAsString = Integer.toString(year);
        String yearAsSubbed = StringUtils.right((String)yearAsString, (int)2);
        return String.format("%s%s/%s", prefix, yearAsSubbed, numberAsStringLPad);
    }

    @Nonnull
    public Optional<String> findHoles(@NonNull EInvoiceType invoiceType, @NonNull LocalDate invoiceDate) {
        Optional invoiceNumberCandidate;
        if (invoiceType == null) {
            throw new NullPointerException("invoiceType is marked non-null but is null");
        }
        if (invoiceDate == null) {
            throw new NullPointerException("invoiceDate is marked non-null but is null");
        }
        EInvoiceNumberGroup invoiceNumberGroup = INVOICE_TYPE__TO__INVOICE_NUMBER_GROUP.getOrDefault(invoiceType, EInvoiceNumberGroup.UNKNOWN);
        String prefix = InvoiceDefinition.INVOICE_NUMBER_GROUP__TO__PREFIX.getOrDefault(invoiceNumberGroup, "n/a");
        int year = invoiceDate.getYear();
        String yearAsString = Integer.toString(year);
        String yearAsSubbed = StringUtils.right((String)yearAsString, (int)2);
        String invoicePrefix = prefix + yearAsSubbed;
        int prefixLength = prefix.length();
        ImmutableList.Builder holesBuilder = ImmutableList.builder();
        if (1 == prefixLength) {
            this.invoiceHandler.findHolesWithPrefixLength1(invoicePrefix).ifPresent(arg_0 -> ((ImmutableList.Builder)holesBuilder).add(arg_0));
        } else if (2 == prefixLength) {
            this.invoiceHandler.findHolesWithPrefixLength2(invoicePrefix).ifPresent(arg_0 -> ((ImmutableList.Builder)holesBuilder).add(arg_0));
        }
        ImmutableList holes = holesBuilder.build();
        if (!holes.isEmpty() && (invoiceNumberCandidate = this.invoiceNumberHandler.byTypeAndYearNotFailing(invoiceNumberGroup, Integer.valueOf(year))).isPresent()) {
            InvoiceNumber invoiceNumber = (InvoiceNumber)invoiceNumberCandidate.get();
            Long lastInvoiceNumber = invoiceNumber.getInvoiceNumber();
            Long firstHole = (Long)holes.iterator().next();
            if (lastInvoiceNumber - firstHole < 100L) {
                return Optional.of(InvoiceService.yearNumber((String)prefix, (Integer)year, (Long)firstHole));
            }
        }
        return Optional.empty();
    }

    public InvoiceService(EntityFactory entityFactory, InvoiceHandler invoiceHandler, InvoiceNumberHandler invoiceNumberHandler) {
        this.entityFactory = entityFactory;
        this.invoiceHandler = invoiceHandler;
        this.invoiceNumberHandler = invoiceNumberHandler;
    }
}

