/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.service.service;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Multimap;
import com.google.common.collect.Range;
import com.google.common.collect.Sets;
import de.leancoders.common.helper.IterableHelper;
import de.qfm.erp.common.response.quotation.AbstractStageFulfilmentDegreePositionCommon;
import de.qfm.erp.common.response.quotation.StageFulfilmentDegreePositionCommon;
import de.qfm.erp.common.response.quotation.StageFulfilmentDegreeSimpleCommon;
import de.qfm.erp.service.helper.BigDecimalHelper;
import de.qfm.erp.service.helper.MapsHelper;
import de.qfm.erp.service.helper.StageHelper;
import de.qfm.erp.service.model.annotation.ProofOfConcept;
import de.qfm.erp.service.model.internal.invoice.AddendumDiscount;
import de.qfm.erp.service.model.internal.measurement.MeasurementAmountPriceWage;
import de.qfm.erp.service.model.internal.quotation.StageAmountPriceWage;
import de.qfm.erp.service.model.jpa.measurement.type.EMeasurementState;
import de.qfm.erp.service.model.jpa.quotation.EQStageType;
import de.qfm.erp.service.model.jpa.quotation.EStageOrigin;
import de.qfm.erp.service.model.jpa.quotation.QEntity;
import de.qfm.erp.service.model.jpa.quotation.Quotation;
import de.qfm.erp.service.model.jpa.shared.EAlternativePositionType;
import de.qfm.erp.service.model.jpa.shared.EPositionType;
import de.qfm.erp.service.service.handler.MeasurementHandler;
import de.qfm.erp.service.service.handler.StageHandler;
import de.qfm.erp.service.service.handler.UserHandler;
import de.qfm.erp.service.service.service.DataAggregationService;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.annotation.Nonnull;
import lombok.NonNull;
import org.apache.commons.compress.utils.Lists;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.commons.lang3.tuple.Triple;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.stereotype.Service;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class DataAggregationService {
    private static final Logger log = LogManager.getLogger(DataAggregationService.class);
    private final MeasurementHandler measurementHandler;
    private final UserHandler userHandler;
    private final StageHandler stageHandler;

    @Nonnull
    @ProofOfConcept(value="Stage Fulfilment for Dashboards")
    public StageFulfilmentDegreeSimpleCommon stageFulfilmentDegree(@NonNull Iterable<Quotation> stages, @NonNull Iterable<Long> stagePositionIdsFilter, @NonNull Iterable<Long> userIdsFilter, @NonNull Range<LocalDate> projectExecutionDateRange, @NonNull Iterable<String> costCenters, boolean optionMergePositions, boolean optionMergeChangeInQuantity, boolean optionDisableDiscount, boolean stagesBasedOnEntity) {
        if (stages == null) {
            throw new NullPointerException("stages is marked non-null but is null");
        }
        if (stagePositionIdsFilter == null) {
            throw new NullPointerException("stagePositionIdsFilter is marked non-null but is null");
        }
        if (userIdsFilter == null) {
            throw new NullPointerException("userIdsFilter is marked non-null but is null");
        }
        if (projectExecutionDateRange == null) {
            throw new NullPointerException("projectExecutionDateRange is marked non-null but is null");
        }
        if (costCenters == null) {
            throw new NullPointerException("costCenters is marked non-null but is null");
        }
        if (Iterables.isEmpty(stages)) {
            return StageFulfilmentDegreeSimpleCommon.empty();
        }
        Iterable stageIds = (Iterable)IterableHelper.stream(stages).map(Quotation::getId).collect(ImmutableSet.toImmutableSet());
        ImmutableSet positionIds = ImmutableSet.copyOf((Iterable)Iterables.filter(stagePositionIdsFilter, Objects::nonNull));
        boolean filterPositions = !Iterables.isEmpty((Iterable)positionIds);
        List stageAmountPriceWagesRaw = this.stageHandler.amountPriceWage(stageIds, (Iterable)positionIds, EPositionType.WAGE_AND_VALUE_TYPES);
        Iterable users = this.userHandler.allByIds(userIdsFilter);
        ImmutableList iAddendumDiscounts = optionDisableDiscount ? ImmutableList.of() : this.stageHandler.allStageDiscounts(stages);
        Map addendumDiscountByKey = MapsHelper.mapFirst((Iterable)iAddendumDiscounts, arg_0 -> this.key(arg_0), item -> {
            BigDecimal generalDiscount = (BigDecimal)MoreObjects.firstNonNull((Object)item.getGeneralDiscount(), (Object)BigDecimal.ZERO);
            BigDecimal otherDiscount = (BigDecimal)MoreObjects.firstNonNull((Object)item.getOtherDiscount(), (Object)BigDecimal.ZERO);
            return generalDiscount.add(otherDiscount);
        });
        boolean containsOldStage = IterableHelper.stream(stages).anyMatch(item -> EStageOrigin.QUANTE_V1 == item.getOrigin());
        Function<MeasurementAmountPriceWage, String> measurementAmountPriceWageKeyFn = containsOldStage ? item -> this.keyBySPN(item, optionMergePositions, optionMergeChangeInQuantity) : item -> this.keyById(item, optionMergePositions, optionMergeChangeInQuantity);
        Function<StageAmountPriceWage, String> positionKeyFn = containsOldStage ? item -> this.keyBySPN(item, optionMergePositions, optionMergeChangeInQuantity) : item -> this.keyById(item, optionMergePositions, optionMergeChangeInQuantity);
        Iterable stageAmountPriceWages = optionMergePositions || optionMergeChangeInQuantity ? this.mergeChangeInQuantityS((Iterable)stageAmountPriceWagesRaw) : stageAmountPriceWagesRaw;
        Map stageAmountPriceWageMap = MapsHelper.mapFirst((Iterable)stageAmountPriceWages, positionKeyFn);
        List measurementAmountPriceWagesRaw = containsOldStage ? this.measurementHandler.amountPriceWageBySPN(stageIds, (Iterable)ImmutableList.of(), (Iterable)EMeasurementState.ALL_RELEVANT_FOR_FULFILMENT_DEGREE, projectExecutionDateRange, users, costCenters) : this.measurementHandler.amountPriceWageById(stageIds, (Iterable)ImmutableList.of(), (Iterable)EMeasurementState.ALL_RELEVANT_FOR_FULFILMENT_DEGREE, projectExecutionDateRange, users, costCenters);
        Iterable measurementAmountPriceWages = optionMergePositions || optionMergeChangeInQuantity ? this.mergeChangeInQuantityM((Iterable)measurementAmountPriceWagesRaw) : measurementAmountPriceWagesRaw;
        Multimap measurementAmountPriceWageMap = MapsHelper.map((Iterable)measurementAmountPriceWages, measurementAmountPriceWageKeyFn, item -> item);
        Map positionByKey = MapsHelper.mapFirst((Iterable)stageAmountPriceWagesRaw, positionKeyFn);
        ImmutableSet positionSortedKeys = (ImmutableSet)ImmutableList.sortedCopyOf((Comparator)AmountPriceWageComparator.of(), (Iterable)stageAmountPriceWagesRaw).stream().map(positionKeyFn).collect(ImmutableSet.toImmutableSet());
        ArrayListMultimap totalMeasurementValue = ArrayListMultimap.create();
        ArrayListMultimap totalMeasurementMaterialSellingPriceValue = ArrayListMultimap.create();
        ArrayListMultimap totalMeasurementCompanyWageValue = ArrayListMultimap.create();
        ArrayListMultimap totalMeasurementSquadWageValue = ArrayListMultimap.create();
        ArrayListMultimap totalMeasurementExternalServiceSellingPriceValue = ArrayListMultimap.create();
        ArrayListMultimap accountedMeasurementValue = ArrayListMultimap.create();
        ArrayListMultimap accountedMeasurementMaterialSellingPriceValue = ArrayListMultimap.create();
        ArrayListMultimap accountedMeasurementCompanyWageValue = ArrayListMultimap.create();
        ArrayListMultimap accountedMeasurementSquadWageValue = ArrayListMultimap.create();
        ArrayListMultimap accountedMeasurementExternalServiceSellingPriceValue = ArrayListMultimap.create();
        ArrayListMultimap notAccountedMeasurementValue = ArrayListMultimap.create();
        ArrayListMultimap notAccountedMeasurementMaterialSellingPriceValue = ArrayListMultimap.create();
        ArrayListMultimap notAccountedMeasurementCompanyWageValue = ArrayListMultimap.create();
        ArrayListMultimap notAccountedMeasurementSquadWageValue = ArrayListMultimap.create();
        ArrayListMultimap notAccountedMeasurementExternalServiceSellingPriceValue = ArrayListMultimap.create();
        ArrayListMultimap totalMeasurementAmounts = ArrayListMultimap.create();
        ArrayListMultimap notAccountedMeasurementAmounts = ArrayListMultimap.create();
        ArrayListMultimap accountedMeasurementAmounts = ArrayListMultimap.create();
        ArrayListMultimap stageCompanyWagesAll = ArrayListMultimap.create();
        ArrayListMultimap stageSquadWagesAll = ArrayListMultimap.create();
        ArrayListMultimap stageMaterialSellingPriceAll = ArrayListMultimap.create();
        ArrayListMultimap stageExternalServiceSellingPriceAll = ArrayListMultimap.create();
        ArrayListMultimap stageOrderedAmounts = ArrayListMultimap.create();
        ImmutableList.Builder positionCommonsBuilder = ImmutableList.builder();
        Set measurementKeys = measurementAmountPriceWageMap.keySet();
        Sets.SetView difference = Sets.difference((Set)measurementKeys, (Set)positionSortedKeys);
        ImmutableList allKeysSorted = ImmutableList.builder().addAll((Iterable)positionSortedKeys).addAll((Iterable)difference).build();
        allKeysSorted.forEach(arg_0 -> this.lambda$stageFulfilmentDegree$7(stageAmountPriceWageMap, measurementAmountPriceWageMap, (Multimap)stageOrderedAmounts, (Multimap)stageCompanyWagesAll, (Multimap)stageSquadWagesAll, (Multimap)stageMaterialSellingPriceAll, (Multimap)stageExternalServiceSellingPriceAll, (Multimap)totalMeasurementAmounts, (Multimap)notAccountedMeasurementAmounts, (Multimap)accountedMeasurementAmounts, addendumDiscountByKey, (Multimap)totalMeasurementValue, (Multimap)notAccountedMeasurementValue, (Multimap)accountedMeasurementValue, (Multimap)totalMeasurementSquadWageValue, (Multimap)notAccountedMeasurementSquadWageValue, (Multimap)accountedMeasurementSquadWageValue, (Multimap)totalMeasurementCompanyWageValue, (Multimap)notAccountedMeasurementCompanyWageValue, (Multimap)accountedMeasurementCompanyWageValue, (Multimap)totalMeasurementMaterialSellingPriceValue, (Multimap)notAccountedMeasurementMaterialSellingPriceValue, (Multimap)accountedMeasurementMaterialSellingPriceValue, (Multimap)totalMeasurementExternalServiceSellingPriceValue, (Multimap)notAccountedMeasurementExternalServiceSellingPriceValue, (Multimap)accountedMeasurementExternalServiceSellingPriceValue, positionByKey, positionCommonsBuilder, filterPositions, arg_0));
        ImmutableList positionCommons = positionCommonsBuilder.build();
        StageFulfilmentDegreeSimpleCommon common = new StageFulfilmentDegreeSimpleCommon();
        Iterable entityNumbers = (Iterable)positionCommons.stream().map(AbstractStageFulfilmentDegreePositionCommon::getEntityNumber).collect(ImmutableSet.toImmutableSet());
        Iterable stageNumbers = (Iterable)positionCommons.stream().map(AbstractStageFulfilmentDegreePositionCommon::getStageNumber).collect(ImmutableSet.toImmutableSet());
        common.setEntityNumbers((List)ImmutableList.copyOf((Iterable)entityNumbers));
        common.setStageNumbers((List)ImmutableList.copyOf((Iterable)stageNumbers));
        common.setStageIds((List)ImmutableList.copyOf((Iterable)stageIds));
        this.apply((Multimap)totalMeasurementValue, arg_0 -> ((StageFulfilmentDegreeSimpleCommon)common).setTotalMeasurementValue(arg_0));
        this.apply((Multimap)totalMeasurementMaterialSellingPriceValue, arg_0 -> ((StageFulfilmentDegreeSimpleCommon)common).setTotalMeasurementMaterialSellingPriceValue(arg_0));
        this.apply((Multimap)totalMeasurementExternalServiceSellingPriceValue, arg_0 -> ((StageFulfilmentDegreeSimpleCommon)common).setTotalMeasurementExternalServiceSellingPriceValue(arg_0));
        this.apply((Multimap)totalMeasurementCompanyWageValue, arg_0 -> ((StageFulfilmentDegreeSimpleCommon)common).setTotalMeasurementCompanyWageValue(arg_0));
        this.apply((Multimap)totalMeasurementSquadWageValue, arg_0 -> ((StageFulfilmentDegreeSimpleCommon)common).setTotalMeasurementSquadWageValue(arg_0));
        this.apply((Multimap)accountedMeasurementValue, arg_0 -> ((StageFulfilmentDegreeSimpleCommon)common).setAccountedMeasurementValue(arg_0));
        this.apply((Multimap)accountedMeasurementMaterialSellingPriceValue, arg_0 -> ((StageFulfilmentDegreeSimpleCommon)common).setAccountedMeasurementMaterialSellingPriceValue(arg_0));
        this.apply((Multimap)accountedMeasurementExternalServiceSellingPriceValue, arg_0 -> ((StageFulfilmentDegreeSimpleCommon)common).setAccountedMeasurementExternalServiceSellingPriceValue(arg_0));
        this.apply((Multimap)accountedMeasurementCompanyWageValue, arg_0 -> ((StageFulfilmentDegreeSimpleCommon)common).setAccountedMeasurementCompanyWageValue(arg_0));
        this.apply((Multimap)accountedMeasurementSquadWageValue, arg_0 -> ((StageFulfilmentDegreeSimpleCommon)common).setAccountedMeasurementSquadWageValue(arg_0));
        this.apply((Multimap)notAccountedMeasurementValue, arg_0 -> ((StageFulfilmentDegreeSimpleCommon)common).setNotAccountedMeasurementValue(arg_0));
        this.apply((Multimap)notAccountedMeasurementMaterialSellingPriceValue, arg_0 -> ((StageFulfilmentDegreeSimpleCommon)common).setNotAccountedMeasurementMaterialSellingPriceValue(arg_0));
        this.apply((Multimap)notAccountedMeasurementExternalServiceSellingPriceValue, arg_0 -> ((StageFulfilmentDegreeSimpleCommon)common).setNotAccountedMeasurementExternalServiceSellingPriceValue(arg_0));
        this.apply((Multimap)notAccountedMeasurementCompanyWageValue, arg_0 -> ((StageFulfilmentDegreeSimpleCommon)common).setNotAccountedMeasurementCompanyWageValue(arg_0));
        this.apply((Multimap)notAccountedMeasurementSquadWageValue, arg_0 -> ((StageFulfilmentDegreeSimpleCommon)common).setNotAccountedMeasurementSquadWageValue(arg_0));
        this.apply(stageAmountPriceWages, StageAmountPriceWage::getSquadWageAggregated, arg_0 -> ((StageFulfilmentDegreeSimpleCommon)common).setStageSquadWageValue(arg_0));
        this.apply(stageAmountPriceWages, StageAmountPriceWage::getCompanyWageAggregated, arg_0 -> ((StageFulfilmentDegreeSimpleCommon)common).setStageCompanyWageValue(arg_0));
        this.apply(stageAmountPriceWages, StageAmountPriceWage::getMaterialSellingPriceAggregated, arg_0 -> ((StageFulfilmentDegreeSimpleCommon)common).setStageMaterialSellingPriceValue(arg_0));
        this.apply(stageAmountPriceWages, StageAmountPriceWage::getExternalServiceSellingPriceAggregated, arg_0 -> ((StageFulfilmentDegreeSimpleCommon)common).setStageExternalServiceSellingPriceValue(arg_0));
        this.apply(stageAmountPriceWages, StageAmountPriceWage::getPrice, arg_0 -> ((StageFulfilmentDegreeSimpleCommon)common).setStagePriceValue(arg_0));
        boolean crossOrderValue = IterableHelper.stream(stages).filter(item -> item.getStageType() == EQStageType.COMMISSION).map(item -> (Boolean)MoreObjects.firstNonNull((Object)item.getFlagCrossVersionOrderValue(), (Object)false)).reduce(false, (left, right) -> left != false || right != false);
        BigDecimal totalOrderValue = IterableHelper.stream(stages).filter(item -> {
            EQStageType stageType = item.getStageType();
            boolean isCommission = EQStageType.COMMISSION == stageType;
            boolean isAddendumType = Iterables.contains((Iterable)EQStageType.ADDENDUM_TYPES, (Object)stageType);
            if (stagesBasedOnEntity) {
                if (isCommission) {
                    QEntity entity = item.getQEntity();
                    boolean isPrimaryCommission = null != entity && entity.getPrimaryStage() == item;
                    return crossOrderValue || isPrimaryCommission;
                }
                return isAddendumType && Boolean.TRUE == item.getFlagBudgetRelevant();
            }
            if (isAddendumType) {
                return Boolean.TRUE == item.getFlagBudgetRelevant();
            }
            return true;
        }).map(item -> {
            BigDecimal relevantOrderValue = optionDisableDiscount ? item.getOrderValue() : item.getOrderValueWithDiscount();
            BigDecimal orderValueEstimate = (BigDecimal)MoreObjects.firstNonNull((Object)item.getOrderValueEstimate(), (Object)BigDecimal.ZERO);
            boolean orderValueSet = null != relevantOrderValue;
            return orderValueSet ? relevantOrderValue : orderValueEstimate;
        }).reduce(BigDecimal.ZERO, BigDecimal::add);
        common.setStageOrderValue(totalOrderValue);
        common.setPositions((List)positionCommons);
        return common;
    }

    @Nonnull
    private Iterable<MeasurementAmountPriceWage> mergeChangeInQuantityM(@NonNull Iterable<MeasurementAmountPriceWage> measurementAmountPriceWagesRaw) {
        if (measurementAmountPriceWagesRaw == null) {
            throw new NullPointerException("measurementAmountPriceWagesRaw is marked non-null but is null");
        }
        Map standardPositionById = (Map)IterableHelper.stream(measurementAmountPriceWagesRaw).filter(item -> item.getPositionType() == EPositionType.STANDARD).filter(item -> null != item.getPositionId()).collect(ImmutableMap.toImmutableMap(item -> Triple.of((Object)item.getMeasurementId(), (Object)item.getPositionId(), (Object)item.getPricePerUnit()), item -> item));
        IterableHelper.stream(measurementAmountPriceWagesRaw).filter(item -> item.getPositionType() == EPositionType.CHANGE_IN_QUANTITY).forEach(item -> {
            BigDecimal pricePerUnit;
            Long referencePositionId;
            Long measurementId = item.getMeasurementId();
            Triple key = Triple.of((Object)measurementId, (Object)(referencePositionId = item.getReferencePositionId()), (Object)(pricePerUnit = item.getPricePerUnit()));
            MeasurementAmountPriceWage measurementAmountPriceWage = (MeasurementAmountPriceWage)standardPositionById.get(key);
            if (null != measurementAmountPriceWage) {
                BigDecimal leftProduct = (BigDecimal)MoreObjects.firstNonNull((Object)item.getProduct(), (Object)BigDecimal.ZERO);
                BigDecimal leftPrice = (BigDecimal)MoreObjects.firstNonNull((Object)item.getPrice(), (Object)BigDecimal.ZERO);
                BigDecimal leftSquadWage = (BigDecimal)MoreObjects.firstNonNull((Object)item.getSquadWageAggregated(), (Object)BigDecimal.ZERO);
                BigDecimal leftCompanyWage = (BigDecimal)MoreObjects.firstNonNull((Object)item.getCompanyWageAggregated(), (Object)BigDecimal.ZERO);
                BigDecimal leftMatSellingPrice = (BigDecimal)MoreObjects.firstNonNull((Object)item.getMaterialSellingPriceAggregated(), (Object)BigDecimal.ZERO);
                BigDecimal rightProduct = (BigDecimal)MoreObjects.firstNonNull((Object)measurementAmountPriceWage.getProduct(), (Object)BigDecimal.ZERO);
                BigDecimal rightPrice = (BigDecimal)MoreObjects.firstNonNull((Object)measurementAmountPriceWage.getPrice(), (Object)BigDecimal.ZERO);
                BigDecimal rightSquadWage = (BigDecimal)MoreObjects.firstNonNull((Object)measurementAmountPriceWage.getSquadWageAggregated(), (Object)BigDecimal.ZERO);
                BigDecimal rightCompanyWage = (BigDecimal)MoreObjects.firstNonNull((Object)measurementAmountPriceWage.getCompanyWageAggregated(), (Object)BigDecimal.ZERO);
                BigDecimal rightMatSellingPrice = (BigDecimal)MoreObjects.firstNonNull((Object)measurementAmountPriceWage.getMaterialSellingPriceAggregated(), (Object)BigDecimal.ZERO);
                measurementAmountPriceWage.setProduct(leftProduct.add(rightProduct));
                measurementAmountPriceWage.setPrice(leftPrice.add(rightPrice));
                measurementAmountPriceWage.setSquadWageAggregated(leftSquadWage.add(rightSquadWage));
                measurementAmountPriceWage.setCompanyWageAggregated(leftCompanyWage.add(rightCompanyWage));
                measurementAmountPriceWage.setMaterialSellingPriceAggregated(leftMatSellingPrice.add(rightMatSellingPrice));
            }
        });
        return measurementAmountPriceWagesRaw;
    }

    @Nonnull
    private Iterable<StageAmountPriceWage> mergeChangeInQuantityS(@NonNull Iterable<StageAmountPriceWage> stageAmountPriceWagesRaw) {
        if (stageAmountPriceWagesRaw == null) {
            throw new NullPointerException("stageAmountPriceWagesRaw is marked non-null but is null");
        }
        Map standardPositionById = (Map)IterableHelper.stream(stageAmountPriceWagesRaw).filter(item -> item.getPositionType() == EPositionType.STANDARD).filter(item -> null != item.getPositionId()).collect(ImmutableMap.toImmutableMap(StageAmountPriceWage::getPositionId, item -> item));
        IterableHelper.stream(stageAmountPriceWagesRaw).filter(item -> item.getPositionType() == EPositionType.CHANGE_IN_QUANTITY).forEach(item -> {
            Long referencePositionId = item.getReferencePositionId();
            StageAmountPriceWage stageAmountPriceWage = (StageAmountPriceWage)standardPositionById.get(referencePositionId);
            if (null != stageAmountPriceWage) {
                BigDecimal leftOrderedAmount = (BigDecimal)MoreObjects.firstNonNull((Object)item.getOrderedAmount(), (Object)BigDecimal.ZERO);
                BigDecimal leftPrice = (BigDecimal)MoreObjects.firstNonNull((Object)item.getPrice(), (Object)BigDecimal.ZERO);
                BigDecimal leftSquadWage = (BigDecimal)MoreObjects.firstNonNull((Object)item.getSquadWageAggregated(), (Object)BigDecimal.ZERO);
                BigDecimal leftCompanyWage = (BigDecimal)MoreObjects.firstNonNull((Object)item.getCompanyWageAggregated(), (Object)BigDecimal.ZERO);
                BigDecimal leftMatSellingPrice = (BigDecimal)MoreObjects.firstNonNull((Object)item.getMaterialSellingPriceAggregated(), (Object)BigDecimal.ZERO);
                BigDecimal rightOrderedAmount = (BigDecimal)MoreObjects.firstNonNull((Object)stageAmountPriceWage.getOrderedAmount(), (Object)BigDecimal.ZERO);
                BigDecimal rightPrice = (BigDecimal)MoreObjects.firstNonNull((Object)stageAmountPriceWage.getPrice(), (Object)BigDecimal.ZERO);
                BigDecimal rightSquadWage = (BigDecimal)MoreObjects.firstNonNull((Object)stageAmountPriceWage.getSquadWageAggregated(), (Object)BigDecimal.ZERO);
                BigDecimal rightCompanyWage = (BigDecimal)MoreObjects.firstNonNull((Object)stageAmountPriceWage.getCompanyWageAggregated(), (Object)BigDecimal.ZERO);
                BigDecimal rightMatSellingPrice = (BigDecimal)MoreObjects.firstNonNull((Object)stageAmountPriceWage.getMaterialSellingPriceAggregated(), (Object)BigDecimal.ZERO);
                stageAmountPriceWage.setOrderedAmount(leftOrderedAmount.add(rightOrderedAmount));
                stageAmountPriceWage.setPrice(leftPrice.add(rightPrice));
                stageAmountPriceWage.setSquadWageAggregated(leftSquadWage.add(rightSquadWage));
                stageAmountPriceWage.setCompanyWageAggregated(leftCompanyWage.add(rightCompanyWage));
                stageAmountPriceWage.setMaterialSellingPriceAggregated(leftMatSellingPrice.add(rightMatSellingPrice));
                item.setOrderedAmount(leftOrderedAmount.add(rightOrderedAmount));
                item.setPrice(leftPrice.add(rightPrice));
                item.setSquadWageAggregated(leftSquadWage.add(rightSquadWage));
                item.setCompanyWageAggregated(leftCompanyWage.add(rightCompanyWage));
                item.setMaterialSellingPriceAggregated(leftMatSellingPrice.add(rightMatSellingPrice));
            }
        });
        return stageAmountPriceWagesRaw;
    }

    @Nonnull
    private String keyById(@NonNull StageAmountPriceWage item, boolean mergePosition, boolean mergeChangeInQuantityPosition) {
        if (item == null) {
            throw new NullPointerException("item is marked non-null but is null");
        }
        if (mergePosition || mergeChangeInQuantityPosition) {
            return this.keyBySPN(item, mergePosition, mergeChangeInQuantityPosition);
        }
        String stageNumber = item.getStageNumber();
        Long addendumNumber = item.getAddendumNumber();
        Long positionId = item.getPositionId();
        return String.format("%s_%s_%s", stageNumber, positionId, addendumNumber);
    }

    @Nonnull
    private String keyById(@NonNull MeasurementAmountPriceWage item, boolean mergePosition, boolean mergeChangeInQuantityPosition) {
        if (item == null) {
            throw new NullPointerException("item is marked non-null but is null");
        }
        if (mergePosition || mergeChangeInQuantityPosition) {
            return this.keyBySPN(item, mergePosition, mergeChangeInQuantityPosition);
        }
        return String.format("%s_%s_%s", item.getStageNumber(), item.getPositionId(), item.getAddendumNumber());
    }

    @Nonnull
    private String keyBySPN(@NonNull StageAmountPriceWage stageAmountPriceWage, boolean mergePosition, boolean mergeChangeInQuantityPosition) {
        if (stageAmountPriceWage == null) {
            throw new NullPointerException("stageAmountPriceWage is marked non-null but is null");
        }
        ArrayList keyParts = Lists.newArrayList();
        if (!mergePosition) {
            keyParts.add(StageAmountPriceWage::getStageNumber);
            keyParts.add(item -> MoreObjects.firstNonNull((Object)item.getAddendumNumber(), (Object)0));
        }
        if (!mergeChangeInQuantityPosition && !mergePosition) {
            keyParts.add(StageAmountPriceWage::getPositionType);
        }
        keyParts.add(StageAmountPriceWage::getSurrogatePositionNumber);
        return keyParts.stream().map(item -> item.apply(stageAmountPriceWage)).map(Objects::toString).reduce("", (l, r) -> l + "_" + r);
    }

    @Nonnull
    private String keyBySPN(@NonNull MeasurementAmountPriceWage measurementAmountPriceWage, boolean mergePosition, boolean mergeChangeInQuantityPosition) {
        if (measurementAmountPriceWage == null) {
            throw new NullPointerException("measurementAmountPriceWage is marked non-null but is null");
        }
        ArrayList keyParts = Lists.newArrayList();
        if (!mergePosition) {
            keyParts.add(MeasurementAmountPriceWage::getStageNumber);
            keyParts.add(item -> MoreObjects.firstNonNull((Object)item.getAddendumNumber(), (Object)0));
        }
        if (!mergeChangeInQuantityPosition && !mergePosition) {
            keyParts.add(MeasurementAmountPriceWage::getPositionType);
        }
        keyParts.add(MeasurementAmountPriceWage::getSurrogatePositionNumber);
        return keyParts.stream().map(item -> item.apply(measurementAmountPriceWage)).map(Objects::toString).reduce("", (l, r) -> l + "_" + r);
    }

    @Nonnull
    private Pair<String, Long> key(@NonNull AddendumDiscount item) {
        if (item == null) {
            throw new NullPointerException("item is marked non-null but is null");
        }
        return Pair.of((Object)item.getStageNumber(), (Object)item.getAddendumNumber());
    }

    @Nonnull
    private BigDecimal sum(@NonNull Iterable<MeasurementAmountPriceWage> amountPriceWages, @NonNull Set<EMeasurementState> measurementStates, @NonNull Function<MeasurementAmountPriceWage, BigDecimal> attributeFN, @NonNull Map<Pair<String, Long>, BigDecimal> addendumDiscountsPerKey) {
        if (amountPriceWages == null) {
            throw new NullPointerException("amountPriceWages is marked non-null but is null");
        }
        if (measurementStates == null) {
            throw new NullPointerException("measurementStates is marked non-null but is null");
        }
        if (attributeFN == null) {
            throw new NullPointerException("attributeFN is marked non-null but is null");
        }
        if (addendumDiscountsPerKey == null) {
            throw new NullPointerException("addendumDiscountsPerKey is marked non-null but is null");
        }
        return IterableHelper.stream(amountPriceWages).filter(item -> measurementStates.contains(item.getMeasurementState())).map(amountPriceWage -> {
            String stageNumber = amountPriceWage.getStageNumber();
            Long addendumNumber = amountPriceWage.getAddendumNumber();
            Pair discountKey = Pair.of((Object)stageNumber, (Object)addendumNumber);
            BigDecimal discount = addendumDiscountsPerKey.getOrDefault(discountKey, BigDecimal.ZERO);
            BigDecimal valueWithoutDiscount = (BigDecimal)MoreObjects.firstNonNull((Object)((BigDecimal)attributeFN.apply((MeasurementAmountPriceWage)amountPriceWage)), (Object)BigDecimal.ZERO);
            BigDecimal valueWithDiscount = DataAggregationService.discount((BigDecimal)valueWithoutDiscount, (BigDecimal)discount);
            return valueWithDiscount;
        }).reduce(BigDecimal.ZERO, BigDecimal::add);
    }

    @Nonnull
    private static BigDecimal discount(BigDecimal valueWithoutDiscount, BigDecimal discount) {
        BigDecimal factor = BigDecimal.ONE.subtract(discount.divide(BigDecimal.valueOf(100L), 4, RoundingMode.HALF_UP));
        return valueWithoutDiscount.multiply(factor).setScale(2, RoundingMode.HALF_UP);
    }

    @Nonnull
    private BigDecimal apply(@NonNull Multimap<String, BigDecimal> values, @NonNull Consumer<BigDecimal> sumConsumer) {
        if (values == null) {
            throw new NullPointerException("values is marked non-null but is null");
        }
        if (sumConsumer == null) {
            throw new NullPointerException("sumConsumer is marked non-null but is null");
        }
        BigDecimal sum = values.values().stream().filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add);
        sumConsumer.accept(sum);
        return sum;
    }

    @Nonnull
    private BigDecimal apply(@NonNull Iterable<StageAmountPriceWage> amountPriceWages, @NonNull Function<StageAmountPriceWage, BigDecimal> fn, @NonNull Consumer<BigDecimal> sumConsumer) {
        if (amountPriceWages == null) {
            throw new NullPointerException("amountPriceWages is marked non-null but is null");
        }
        if (fn == null) {
            throw new NullPointerException("fn is marked non-null but is null");
        }
        if (sumConsumer == null) {
            throw new NullPointerException("sumConsumer is marked non-null but is null");
        }
        BigDecimal sum = IterableHelper.stream(amountPriceWages).map(fn).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add);
        sumConsumer.accept(sum);
        return sum;
    }

    @Nonnull
    private static BigDecimal fulfilmentDegree(@NonNull BigDecimal quotationAmount, @NonNull BigDecimal measurementAmountReference) {
        if (quotationAmount == null) {
            throw new NullPointerException("quotationAmount is marked non-null but is null");
        }
        if (measurementAmountReference == null) {
            throw new NullPointerException("measurementAmountReference is marked non-null but is null");
        }
        return BigDecimal.valueOf(100L).multiply(BigDecimalHelper.anyZero((BigDecimal[])new BigDecimal[]{measurementAmountReference, quotationAmount}) ? BigDecimal.ZERO : measurementAmountReference.divide(quotationAmount, 5, RoundingMode.HALF_UP)).setScale(2, RoundingMode.HALF_UP);
    }

    @Nonnull
    private static BigDecimal valueInMeasurement(@NonNull BigDecimal pricePerUnit, @NonNull BigDecimal measurementAmountReference) {
        if (pricePerUnit == null) {
            throw new NullPointerException("pricePerUnit is marked non-null but is null");
        }
        if (measurementAmountReference == null) {
            throw new NullPointerException("measurementAmountReference is marked non-null but is null");
        }
        return BigDecimalHelper.anyZero((BigDecimal[])new BigDecimal[]{measurementAmountReference, pricePerUnit}) ? BigDecimal.ZERO : measurementAmountReference.multiply(pricePerUnit).setScale(2, RoundingMode.HALF_UP);
    }

    public DataAggregationService(MeasurementHandler measurementHandler, UserHandler userHandler, StageHandler stageHandler) {
        this.measurementHandler = measurementHandler;
        this.userHandler = userHandler;
        this.stageHandler = stageHandler;
    }

    private /* synthetic */ void lambda$stageFulfilmentDegree$7(Map stageAmountPriceWageMap, Multimap measurementAmountPriceWageMap, Multimap stageOrderedAmounts, Multimap stageCompanyWagesAll, Multimap stageSquadWagesAll, Multimap stageMaterialSellingPriceAll, Multimap stageExternalServiceSellingPriceAll, Multimap totalMeasurementAmounts, Multimap notAccountedMeasurementAmounts, Multimap accountedMeasurementAmounts, Map addendumDiscountByKey, Multimap totalMeasurementValue, Multimap notAccountedMeasurementValue, Multimap accountedMeasurementValue, Multimap totalMeasurementSquadWageValue, Multimap notAccountedMeasurementSquadWageValue, Multimap accountedMeasurementSquadWageValue, Multimap totalMeasurementCompanyWageValue, Multimap notAccountedMeasurementCompanyWageValue, Multimap accountedMeasurementCompanyWageValue, Multimap totalMeasurementMaterialSellingPriceValue, Multimap notAccountedMeasurementMaterialSellingPriceValue, Multimap accountedMeasurementMaterialSellingPriceValue, Multimap totalMeasurementExternalServiceSellingPriceValue, Multimap notAccountedMeasurementExternalServiceSellingPriceValue, Multimap accountedMeasurementExternalServiceSellingPriceValue, Map positionByKey, ImmutableList.Builder positionCommonsBuilder, boolean filterPositions, String key) {
        EAlternativePositionType alternativePositionType;
        StageAmountPriceWage stagePosition;
        boolean positionIsPresent = stageAmountPriceWageMap.containsKey(key);
        boolean measurementPositionIsPresent = measurementAmountPriceWageMap.containsKey((Object)key);
        if (positionIsPresent) {
            StageAmountPriceWage stageAmountPriceWage = (StageAmountPriceWage)stageAmountPriceWageMap.get(key);
            BigDecimal orderedAmount = (BigDecimal)MoreObjects.firstNonNull((Object)stageAmountPriceWage.getOrderedAmount(), (Object)BigDecimal.ZERO);
            stageOrderedAmounts.put((Object)key, (Object)orderedAmount);
            BigDecimal companyWageAggregated = (BigDecimal)MoreObjects.firstNonNull((Object)stageAmountPriceWage.getCompanyWageAggregated(), (Object)BigDecimal.ZERO);
            stageCompanyWagesAll.put((Object)key, (Object)companyWageAggregated);
            BigDecimal squadWageAggregated = (BigDecimal)MoreObjects.firstNonNull((Object)stageAmountPriceWage.getSquadWageAggregated(), (Object)BigDecimal.ZERO);
            stageSquadWagesAll.put((Object)key, (Object)squadWageAggregated);
            BigDecimal materialSellingPriceAggregated = (BigDecimal)MoreObjects.firstNonNull((Object)stageAmountPriceWage.getMaterialSellingPriceAggregated(), (Object)BigDecimal.ZERO);
            stageMaterialSellingPriceAll.put((Object)key, (Object)materialSellingPriceAggregated);
            BigDecimal externalServiceSellingPriceAggregated = (BigDecimal)MoreObjects.firstNonNull((Object)stageAmountPriceWage.getExternalServiceSellingPriceAggregated(), (Object)BigDecimal.ZERO);
            stageExternalServiceSellingPriceAll.put((Object)key, (Object)externalServiceSellingPriceAggregated);
        }
        if (measurementPositionIsPresent) {
            Collection measurementAmountPriceWagesForSPN = measurementAmountPriceWageMap.get((Object)key);
            BigDecimal productsAllSum = this.sum((Iterable)measurementAmountPriceWagesForSPN, EMeasurementState.ALL_RELEVANT_FOR_FULFILMENT_DEGREE, MeasurementAmountPriceWage::getProduct, (Map)ImmutableMap.of());
            totalMeasurementAmounts.put((Object)key, (Object)productsAllSum);
            BigDecimal productNotAccountedSum = this.sum((Iterable)measurementAmountPriceWagesForSPN, EMeasurementState.NOT_ACCOUNTED_STATES, MeasurementAmountPriceWage::getProduct, (Map)ImmutableMap.of());
            notAccountedMeasurementAmounts.put((Object)key, (Object)productNotAccountedSum);
            BigDecimal productAccountedSum = this.sum((Iterable)measurementAmountPriceWagesForSPN, EMeasurementState.ACCOUNTED_STATES, MeasurementAmountPriceWage::getProduct, (Map)ImmutableMap.of());
            accountedMeasurementAmounts.put((Object)key, (Object)productAccountedSum);
            BigDecimal priceAllSum = this.sum((Iterable)measurementAmountPriceWagesForSPN, EMeasurementState.ALL_RELEVANT_FOR_FULFILMENT_DEGREE, MeasurementAmountPriceWage::getPrice, addendumDiscountByKey);
            totalMeasurementValue.put((Object)key, (Object)priceAllSum);
            BigDecimal priceNotAccountedSum = this.sum((Iterable)measurementAmountPriceWagesForSPN, EMeasurementState.NOT_ACCOUNTED_STATES, MeasurementAmountPriceWage::getPrice, addendumDiscountByKey);
            notAccountedMeasurementValue.put((Object)key, (Object)priceNotAccountedSum);
            BigDecimal priceAccountedSum = this.sum((Iterable)measurementAmountPriceWagesForSPN, EMeasurementState.ACCOUNTED_STATES, MeasurementAmountPriceWage::getPrice, addendumDiscountByKey);
            accountedMeasurementValue.put((Object)key, (Object)priceAccountedSum);
            BigDecimal squadWageAllSum = this.sum((Iterable)measurementAmountPriceWagesForSPN, EMeasurementState.ALL_RELEVANT_FOR_FULFILMENT_DEGREE, MeasurementAmountPriceWage::getSquadWageAggregated, (Map)ImmutableMap.of());
            totalMeasurementSquadWageValue.put((Object)key, (Object)squadWageAllSum);
            BigDecimal wageNotAccountedSum = this.sum((Iterable)measurementAmountPriceWagesForSPN, EMeasurementState.NOT_ACCOUNTED_STATES, MeasurementAmountPriceWage::getSquadWageAggregated, (Map)ImmutableMap.of());
            notAccountedMeasurementSquadWageValue.put((Object)key, (Object)wageNotAccountedSum);
            BigDecimal wageAccountedSum = this.sum((Iterable)measurementAmountPriceWagesForSPN, EMeasurementState.ACCOUNTED_STATES, MeasurementAmountPriceWage::getSquadWageAggregated, (Map)ImmutableMap.of());
            accountedMeasurementSquadWageValue.put((Object)key, (Object)wageAccountedSum);
            BigDecimal companyWageAllSum = this.sum((Iterable)measurementAmountPriceWagesForSPN, EMeasurementState.ALL_RELEVANT_FOR_FULFILMENT_DEGREE, MeasurementAmountPriceWage::getCompanyWageAggregated, addendumDiscountByKey);
            totalMeasurementCompanyWageValue.put((Object)key, (Object)companyWageAllSum);
            BigDecimal companyWageNotAccountedSum = this.sum((Iterable)measurementAmountPriceWagesForSPN, EMeasurementState.NOT_ACCOUNTED_STATES, MeasurementAmountPriceWage::getCompanyWageAggregated, addendumDiscountByKey);
            notAccountedMeasurementCompanyWageValue.put((Object)key, (Object)companyWageNotAccountedSum);
            BigDecimal companyWageAccountedSum = this.sum((Iterable)measurementAmountPriceWagesForSPN, EMeasurementState.ACCOUNTED_STATES, MeasurementAmountPriceWage::getCompanyWageAggregated, addendumDiscountByKey);
            accountedMeasurementCompanyWageValue.put((Object)key, (Object)companyWageAccountedSum);
            BigDecimal materialSellingPriceAllSum = this.sum((Iterable)measurementAmountPriceWagesForSPN, EMeasurementState.ALL_RELEVANT_FOR_FULFILMENT_DEGREE, MeasurementAmountPriceWage::getMaterialSellingPriceAggregated, addendumDiscountByKey);
            totalMeasurementMaterialSellingPriceValue.put((Object)key, (Object)materialSellingPriceAllSum);
            BigDecimal materialSellingPriceNotAccountedSum = this.sum((Iterable)measurementAmountPriceWagesForSPN, EMeasurementState.NOT_ACCOUNTED_STATES, MeasurementAmountPriceWage::getMaterialSellingPriceAggregated, addendumDiscountByKey);
            notAccountedMeasurementMaterialSellingPriceValue.put((Object)key, (Object)materialSellingPriceNotAccountedSum);
            BigDecimal materialSellingPriceAccountedSum = this.sum((Iterable)measurementAmountPriceWagesForSPN, EMeasurementState.ACCOUNTED_STATES, MeasurementAmountPriceWage::getMaterialSellingPriceAggregated, addendumDiscountByKey);
            accountedMeasurementMaterialSellingPriceValue.put((Object)key, (Object)materialSellingPriceAccountedSum);
            BigDecimal externalServiceSellingPriceSum = this.sum((Iterable)measurementAmountPriceWagesForSPN, EMeasurementState.ALL_RELEVANT_FOR_FULFILMENT_DEGREE, MeasurementAmountPriceWage::getExternalServiceSellingPriceAggregated, addendumDiscountByKey);
            totalMeasurementExternalServiceSellingPriceValue.put((Object)key, (Object)externalServiceSellingPriceSum);
            BigDecimal externalServiceSellingPriceNotAccountedSum = this.sum((Iterable)measurementAmountPriceWagesForSPN, EMeasurementState.NOT_ACCOUNTED_STATES, MeasurementAmountPriceWage::getExternalServiceSellingPriceAggregated, addendumDiscountByKey);
            notAccountedMeasurementExternalServiceSellingPriceValue.put((Object)key, (Object)externalServiceSellingPriceNotAccountedSum);
            BigDecimal externalServiceSellingPriceAccountedSum = this.sum((Iterable)measurementAmountPriceWagesForSPN, EMeasurementState.ACCOUNTED_STATES, MeasurementAmountPriceWage::getExternalServiceSellingPriceAggregated, addendumDiscountByKey);
            accountedMeasurementExternalServiceSellingPriceValue.put((Object)key, (Object)externalServiceSellingPriceAccountedSum);
        }
        Long stageId = null != (stagePosition = (StageAmountPriceWage)positionByKey.get(key)) ? (Long)MoreObjects.firstNonNull((Object)stagePosition.getStageId(), (Object)-1L) : Long.valueOf(-1L);
        String stageNumber = null != stagePosition ? (String)StringUtils.defaultIfBlank((CharSequence)stagePosition.getStageNumber(), (CharSequence)"n/a") : "n/a";
        String stageAlias = null != stagePosition ? (String)StringUtils.defaultIfBlank((CharSequence)stagePosition.getStageAlias(), (CharSequence)"n/a") : "n/a";
        Integer stageVersion = null != stagePosition ? stagePosition.getStageVersion() : null;
        String stageText = null != stagePosition ? StageHelper.stageText((StageAmountPriceWage)stagePosition) : "n/a";
        Long addendumNumber = null != stagePosition ? (Long)MoreObjects.firstNonNull((Object)stagePosition.getAddendumNumber(), (Object)0L) : Long.valueOf(-1L);
        Long entityId = null != stagePosition ? (Long)MoreObjects.firstNonNull((Object)stagePosition.getEntityId(), (Object)-1L) : Long.valueOf(-1L);
        String entityNumber = null != stagePosition ? (String)StringUtils.defaultIfBlank((CharSequence)stagePosition.getEntityNumber(), (CharSequence)"n/a") : "n/a";
        String entityAlias = null != stagePosition ? (String)StringUtils.defaultIfBlank((CharSequence)stagePosition.getEntityAlias(), (CharSequence)"n/a") : "n/a";
        Long projectId = null != stagePosition ? (Long)MoreObjects.firstNonNull((Object)stagePosition.getProjectId(), (Object)-1L) : Long.valueOf(-1L);
        String projectName = null != stagePosition ? (String)StringUtils.defaultIfBlank((CharSequence)stagePosition.getProjectName(), (CharSequence)"n/a") : "n/a";
        String projectReferenceId = null != stagePosition ? (String)StringUtils.defaultIfBlank((CharSequence)stagePosition.getProjectReferenceId(), (CharSequence)"n/a") : "n/a";
        Long subProjectId = null != stagePosition ? (Long)MoreObjects.firstNonNull((Object)stagePosition.getSubProjectId(), (Object)-1L) : Long.valueOf(-1L);
        String subProjectName = null != stagePosition ? (String)StringUtils.defaultIfBlank((CharSequence)stagePosition.getSubProjectName(), (CharSequence)"n/a") : "n/a";
        Long stagePositionId = null != stagePosition ? (Long)MoreObjects.firstNonNull((Object)stagePosition.getPositionId(), (Object)-1L) : Long.valueOf(-1L);
        BigDecimal orderedAmountFallback = null != stagePosition ? (BigDecimal)MoreObjects.firstNonNull((Object)stagePosition.getOrderedAmount(), (Object)BigDecimal.ZERO) : BigDecimal.ZERO;
        String positionNumber = null != stagePosition ? StringUtils.trimToEmpty((String)stagePosition.getPositionNumber()) : "";
        Integer subPositionNumber = null != stagePosition ? stagePosition.getSubPositionNumber() : null;
        String surrogatePositionNumber = null != stagePosition ? StringUtils.trimToEmpty((String)stagePosition.getSurrogatePositionNumber()) : "";
        String shortText = null != stagePosition ? StringUtils.trimToEmpty((String)stagePosition.getShortText()) : "";
        String longText = null != stagePosition ? StringUtils.trimToEmpty((String)stagePosition.getLongText()) : "";
        BigDecimal pricePerUnit = null != stagePosition ? (BigDecimal)MoreObjects.firstNonNull((Object)stagePosition.getPricePerUnit(), (Object)BigDecimal.ZERO) : BigDecimal.ZERO;
        BigDecimal price = null != stagePosition ? (BigDecimal)MoreObjects.firstNonNull((Object)stagePosition.getPrice(), (Object)BigDecimal.ZERO) : BigDecimal.ZERO;
        String unit = null != stagePosition ? StringUtils.trimToEmpty((String)stagePosition.getUnit()) : "";
        EAlternativePositionType eAlternativePositionType = alternativePositionType = null != stagePosition ? (EAlternativePositionType)MoreObjects.firstNonNull((Object)stagePosition.getAlternativePositionType(), (Object)EAlternativePositionType.UNKNOWN) : EAlternativePositionType.UNKNOWN;
        if (positionIsPresent && measurementPositionIsPresent) {
            BigDecimal stageOrderedAmount = stageOrderedAmounts.get((Object)key).stream().reduce(BigDecimal.ZERO, BigDecimal::add);
            BigDecimal measurementAmountAll = totalMeasurementAmounts.get((Object)key).stream().reduce(BigDecimal.ZERO, BigDecimal::add);
            BigDecimal measurementAmountNotAccounted = notAccountedMeasurementAmounts.get((Object)key).stream().reduce(BigDecimal.ZERO, BigDecimal::add);
            BigDecimal measurementAmountAccounted = accountedMeasurementAmounts.get((Object)key).stream().reduce(BigDecimal.ZERO, BigDecimal::add);
            BigDecimal fulfilmentDegreeAll = DataAggregationService.fulfilmentDegree((BigDecimal)stageOrderedAmount, (BigDecimal)measurementAmountAll);
            BigDecimal fulfilmentDegreeMeasurementNotAccounted = DataAggregationService.fulfilmentDegree((BigDecimal)stageOrderedAmount, (BigDecimal)measurementAmountNotAccounted);
            BigDecimal fulfilmentDegreeMeasurementAccounted = DataAggregationService.fulfilmentDegree((BigDecimal)stageOrderedAmount, (BigDecimal)measurementAmountAccounted);
            BigDecimal valueInMeasurementAll = DataAggregationService.valueInMeasurement((BigDecimal)pricePerUnit, (BigDecimal)measurementAmountAll);
            BigDecimal valueInMeasurementNotAccounted = DataAggregationService.valueInMeasurement((BigDecimal)pricePerUnit, (BigDecimal)measurementAmountNotAccounted);
            BigDecimal valueInMeasurementAccounted = DataAggregationService.valueInMeasurement((BigDecimal)pricePerUnit, (BigDecimal)measurementAmountAccounted);
            positionCommonsBuilder.add((Object)StageFulfilmentDegreePositionCommon.of((Long)stageId, (String)stageNumber, (String)stageAlias, (Integer)stageVersion, (String)stageText, (Long)entityId, (String)entityNumber, (String)entityAlias, (Long)stagePositionId, (Long)addendumNumber, (Long)projectId, (String)projectName, (String)projectReferenceId, (Long)subProjectId, (String)subProjectName, (String)positionNumber, (Integer)subPositionNumber, (String)alternativePositionType.name(), (String)surrogatePositionNumber, (String)shortText, (String)longText, (BigDecimal)stageOrderedAmount, (String)unit, (BigDecimal)pricePerUnit, (BigDecimal)price, (BigDecimal)measurementAmountAll, (BigDecimal)fulfilmentDegreeAll, (BigDecimal)valueInMeasurementAll, (BigDecimal)measurementAmountNotAccounted, (BigDecimal)fulfilmentDegreeMeasurementNotAccounted, (BigDecimal)valueInMeasurementNotAccounted, (BigDecimal)measurementAmountAccounted, (BigDecimal)fulfilmentDegreeMeasurementAccounted, (BigDecimal)valueInMeasurementAccounted));
        } else if (!filterPositions && measurementPositionIsPresent) {
            BigDecimal stageOrderedAmount = stageOrderedAmounts.get((Object)key).stream().reduce(BigDecimal.ZERO, BigDecimal::add);
            BigDecimal measurementAmountAll = totalMeasurementAmounts.get((Object)key).stream().reduce(BigDecimal.ZERO, BigDecimal::add);
            BigDecimal measurementAmountNotAccounted = notAccountedMeasurementAmounts.get((Object)key).stream().reduce(BigDecimal.ZERO, BigDecimal::add);
            BigDecimal measurementAmountAccounted = accountedMeasurementAmounts.get((Object)key).stream().reduce(BigDecimal.ZERO, BigDecimal::add);
            BigDecimal valueInMeasurementAll = DataAggregationService.valueInMeasurement((BigDecimal)pricePerUnit, (BigDecimal)measurementAmountAll);
            BigDecimal valueInMeasurementNotAccounted = DataAggregationService.valueInMeasurement((BigDecimal)pricePerUnit, (BigDecimal)measurementAmountNotAccounted);
            BigDecimal valueInMeasurementAccounted = DataAggregationService.valueInMeasurement((BigDecimal)pricePerUnit, (BigDecimal)measurementAmountAccounted);
            positionCommonsBuilder.add((Object)StageFulfilmentDegreePositionCommon.of((Long)stageId, (String)stageNumber, (String)stageAlias, (Integer)stageVersion, (String)stageText, (Long)entityId, (String)entityNumber, (String)entityAlias, (Long)stagePositionId, (Long)addendumNumber, (Long)projectId, (String)projectName, (String)projectReferenceId, (Long)subProjectId, (String)subProjectName, (String)positionNumber, (Integer)subPositionNumber, (String)alternativePositionType.name(), (String)surrogatePositionNumber, (String)shortText, (String)longText, (BigDecimal)stageOrderedAmount, (String)unit, (BigDecimal)pricePerUnit, (BigDecimal)price, (BigDecimal)measurementAmountAll, (BigDecimal)BigDecimal.ZERO, (BigDecimal)valueInMeasurementAll, (BigDecimal)measurementAmountNotAccounted, (BigDecimal)BigDecimal.ZERO, (BigDecimal)valueInMeasurementNotAccounted, (BigDecimal)measurementAmountAccounted, (BigDecimal)BigDecimal.ZERO, (BigDecimal)valueInMeasurementAccounted));
        } else {
            positionCommonsBuilder.add((Object)StageFulfilmentDegreePositionCommon.zero((Long)stageId, (String)stageNumber, (String)stageAlias, (Integer)stageVersion, (String)stageText, (Long)entityId, (String)entityNumber, (String)entityAlias, (Long)stagePositionId, (Long)addendumNumber, (Long)projectId, (String)projectName, (String)projectReferenceId, (Long)subProjectId, (String)subProjectName, (String)positionNumber, (Integer)subPositionNumber, (String)alternativePositionType.name(), (String)surrogatePositionNumber, (String)shortText, (String)longText, (BigDecimal)orderedAmountFallback, (String)unit, (BigDecimal)pricePerUnit, (BigDecimal)price));
        }
    }
}

