/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.service.service;

import com.google.common.base.MoreObjects;
import com.google.common.base.Stopwatch;
import com.google.common.cache.Cache;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import com.google.common.collect.Range;
import de.leancoders.common.helper.DateTimeHelper;
import de.qfm.erp.service.configuration.CacheNames;
import de.qfm.erp.service.helper.comparator.BusinessUnitComparator;
import de.qfm.erp.service.model.internal.businessunit.BusinessUnitTree;
import de.qfm.erp.service.model.jpa.businessunit.BusinessUnit;
import de.qfm.erp.service.model.jpa.user.User;
import de.qfm.erp.service.service.handler.BusinessUnitHandler;
import de.qfm.erp.service.service.service.BusinessUnitService;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.StreamSupport;
import javax.annotation.Nonnull;
import lombok.NonNull;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class CachingBusinessUnitServiceImpl
implements BusinessUnitService,
CacheNames {
    private static final Logger log = LogManager.getLogger(CachingBusinessUnitServiceImpl.class);
    public static final BusinessUnitTree EMPTY = BusinessUnitTree.of((int)0, (BusinessUnit)new BusinessUnit(), (List)ImmutableList.of(), (List)ImmutableList.of());
    private final BusinessUnitHandler businessUnitHandler;
    private final Cache<String, BusinessUnitTree> businessUnitTreeCache;

    @Autowired
    public CachingBusinessUnitServiceImpl(BusinessUnitHandler businessUnitHandler, @Qualifier(value="business_unit_tree_cache") Cache<String, BusinessUnitTree> businessUnitTreeCache) {
        this.businessUnitHandler = businessUnitHandler;
        this.businessUnitTreeCache = businessUnitTreeCache;
    }

    @Nonnull
    public BusinessUnitTree root() {
        BusinessUnit root = this.businessUnitHandler.root();
        return this.tree(root.getId().longValue(), 5);
    }

    @Nonnull
    public Multimap<Long, Long> businessUnitUsers(boolean cascade) {
        ImmutableMultimap.Builder multiMap = ImmutableMultimap.builder();
        BusinessUnitTree root = this.root();
        multiMap.putAll(this.businessUnitUsers(root, cascade));
        return multiMap.build();
    }

    @Nonnull
    private Multimap<Long, Long> businessUnitUsers(@NonNull BusinessUnitTree businessUnitTree, boolean cascade) {
        if (businessUnitTree == null) {
            throw new NullPointerException("businessUnitTree is marked non-null but is null");
        }
        ImmutableMultimap.Builder multiMap = ImmutableMultimap.builder();
        ImmutableSet.Builder allUsersIdsInThisBUBuilder = ImmutableSet.builder();
        List users = businessUnitTree.getUsers();
        Iterable userIdsInThisBU = (Iterable)users.stream().map(Pair::getLeft).map(User::getId).collect(ImmutableSet.toImmutableSet());
        allUsersIdsInThisBUBuilder.addAll(userIdsInThisBU);
        List children = businessUnitTree.getChildren();
        for (BusinessUnitTree child : children) {
            Multimap childrenBusinessUnitUsers = this.businessUnitUsers(child, cascade);
            if (cascade) {
                allUsersIdsInThisBUBuilder.addAll((Iterable)childrenBusinessUnitUsers.values());
            }
            multiMap.putAll(childrenBusinessUnitUsers);
        }
        BusinessUnit businessUnit = businessUnitTree.getBusinessUnit();
        Long currentBusinessUnitId = businessUnit.getId();
        ImmutableSet allUsersIdsInThisBU = allUsersIdsInThisBUBuilder.build();
        multiMap.putAll((Object)currentBusinessUnitId, (Iterable)allUsersIdsInThisBU);
        return multiMap.build();
    }

    @Nonnull
    public BusinessUnitTree tree(long id, int maxLevels) {
        Optional businessUnitCandidate;
        String key = String.format("%s_%s", id, maxLevels);
        BusinessUnitTree cacheEntryPresent = (BusinessUnitTree)this.businessUnitTreeCache.getIfPresent((Object)key);
        if (null == cacheEntryPresent && (businessUnitCandidate = this.businessUnitHandler.byIdNotFailing(Long.valueOf(id))).isPresent()) {
            log.info("Refreshing Business Units Tree Cache");
            Stopwatch stopwatch = Stopwatch.createStarted();
            BusinessUnitTree businessUnitTree = this.tree((BusinessUnit)businessUnitCandidate.get(), 0, maxLevels, true);
            this.businessUnitTreeCache.put((Object)key, (Object)businessUnitTree);
            log.info("Finished Business Units Tree Cache, took: {} ms", (Object)stopwatch.elapsed(TimeUnit.MILLISECONDS));
            return businessUnitTree;
        }
        return (BusinessUnitTree)MoreObjects.firstNonNull((Object)cacheEntryPresent, (Object)EMPTY);
    }

    @Nonnull
    private BusinessUnitTree tree(@NonNull BusinessUnit businessUnit, int level, int maxLevels, boolean includeUsers) {
        Object usersInBusinessUnit;
        if (businessUnit == null) {
            throw new NullPointerException("businessUnit is marked non-null but is null");
        }
        Object object = usersInBusinessUnit = includeUsers ? CachingBusinessUnitServiceImpl.usersInBusinessUnit((BusinessUnit)businessUnit) : ImmutableList.of();
        if (maxLevels > 0) {
            Set children = businessUnit.getChildren();
            List childrenTree = (List)StreamSupport.stream(children.spliterator(), false).map(child -> this.tree(child, level + 1, maxLevels - 1, includeUsers)).sorted((Comparator<BusinessUnitTree>)BusinessUnitComparator.BUSINESS_UNIT_COMPARATOR).collect(ImmutableList.toImmutableList());
            return BusinessUnitTree.of((int)level, (BusinessUnit)businessUnit, (List)childrenTree, (List)usersInBusinessUnit);
        }
        return BusinessUnitTree.of((int)level, (BusinessUnit)businessUnit, (List)ImmutableList.of(), (List)usersInBusinessUnit);
    }

    @Nonnull
    private static List<Pair<User, Boolean>> usersInBusinessUnit(@NonNull BusinessUnit businessUnit) {
        if (businessUnit == null) {
            throw new NullPointerException("businessUnit is marked non-null but is null");
        }
        Set userBusinessUnits = (Set)MoreObjects.firstNonNull((Object)businessUnit.getUserBusinessUnits(), (Object)ImmutableSet.of());
        return (List)userBusinessUnits.stream().filter(item -> Range.closed((Comparable)item.getValidBegin(), (Comparable)item.getValidEnd()).contains((Comparable)DateTimeHelper.today())).filter(item -> item.getUser() != null && item.getBusinessUnit() != null).map(item -> Pair.of((Object)item.getUser(), (Object)item.getFlagLead())).collect(ImmutableList.toImmutableList());
    }
}

