/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.service.security.impl;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import de.qfm.erp.service.configuration.ApplicationConfig;
import de.qfm.erp.service.model.exception.request.IllegalValueException;
import de.qfm.erp.service.service.security.AuthenticationHelper;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.List;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import lombok.NonNull;
import org.springframework.security.authentication.AnonymousAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.core.userdetails.User;
import org.springframework.stereotype.Service;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public final class AuthenticationHelperImpl
implements AuthenticationHelper {
    private static final Pattern BASE64 = Pattern.compile("^([A-Za-z0-9+/]{4})*([A-Za-z0-9+/]{3}=|[A-Za-z0-9+/]{2}==)?$");
    private final ApplicationConfig applicationConfig;

    @Nonnull
    public User currentUser() {
        Object principal;
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        if (!(authentication instanceof AnonymousAuthenticationToken) && (principal = authentication.getPrincipal()) instanceof User) {
            return (User)principal;
        }
        throw new IllegalStateException("Not logged in");
    }

    @Nonnull
    public String currentUserName() {
        return this.currentUser().getUsername();
    }

    public boolean canBeDecoded(@NonNull String password) {
        if (password == null) {
            throw new NullPointerException("password is marked non-null but is null");
        }
        if (this.applicationConfig.isSecurityAuthPasswordEncodingEnabled() && !BASE64.asPredicate().test(password)) {
            throw new IllegalValueException(String.format("Password '%s' is not of BASE64", password), (List)ImmutableList.of());
        }
        return true;
    }

    @Nonnull
    @VisibleForTesting
    public String decodePassword(@NonNull String password) {
        if (password == null) {
            throw new NullPointerException("password is marked non-null but is null");
        }
        if (this.applicationConfig.isSecurityAuthPasswordEncodingEnabled() && this.canBeDecoded(password)) {
            return AuthenticationHelperImpl.decodeBase64((String)password);
        }
        return password;
    }

    @Nonnull
    @VisibleForTesting
    static String decodeBase64(@NonNull String password) {
        if (password == null) {
            throw new NullPointerException("password is marked non-null but is null");
        }
        return new String(Base64.getDecoder().decode(password), StandardCharsets.ISO_8859_1);
    }

    public AuthenticationHelperImpl(ApplicationConfig applicationConfig) {
        this.applicationConfig = applicationConfig;
    }
}

