/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.service.route.impl;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Streams;
import de.qfm.erp.common.request.measurement.MeasurementPositionsStandardToTransposeRequest;
import de.qfm.erp.common.request.measurement.MeasurementPositionsTransposeToStandardRequest;
import de.qfm.erp.common.response.measurement.MeasurementPositionsTransposedCommon;
import de.qfm.erp.common.response.measurement.MeasurementPositionsUntransposedResponse;
import de.qfm.erp.common.response.measurement.MeasurementTransposedRemarkCommon;
import de.qfm.erp.service.helper.TranspositionHelper;
import de.qfm.erp.service.model.internal.transposition.MeasurementPositionTransposedToStandard;
import de.qfm.erp.service.model.internal.transposition.MeasurementPositionsTransposed;
import de.qfm.erp.service.service.mapper.TranspositionMapper;
import de.qfm.erp.service.service.route.TranspositionRoute;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import lombok.NonNull;
import org.apache.commons.compress.utils.Lists;
import org.apache.commons.lang3.tuple.Pair;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class TranspositionRouteImpl
implements TranspositionRoute {
    private final TranspositionMapper transpositionMapper;

    @Transactional(readOnly=true)
    @Nonnull
    public MeasurementPositionsTransposedCommon transpose(@NonNull MeasurementPositionsStandardToTransposeRequest measurementPositionsStandardToTransposeRequest) {
        if (measurementPositionsStandardToTransposeRequest == null) {
            throw new NullPointerException("measurementPositionsStandardToTransposeRequest is marked non-null but is null");
        }
        Pair measurementTransposeInput = this.transpositionMapper.mapToIntern(measurementPositionsStandardToTransposeRequest);
        MeasurementPositionsTransposed measurementPositionsTransposed = TranspositionHelper.transpose((Pair)measurementTransposeInput);
        return this.transpositionMapper.map(measurementPositionsTransposed);
    }

    @Nonnull
    public MeasurementPositionsUntransposedResponse transposeAndUngroup(@NonNull MeasurementPositionsTransposeToStandardRequest measurementPositionsTransposeToStandardRequest) {
        if (measurementPositionsTransposeToStandardRequest == null) {
            throw new NullPointerException("measurementPositionsTransposeToStandardRequest is marked non-null but is null");
        }
        MeasurementPositionsTransposedCommon measurementPositionsTransposedInput = measurementPositionsTransposeToStandardRequest.getMeasurementPositionsTransposed();
        List measurementTransposedRemarks = (List)MoreObjects.firstNonNull((Object)measurementPositionsTransposedInput.getTransposedRemarks(), (Object)ImmutableList.of());
        MeasurementPositionsTransposed measurementPositionsTransposed = this.transpositionMapper.map(measurementPositionsTransposedInput, (Iterable)measurementTransposedRemarks);
        Pair untransposeResult = TranspositionHelper.unTranspose((MeasurementPositionsTransposed)measurementPositionsTransposed);
        Iterable missingRemarks = (Iterable)untransposeResult.getLeft();
        Iterable standardPositions = (Iterable)untransposeResult.getRight();
        ImmutableList.Builder measurementPositionCommonBuilder = ImmutableList.builder();
        for (Object measurementPositionTransposedToStandard : standardPositions) {
            measurementPositionCommonBuilder.add((Object)this.transpositionMapper.map((MeasurementPositionTransposedToStandard)measurementPositionTransposedToStandard));
        }
        ArrayList missingTransposedRemarks = Lists.newArrayList();
        for (MeasurementPositionsTransposedCommon.Row row : measurementPositionsTransposedInput.getRows()) {
            String remark = row.getRemarks();
            Integer sequentialNumber = row.getSequentialNumber();
            if (!Iterables.contains((Iterable)missingRemarks, (Object)remark)) continue;
            missingTransposedRemarks.add(MeasurementTransposedRemarkCommon.of((String)remark, (Integer)sequentialNumber));
        }
        List allTransposedRemarks = (List)Streams.concat((Stream[])new Stream[]{measurementTransposedRemarks.stream(), missingTransposedRemarks.stream()}).sorted(Comparator.comparing(MeasurementTransposedRemarkCommon::getRowIndex)).distinct().collect(ImmutableList.toImmutableList());
        ImmutableList measurementPositionsUntransposedCommons = measurementPositionCommonBuilder.build();
        return MeasurementPositionsUntransposedResponse.of((List)measurementPositionsUntransposedCommons, (List)allTransposedRemarks);
    }

    public TranspositionRouteImpl(TranspositionMapper transpositionMapper) {
        this.transpositionMapper = transpositionMapper;
    }
}

