/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.service.route.impl;

import com.google.common.collect.ImmutableList;
import de.qfm.erp.common.request.tracking.TrackingPointPayloadItem;
import de.qfm.erp.common.request.tracking.TrackingPointUpdateRequest;
import de.qfm.erp.common.response.tracking.TrackingPointCommon;
import de.qfm.erp.service.model.internal.fieldname.EField;
import de.qfm.erp.service.model.internal.fieldname.FieldName;
import de.qfm.erp.service.model.internal.fieldname.FieldNamesFactory;
import de.qfm.erp.service.model.internal.tracking.TrackingPointBucket;
import de.qfm.erp.service.model.jpa.EntityBase;
import de.qfm.erp.service.model.jpa.tracking.ETrackingCategory;
import de.qfm.erp.service.model.jpa.tracking.TrackingPoint;
import de.qfm.erp.service.model.jpa.tracking.TrackingPointPayload;
import de.qfm.erp.service.service.handler.EntityFactory;
import de.qfm.erp.service.service.handler.TrackingPointHandler;
import de.qfm.erp.service.service.mapper.TrackingPointMapper;
import de.qfm.erp.service.service.route.TrackingPointRoute;
import de.qfm.erp.service.service.validator.Validator;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import lombok.NonNull;
import org.springframework.stereotype.Service;

@Service
public class TrackingPointRouteImpl
implements TrackingPointRoute {
    private final EntityFactory entityFactory;
    private final TrackingPointHandler handler;
    private final TrackingPointMapper mapper;

    @Nonnull
    public TrackingPointCommon getById(@NonNull Long id) {
        if (id == null) {
            throw new NullPointerException("id is marked non-null but is null");
        }
        return this.mapper.map((TrackingPoint)this.handler.byIdFailing(id));
    }

    @Nonnull
    public TrackingPointCommon createOrUpdate(@NonNull String categoryCandidate, @NonNull TrackingPointUpdateRequest request) {
        if (categoryCandidate == null) {
            throw new NullPointerException("categoryCandidate is marked non-null but is null");
        }
        if (request == null) {
            throw new NullPointerException("request is marked non-null but is null");
        }
        TrackingPointBucket bucket = this.bucket(categoryCandidate, request);
        TrackingPoint trackingPointToPersist = this.mapper.merge(bucket);
        TrackingPoint trackingPointPersisted = (TrackingPoint)this.handler.update((EntityBase)trackingPointToPersist);
        return this.mapper.map(trackingPointPersisted);
    }

    @Nonnull
    private TrackingPointBucket bucket(@NonNull String categoryCandidate, @NonNull TrackingPointUpdateRequest request) {
        if (categoryCandidate == null) {
            throw new NullPointerException("categoryCandidate is marked non-null but is null");
        }
        if (request == null) {
            throw new NullPointerException("request is marked non-null but is null");
        }
        Optional trackingCategory = ETrackingCategory.lookup((String)categoryCandidate);
        if (trackingCategory.isPresent()) {
            TrackingPoint trackingPoint = this.entityFactory.trackingPoint();
            List payloadInRequest = request.getPayload();
            Iterable payload = this.payload(payloadInRequest);
            return TrackingPointBucket.of((TrackingPoint)trackingPoint, (ETrackingCategory)((ETrackingCategory)trackingCategory.get()), (String)request.getKey(), (Iterable)payload);
        }
        throw Validator.throwEnumException((FieldName)FieldNamesFactory.simpleFieldName((EField)EField.TRACKING_CATEGORY), (String)categoryCandidate, ETrackingCategory.class, ETrackingCategory::allowedKeys);
    }

    @Nonnull
    private Iterable<TrackingPointPayload> payload(@NonNull List<TrackingPointPayloadItem> payloadInRequest) {
        if (payloadInRequest == null) {
            throw new NullPointerException("payloadInRequest is marked non-null but is null");
        }
        return (Iterable)payloadInRequest.stream().map(item -> this.mapper.merge(this.entityFactory.trackingPointPayload(), item)).collect(ImmutableList.toImmutableList());
    }

    public TrackingPointRouteImpl(EntityFactory entityFactory, TrackingPointHandler handler, TrackingPointMapper mapper) {
        this.entityFactory = entityFactory;
        this.handler = handler;
        this.mapper = mapper;
    }
}

