/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.service.route.impl;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimaps;
import com.google.common.collect.Sets;
import de.qfm.erp.common.response.quotation.StagePropagationCommon;
import de.qfm.erp.common.response.quotation.StagePropagationListCommon;
import de.qfm.erp.service.helper.MapsHelper;
import de.qfm.erp.service.model.internal.eventbus.QStageChangeMessage;
import de.qfm.erp.service.model.internal.quotation.EStagePositionMergeOption;
import de.qfm.erp.service.model.jpa.EntityBase;
import de.qfm.erp.service.model.jpa.queue.EProcessingState;
import de.qfm.erp.service.model.jpa.quotation.EQStageType;
import de.qfm.erp.service.model.jpa.quotation.EStagePropagationItemType;
import de.qfm.erp.service.model.jpa.quotation.Quotation;
import de.qfm.erp.service.model.jpa.quotation.QuotationPosition;
import de.qfm.erp.service.model.jpa.quotation.StagePropagation;
import de.qfm.erp.service.model.jpa.quotation.StagePropagationItem;
import de.qfm.erp.service.model.jpa.quotation.StageResponsibleUser;
import de.qfm.erp.service.model.jpa.shared.EPositionType;
import de.qfm.erp.service.model.jpa.user.User;
import de.qfm.erp.service.service.calculator.quotation.StageCalculators;
import de.qfm.erp.service.service.handler.EntityFactory;
import de.qfm.erp.service.service.handler.StageHandler;
import de.qfm.erp.service.service.handler.StagePositionHandler;
import de.qfm.erp.service.service.handler.StagePropagationHandler;
import de.qfm.erp.service.service.mapper.StagePositionMapper;
import de.qfm.erp.service.service.mapper.StagePropagationMapper;
import de.qfm.erp.service.service.route.StagePropagationRoute;
import de.qfm.erp.service.service.security.AuthenticationHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nonnull;
import lombok.NonNull;
import org.apache.commons.compress.utils.Lists;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class StagePropagationRouteImpl
implements StagePropagationRoute {
    private static final Logger log = LogManager.getLogger(StagePropagationRouteImpl.class);
    private final ApplicationEventPublisher applicationEventPublisher;
    private final EntityFactory entityFactory;
    private final StagePropagationHandler handler;
    private final StagePropagationMapper mapper;
    private final StageHandler stageHandler;
    private final StageCalculators stageCalculators;
    private final StagePositionMapper positionMapper;
    private final StagePositionHandler positionHandler;

    @Nonnull
    public StagePropagationCommon byId(@NonNull Long id) {
        if (id == null) {
            throw new NullPointerException("id is marked non-null but is null");
        }
        StagePropagation stagePropagation = (StagePropagation)this.handler.byIdFailing(id);
        return this.mapper.mapToCommon(stagePropagation);
    }

    @Nonnull
    public StagePropagationListCommon list(@NonNull Iterable<Long> filterStageIds, boolean showProcessed) {
        if (filterStageIds == null) {
            throw new NullPointerException("filterStageIds is marked non-null but is null");
        }
        Iterable unfinishedBatches = this.handler.unfinishedBatches(filterStageIds);
        Iterable batchesToUse = Iterables.isEmpty((Iterable)unfinishedBatches) ? this.handler.lastBatches(filterStageIds, 1) : unfinishedBatches;
        Object stagePropagations = !Iterables.isEmpty((Iterable)batchesToUse) || showProcessed ? this.handler.list(filterStageIds, batchesToUse, showProcessed) : ImmutableList.of();
        return this.mapper.mapToList((Iterable)stagePropagations);
    }

    @Nonnull
    @Transactional
    public StagePropagationCommon process(@NonNull Long id) {
        if (id == null) {
            throw new NullPointerException("id is marked non-null but is null");
        }
        StagePropagation stagePropagation = (StagePropagation)this.handler.byIdFailing(id);
        if (stagePropagation.getProcessingState() == EProcessingState.UNPROCESSED) {
            StagePropagation stagePropagationProcessed = this.process(stagePropagation);
            return this.mapper.mapToCommon(stagePropagationProcessed);
        }
        return this.mapper.mapToCommon(stagePropagation);
    }

    @Nonnull
    @Transactional
    public Optional<StagePropagationCommon> processNext() {
        Iterable stagePropagations = this.handler.nextUnprocessed();
        if (!Iterables.isEmpty((Iterable)stagePropagations)) {
            StagePropagation stagePropagation = (StagePropagation)stagePropagations.iterator().next();
            StagePropagation stagePropagationProcessed = this.process(stagePropagation);
            return Optional.of(this.mapper.mapToCommon(stagePropagationProcessed));
        }
        return Optional.empty();
    }

    @Nonnull
    private StagePropagation process(@NonNull StagePropagation stagePropagation) {
        if (stagePropagation == null) {
            throw new NullPointerException("stagePropagation is marked non-null but is null");
        }
        try {
            ImmutableSet mergeOptions;
            Quotation stageFrom = stagePropagation.getStageFrom();
            Quotation stageTo = stagePropagation.getStageTo();
            this.propagateHeadToChildren(stageFrom, stageTo);
            if (stageFrom.getQuotationPositions() == null) {
                stageFrom.setQuotationPositions((Set)Sets.newHashSet());
            }
            if (stageTo.getQuotationPositions() == null) {
                stageTo.setQuotationPositions((Set)Sets.newHashSet());
            }
            EQStageType stageTypeFrom = stageFrom.getStageType();
            EQStageType stageTypeTo = stageTo.getStageType();
            boolean propagateAmount = stageTypeFrom == EQStageType.COMMISSION__COST_ESTIMATE && stageTypeTo == EQStageType.COMMISSION__COST_UNIT__CE;
            ImmutableSet immutableSet = mergeOptions = propagateAmount ? ImmutableSet.of() : ImmutableSet.of((Object)EStagePositionMergeOption.EXCLUDE_AMOUNT);
            if (stageTypeFrom == EQStageType.COMMISSION__COST_ESTIMATE && stageTypeTo == EQStageType.COMMISSION__COST_UNIT__CE) {
                this.propagateHeadChangesToChildren(stageFrom, stageTo);
            }
            List stagePropagationItems = (List)MoreObjects.firstNonNull((Object)stagePropagation.getItems(), (Object)ImmutableList.of());
            ImmutableListMultimap positionPropagationItemByType = Multimaps.index((Iterable)stagePropagationItems, StagePropagationItem::getStagePropagationItemType);
            ImmutableSet positionsAdded = (ImmutableSet)positionPropagationItemByType.get((Object)EStagePropagationItemType.ADD).stream().map(StagePropagationItem::getPosition).filter(Objects::nonNull).collect(ImmutableSet.toImmutableSet());
            Iterable addedPos = this.addPositionChangesToChildren((Iterable)positionsAdded, stageTo, (Iterable)mergeOptions);
            ImmutableSet positionsUpdated = (ImmutableSet)positionPropagationItemByType.get((Object)EStagePropagationItemType.UPDATE).stream().map(StagePropagationItem::getPosition).filter(Objects::nonNull).collect(ImmutableSet.toImmutableSet());
            Iterable updatedPositions = this.propagatePositionChangesToChildren((Iterable)positionsUpdated, stageTo, (Iterable)mergeOptions);
            ImmutableSet positionsRemoved = (ImmutableSet)positionPropagationItemByType.get((Object)EStagePropagationItemType.REMOVE).stream().map(StagePropagationItem::getPosition).filter(Objects::nonNull).collect(ImmutableSet.toImmutableSet());
            Iterable removedPositions = this.removePositionChangesToChildren((Iterable)positionsRemoved, stageTo);
            stagePropagation.setProcessingState(EProcessingState.PROCESSED);
            log.info("Stage Propagation - Added Positions: {}", (Object)addedPos);
            log.info("Stage Propagation - Updated Positions: {}", (Object)updatedPositions);
            log.info("Stage Propagation - Removed Positions: {}", (Object)removedPositions);
            this.updateAndEmitChangeMessage(stageTo);
            stagePropagation.setProcessingState(EProcessingState.PROCESSED);
            return (StagePropagation)this.handler.update((EntityBase)stagePropagation, false);
        }
        catch (Exception ex) {
            log.error("Error Processing Stage Propagation: {}", (Object)stagePropagation, (Object)ex);
            return stagePropagation;
        }
    }

    private void propagateHeadToChildren(@NonNull Quotation stageFrom, @NonNull Quotation stageTo) {
        if (stageFrom == null) {
            throw new NullPointerException("stageFrom is marked non-null but is null");
        }
        if (stageTo == null) {
            throw new NullPointerException("stageTo is marked non-null but is null");
        }
        stageTo.setFinanceCashDiscount1(stageFrom.getFinanceCashDiscount1());
        stageTo.setFinanceCashDiscount2(stageFrom.getFinanceCashDiscount2());
        stageTo.setFinanceCashDiscountTime1(stageFrom.getFinanceCashDiscountTime1());
        stageTo.setFinanceCashDiscountTime2(stageFrom.getFinanceCashDiscountTime2());
        stageTo.setFinanceDefaultInvoiceType(stageFrom.getFinanceDefaultInvoiceType());
        stageTo.setFinanceFlagSubcontractor(stageFrom.getFinanceFlagSubcontractor());
        stageTo.setFinanceRoutingReferenceId(stageFrom.getFinanceRoutingReferenceId());
        stageTo.setFinanceTimeForPayment(stageFrom.getFinanceTimeForPayment());
        stageTo.setVatPercent(stageFrom.getVatPercent());
        stageTo.setPdfExtractType(stageFrom.getPdfExtractType());
        stageTo.setFinanceAccount(stageFrom.getFinanceAccount());
        stageTo.setFinanceTaxKey(stageFrom.getFinanceTaxKey());
        stageTo.setFinanceTaxKeyValue(stageFrom.getFinanceTaxKeyValue());
        stageTo.setFinanceDebtorAccountNumber(stageFrom.getFinanceDebtorAccountNumber());
    }

    private void propagateHeadChangesToChildren(@NonNull Quotation sourceStage, @NonNull Quotation targetStage) {
        if (sourceStage == null) {
            throw new NullPointerException("sourceStage is marked non-null but is null");
        }
        if (targetStage == null) {
            throw new NullPointerException("targetStage is marked non-null but is null");
        }
        targetStage.setGeneralDiscount(sourceStage.getGeneralDiscount());
        targetStage.setFlagDiscountFeePositions(sourceStage.getFlagDiscountFeePositions());
        targetStage.setOrderValue(sourceStage.getOrderValue());
        targetStage.setOrderNumber(sourceStage.getOrderNumber());
        targetStage.setWagePercentageMin(sourceStage.getWagePercentageMin());
        targetStage.setWagePercentageStandard(sourceStage.getWagePercentageStandard());
        targetStage.setMaterialPercentageMin(sourceStage.getMaterialPercentageMin());
        targetStage.setMaterialPercentageStandard(sourceStage.getMaterialPercentageStandard());
        targetStage.setWarrantySecurityRetentionPercent(sourceStage.getWarrantySecurityRetentionPercent());
        targetStage.setFulfillmentSecurityRetentionPercent(sourceStage.getFulfillmentSecurityRetentionPercent());
        targetStage.setSubProject(sourceStage.getSubProject());
        targetStage.setStagePositionSortOption(sourceStage.getStagePositionSortOption());
        targetStage.setFlagMeasurementWithoutCommissionNumberAllowed(sourceStage.getFlagMeasurementWithoutCommissionNumberAllowed());
        targetStage.setOrderDescriptionCustomer(sourceStage.getOrderDescriptionCustomer());
        targetStage.setOrderDescriptionInternal(sourceStage.getOrderDescriptionInternal());
        if (targetStage.getStageResponsibleUsers() == null) {
            targetStage.setStageResponsibleUsers((Set)Sets.newHashSet());
        }
        Set targetStageResponsibleUsers = targetStage.getStageResponsibleUsers();
        targetStageResponsibleUsers.forEach(item -> item.setQuotation(null));
        targetStageResponsibleUsers.clear();
        HashSet stageResponsibleUsersToAdd = Sets.newHashSet();
        Set existingStageResponsibleUsers = (Set)MoreObjects.firstNonNull((Object)sourceStage.getStageResponsibleUsers(), (Object)ImmutableSet.of());
        for (StageResponsibleUser existingStageResponsibleUser : existingStageResponsibleUsers) {
            User user = existingStageResponsibleUser.getUser();
            if (null == user) continue;
            StageResponsibleUser stageResponsibleUserNew = this.entityFactory.stageResponsibleUser(AuthenticationHelper.INTERNAL_AUTH);
            stageResponsibleUserNew.setUser(user);
            stageResponsibleUsersToAdd.add(stageResponsibleUserNew);
        }
        stageResponsibleUsersToAdd.forEach(item -> item.setQuotation(targetStage));
        targetStageResponsibleUsers.addAll(stageResponsibleUsersToAdd);
    }

    @Nonnull
    private Iterable<QuotationPosition> propagatePositionChangesToChildren(@NonNull Iterable<QuotationPosition> sourcePositions, @NonNull Quotation targetStage, @NonNull Iterable<EStagePositionMergeOption> mergeOptions) {
        if (sourcePositions == null) {
            throw new NullPointerException("sourcePositions is marked non-null but is null");
        }
        if (targetStage == null) {
            throw new NullPointerException("targetStage is marked non-null but is null");
        }
        if (mergeOptions == null) {
            throw new NullPointerException("mergeOptions is marked non-null but is null");
        }
        ArrayList updatedPositions = Lists.newArrayList();
        log.info("calling: propagatePositionChangesToChildren with Pos Amount: {}, Target Stage Id: {}", (Object)Iterables.size(sourcePositions), (Object)targetStage.getId());
        if (!Iterables.isEmpty(sourcePositions)) {
            List allAffectedPositions = this.positionHandler.allByReferencePosition(targetStage, sourcePositions);
            ImmutableListMultimap positionToNewPosition = Multimaps.index((Iterable)allAffectedPositions, QuotationPosition::getReferencePosition);
            HashSet changeInQuantityPositions = Sets.newHashSet();
            for (QuotationPosition source : sourcePositions) {
                EPositionType sourcePositionType = source.getPositionType();
                try {
                    ImmutableCollection targets = positionToNewPosition.get((Object)source);
                    for (QuotationPosition target : targets) {
                        EPositionType originalTargetPositionType = target.getPositionType();
                        EQStageType targetStageType = targetStage.getStageType();
                        if (Iterables.contains((Iterable)EQStageType.ADDENDUM_TYPES, (Object)targetStageType)) {
                            this.positionMapper.mergeInto(source, target, targetStageType, (Iterable)ImmutableSet.of((Object)EStagePositionMergeOption.EXCLUDE_AMOUNT));
                            if (EPositionType.CHANGE_IN_QUANTITY == originalTargetPositionType) {
                                changeInQuantityPositions.add(target);
                            }
                            updatedPositions.add(target);
                            continue;
                        }
                        this.positionMapper.mergeInto(source, target, targetStageType, mergeOptions);
                        if (!Iterables.contains((Iterable)EPositionType.JUMBO_CHILD, (Object)sourcePositionType)) continue;
                        QuotationPosition sourceParent = source.getParent();
                        QuotationPosition targetParent = target.getParent();
                        QuotationPosition sourceRef = source.getReferencePosition();
                        QuotationPosition targetReg = target.getReferencePosition();
                        Set sourceChildren = (Set)MoreObjects.firstNonNull((Object)source.getChildren(), (Object)ImmutableSet.of());
                        Set targetChildren = (Set)MoreObjects.firstNonNull((Object)target.getChildren(), (Object)ImmutableSet.of());
                        ImmutableMap sourceChildrenBySubPNr = Maps.uniqueIndex((Iterable)sourceChildren, QuotationPosition::getSubPositionNumber);
                        ImmutableMap immutableMap = Maps.uniqueIndex((Iterable)targetChildren, QuotationPosition::getSubPositionNumber);
                    }
                }
                catch (Exception e) {
                    log.error("Error Propagating Source: {}, Reason: {}", (Object)source, (Object)e.getMessage(), (Object)e);
                }
            }
            try {
                this.stageCalculators.standard().calculateAndApply(targetStage);
                changeInQuantityPositions.forEach(item -> {
                    item.setPositionType(EPositionType.CHANGE_IN_QUANTITY);
                    item.setJumboPositionType(EPositionType.UNKNOWN);
                });
                this.updateAndEmitChangeMessage(targetStage);
            }
            catch (Exception e) {
                log.error("Error Applying Calculations Target ID: {}, Reason: {}", (Object)targetStage.getId(), (Object)e.getMessage(), (Object)e);
            }
        }
        return ImmutableList.copyOf((Collection)updatedPositions);
    }

    @Nonnull
    private Iterable<QuotationPosition> addPositionChangesToChildren(@NonNull Iterable<QuotationPosition> sourcePositions, @NonNull Quotation stageTo, Iterable<EStagePositionMergeOption> mergeOptions) {
        if (sourcePositions == null) {
            throw new NullPointerException("sourcePositions is marked non-null but is null");
        }
        if (stageTo == null) {
            throw new NullPointerException("stageTo is marked non-null but is null");
        }
        ArrayList addedPositions = Lists.newArrayList();
        if (!Iterables.isEmpty(sourcePositions)) {
            LinkedHashMap sourceToTargetMap = Maps.newLinkedHashMap();
            HashSet changeInQuantityPositions = Sets.newHashSet();
            EQStageType stageType = stageTo.getStageType();
            for (QuotationPosition sourcePosition : sourcePositions) {
                EPositionType originalTargetPositionType = sourcePosition.getPositionType();
                QuotationPosition targetPosition = this.entityFactory.quotationPosition(AuthenticationHelper.INTERNAL_AUTH);
                this.positionMapper.mergeInto(sourcePosition, targetPosition, stageType, mergeOptions);
                targetPosition.setReferencePosition(sourcePosition);
                addedPositions.add(targetPosition);
                sourceToTargetMap.put(sourcePosition, targetPosition);
                if (EPositionType.CHANGE_IN_QUANTITY == originalTargetPositionType) {
                    changeInQuantityPositions.add(targetPosition);
                }
                if (Iterables.contains((Iterable)EPositionType.JUMBO_ANY, (Object)originalTargetPositionType)) {
                    // empty if block
                }
                if (!Iterables.contains((Iterable)EPositionType.JUMBO_CHILD, (Object)originalTargetPositionType)) continue;
                QuotationPosition sourceParent = sourcePosition.getParent();
                QuotationPosition targetParent = (QuotationPosition)sourceToTargetMap.get(sourceParent);
                targetPosition.setParent(targetParent);
            }
            addedPositions.forEach(item -> item.setQuotation(stageTo));
            stageTo.getQuotationPositions().addAll(addedPositions);
            this.stageCalculators.standard().calculateAndApply(stageTo);
            changeInQuantityPositions.forEach(item -> {
                item.setPositionType(EPositionType.CHANGE_IN_QUANTITY);
                item.setJumboPositionType(EPositionType.UNKNOWN);
            });
        }
        return ImmutableList.copyOf((Collection)addedPositions);
    }

    @Nonnull
    private Iterable<QuotationPosition> removePositionChangesToChildren(@NonNull Iterable<QuotationPosition> sourcePositions, @NonNull Quotation targetStage) {
        if (sourcePositions == null) {
            throw new NullPointerException("sourcePositions is marked non-null but is null");
        }
        if (targetStage == null) {
            throw new NullPointerException("targetStage is marked non-null but is null");
        }
        ArrayList positionsToRemove = Lists.newArrayList();
        if (!Iterables.isEmpty(sourcePositions)) {
            Set allPositionsInStage = targetStage.getQuotationPositions();
            Set changeInQuantityPositions = (Set)allPositionsInStage.stream().filter(item -> item.getPositionType() == EPositionType.CHANGE_IN_QUANTITY).collect(ImmutableSet.toImmutableSet());
            Set allPositionsInStageWithRef = (Set)allPositionsInStage.stream().filter(item -> null != item.getReferencePosition()).collect(ImmutableSet.toImmutableSet());
            Map allPositionsInStageByReferenceId = MapsHelper.mapFirst((Iterable)allPositionsInStageWithRef, item -> item.getReferencePosition().getId());
            for (QuotationPosition sourcePosition : sourcePositions) {
                Long sourceId = sourcePosition.getId();
                if (!allPositionsInStageByReferenceId.containsKey(sourceId)) continue;
                positionsToRemove.add((QuotationPosition)allPositionsInStageByReferenceId.get(sourceId));
            }
            positionsToRemove.forEach(item -> item.setQuotation(null));
            positionsToRemove.forEach(targetStage.getQuotationPositions()::remove);
            positionsToRemove.forEach(item -> {
                if (Iterables.contains((Iterable)EPositionType.JUMBO_CHILD, (Object)item.getPositionType())) {
                    item.getParent().getChildren().remove(item);
                    item.setParent(null);
                }
            });
            this.stageCalculators.standard().calculateAndApply(targetStage);
            changeInQuantityPositions.forEach(item -> {
                item.setPositionType(EPositionType.CHANGE_IN_QUANTITY);
                item.setJumboPositionType(EPositionType.UNKNOWN);
            });
        }
        return ImmutableList.copyOf((Collection)positionsToRemove);
    }

    @Nonnull
    private Quotation updateAndEmitChangeMessage(@NonNull Quotation stage) {
        if (stage == null) {
            throw new NullPointerException("stage is marked non-null but is null");
        }
        Quotation stageUpdated = (Quotation)this.stageHandler.update((EntityBase)stage, false);
        this.applicationEventPublisher.publishEvent((ApplicationEvent)QStageChangeMessage.of((Object)this, (Quotation)stageUpdated));
        return stageUpdated;
    }

    public StagePropagationRouteImpl(ApplicationEventPublisher applicationEventPublisher, EntityFactory entityFactory, StagePropagationHandler handler, StagePropagationMapper mapper, StageHandler stageHandler, StageCalculators stageCalculators, StagePositionMapper positionMapper, StagePositionHandler positionHandler) {
        this.applicationEventPublisher = applicationEventPublisher;
        this.entityFactory = entityFactory;
        this.handler = handler;
        this.mapper = mapper;
        this.stageHandler = stageHandler;
        this.stageCalculators = stageCalculators;
        this.positionMapper = positionMapper;
        this.positionHandler = positionHandler;
    }
}

