/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.service.route.impl;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import de.leancoders.common.helper.DateTimeHelper;
import de.leancoders.common.response.reporting.ReportResponse;
import de.qfm.erp.service.model.exception.response.ResourceNotFoundException;
import de.qfm.erp.service.model.internal.dashboard.IReportCountDateBigDecimalBigDecimal;
import de.qfm.erp.service.model.internal.fieldname.EField;
import de.qfm.erp.service.model.internal.fieldname.FieldName;
import de.qfm.erp.service.model.internal.fieldname.FieldNamesFactory;
import de.qfm.erp.service.model.internal.reporting.EReportType;
import de.qfm.erp.service.model.jpa.user.User;
import de.qfm.erp.service.service.handler.MeasurementHandler;
import de.qfm.erp.service.service.mapper.ReportingMapper;
import de.qfm.erp.service.service.route.ReportingRoute;
import de.qfm.erp.service.service.route.impl.ReportingRouteImpl;
import de.qfm.erp.service.service.security.UserService;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import lombok.NonNull;
import org.springframework.stereotype.Service;

@Service
public class ReportingRouteImpl
implements ReportingRoute {
    private final MeasurementHandler measurementHandler;
    private final ReportingMapper reportingMapper;
    private final UserService userService;

    @Nonnull
    public ReportResponse<String, BigDecimal> reportResponse(@NonNull String reportNameCandidate) {
        if (reportNameCandidate == null) {
            throw new NullPointerException("reportNameCandidate is marked non-null but is null");
        }
        Optional lookup = EReportType.lookup((String)reportNameCandidate);
        if (lookup.isPresent()) {
            EReportType reportType = (EReportType)lookup.get();
            switch (2.$SwitchMap$de$qfm$erp$service$model$internal$reporting$EReportType[reportType.ordinal()]) {
                case 1: {
                    return this.reportingMapper.map(reportType, this.sumsInMonthSince(DateTimeHelper.today().minusYears(1L)), IReportCountDateBigDecimalBigDecimal::getValue1);
                }
                case 2: {
                    return this.reportingMapper.map(reportType, this.sumsInMonthSince(DateTimeHelper.today().minusYears(1L)), IReportCountDateBigDecimalBigDecimal::getValue2);
                }
            }
            return ReportResponse.of((String)"", (List)ImmutableList.of(), (List)ImmutableList.of(), (List)ImmutableList.of());
        }
        throw ResourceNotFoundException.of((String)EReportType.class.getSimpleName(), (FieldName)FieldNamesFactory.simpleFieldName((EField)EField.REPORT_KEY), (String)reportNameCandidate);
    }

    @Nonnull
    private Iterable<IReportCountDateBigDecimalBigDecimal> sumsInMonthSince(@NonNull LocalDate minDate) {
        if (minDate == null) {
            throw new NullPointerException("minDate is marked non-null but is null");
        }
        LocalDate today = DateTimeHelper.today();
        ImmutableList.Builder reportCountBuilder = ImmutableList.builder();
        LocalDate referenceDate = minDate.withDayOfMonth(1);
        while (referenceDate.isBefore(today)) {
            Iterable reportCounts = this.measurementHandler.sumInMonth(referenceDate, this.myUsers());
            if (!Iterables.isEmpty((Iterable)reportCounts)) {
                reportCountBuilder.add((Object)((IReportCountDateBigDecimalBigDecimal)Iterables.get((Iterable)reportCounts, (int)0)));
            } else {
                reportCountBuilder.add((Object)this.empty(referenceDate));
            }
            referenceDate = referenceDate.plusMonths(1L);
        }
        return reportCountBuilder.build();
    }

    @Nonnull
    private IReportCountDateBigDecimalBigDecimal empty(@NonNull LocalDate reportDate) {
        if (reportDate == null) {
            throw new NullPointerException("reportDate is marked non-null but is null");
        }
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    @Nonnull
    private Iterable<User> myUsers() {
        return this.userService.refresh(this.userService.currentUsersAssignedToLogin());
    }

    public ReportingRouteImpl(MeasurementHandler measurementHandler, ReportingMapper reportingMapper, UserService userService) {
        this.measurementHandler = measurementHandler;
        this.reportingMapper = reportingMapper;
        this.userService = userService;
    }
}

