/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.service.route.impl;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Range;
import com.google.common.collect.Streams;
import de.leancoders.common.helper.IterableHelper;
import de.qfm.erp.common.response.StringListResponse;
import de.qfm.erp.common.response.quotation.QuotationCommon;
import de.qfm.erp.common.response.quotation.QuotationPageCommon;
import de.qfm.erp.common.response.quotation.QuotationPositionCommon;
import de.qfm.erp.service.configuration.CompanyConfig;
import de.qfm.erp.service.configuration.PrintLayoutConfig;
import de.qfm.erp.service.helper.FileHelper;
import de.qfm.erp.service.helper.QuotationHelper;
import de.qfm.erp.service.helper.StageHelper;
import de.qfm.erp.service.helper.comparator.quotation.QuotationPositionGroupingLevelComparator;
import de.qfm.erp.service.model.internal.message.Translatable;
import de.qfm.erp.service.model.internal.payroll.EExportFileName;
import de.qfm.erp.service.model.internal.quotation.BillOfQuantitiesMeasurementExport;
import de.qfm.erp.service.model.internal.quotation.ECostUnitCEViewMode;
import de.qfm.erp.service.model.internal.quotation.EQuotationHint;
import de.qfm.erp.service.model.internal.quotation.EQuotationPositionSortOption;
import de.qfm.erp.service.model.internal.quotation.QuotationBucket;
import de.qfm.erp.service.model.jpa.EntityBase;
import de.qfm.erp.service.model.jpa.measurement.Measurement;
import de.qfm.erp.service.model.jpa.measurement.MeasurementPosition;
import de.qfm.erp.service.model.jpa.measurement.type.EMeasurementState;
import de.qfm.erp.service.model.jpa.quotation.Quotation;
import de.qfm.erp.service.model.jpa.quotation.QuotationPosition;
import de.qfm.erp.service.model.jpa.shared.EAlternativePositionType;
import de.qfm.erp.service.model.jpa.shared.EPositionType;
import de.qfm.erp.service.model.jpa.user.EPrivilege;
import de.qfm.erp.service.service.handler.EntityFactory;
import de.qfm.erp.service.service.handler.MeasurementHandler;
import de.qfm.erp.service.service.handler.MeasurementPositionHandler;
import de.qfm.erp.service.service.handler.PersonAutoCompleteHandler;
import de.qfm.erp.service.service.handler.StageHandler;
import de.qfm.erp.service.service.mapper.QuotationMapper;
import de.qfm.erp.service.service.mapper.QuotationPositionMapper;
import de.qfm.erp.service.service.route.QuotationRoute;
import de.qfm.erp.service.service.security.UserService;
import de.qfm.erp.service.service.service.ConfigService;
import de.qfm.erp.service.service.service.DateTimeHelperService;
import de.qfm.erp.service.service.service.MessageService;
import de.qfm.erp.service.service.service.xls.BillOfQuantitiesMeasurementXlsExportService;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.time.Clock;
import java.time.LocalDate;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class QuotationRouteImpl
implements QuotationRoute {
    private static final Logger log = LogManager.getLogger(QuotationRouteImpl.class);
    private final UserService userService;
    private final ConfigService configService;
    private final EntityFactory entityFactory;
    private final BillOfQuantitiesMeasurementXlsExportService billOfQuantitiesMeasurementXlsExportService;
    private final DateTimeHelperService dateTimeHelperService;
    private final MessageService messageService;
    private final MeasurementHandler measurementHandler;
    private final MeasurementPositionHandler measurementPositionHandler;
    private final QuotationMapper mapper;
    private final QuotationPositionMapper quotationPositionMapper;
    private final StageHandler stageHandler;
    private final PersonAutoCompleteHandler personAutoCompleteHandler;
    private final PrintLayoutConfig printLayoutConfig;
    private final CompanyConfig companyConfig;

    @Nonnull
    @Transactional(readOnly=true)
    public QuotationCommon byId(long quotationId, boolean includeAllPositions, boolean ignoreCommissionFlag, @NonNull String quotationPositionSortOptionCandidate) {
        if (quotationPositionSortOptionCandidate == null) {
            throw new NullPointerException("quotationPositionSortOptionCandidate is marked non-null but is null");
        }
        Quotation quotation = (Quotation)this.stageHandler.byIdFailing(Long.valueOf(quotationId));
        String quotationNumber = quotation.getQuotationNumber();
        Set quotationPositions = includeAllPositions ? this.stageHandler.allQuotationPositionsByQuotationNumberFailing(quotationNumber, ignoreCommissionFlag) : quotation.getQuotationPositions();
        Iterable iAddendumDiscounts = this.stageHandler.allStageDiscounts(quotation);
        EQuotationPositionSortOption quotationPositionSortOption = EQuotationPositionSortOption.lookup((String)quotationPositionSortOptionCandidate, (EQuotationPositionSortOption)EQuotationPositionSortOption.SEQUENTIAL_NUMBER_ASC);
        Iterable quotationHints = QuotationRouteImpl.hints((Quotation)quotation, (Iterable)quotationPositions, (boolean)ignoreCommissionFlag);
        return this.mapper.mapToCommon(QuotationBucket.of((ECostUnitCEViewMode)ECostUnitCEViewMode.COMMISSION__COST_UNIT_CE, (EQuotationPositionSortOption)quotationPositionSortOption, (Quotation)quotation, (String)"", (String)"", (Iterable)iAddendumDiscounts, (Iterable)quotationPositions, (Iterable)quotationHints));
    }

    @Nonnull
    @Transactional
    public QuotationCommon byReferenceId(@NonNull String referenceId) {
        if (referenceId == null) {
            throw new NullPointerException("referenceId is marked non-null but is null");
        }
        QuotationBucket bucket = this.updateBucket(this.stageHandler.byReferenceIdFailing(referenceId));
        return this.mapper.mapToCommon(bucket);
    }

    @Nonnull
    @Transactional(readOnly=true)
    public QuotationCommon byQuotationNumber(@NonNull String quotationNumber, boolean ignoreCommissionFlag, @NonNull String quotationPositionSortOptionCandidate) {
        if (quotationNumber == null) {
            throw new NullPointerException("quotationNumber is marked non-null but is null");
        }
        if (quotationPositionSortOptionCandidate == null) {
            throw new NullPointerException("quotationPositionSortOptionCandidate is marked non-null but is null");
        }
        Quotation quotation = this.stageHandler.firstByQuotationNumberFailing(quotationNumber);
        List quotationPositions = this.stageHandler.allQuotationPositionsByQuotationNumberFailing(quotationNumber, ignoreCommissionFlag);
        Iterable iAddendumDiscounts = this.stageHandler.allStageDiscounts(quotation);
        EQuotationPositionSortOption quotationPositionSortOption = EQuotationPositionSortOption.lookup((String)quotationPositionSortOptionCandidate, (EQuotationPositionSortOption)EQuotationPositionSortOption.SEQUENTIAL_NUMBER_ASC);
        Iterable quotationHints = QuotationRouteImpl.hints((Quotation)quotation, (Iterable)quotationPositions, (boolean)ignoreCommissionFlag);
        return this.mapper.mapToCommon(QuotationBucket.of((ECostUnitCEViewMode)ECostUnitCEViewMode.COMMISSION__COST_UNIT_CE, (EQuotationPositionSortOption)quotationPositionSortOption, (Quotation)quotation, (String)"", (String)"", (Iterable)iAddendumDiscounts, (Iterable)quotationPositions, (Iterable)quotationHints));
    }

    @Nonnull
    @Transactional(readOnly=true)
    public QuotationPageCommon page(int page, int size) {
        return this.mapper.mapPageToCommon(this.stageHandler.page(page, size));
    }

    @Nonnull
    private Iterable<MeasurementPosition> cleanupMeasurementPositions(@NonNull Quotation quotation, @NonNull Iterable<QuotationPosition> quotationPositions) {
        Iterable surrogatePositionNumbers;
        Set measurementStatesAffectedInQuotationPositionDeletion;
        String quotationNumber;
        List measurementPositions;
        if (quotation == null) {
            throw new NullPointerException("quotation is marked non-null but is null");
        }
        if (quotationPositions == null) {
            throw new NullPointerException("quotationPositions is marked non-null but is null");
        }
        if (!Iterables.isEmpty(quotationPositions) && !Iterables.isEmpty((Iterable)(measurementPositions = this.measurementPositionHandler.allForQuotationNumberAndSurrogate(quotationNumber = quotation.getQuotationNumber(), (Iterable)(measurementStatesAffectedInQuotationPositionDeletion = EMeasurementState.MEASUREMENT_STATES_AFFECTED_IN_QUOTATION_POSITION_DELETION), surrogatePositionNumbers = (Iterable)IterableHelper.stream(quotationPositions).map(QuotationPosition::getSurrogatePositionNumber).collect(ImmutableSet.toImmutableSet()))))) {
            Measurement measurement = ((MeasurementPosition)measurementPositions.get(0)).getMeasurement();
            measurementPositions.forEach(measurementPosition -> measurementPosition.setFlagNotInQuotation(Boolean.valueOf(true)));
            Measurement measurement2 = (Measurement)this.measurementHandler.update((EntityBase)measurement);
        }
        return ImmutableList.of();
    }

    @Nonnull
    public StringListResponse personResponsibleAtClient(long id, @NonNull String filterText) {
        if (filterText == null) {
            throw new NullPointerException("filterText is marked non-null but is null");
        }
        List usedInQuotation = this.personAutoCompleteHandler.quotationContactPerson(id, filterText);
        List usedInMeasurements = this.personAutoCompleteHandler.personResponsibleAtClientInMeasurementWithQuotation(id, filterText);
        ImmutableSet.Builder allBuilder = ImmutableSet.builder();
        allBuilder.addAll((Iterable)usedInQuotation);
        allBuilder.addAll((Iterable)usedInMeasurements);
        ImmutableSet all = allBuilder.build();
        return new StringListResponse(all.size(), (List)ImmutableList.sortedCopyOf((Iterable)all));
    }

    @Nonnull
    @VisibleForTesting
    static Iterable<EQuotationHint> hints(@NonNull Quotation quotation, @NonNull Iterable<QuotationPosition> quotationPositions, boolean ignoreCommissionFlag) {
        if (quotation == null) {
            throw new NullPointerException("quotation is marked non-null but is null");
        }
        if (quotationPositions == null) {
            throw new NullPointerException("quotationPositions is marked non-null but is null");
        }
        ImmutableSet.Builder quotationHintBuilder = ImmutableSet.builder();
        if (!ignoreCommissionFlag && Iterables.isEmpty(quotationPositions) && QuotationHelper.isQuotationCommissionNumberPresentAndNeeded((Quotation)quotation)) {
            quotationHintBuilder.add((Object)EQuotationHint.MEASUREMENT_WITHOUT_COMMISSION_NUMBER_NOT_ALLOWED);
        }
        if (QuotationHelper.isQuotationEnded((Quotation)quotation)) {
            quotationHintBuilder.add((Object)EQuotationHint.QUOTATION_ORDER_END);
        }
        LocalDate projectExecutionStartDate = quotation.getProjectExecutionStartDate();
        LocalDate projectExecutionEndDate = quotation.getProjectExecutionEndDate();
        if (null != projectExecutionStartDate && null != projectExecutionEndDate) {
            if (projectExecutionStartDate.isAfter(projectExecutionEndDate)) {
                quotationHintBuilder.add((Object)EQuotationHint.QUOTATION_PROJECT_EXECUTION_INVALID_RANGE);
            } else {
                LocalDate now;
                Range validRange = Range.closed((Comparable)projectExecutionStartDate, (Comparable)projectExecutionEndDate);
                if (!validRange.contains((Comparable)(now = LocalDate.now(Clock.systemUTC())))) {
                    if (now.isBefore(projectExecutionStartDate)) {
                        quotationHintBuilder.add((Object)EQuotationHint.QUOTATION_PROJECT_EXECUTION_NOT_STARTED);
                    } else if (now.isAfter(projectExecutionEndDate)) {
                        quotationHintBuilder.add((Object)EQuotationHint.QUOTATION_PROJECT_EXECUTION_FINISHED);
                    }
                }
            }
        } else {
            quotationHintBuilder.add((Object)EQuotationHint.QUOTATION_PROJECT_EXECUTION_MISSING);
        }
        return quotationHintBuilder.build();
    }

    @Nonnull
    private QuotationBucket updateBucket(@NonNull Quotation quotation) {
        if (quotation == null) {
            throw new NullPointerException("quotation is marked non-null but is null");
        }
        Iterable quotationHints = QuotationRouteImpl.hints((Quotation)quotation, (Iterable)quotation.getQuotationPositions(), (boolean)true);
        return QuotationBucket.of((ECostUnitCEViewMode)ECostUnitCEViewMode.COMMISSION__COST_UNIT_CE, (EQuotationPositionSortOption)EQuotationPositionSortOption.SEQUENTIAL_NUMBER_ASC, (Quotation)quotation, (String)"", (String)"", (Iterable)ImmutableList.of(), (Iterable)quotation.getQuotationPositions(), (Iterable)quotationHints);
    }

    @Nonnull
    @Transactional
    public QuotationCommon ensureCorrectionPosition(long quotationId) {
        Quotation originalQuotation = (Quotation)this.stageHandler.byIdFailing(Long.valueOf(quotationId));
        Optional firstQuotationCandidate = this.stageHandler.firstQuotationByQuotationNumberNotFailing(originalQuotation.getQuotationNumber());
        if (firstQuotationCandidate.isPresent()) {
            Quotation firstQuotation = (Quotation)firstQuotationCandidate.get();
            Pair quotationWithCPPosition = this.internalEnsureCorrectionPosition(firstQuotation);
            QuotationBucket quotationBucket = this.updateBucket((Quotation)quotationWithCPPosition.getLeft());
            return this.mapper.mapToCommon(quotationBucket);
        }
        return new QuotationCommon();
    }

    @Nonnull
    public List<QuotationPositionCommon> correctionPosition(long quotationId) {
        Quotation originalQuotation = (Quotation)this.stageHandler.byIdFailing(Long.valueOf(quotationId));
        Optional firstQuotationCandidate = this.stageHandler.firstQuotationByQuotationNumberNotFailing(originalQuotation.getQuotationNumber());
        if (firstQuotationCandidate.isPresent()) {
            Quotation firstQuotation = (Quotation)firstQuotationCandidate.get();
            Pair quotationWithCPPosition = this.internalEnsureCorrectionPosition(firstQuotation);
            Quotation quotation = (Quotation)quotationWithCPPosition.getLeft();
            Iterable cpPositions = (Iterable)quotationWithCPPosition.getRight();
            return ImmutableList.copyOf((Iterable)this.quotationPositionMapper.mapCPPositions(quotation, cpPositions));
        }
        return ImmutableList.of();
    }

    @Nonnull
    public Pair<String, byte[]> billOfQuantitiesMeasurementTemplateById(long id) throws IOException {
        this.userService.checkPrivilege(EPrivilege.QUOTATION__BOQ_MEASUREMENT_DOWNLOAD_ALLOW);
        Quotation stage = (Quotation)this.stageHandler.byIdFailing(Long.valueOf(id));
        Map quotationIterableMap = this.stageHandler.allPositionStages(stage);
        Stream<BillOfQuantitiesMeasurementExport> boqStream = quotationIterableMap.values().stream().flatMap(IterableHelper::stream).sorted(QuotationPositionGroupingLevelComparator.of((boolean)true)).map(arg_0 -> this.map(arg_0));
        try (InputStream fis = FileHelper.fisFromResource(this.getClass(), (String)"/xls/BillOfQuantities_Measurement_XLS_Template.xlsx");){
            Pair pair;
            try (ByteArrayOutputStream bos = new ByteArrayOutputStream();){
                XSSFWorkbook template = new XSSFWorkbook(fis);
                String companyName = this.companyConfig.getCompanyName();
                String stageNumber = StageHelper.quotationOrStageNumber((Quotation)stage);
                String stageAlias = StringUtils.trimToEmpty((String)stage.getAlias());
                XSSFWorkbook sxssfWorkbook = this.billOfQuantitiesMeasurementXlsExportService.detailXLS(template, companyName, "Aufmass", "Positionen", stageNumber, stageAlias, boqStream);
                sxssfWorkbook.setActiveSheet(0);
                sxssfWorkbook.write((OutputStream)bos);
                byte[] bytes = bos.toByteArray();
                String dateForFile = this.dateTimeHelperService.dateForFile();
                String fileName = this.messageService.get((Translatable)EExportFileName.QUOTATION__BOQ_MEASUREMENT_TEMPLATE_AS_XLSX, new Object[]{dateForFile, stageNumber});
                pair = Pair.of((Object)fileName, (Object)bytes);
            }
            return pair;
        }
    }

    @Nonnull
    private BillOfQuantitiesMeasurementExport map(@NonNull QuotationPosition quotationPosition) {
        if (quotationPosition == null) {
            throw new NullPointerException("quotationPosition is marked non-null but is null");
        }
        BillOfQuantitiesMeasurementExport boq = new BillOfQuantitiesMeasurementExport();
        boq.setUnit(quotationPosition.getUnit());
        boq.setShortText(quotationPosition.getShortText());
        boq.setSurrogatePositionNumber(quotationPosition.getSurrogatePositionNumber());
        boq.setPricePerUnit(quotationPosition.getPricePerUnit());
        boq.setRemarks(quotationPosition.getRemarks());
        boq.setPriceAggregated(quotationPosition.getPriceAggregated());
        boq.setProduct(quotationPosition.getOrderedAmount());
        boq.setDiscount(BigDecimal.ZERO);
        return boq;
    }

    @Nonnull
    private Pair<Quotation, Iterable<QuotationPosition>> internalEnsureCorrectionPosition(@NonNull Quotation quotation) {
        if (quotation == null) {
            throw new NullPointerException("quotation is marked non-null but is null");
        }
        Iterable quotationPositions = (Iterable)MoreObjects.firstNonNull((Object)quotation.getQuotationPositions(), (Object)ImmutableList.of());
        Iterable correctionPositions = (Iterable)Streams.stream((Iterable)quotationPositions).filter(item -> EPositionType.CORRECTION == item.getPositionType()).collect(ImmutableList.toImmutableList());
        if (Iterables.isEmpty((Iterable)correctionPositions)) {
            QuotationPosition quotationPosition = this.entityFactory.quotationPosition();
            quotationPosition.setFlagAlternativePosition("x");
            quotationPosition.setAlternativePositionType(EAlternativePositionType.YES__EXCLUDE_FROM_CALCULATION);
            quotationPosition.setPositionType(EPositionType.CORRECTION);
            quotationPosition.setJumboPositionType(EPositionType.UNKNOWN);
            quotationPosition.setPricePerUnit(BigDecimal.ONE);
            quotationPosition.setMaterialSellingPricePerUnit(BigDecimal.ONE);
            quotationPosition.setMaterialSellingPriceAggregated(BigDecimal.ONE);
            quotationPosition.setMaterialFactor(BigDecimal.ZERO);
            quotationPosition.setFactorAggregated(BigDecimal.ONE);
            quotationPosition.setPriceAggregated(BigDecimal.ZERO);
            quotationPosition.setWagePerUnit(BigDecimal.ZERO);
            quotationPosition.setOrderedAmount(BigDecimal.ZERO);
            quotationPosition.setWageFactor(BigDecimal.ZERO);
            quotationPosition.setCompanyWagePerItem(BigDecimal.ZERO);
            quotationPosition.setCompanyWageAggregated(BigDecimal.ZERO);
            quotationPosition.setMaterialWholesalePriceDiscount(BigDecimal.ZERO);
            quotationPosition.setMaterialWholesalePriceIncludingDiscountPerItem(BigDecimal.ZERO);
            quotationPosition.setMaterialWholesalePriceExcludingDiscountPerItem(BigDecimal.ZERO);
            quotationPosition.setMaterialWholesalePriceIncludingDiscountAggregated(BigDecimal.ZERO);
            quotationPosition.setMaterialWholesalePriceExcludingDiscountAggregated(BigDecimal.ZERO);
            quotationPosition.setInternalWageAggregated(BigDecimal.ZERO);
            quotationPosition.setSquadWagePerUnit(BigDecimal.ZERO);
            quotationPosition.setWagePerUnit(BigDecimal.ZERO);
            quotationPosition.setShortText("Korrektur Position 1 EUR");
            quotationPosition.setLongText("Korrektur Position 1 EUR");
            quotationPosition.setPositionNumber("KP_1EUR");
            quotationPosition.setUnitAmount(BigDecimal.ONE);
            quotationPosition.setUnit("");
            quotationPosition.setSurrogatePositionNumber("KP_1EUR");
            quotationPosition.setSequenceNumberQuotationStandard(Integer.valueOf(Integer.MAX_VALUE));
            quotationPosition.setQuotation(quotation);
            quotation.getQuotationPositions().add(quotationPosition);
            Quotation quotationUpdated = this.stageHandler.update(quotation);
            Iterable quotationPositionsUpdated = (Iterable)MoreObjects.firstNonNull((Object)quotationUpdated.getQuotationPositions(), (Object)ImmutableList.of());
            Iterable correctionPositionsUpdated = (Iterable)Streams.stream((Iterable)quotationPositionsUpdated).filter(item -> EPositionType.CORRECTION == item.getPositionType()).collect(ImmutableList.toImmutableList());
            return Pair.of((Object)quotationUpdated, (Object)correctionPositionsUpdated);
        }
        return Pair.of((Object)quotation, (Object)correctionPositions);
    }

    public QuotationRouteImpl(UserService userService, ConfigService configService, EntityFactory entityFactory, BillOfQuantitiesMeasurementXlsExportService billOfQuantitiesMeasurementXlsExportService, DateTimeHelperService dateTimeHelperService, MessageService messageService, MeasurementHandler measurementHandler, MeasurementPositionHandler measurementPositionHandler, QuotationMapper mapper, QuotationPositionMapper quotationPositionMapper, StageHandler stageHandler, PersonAutoCompleteHandler personAutoCompleteHandler, PrintLayoutConfig printLayoutConfig, CompanyConfig companyConfig) {
        this.userService = userService;
        this.configService = configService;
        this.entityFactory = entityFactory;
        this.billOfQuantitiesMeasurementXlsExportService = billOfQuantitiesMeasurementXlsExportService;
        this.dateTimeHelperService = dateTimeHelperService;
        this.messageService = messageService;
        this.measurementHandler = measurementHandler;
        this.measurementPositionHandler = measurementPositionHandler;
        this.mapper = mapper;
        this.quotationPositionMapper = quotationPositionMapper;
        this.stageHandler = stageHandler;
        this.personAutoCompleteHandler = personAutoCompleteHandler;
        this.printLayoutConfig = printLayoutConfig;
        this.companyConfig = companyConfig;
    }
}

