/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.service.route.impl;

import com.google.common.collect.Multimaps;
import de.qfm.erp.common.response.queue.QueueItemListCommon;
import de.qfm.erp.service.model.jpa.queue.EReferenceType;
import de.qfm.erp.service.service.handler.QueueService;
import de.qfm.erp.service.service.mapper.QueueMapper;
import de.qfm.erp.service.service.queue.QueueProcessor;
import de.qfm.erp.service.service.route.QueueRoute;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Nonnull;
import lombok.NonNull;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class QueueRouteImpl
implements QueueRoute {
    private static final Logger log = LogManager.getLogger(QueueRouteImpl.class);
    private final QueueService service;
    private final QueueMapper mapper;
    private final Map<EReferenceType, Collection<QueueProcessor>> queueHandlerMap;

    @Autowired
    public QueueRouteImpl(@NonNull QueueService service, @NonNull QueueMapper mapper, @NonNull List<QueueProcessor> queueProcessors) {
        if (service == null) {
            throw new NullPointerException("service is marked non-null but is null");
        }
        if (mapper == null) {
            throw new NullPointerException("mapper is marked non-null but is null");
        }
        if (queueProcessors == null) {
            throw new NullPointerException("queueProcessors is marked non-null but is null");
        }
        this.service = service;
        this.mapper = mapper;
        this.queueHandlerMap = Multimaps.index(queueProcessors, QueueProcessor::referenceType).asMap();
    }

    @Transactional(readOnly=false)
    public boolean processNextItem() {
        Optional queueItemCandidate = this.service.pull();
        AtomicBoolean atomicBoolean = new AtomicBoolean(false);
        queueItemCandidate.ifPresent(queueItem -> {
            EReferenceType referenceType = queueItem.getReferenceType();
            if (this.queueHandlerMap.containsKey(referenceType)) {
                Collection queueProcessors = (Collection)this.queueHandlerMap.get(referenceType);
                boolean processed = true;
                for (QueueProcessor queueProcessor : queueProcessors) {
                    processed &= queueProcessor.process(queueItem);
                    log.info("Processed: {}", queueItem);
                }
                if (processed) {
                    this.service.processed(queueItem);
                } else {
                    this.service.failure(queueItem);
                }
                atomicBoolean.set(processed);
            } else {
                log.warn("No Handler found for {}, skipping", (Object)referenceType);
                queueItem.setFailureAmount(Integer.valueOf(999));
                this.service.failure(queueItem);
            }
        });
        return atomicBoolean.get();
    }

    @Nonnull
    public QueueItemListCommon list(int size) {
        return this.mapper.map(size, this.service.pull(size));
    }
}

