/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.service.route.impl;

import com.google.common.collect.Iterables;
import de.qfm.erp.service.model.external.psx.ExtPsxNotifyRequest;
import de.qfm.erp.service.model.external.psx.ExtPsxNotifyResponse;
import de.qfm.erp.service.model.jpa.customer.Customer;
import de.qfm.erp.service.model.jpa.project.Project;
import de.qfm.erp.service.model.jpa.quotation.EQStageType;
import de.qfm.erp.service.model.jpa.quotation.QEntity;
import de.qfm.erp.service.model.jpa.quotation.Quotation;
import de.qfm.erp.service.model.jpa.user.User;
import de.qfm.erp.service.service.handler.CustomerHandler;
import de.qfm.erp.service.service.handler.EntityHandler;
import de.qfm.erp.service.service.handler.ProjectHandler;
import de.qfm.erp.service.service.handler.StageHandler;
import de.qfm.erp.service.service.handler.UserHandler;
import de.qfm.erp.service.service.psx.PsxNotifyClientService;
import de.qfm.erp.service.service.route.PsxSyncRoute;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class PsxSyncRouteImpl
implements PsxSyncRoute {
    private static final Logger log = LogManager.getLogger(PsxSyncRouteImpl.class);
    private final CustomerHandler customerHandler;
    private final ProjectHandler projectHandler;
    private final EntityHandler entityHandler;
    private final StageHandler stageHandler;
    private final UserHandler userHandler;
    private final PsxNotifyClientService psxNotifyClientService;

    @Transactional
    @Nonnull
    public Optional<ExtPsxNotifyResponse> processNextCustomer() {
        Iterable customerCand = this.customerHandler.nextNotNotified();
        if (!Iterables.isEmpty((Iterable)customerCand)) {
            Customer customer = (Customer)customerCand.iterator().next();
            Long customerId = customer.getId();
            String customerIdStr = customerId.toString();
            ExtPsxNotifyRequest request = new ExtPsxNotifyRequest();
            request.setEntityType("CUSTOMER");
            request.setEntityReferenceId(customerIdStr);
            ExtPsxNotifyResponse notify = this.psxNotifyClientService.notify(request);
            if (notify.isSuccess()) {
                this.customerHandler.markPsxNotified(customerId.longValue());
            }
            return Optional.of(notify);
        }
        return Optional.empty();
    }

    @Transactional
    @Nonnull
    public Optional<ExtPsxNotifyResponse> processNextProjectTeam() {
        Iterable projectCand = this.projectHandler.nextNotNotified();
        if (!Iterables.isEmpty((Iterable)projectCand)) {
            Project project = (Project)projectCand.iterator().next();
            Long projectId = project.getId();
            String projectIdStr = projectId.toString();
            ExtPsxNotifyRequest request = new ExtPsxNotifyRequest();
            request.setEntityType("PROJECT_TEAM");
            request.setEntityReferenceId(projectIdStr);
            ExtPsxNotifyResponse notify = this.psxNotifyClientService.notify(request);
            if (notify.isSuccess()) {
                this.projectHandler.markPsxNotified(projectId.longValue());
            }
            return Optional.of(notify);
        }
        return Optional.empty();
    }

    @Nonnull
    public Optional<ExtPsxNotifyResponse> processNextEntity() {
        Iterable entityCand = this.entityHandler.nextNotNotified();
        if (!Iterables.isEmpty((Iterable)entityCand)) {
            QEntity entity = (QEntity)entityCand.iterator().next();
            Long entityId = entity.getId();
            String entityIdIdStr = entityId.toString();
            ExtPsxNotifyRequest request = new ExtPsxNotifyRequest();
            request.setEntityType("ENTITY");
            request.setEntityReferenceId(entityIdIdStr);
            ExtPsxNotifyResponse notify = this.psxNotifyClientService.notify(request);
            if (notify.isSuccess()) {
                this.entityHandler.markPsxNotified(entityId.longValue());
            }
            return Optional.of(notify);
        }
        return Optional.empty();
    }

    @Nonnull
    public Optional<ExtPsxNotifyResponse> processNextStage() {
        Iterable stageCand = this.stageHandler.nextNotNotified();
        if (!Iterables.isEmpty((Iterable)stageCand)) {
            Quotation stage = (Quotation)stageCand.iterator().next();
            Long stageId = stage.getId();
            String stageIdStr = stageId.toString();
            EQStageType stageType = stage.getStageType();
            if (Iterables.contains((Iterable)EQStageType.PSX_NOTIFY_TYPES, (Object)stageType)) {
                ExtPsxNotifyRequest request = new ExtPsxNotifyRequest();
                request.setEntityType("STAGE");
                request.setEntityReferenceId(stageIdStr);
                ExtPsxNotifyResponse notify = this.psxNotifyClientService.notify(request);
                if (notify.isSuccess()) {
                    this.stageHandler.markPsxNotified(stageId.longValue());
                }
                return Optional.of(notify);
            }
            this.stageHandler.markPsxNotified(stageId.longValue());
        }
        return Optional.empty();
    }

    @Nonnull
    public Optional<ExtPsxNotifyResponse> processNextUser() {
        List userCand = this.userHandler.nextNotNotified();
        if (!Iterables.isEmpty((Iterable)userCand)) {
            User user = (User)userCand.iterator().next();
            Long userId = user.getId();
            String userIdStr = userId.toString();
            ExtPsxNotifyRequest request = new ExtPsxNotifyRequest();
            request.setEntityType("USER");
            request.setEntityReferenceId(userIdStr);
            ExtPsxNotifyResponse notify = this.psxNotifyClientService.notify(request);
            if (notify.isSuccess()) {
                this.userHandler.markPsxNotified(userId.longValue());
            }
            return Optional.of(notify);
        }
        return Optional.empty();
    }

    public PsxSyncRouteImpl(CustomerHandler customerHandler, ProjectHandler projectHandler, EntityHandler entityHandler, StageHandler stageHandler, UserHandler userHandler, PsxNotifyClientService psxNotifyClientService) {
        this.customerHandler = customerHandler;
        this.projectHandler = projectHandler;
        this.entityHandler = entityHandler;
        this.stageHandler = stageHandler;
        this.userHandler = userHandler;
        this.psxNotifyClientService = psxNotifyClientService;
    }
}

