/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.service.route.impl;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Streams;
import de.leancoders.common.helper.DateTimeHelper;
import de.qfm.erp.common.response.EntityBaseCommon;
import de.qfm.erp.common.response.psx.PsxConstructionSiteCommon;
import de.qfm.erp.common.response.psx.PsxEntryCommon;
import de.qfm.erp.common.response.psx.PsxEntryListCommon;
import de.qfm.erp.common.response.psx.PsxOrderValueListCommon;
import de.qfm.erp.common.response.psx.PsxReleaseOrderCommon;
import de.qfm.erp.common.response.psx.PsxSaveAllResponse;
import de.qfm.erp.common.response.psx.PsxWorkSpaceListCommon;
import de.qfm.erp.service.model.external.psx.ExtGroupCommon;
import de.qfm.erp.service.model.external.psx.ExtPsxConstructionSiteCommon;
import de.qfm.erp.service.model.external.psx.ExtPsxConstructionSitePageCommon;
import de.qfm.erp.service.model.external.psx.ExtPsxConstructionSiteUpdateRequest;
import de.qfm.erp.service.model.external.psx.ExtPsxReleaseOrderCommon;
import de.qfm.erp.service.model.external.psx.ExtPsxReleaseOrderPageCommon;
import de.qfm.erp.service.model.external.psx.ExtPsxReleaseOrderUpdateRequest;
import de.qfm.erp.service.model.external.psx.ExtPsxSaveAllUpdateRequest;
import de.qfm.erp.service.model.external.psx.ExtPsxSaveAllUpdateResponse;
import de.qfm.erp.service.model.external.psx.ExtPsxWorkSpacePageCommon;
import de.qfm.erp.service.model.internal.measurement.PsxRelevantMeasurementState;
import de.qfm.erp.service.service.handler.MeasurementHandler;
import de.qfm.erp.service.service.mapper.PsxMapper;
import de.qfm.erp.service.service.psx.PsxConstructionSiteClientService;
import de.qfm.erp.service.service.psx.PsxGroupClientService;
import de.qfm.erp.service.service.psx.PsxReleaseOrderClientService;
import de.qfm.erp.service.service.psx.PsxSaveAllClientService;
import de.qfm.erp.service.service.psx.PsxWorkSpaceClientService;
import de.qfm.erp.service.service.route.PsxRoute;
import java.math.BigDecimal;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import lombok.NonNull;
import org.springframework.stereotype.Service;

@Service
public class PsxRouteImpl
implements PsxRoute {
    private final MeasurementHandler measurementHandler;
    private final PsxMapper mapper;
    private final PsxSaveAllClientService psxSaveAllClientService;
    private final PsxConstructionSiteClientService psxConstructionSiteClientService;
    private final PsxGroupClientService psxGroupClientService;
    private final PsxReleaseOrderClientService psxReleaseOrderClientService;
    private final PsxWorkSpaceClientService psxWorkSpaceClientService;

    @Nonnull
    public PsxEntryListCommon entries(@Nullable Long stageId, @NonNull String filterText) {
        if (filterText == null) {
            throw new NullPointerException("filterText is marked non-null but is null");
        }
        ImmutableSet stageReferenceIds = stageId == null ? ImmutableSet.of() : ImmutableSet.of((Object)stageId.toString());
        ExtPsxConstructionSitePageCommon psxConstructionSitePage = this.psxConstructionSiteClientService.constructionSites(filterText, (Iterable)stageReferenceIds, (Iterable)ImmutableSet.of());
        ExtPsxReleaseOrderPageCommon psxReleaseOrdersPage = this.psxReleaseOrderClientService.releaseOrders(filterText, (Iterable)stageReferenceIds, (Iterable)ImmutableSet.of());
        ImmutableSet releaseOrderIdsFromCS = (ImmutableSet)psxConstructionSitePage.getItems().stream().map(ExtPsxConstructionSiteCommon::getReleaseOrderId).filter(Objects::nonNull).collect(ImmutableSet.toImmutableSet());
        ImmutableSet releaseOrderIdsFromRO = (ImmutableSet)psxReleaseOrdersPage.getItems().stream().map(EntityBaseCommon::getId).filter(Objects::nonNull).collect(ImmutableSet.toImmutableSet());
        ImmutableSet releaseOrderReferenceIdsFromCS = (ImmutableSet)releaseOrderIdsFromCS.stream().map(String::valueOf).collect(ImmutableSet.toImmutableSet());
        ImmutableSet releaseOrderReferenceIdsFromRO = (ImmutableSet)releaseOrderIdsFromRO.stream().map(String::valueOf).collect(ImmutableSet.toImmutableSet());
        Iterable releaseOrderReferenceIds = Iterables.concat((Iterable)releaseOrderReferenceIdsFromCS, (Iterable)releaseOrderReferenceIdsFromRO);
        Iterable psxRelevantMeasurementStates = this.measurementHandler.psxRelevantMeasurementStates((Iterable)ImmutableSet.of(), releaseOrderReferenceIds);
        Iterable disabledReferenceIds = (Iterable)Streams.stream((Iterable)psxRelevantMeasurementStates).map(PsxRelevantMeasurementState::getPsxReleaseOrderReferenceId).collect(ImmutableSet.toImmutableSet());
        Function<PsxEntryCommon, Boolean> disabledPsxEntryFunction = psxEntry -> {
            String releaseOrderReferenceId = psxEntry.getReleaseOrderReferenceId();
            return Iterables.contains((Iterable)disabledReferenceIds, (Object)releaseOrderReferenceId);
        };
        return this.mapper.mapToEntries(psxConstructionSitePage, psxReleaseOrdersPage, disabledPsxEntryFunction);
    }

    @Nonnull
    public PsxConstructionSiteCommon constructionSiteByReferenceId(@NonNull String constructionSiteReferenceId) {
        if (constructionSiteReferenceId == null) {
            throw new NullPointerException("constructionSiteReferenceId is marked non-null but is null");
        }
        ExtPsxConstructionSiteCommon extPsxConstructionSiteCommon = this.psxConstructionSiteClientService.constructionSite(constructionSiteReferenceId);
        return this.mapper.map(extPsxConstructionSiteCommon);
    }

    @Nonnull
    public PsxReleaseOrderCommon releaseOrderByReferenceId(@NonNull String releaseOrderReferenceId) {
        if (releaseOrderReferenceId == null) {
            throw new NullPointerException("releaseOrderReferenceId is marked non-null but is null");
        }
        ExtPsxReleaseOrderCommon extPsxReleaseOrderCommon = this.psxReleaseOrderClientService.releaseOrder(releaseOrderReferenceId);
        return this.mapper.map(extPsxReleaseOrderCommon);
    }

    @Nonnull
    public PsxOrderValueListCommon orderValues(@NonNull Long stageId) {
        if (stageId == null) {
            throw new NullPointerException("stageId is marked non-null but is null");
        }
        String stageReferenceId = stageId.toString();
        ExtPsxReleaseOrderPageCommon psxReleaseOrdersPage = this.psxReleaseOrderClientService.releaseOrders("", (Iterable)ImmutableSet.of((Object)stageReferenceId), (Iterable)ImmutableSet.of());
        return this.mapper.mapToOrderValues(psxReleaseOrdersPage);
    }

    @Nonnull
    public PsxWorkSpaceListCommon psxWorkSpaces() {
        ExtPsxWorkSpacePageCommon workspaces = this.psxWorkSpaceClientService.workspaces();
        return this.mapper.map(workspaces);
    }

    @Nonnull
    public PsxSaveAllResponse createAllByStageId(Long stageId) {
        ExtGroupCommon extGroupCommon = this.psxGroupClientService.groupByStageReferenceId(Long.toString(stageId));
        Long stageGroupId = extGroupCommon.getId();
        ExtPsxReleaseOrderUpdateRequest releaseOrderUpdateRequest = new ExtPsxReleaseOrderUpdateRequest();
        releaseOrderUpdateRequest.setReferenceId("");
        releaseOrderUpdateRequest.setReleaseOrderStateName("NEW");
        releaseOrderUpdateRequest.setReleaseOrderType("STANDARD");
        releaseOrderUpdateRequest.setOrderNumber("");
        releaseOrderUpdateRequest.setProjectNumber("");
        releaseOrderUpdateRequest.setOrderValue(BigDecimal.ZERO);
        releaseOrderUpdateRequest.setRemarks("");
        releaseOrderUpdateRequest.setReceiveDateTime(DateTimeHelper.now());
        releaseOrderUpdateRequest.setEndDateTime(null);
        releaseOrderUpdateRequest.setContactPersonOnSite("");
        releaseOrderUpdateRequest.setStageGroupId(stageGroupId);
        releaseOrderUpdateRequest.setResponsibleUserIds((List)ImmutableList.of());
        releaseOrderUpdateRequest.setAppointmentIds((List)ImmutableList.of());
        releaseOrderUpdateRequest.setConstructionSiteIds((List)ImmutableList.of());
        ExtPsxConstructionSiteUpdateRequest constructionSiteUpdateRequest = new ExtPsxConstructionSiteUpdateRequest();
        constructionSiteUpdateRequest.setReferenceId("");
        constructionSiteUpdateRequest.setProjectNumber("");
        constructionSiteUpdateRequest.setGeneralDescription("");
        constructionSiteUpdateRequest.setProcedureDescription("");
        constructionSiteUpdateRequest.setStreet("");
        constructionSiteUpdateRequest.setStreetNo("");
        constructionSiteUpdateRequest.setZipCode("");
        constructionSiteUpdateRequest.setCity("");
        constructionSiteUpdateRequest.setBerlinDistrict("NONE");
        constructionSiteUpdateRequest.setStartOfWorkPlannedDateTime(null);
        constructionSiteUpdateRequest.setEndOfWorkPlannedDateTime(null);
        constructionSiteUpdateRequest.setStartOfWorkAsIsDateTime(null);
        constructionSiteUpdateRequest.setEndOfWorkAsIsDateTime(null);
        constructionSiteUpdateRequest.setCustomDateTime1(null);
        constructionSiteUpdateRequest.setCustomDateTime2(null);
        constructionSiteUpdateRequest.setContactPersonOnSite("");
        constructionSiteUpdateRequest.setContactPersonOnSitePhone("");
        constructionSiteUpdateRequest.setContactPersonOnSiteMail("");
        constructionSiteUpdateRequest.setConstructionSiteStateName("NEW");
        constructionSiteUpdateRequest.setExecutingCompanyId(null);
        constructionSiteUpdateRequest.setReleaseOrderId(null);
        constructionSiteUpdateRequest.setContactPersonIds((List)ImmutableList.of());
        constructionSiteUpdateRequest.setUserAssignedIds((List)ImmutableList.of());
        constructionSiteUpdateRequest.setUserInvolvedIds((List)ImmutableList.of());
        ExtPsxSaveAllUpdateRequest saveAllUpdateRequest = new ExtPsxSaveAllUpdateRequest();
        saveAllUpdateRequest.setReleaseOrder(releaseOrderUpdateRequest);
        saveAllUpdateRequest.setConstructionSite(constructionSiteUpdateRequest);
        ExtPsxSaveAllUpdateResponse saveAllResponse = this.psxSaveAllClientService.save(saveAllUpdateRequest);
        return this.mapper.map(saveAllResponse);
    }

    public PsxRouteImpl(MeasurementHandler measurementHandler, PsxMapper mapper, PsxSaveAllClientService psxSaveAllClientService, PsxConstructionSiteClientService psxConstructionSiteClientService, PsxGroupClientService psxGroupClientService, PsxReleaseOrderClientService psxReleaseOrderClientService, PsxWorkSpaceClientService psxWorkSpaceClientService) {
        this.measurementHandler = measurementHandler;
        this.mapper = mapper;
        this.psxSaveAllClientService = psxSaveAllClientService;
        this.psxConstructionSiteClientService = psxConstructionSiteClientService;
        this.psxGroupClientService = psxGroupClientService;
        this.psxReleaseOrderClientService = psxReleaseOrderClientService;
        this.psxWorkSpaceClientService = psxWorkSpaceClientService;
    }
}

