/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.service.route.impl;

import com.google.common.collect.Iterables;
import de.qfm.erp.service.configuration.PrintLayoutConfig;
import de.qfm.erp.service.helper.BigDecimalHelper;
import de.qfm.erp.service.model.internal.print.EPrintFontSize;
import de.qfm.erp.service.model.internal.print.PrintFonts;
import de.qfm.erp.service.model.internal.print.PrintSetup;
import de.qfm.erp.service.model.internal.print.invoice.InvoiceAddendumDiscountMetaData;
import de.qfm.erp.service.model.internal.print.invoice.InvoicePositionPrintGroup;
import de.qfm.erp.service.model.internal.print.invoice.InvoicePrintInfo;
import de.qfm.erp.service.model.jpa.configuration.ConfigurationCompany;
import de.qfm.erp.service.service.route.impl.PrintHelper;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import lombok.NonNull;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.font.PDFont;
import org.apache.pdfbox.pdmodel.font.PDType0Font;
import org.springframework.stereotype.Service;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class PrintHelper {
    @Nonnull
    public static String addendumName(@NonNull InvoicePositionPrintGroup printGroup, @NonNull InvoicePrintInfo invoicePrintInfo) {
        if (printGroup == null) {
            throw new NullPointerException("printGroup is marked non-null but is null");
        }
        if (invoicePrintInfo == null) {
            throw new NullPointerException("invoicePrintInfo is marked non-null but is null");
        }
        boolean optionAddendumPositionWording = invoicePrintInfo.isOptionAddendumPositionWording();
        Long addendumNumber = printGroup.getAddendumNumber();
        if (!optionAddendumPositionWording) {
            return PrintHelper.addendumName((Long)addendumNumber);
        }
        Iterable rows = printGroup.getRows();
        if (Iterables.size((Iterable)rows) > 1) {
            return "Summe Zusatzpositionen";
        }
        return "Summe Zusatzposition";
    }

    @Nonnull
    public static String addendumName(@NonNull InvoiceAddendumDiscountMetaData invoiceAddendumDiscountMetaData, @NonNull InvoicePrintInfo invoicePrintInfo) {
        if (invoiceAddendumDiscountMetaData == null) {
            throw new NullPointerException("invoiceAddendumDiscountMetaData is marked non-null but is null");
        }
        if (invoicePrintInfo == null) {
            throw new NullPointerException("invoicePrintInfo is marked non-null but is null");
        }
        boolean optionAddendumPositionWording = invoicePrintInfo.isOptionAddendumPositionWording();
        Long addendumNumber = invoiceAddendumDiscountMetaData.getAddendumNumber();
        if (!optionAddendumPositionWording) {
            return PrintHelper.addendumName((Long)addendumNumber);
        }
        int positionAmount = invoiceAddendumDiscountMetaData.getPositionAmount();
        if (positionAmount > 1) {
            return "Summe Zusatzpositionen";
        }
        return "Summe Zusatzposition";
    }

    public static String addendumName(@NonNull Long addendumNumber) {
        if (addendumNumber == null) {
            throw new NullPointerException("addendumNumber is marked non-null but is null");
        }
        return Objects.equals(addendumNumber, 0L) ? "Summe aus Auftrag" : String.format("Summe aus Nachtrag %s", addendumNumber);
    }

    @Nonnull
    public static String discountName(@NonNull BigDecimal discount) {
        if (discount == null) {
            throw new NullPointerException("discount is marked non-null but is null");
        }
        return discount.compareTo(BigDecimal.ZERO) < 0 ? "Zuschlag" : "Nachlass";
    }

    @Nonnull
    public static String asString(@Nullable BigDecimal value, @NonNull String fallback, boolean printZero) {
        if (fallback == null) {
            throw new NullPointerException("fallback is marked non-null but is null");
        }
        if (null != value && (0 != value.compareTo(BigDecimal.ZERO) || printZero)) {
            return BigDecimalHelper.asString((BigDecimal)value);
        }
        return fallback;
    }

    @Nonnull
    public static String asCurrency(@Nullable BigDecimal value, @NonNull String fallback, boolean printZero) {
        if (fallback == null) {
            throw new NullPointerException("fallback is marked non-null but is null");
        }
        String numericValueAsString = PrintHelper.asString((BigDecimal)value, (String)fallback, (boolean)printZero);
        return String.format("%s EUR", numericValueAsString);
    }

    @Nonnull
    public static String asPercentage(@Nullable BigDecimal value, @NonNull String fallback, boolean printZero) {
        if (fallback == null) {
            throw new NullPointerException("fallback is marked non-null but is null");
        }
        String numericValueAsString = PrintHelper.asString((BigDecimal)value, (String)fallback, (boolean)printZero);
        return String.format("%s%%", numericValueAsString);
    }

    @Nonnull
    public static PrintSetup printSetup(@NonNull PrintLayoutConfig printLayoutConfig, @NonNull ConfigurationCompany configurationCompany, @NonNull EPrintFontSize printFontSize, @NonNull PDDocument document, @NonNull Function<PrintLayoutConfig, Float> paddingFN, @NonNull Function<PrintLayoutConfig, Integer> heightFN, @NonNull Function<PrintLayoutConfig, byte[]> logoFN) throws IOException {
        Integer aggregationFontSize;
        Integer detailsFontSize;
        Integer headerFontSize;
        Integer titleFontSize;
        Integer footerFontSize;
        if (printLayoutConfig == null) {
            throw new NullPointerException("printLayoutConfig is marked non-null but is null");
        }
        if (configurationCompany == null) {
            throw new NullPointerException("configurationCompany is marked non-null but is null");
        }
        if (printFontSize == null) {
            throw new NullPointerException("printFontSize is marked non-null but is null");
        }
        if (document == null) {
            throw new NullPointerException("document is marked non-null but is null");
        }
        if (paddingFN == null) {
            throw new NullPointerException("paddingFN is marked non-null but is null");
        }
        if (heightFN == null) {
            throw new NullPointerException("heightFN is marked non-null but is null");
        }
        if (logoFN == null) {
            throw new NullPointerException("logoFN is marked non-null but is null");
        }
        PDType0Font regular = PDType0Font.load((PDDocument)document, (InputStream)new ByteArrayInputStream(printLayoutConfig.getFontRegularBuffer()));
        PDType0Font bold = PDType0Font.load((PDDocument)document, (InputStream)new ByteArrayInputStream(printLayoutConfig.getFontBoldBuffer()));
        PDType0Font italic = PDType0Font.load((PDDocument)document, (InputStream)new ByteArrayInputStream(printLayoutConfig.getFontItalicBuffer()));
        PrintFonts printFonts = PrintFonts.of((PDFont)regular, (PDFont)bold, (PDFont)italic);
        return PrintSetup.of((Float)printLayoutConfig.getHeader1Width(), (Float)printLayoutConfig.getHeader2Width(), (Float)printLayoutConfig.getHeader3Width(), (Float)printLayoutConfig.getHeader4Width(), (int)footerFontSize, (int)titleFontSize, (int)headerFontSize, (int)detailsFontSize, (int)aggregationFontSize, (int)(switch (1.$SwitchMap$de$qfm$erp$service$model$internal$print$EPrintFontSize[printFontSize.ordinal()]) {
            case 1 -> {
                footerFontSize = printLayoutConfig.getFooterFontSizeSmaller();
                titleFontSize = printLayoutConfig.getTitleFontSizeSmaller();
                headerFontSize = printLayoutConfig.getHeaderFontSizeSmaller();
                detailsFontSize = printLayoutConfig.getDetailsFontSizeSmaller();
                aggregationFontSize = printLayoutConfig.getAggregationFontSizeSmaller();
                yield printLayoutConfig.getMetaFontSizeSmaller();
            }
            case 2 -> {
                footerFontSize = printLayoutConfig.getFooterFontSizeSmallest();
                titleFontSize = printLayoutConfig.getTitleFontSizeSmallest();
                headerFontSize = printLayoutConfig.getHeaderFontSizeSmallest();
                detailsFontSize = printLayoutConfig.getDetailsFontSizeSmallest();
                aggregationFontSize = printLayoutConfig.getAggregationFontSizeSmallest();
                yield printLayoutConfig.getMetaFontSizeSmallest();
            }
            default -> {
                footerFontSize = printLayoutConfig.getFooterFontSize();
                titleFontSize = printLayoutConfig.getTitleFontSize();
                headerFontSize = printLayoutConfig.getHeaderFontSize();
                detailsFontSize = printLayoutConfig.getDetailsFontSize();
                aggregationFontSize = printLayoutConfig.getAggregationFontSize();
                yield printLayoutConfig.getMetaFontSize();
            }
        }), (String)configurationCompany.getCompanyBankName(), (String)configurationCompany.getFooterColumn1(), (String)configurationCompany.getFooterColumn2(), (String)configurationCompany.getFooterColumn3(), (String)configurationCompany.getFooterColumn4(), (String)configurationCompany.getFooterColumn5(), (Float)printLayoutConfig.getFooter1Width(), (Float)printLayoutConfig.getFooter2Width(), (Float)printLayoutConfig.getFooter3Width(), (Float)printLayoutConfig.getFooter4Width(), (Float)printLayoutConfig.getFooter5Width(), (PrintFonts)printFonts, (float)paddingFN.apply(printLayoutConfig).floatValue(), (byte[])logoFN.apply(printLayoutConfig), (int)heightFN.apply(printLayoutConfig));
    }
}

