/*
 * Decompiled with CFR 0.152.
 */
package de.qfm.erp.service.service.route.impl;

import de.qfm.erp.common.request.generic.PayrollItemTypeUpdateRequest;
import de.qfm.erp.common.response.generic.PayrollItemTypeCommon;
import de.qfm.erp.common.response.generic.PayrollItemTypePageCommon;
import de.qfm.erp.service.model.internal.employee.payroll.EWageTypeCalculationResultType;
import de.qfm.erp.service.model.internal.payroll.PayrollItemTypeUpdateBucket;
import de.qfm.erp.service.model.jpa.EntityBase;
import de.qfm.erp.service.model.jpa.employee.contract.LaborUnionContract;
import de.qfm.erp.service.model.jpa.employee.payroll.EPayrollItemUnit;
import de.qfm.erp.service.model.jpa.employee.payroll.PayrollItemType;
import de.qfm.erp.service.service.calculator.wagetype.EWageType;
import de.qfm.erp.service.service.handler.EntityFactory;
import de.qfm.erp.service.service.handler.LaborUnionContractHandler;
import de.qfm.erp.service.service.handler.PayrollItemTypeHandler;
import de.qfm.erp.service.service.mapper.PayrollItemTypeMapper;
import de.qfm.erp.service.service.route.PayrollItemTypeRoute;
import javax.annotation.Nonnull;
import lombok.NonNull;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;

@Service
public class PayrollItemTypeRouteImpl
implements PayrollItemTypeRoute {
    private static final Logger log = LogManager.getLogger(PayrollItemTypeRouteImpl.class);
    private final EntityFactory entityFactory;
    private final LaborUnionContractHandler laborUnionContractHandler;
    private final PayrollItemTypeHandler handler;
    private final PayrollItemTypeMapper mapper;

    @Nonnull
    public PayrollItemTypePageCommon page(int page, int size) {
        return this.mapper.map(this.handler.page((Pageable)PageRequest.of((int)page, (int)size)));
    }

    @Nonnull
    public PayrollItemTypeCommon byId(long id) {
        return this.mapper.map((PayrollItemType)this.handler.byIdFailing(Long.valueOf(id)));
    }

    @Nonnull
    public PayrollItemTypeCommon create(@NonNull PayrollItemTypeUpdateRequest request) {
        if (request == null) {
            throw new NullPointerException("request is marked non-null but is null");
        }
        PayrollItemType payrollItemType = this.entityFactory.payrollItemType();
        PayrollItemTypeUpdateBucket bucket = this.bucket(request, payrollItemType);
        return this.mergeAndPersist(bucket);
    }

    @Nonnull
    public PayrollItemTypeCommon update(long id, @NonNull PayrollItemTypeUpdateRequest request) {
        if (request == null) {
            throw new NullPointerException("request is marked non-null but is null");
        }
        PayrollItemType payrollItemType = (PayrollItemType)this.handler.byIdFailing(Long.valueOf(id));
        PayrollItemTypeUpdateBucket bucket = this.bucket(request, payrollItemType);
        return this.mergeAndPersist(bucket);
    }

    @Nonnull
    private PayrollItemTypeCommon mergeAndPersist(@NonNull PayrollItemTypeUpdateBucket payrollItemTypeUpdateBucket) {
        if (payrollItemTypeUpdateBucket == null) {
            throw new NullPointerException("payrollItemTypeUpdateBucket is marked non-null but is null");
        }
        PayrollItemType merged = this.mapper.merge(payrollItemTypeUpdateBucket);
        PayrollItemType updated = (PayrollItemType)this.handler.update((EntityBase)merged);
        return this.mapper.map(updated);
    }

    @Nonnull
    private PayrollItemTypeUpdateBucket bucket(@NonNull PayrollItemTypeUpdateRequest request, @NonNull PayrollItemType payrollItemType) {
        if (request == null) {
            throw new NullPointerException("request is marked non-null but is null");
        }
        if (payrollItemType == null) {
            throw new NullPointerException("payrollItemType is marked non-null but is null");
        }
        Long laborUnionContractId = request.getLaborUnionContractId();
        LaborUnionContract laborUnionContract = null != laborUnionContractId ? (LaborUnionContract)this.laborUnionContractHandler.byIdFailing(laborUnionContractId) : null;
        Long sbsValuePayrollItemTypeId = request.getSbsValuePayrollItemTypeId();
        PayrollItemType sbsValuePayrollItemType = null != sbsValuePayrollItemTypeId ? (PayrollItemType)this.handler.byIdFailing(sbsValuePayrollItemTypeId) : null;
        String unitString = request.getUnit();
        EPayrollItemUnit payrollItemUnit = EPayrollItemUnit.lookupFailing((String)unitString);
        String wageTypeString = request.getWageType();
        EWageType wageType = EWageType.lookupFailing((String)wageTypeString);
        String sbsExportWageTypeCalculationResultType = request.getSbsExportWageTypeCalculationResultType();
        EWageTypeCalculationResultType sbsWageTypeCalculationResultType = EWageTypeCalculationResultType.lookupFailing((String)sbsExportWageTypeCalculationResultType);
        String printExportWageTypeCalculationResultType = request.getPrintWageTypeCalculationResultType();
        EWageTypeCalculationResultType printWageTypeCalculationResultType = EWageTypeCalculationResultType.lookupFailing((String)printExportWageTypeCalculationResultType);
        return PayrollItemTypeUpdateBucket.of((PayrollItemType)payrollItemType, (PayrollItemTypeUpdateRequest)request, (LaborUnionContract)laborUnionContract, (PayrollItemType)sbsValuePayrollItemType, (EPayrollItemUnit)payrollItemUnit, (EWageType)wageType, (EWageTypeCalculationResultType)printWageTypeCalculationResultType, (EWageTypeCalculationResultType)sbsWageTypeCalculationResultType);
    }

    public PayrollItemTypeRouteImpl(EntityFactory entityFactory, LaborUnionContractHandler laborUnionContractHandler, PayrollItemTypeHandler handler, PayrollItemTypeMapper mapper) {
        this.entityFactory = entityFactory;
        this.laborUnionContractHandler = laborUnionContractHandler;
        this.handler = handler;
        this.mapper = mapper;
    }
}

